/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ios.idb;

import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.image.BaseImageHandler;
import de.qfs.apps.qftest.shared.extensions.image.ImageRep;
import de.qfs.apps.qftest.shared.h;
import de.qfs.apps.qftest.shared.i;
import de.qfs.apps.qftest.shared.ios.IOSApp;
import de.qfs.apps.qftest.shared.ios.IOSTarget;
import de.qfs.apps.qftest.shared.ios.IOSUtil;
import de.qfs.apps.qftest.shared.ios.idb.IdbClient;
import de.qfs.apps.qftest.shared.ios.idb.IdbTarget;
import de.qfs.apps.qftest.shared.script.modules.Automac;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessListener;
import de.qfs.lib.util.ProcessManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class IdbProcessClient
extends IdbClient {
    private static final QFLogger f = new QFLogger("de.qfs.apps.qftest.shared.ios.idb.IdbProcessClient");
    public static final String IDB_BINARY_NAME = "idb";
    public static final String IDB_COMPANION_BINARY_NAME = "idb_companion";
    private static final AtomicReference g = new AtomicReference();
    public static final String VENV_PATH = "/python3/venv";
    public final int DEFAULT_TIMEOUT = 30000;
    static final Pattern a = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d \\[[A-Z]+\\].*");
    LogLevel b = LogLevel.INFO;
    static final i c = new i(f.getOwnerName() + ".Process");
    volatile String d;
    volatile String e;

    private static List a() {
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "determinePythonFrameworkPaths()", 93).log();
        }
        LinkedList linkedList = new LinkedList();
        if (Misc.OS_IS_MAC_OS_X) {
            for (int n2 : new int[]{1, 2, 8}) {
                List list = Automac.instance().getSearchPathForDirectoriesInDomains(5, n2, true);
                for (String string : new String[]{"/Frameworks/Python.framework/Versions", "/Python"}) {
                    linkedList.addAll(list.stream().map(string2 -> string2 + string).collect(Collectors.toList()));
                }
            }
        }
        return linkedList;
    }

    public static String getVenvDir() {
        String string;
        Object object;
        String string2;
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "getVenvDir()", 107).log();
        }
        if ((string2 = Options.cached_OPT_IOS_PYTHON_VENV_DIR) != null) {
            object = new File(string2);
            if (((File)object).isDirectory() || ((File)object).mkdirs()) {
                return string2;
            }
            if (IdbProcessClient.f.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(1, "getVenvDir()", 114).add("Cannot use venv dir ")).add(string2)).add(", falling back to default")).log();
            }
        }
        if (!new File((String)(object = Util.getUserConfigDir() + VENV_PATH)).isDirectory() && new File(string = Util.getCacheDir() + VENV_PATH).isDirectory()) {
            if (IdbProcessClient.f.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "getVenvDir()", 122).add("Using ")).add(string)).log();
            }
            return string;
        }
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "getVenvDir()", 126).add("Using ")).add((String)object)).log();
        }
        return object;
    }

    public String getIdbPath() {
        String string;
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "getIdbPath()", 132).log();
        }
        if (!Misc.emptyOrNull((String)(string = Options.cached_OPT_IOS_TOOL_PATH_IDB))) {
            return string;
        }
        if (this.d == null) {
            this.d = IdbProcessClient.findIdb(IDB_BINARY_NAME);
        }
        if (this.d != null) {
            return this.d;
        }
        return IDB_BINARY_NAME;
    }

    public String getIdbCompanionPath() {
        String string;
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "getIdbCompanionPath()", 147).log();
        }
        if (!Misc.emptyOrNull((String)(string = Options.cached_OPT_IOS_TOOL_PATH_IDB_COMPANION))) {
            return string;
        }
        if (this.e == null) {
            this.e = IdbProcessClient.findIdb(IDB_COMPANION_BINARY_NAME);
        }
        if (this.e != null) {
            return this.e;
        }
        return IDB_COMPANION_BINARY_NAME;
    }

    public static String findIdb(String string) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "findIdb(String)", 161).addDetail("binaryName", string)).log();
        }
        String string2 = IdbProcessClient.findInPythonFramework(string);
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "findIdb(String)", 166).add("defaultPath", string2)).log();
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = System.getenv("PATH");
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "findIdb(String)", 171).add("paths", string3)).log();
        }
        if (string3 != null) {
            for (String string4 : Misc.fastSplit((String)string3, (char)File.pathSeparatorChar)) {
                File file;
                if (Misc.emptyOrNull((String)string4) || !(file = new File(string4, string)).exists()) continue;
                return file.getAbsolutePath();
            }
        }
        if (IdbProcessClient.f.level >= 3) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "findIdb(String)", 181).add(string)).add(" binary not found")).log();
        }
        return null;
    }

    public static String findInPythonFramework(String string) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "findInPythonFramework(String)", 187).addDetail("exeName", string)).log();
        }
        File file = new File(IdbProcessClient.getVenvDir() + "/bin/" + string);
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "findInPythonFramework(String)", 189).add("inVenv", (Object)file)).log();
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        for (String string2 : IdbProcessClient.getPythonFrameworkPaths()) {
            String string3 = IdbProcessClient.a(string2, string);
            if (IdbProcessClient.f.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "findInPythonFramework(String)", 194).add("baseDir", string2)).add("candidate", string3)).log();
            }
            if (string3 == null) continue;
            return string3;
        }
        File file2 = IdbProcessClient.a(string);
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "findInPythonFramework(String)", 198).add("onPath", (Object)file2)).log();
        }
        return file2 == null ? null : file2.getAbsolutePath();
    }

    @Nullable
    private static String a(String string3, String string4) {
        File file2 = new File(string3 + "/Current/bin", string4);
        if (file2.exists()) {
            return file2.getAbsolutePath();
        }
        String[] stringArray = new File(string3).list((file, string) -> string.matches("3\\.\\d+"));
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "findInPythonVersionBinDir(String,String)", 211).add("versions", (Object)stringArray)).log();
        }
        if (stringArray != null && stringArray.length > 0) {
            Arrays.sort(stringArray, (string, string2) -> Integer.parseInt(string2.substring(2)) - Integer.parseInt(string2.substring(2)));
            if (IdbProcessClient.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "findInPythonVersionBinDir(String,String)", 214).add("versions", (Object)stringArray)).log();
            }
            for (String string5 : stringArray) {
                file2 = new File(string3 + "/" + string5 + "/bin", string4);
                if (!file2.exists()) continue;
                return file2.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    private static File a(String string) {
        File file = Util.findOnPath(string);
        if (file != null) {
            return file;
        }
        file = new File("/opt/homebrew/bin", string);
        if (file.exists()) {
            return file;
        }
        file = new File("/usr/local/opt/", string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    @Override
    public IOSTarget getTargetByName(String string) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getTargetByName(String)", 240).addDetail("targetName", string)).log();
        }
        List list = this.listTargets();
        for (IOSTarget iOSTarget : list) {
            if (!iOSTarget.getName().equals(string)) continue;
            return iOSTarget;
        }
        return null;
    }

    @Override
    public IOSTarget getTargetByUdid(String string) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getTargetByUdid(String)", 252).addDetail("udid", string)).log();
        }
        List list = this.listTargets();
        for (IOSTarget iOSTarget : list) {
            if (!iOSTarget.getUdid().equals(string)) continue;
            return iOSTarget;
        }
        return null;
    }

    @Override
    public List listTargets() {
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "listTargets()", 264).log();
        }
        String string = this.a("list-targets", "--json");
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "listTargets()", 267).add("output", string)).log();
        }
        return this.a(string, (T jsonObject) -> IdbTarget.fromJsonObject(this, jsonObject));
    }

    @Override
    protected boolean connect(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "connect(IdbTarget)", 273).addDetail("target", (Object)idbTarget)).log();
        }
        if (idbTarget == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        String string = this.a("connect", idbTarget.getUdid());
        return string == null || !string.contains("Could not connect to");
    }

    @Override
    protected boolean disconnect(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "disconnect(IdbTarget)", 280).addDetail("target", (Object)idbTarget)).log();
        }
        if (idbTarget == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        this.a("disconnect", idbTarget.d);
        return true;
    }

    @Override
    protected JsonObject describe(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "describe(IdbTarget)", 287).addDetail("target", (Object)idbTarget)).log();
        }
        if (idbTarget == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        String string = this.a("describe", "--udid", idbTarget.d, "--json");
        return this.b(string);
    }

    private JsonObject b(String string) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "getJsonObjectFromOutput(String)", 297).addDetail("output", string)).log();
        }
        if (string == null) {
            return null;
        }
        for (String string2 : Misc.fastSplit((String)string, (char)'\n')) {
            try {
                if (a.matcher(string2).matches()) continue;
                return Json.parse((String)string2).asObject();
            }
            catch (Exception exception) {
                if (IdbProcessClient.f.level < 3) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "getJsonObjectFromOutput(String)", 304).add("Error parsing data", (Object)exception)).add("line", string2)).log();
            }
        }
        return null;
    }

    @Override
    protected boolean verify(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "verify(IdbTarget)", 311).addDetail("target", (Object)idbTarget)).log();
        }
        if (idbTarget == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        if (idbTarget.isSimulator()) {
            return true;
        }
        String string = this.a(idbTarget, "list-apps");
        return string != null && !string.contains("Connection lost");
    }

    @Override
    protected void boot(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "boot(IdbTarget)", 319).addDetail("target", (Object)idbTarget)).log();
        }
        this.a(null, 60000, "boot", idbTarget.d);
    }

    @Override
    protected void shutdown(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "shutdown(IdbTarget)", 325).addDetail("target", (Object)idbTarget)).log();
        }
        this.a("shutdown", idbTarget.d);
    }

    @Override
    protected void focus(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "focus(IdbTarget)", 332).addDetail("target", (Object)idbTarget)).log();
        }
        this.a(idbTarget, "focus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageRep grabScreenshot(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "grabScreenshot(IdbTarget)", 340).addDetail("target", (Object)idbTarget)).log();
        }
        File file = null;
        try {
            file = File.createTempFile("screenshot", ".png");
            String string = file.getAbsolutePath();
            if (IdbProcessClient.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "grabScreenshot(IdbTarget)", 348).add("imageFilePath", string)).log();
            }
            this.a(idbTarget, "screenshot", string);
            if (file.exists() && file.length() > 0L) {
                ImageRep imageRep = BaseImageHandler.instance().loadPng(string);
                return imageRep;
            }
            ImageRep imageRep = null;
            return imageRep;
        }
        catch (Exception exception) {
            if (IdbProcessClient.f.level >= 3) {
                ((LevelAwareLogBuilder)f.lvlBuild(3, "grabScreenshot(IdbTarget)", 356).add("Exception while taking screenshot", (Object)exception)).log();
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return null;
    }

    @Override
    public List listApps(IdbTarget idbTarget) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "listApps(IdbTarget)", 369).addDetail("target", (Object)idbTarget)).log();
        }
        String string = this.a(idbTarget, "list-apps", "--json");
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "listApps(IdbTarget)", 372).add("output", string)).log();
        }
        return this.a(string, (T jsonObject) -> IOSApp.fromJson((JsonValue)jsonObject));
    }

    @Override
    public void install(IdbTarget idbTarget, File file) throws IOException {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "install(IdbTarget,File)", 381).addDetail("target", (Object)idbTarget)).addDetail("appPath", (Object)file)).log();
        }
        String string = this.a(idbTarget, "install", "--json", file.getAbsolutePath());
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "install(IdbTarget,File)", 384).add("result", string)).log();
        }
        if (string != null && idbTarget.isDevice() && string.contains(" is not suitable for ")) {
            this.a(idbTarget, file);
            return;
        }
        if (string != null && idbTarget.isSimulator() && Misc.isMacOsAppleSilicon() && string.contains("not in the bundles supported architectures")) {
            this.b(idbTarget, file);
            return;
        }
        String string2 = h.a((JsonValue)this.b(string), "installedAppBundleId", "");
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "install(IdbTarget,File)", 397).add("installedAppBundleId", string2)).log();
        }
        if (Misc.emptyOrNull((String)string2)) {
            throw new IOException(string);
        }
    }

    private void a(IdbTarget idbTarget, File file) throws IOException {
        IOException iOException;
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "installOnDeviceWithXcrun(IdbTarget,File)", 406).addDetail("target", (Object)idbTarget)).addDetail("appPath", (Object)file)).log();
        }
        if ((iOException = (IOException)this.a(idbTarget, Misc.listOf((Object[])new String[]{"device", "install", "app"}), Misc.listOf((Object[])new String[]{file.getAbsolutePath()}), (T string, U jsonValue) -> {
            int n2 = string.indexOf("ERROR:");
            if (n2 > -1) {
                return new IOException(string.substring(n2));
            }
            return null;
        }, (T runProcessException) -> {
            if (IdbProcessClient.f.level >= 5) {
                ((LevelAwareLogBuilder)f.lvlBuild(5, "installOnDeviceWithXcrun(IdbTarget,File)", 413).add("Error executing terminal command: ", (Object)runProcessException)).log();
            }
            return new IOException((Throwable)runProcessException);
        })) != null) {
            throw iOException;
        }
    }

    private void b(IdbTarget idbTarget, File file) throws IOException {
        IOException iOException;
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "installOnSimulatorWithXcrun(IdbTarget,File)", 425).addDetail("target", (Object)idbTarget)).addDetail("appPath", (Object)file)).log();
        }
        if ((iOException = (IOException)this.a(Misc.listOf((Object[])new String[]{"install"}), Misc.listOf((Object[])new String[]{idbTarget.getUdid(), file.getAbsolutePath()}), (T string) -> {
            int n2 = string.indexOf("ERROR:");
            if (n2 > -1) {
                return new IOException(string.substring(n2));
            }
            return null;
        }, (T runProcessException) -> {
            if (IdbProcessClient.f.level >= 5) {
                ((LevelAwareLogBuilder)f.lvlBuild(5, "installOnSimulatorWithXcrun(IdbTarget,File)", 432).add("Error executing terminal command: ", (Object)runProcessException)).log();
            }
            return new IOException((Throwable)runProcessException);
        })) != null) {
            throw iOException;
        }
    }

    @Override
    public void uninstall(IdbTarget idbTarget, String string) throws IOException {
        String string2;
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "uninstall(IdbTarget,String)", 445).addDetail("target", (Object)idbTarget)).addDetail("bundleId", string)).log();
        }
        String string3 = this.a(idbTarget, "uninstall", string);
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "uninstall(IdbTarget,String)", 448).add("result", string3)).log();
        }
        if (!"".equals(string2 = this.c(string3).trim())) {
            throw new IOException(string3);
        }
    }

    private List a(String string, Function function) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "getListOfJsonFromOutput(String,Function<JsonObject, T>)", 462).addDetail("output", string)).addDetail("creator", (Object)function)).log();
        }
        LinkedList linkedList = new LinkedList();
        if (string == null) {
            return linkedList;
        }
        for (String string2 : Misc.fastSplit((String)string, (char)'\n')) {
            try {
                JsonObject jsonObject;
                Object r2;
                if (a.matcher(string2).matches() || (r2 = function.apply(jsonObject = Json.parse((String)string2).asObject())) == null) continue;
                linkedList.add(r2);
            }
            catch (Exception exception) {
                if (IdbProcessClient.f.level < 3) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "getListOfJsonFromOutput(String,Function<JsonObject, T>)", 476).add("Error parsing data", (Object)exception)).add("line", string2)).log();
            }
        }
        return linkedList;
    }

    @Override
    public int launch(IdbTarget idbTarget, String string, Collection collection, Map map) throws IOException {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "launch(IdbTarget,String,Collection<String>,Map<String, String>)", 486).addDetail("target", (Object)idbTarget)).addDetail("bundleId", string)).addDetail("arguments", (Object)collection)).addDetail("envVariables", (Object)map)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("bundleId is marked non-null but is null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("launch");
        arrayList.add("--json");
        arrayList.add("-f");
        arrayList.add(string);
        if (collection != null) {
            arrayList.addAll(collection);
        }
        String string2 = this.a(idbTarget, 30000, map, arrayList.toArray(new String[arrayList.size()]));
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "launch(IdbTarget,String,Collection<String>,Map<String, String>)", 498).add("result", string2)).log();
        }
        if (string2 != null && idbTarget.isDevice() && string2.contains(" is not suitable for ")) {
            return this.launchOnDeviceWithXcrun(idbTarget, string, collection);
        }
        if (string2 != null && string2.contains("can't be launched")) {
            throw new IOException(string2);
        }
        try {
            return h.a((JsonValue)this.b(string2), "pid", 0);
        }
        catch (Exception exception) {
            throw new IOException(string2);
        }
    }

    public int launchOnDeviceWithXcrun(IdbTarget idbTarget, String string2, Collection collection) throws IOException {
        Object object;
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "launchOnDeviceWithXcrun(IdbTarget,String,Collection<String>)", 517).addDetail("target", (Object)idbTarget)).addDetail("bundleId", string2)).addDetail("arguments", (Object)collection)).log();
        }
        if (string2 == null) {
            throw new IllegalArgumentException("bundleId is marked non-null but is null");
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string2);
        if (collection != null) {
            linkedList.addAll(collection);
        }
        if ((object = this.a(idbTarget, Misc.listOf((Object[])new String[]{"device", "process", "launch"}), linkedList, (T string, U jsonValue) -> {
            int n2;
            block4: {
                if (!string.contains("Launched application")) {
                    return new IOException((String)string);
                }
                n2 = 0;
                if (jsonValue != null) {
                    try {
                        n2 = h.a(jsonValue, Misc.listOf((Object[])new Object[]{"result", "process", "processIdentifier"})).asInt();
                    }
                    catch (Exception exception) {
                        if (IdbProcessClient.f.level < 3) break block4;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "launchOnDeviceWithXcrun(IdbTarget,String,Collection<String>)", 532).add("Could not get process id: ")).add((Object)exception)).log();
                    }
                }
            }
            return Integer.valueOf(n2);
        }, (T runProcessException) -> {
            if (IdbProcessClient.f.level >= 5) {
                ((LevelAwareLogBuilder)f.lvlBuild(5, "launchOnDeviceWithXcrun(IdbTarget,String,Collection<String>)", 537).add("Error executing terminal command: ", (Object)runProcessException)).log();
            }
            return new IOException((Throwable)runProcessException);
        })) instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object a(IdbTarget idbTarget, List list, List list2, BiFunction biFunction, Function function) {
        File file;
        block27: {
            if (IdbProcessClient.f.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "runXcrunDevicectl(IdbTarget,List<String>,List<String>,BiFunction<String, JsonValue, T>,RunProcessException, T>)", 553).addDetail("target", (Object)idbTarget)).addDetail("subcommands", (Object)list)).addDetail("commandArguments", (Object)list2)).addDetail("resultHandler", (Object)biFunction)).addDetail("errorHandler", (Object)function)).log();
            }
            file = null;
            try {
                file = File.createTempFile("xcrun.output", ".json");
            }
            catch (IOException iOException) {
                if (IdbProcessClient.f.level < 3) break block27;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "runXcrunDevicectl(IdbTarget,List<String>,List<String>,BiFunction<String, JsonValue, T>,RunProcessException, T>)", 559).add("Cannot create temp output file: ")).add((Object)iOException)).log();
            }
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(IOSUtil.getXcrunPath());
            arrayList.add("devicectl");
            if (file != null) {
                arrayList.add("--json-output");
                arrayList.add(file.getAbsolutePath());
            }
            arrayList.addAll(list);
            arrayList.add("--device");
            arrayList.add(idbTarget.getUdid());
            if (!Misc.emptyOrNull((Collection)list2)) {
                arrayList.addAll(list2);
            }
            if (IdbProcessClient.f.level >= 9) {
                ((LevelAwareLogBuilder)f.lvlBuild(9, "runXcrunDevicectl(IdbTarget,List<String>,List<String>,BiFunction<String, JsonValue, T>,RunProcessException, T>)", 577).add("command", arrayList)).log();
            }
            try {
                String string = ProcessManager.runProcess((String[])arrayList.toArray(new String[arrayList.size()]), (int)30000, (ProcessListener)c);
                if (IdbProcessClient.f.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "runXcrunDevicectl(IdbTarget,List<String>,List<String>,BiFunction<String, JsonValue, T>,RunProcessException, T>)", 581).add("result", string)).add("command", arrayList)).log();
                }
                if (biFunction != null) {
                    Object object;
                    JsonValue jsonValue;
                    block28: {
                        jsonValue = null;
                        if (file != null) {
                            try {
                                object = new InputStreamReader((InputStream)new FileInputStream(file), Misc.UTF8_CHARSET);
                                try {
                                    jsonValue = Json.parse(object);
                                }
                                finally {
                                    ((Reader)object).close();
                                }
                            }
                            catch (Exception exception) {
                                if (IdbProcessClient.f.level < 3) break block28;
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(3, "runXcrunDevicectl(IdbTarget,List<String>,List<String>,BiFunction<String, JsonValue, T>,RunProcessException, T>)", 588).add("Could not parse temp output file: ")).add((Object)exception)).log();
                            }
                        }
                    }
                    object = biFunction.apply(string, jsonValue);
                    return object;
                }
                Object var9_12 = null;
                return var9_12;
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                if (function != null) {
                    Object r2 = function.apply(runProcessException);
                    return r2;
                }
                Object var9_14 = null;
                return var9_14;
            }
        }
        finally {
            if (file != null) {
                boolean bl = file.delete();
                if (IdbProcessClient.f.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "runXcrunDevicectl(IdbTarget,List<String>,List<String>,BiFunction<String, JsonValue, T>,RunProcessException, T>)", 603).add("outputFile", (Object)file)).add("deleted", bl)).log();
                }
            }
        }
    }

    private Object a(List list, List list2, Function function, Function function2) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "runXcrunSimctl(List<String>,List<String>,Function<String, T>,RunProcessException, T>)", 611).addDetail("subcommands", (Object)list)).addDetail("commandArguments", (Object)list2)).addDetail("resultHandler", (Object)function)).addDetail("errorHandler", (Object)function2)).log();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(IOSUtil.getXcrunPath());
        arrayList.add("simctl");
        arrayList.addAll(list);
        if (!Misc.emptyOrNull((Collection)list2)) {
            arrayList.addAll(list2);
        }
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "runXcrunSimctl(List<String>,List<String>,Function<String, T>,RunProcessException, T>)", 621).add("command", arrayList)).log();
        }
        try {
            String string = ProcessManager.runProcess((String[])arrayList.toArray(new String[arrayList.size()]), (int)30000, (ProcessListener)c);
            if (IdbProcessClient.f.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "runXcrunSimctl(List<String>,List<String>,Function<String, T>,RunProcessException, T>)", 625).add("result", string)).add("command", arrayList)).log();
            }
            if (function != null) {
                return function.apply(string);
            }
            return null;
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (function2 != null) {
                return function2.apply(runProcessException);
            }
            return null;
        }
    }

    @Override
    public void terminate(IdbTarget idbTarget, String string) throws IOException {
        String string2;
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "terminate(IdbTarget,String)", 642).addDetail("target", (Object)idbTarget)).addDetail("bundleId", string)).log();
        }
        String string3 = this.a(idbTarget, "terminate", string);
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "terminate(IdbTarget,String)", 645).add("result", string3)).log();
        }
        if (!"".equals(string2 = this.c(string3))) {
            throw new IOException(string3);
        }
    }

    private String c(String string) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "filterLogLines(String)", 656).addDetail("output", string)).log();
        }
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string2 : Misc.fastSplit((String)string, (char)'\n', (int)-1)) {
            if (a.matcher(string2).matches()) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String a(String ... stringArray) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "runIdb(String[])", 675).addDetail("arguments", (Object)stringArray)).log();
        }
        return this.a((IdbTarget)null, stringArray);
    }

    private String a(IdbTarget idbTarget, String ... stringArray) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "runIdb(IdbTarget,String[])", 682).addDetail("target", (Object)idbTarget)).addDetail("arguments", (Object)stringArray)).log();
        }
        return this.a(idbTarget, 30000, stringArray);
    }

    private String a(IdbTarget idbTarget, int n2, String ... stringArray) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "runIdb(IdbTarget,int,String[])", 690).addDetail("target", (Object)idbTarget)).addDetail("timeout", n2)).addDetail("arguments", (Object)stringArray)).log();
        }
        return this.a(idbTarget, n2, (Map)null, stringArray);
    }

    private String a(IdbTarget idbTarget, int n2, Map map, String ... stringArray) {
        Object object;
        Object object2;
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(7, "runIdb(IdbTarget,int,Map<String, String>,String[])", 698).addDetail("target", (Object)idbTarget)).addDetail("timeout", n2)).addDetail("envVariables", (Object)map)).addDetail("arguments", (Object)stringArray)).log();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (idbTarget != null && idbTarget.isConnected()) {
            arrayList.add("IDB_COMPANION=" + idbTarget.k.a());
            if (map != null) {
                object2 = map.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    arrayList.add("IDB_" + ((String)object.getKey()).toUpperCase().replace(' ', '_') + "=" + (String)object.getValue());
                }
            }
        }
        arrayList.add(this.getIdbPath());
        if (stringArray.length >= 2 && "--log".equals(stringArray[0])) {
            try {
                object2 = LogLevel.valueOf(stringArray[1]);
                if (IdbProcessClient.f.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "runIdb(IdbTarget,int,Map<String, String>,String[])", 716).add("requestedLevel", object2)).add("logLevel", (Object)this.b)).log();
                }
                if (((Enum)object2).ordinal() < this.b.ordinal()) {
                    stringArray[1] = this.b.name();
                }
            }
            catch (Exception exception) {
                if (IdbProcessClient.f.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(1, "runIdb(IdbTarget,int,Map<String, String>,String[])", 721).add("Cannot parse log level ")).add(stringArray[1])).add(". Setting ")).add((Object)this.b)).log();
                }
                stringArray[1] = this.b.name();
            }
        } else if (this.b != LogLevel.CRITICAL) {
            arrayList.add("--log");
            arrayList.add(this.b.name());
        }
        if ((object2 = this.getIdbCompanionPath()) != null && !IDB_COMPANION_BINARY_NAME.equals(this.getIdbCompanionPath())) {
            arrayList.add("--companion-path");
            arrayList.add(object2);
        }
        for (String string : stringArray) {
            arrayList.add(string);
        }
        if (IdbProcessClient.f.level >= 9) {
            ((LevelAwareLogBuilder)f.lvlBuild(9, "runIdb(IdbTarget,int,Map<String, String>,String[])", 738).add("command", arrayList)).log();
        }
        try {
            object = ProcessManager.runProcess((String[])arrayList.toArray(new String[arrayList.size()]), (int)n2, (ProcessListener)c);
            if (IdbProcessClient.f.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(9, "runIdb(IdbTarget,int,Map<String, String>,String[])", 742).add("result", (String)object)).add("command", arrayList)).log();
            }
            return object;
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (IdbProcessClient.f.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)f.lvlBuild(5, "runIdb(IdbTarget,int,Map<String, String>,String[])", 745).add("Error executing terminal command: ", (Object)runProcessException)).add("command", arrayList)).log();
            }
            return runProcessException.getOutput();
        }
    }

    public static void main(String[] stringArray) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "main(String[])", 755).addDetail("args", (Object)stringArray)).log();
        }
        IdbProcessClient idbProcessClient = new IdbProcessClient();
        List list = idbProcessClient.listTargets();
        for (IdbTarget idbTarget : list) {
            if (!"iPhone SE (3rd generation)".equals(idbTarget.b)) continue;
            idbTarget.focus();
        }
    }

    public String toString() {
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "toString()", 71).log();
        }
        return "IdbProcessClient(DEFAULT_TIMEOUT=" + this.DEFAULT_TIMEOUT + ", logLevel=" + String.valueOf((Object)this.getLogLevel()) + ", defaultIdbPath=" + this.d + ", defaultIdbCompanionPath=" + this.e + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getPythonFrameworkPaths() {
        Object object;
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "getPythonFrameworkPaths()", 77).log();
        }
        if ((object = g.get()) == null) {
            AtomicReference atomicReference = g;
            synchronized (atomicReference) {
                object = g.get();
                if (object == null) {
                    List list = IdbProcessClient.a();
                    object = list == null ? g : list;
                    g.set(object);
                }
            }
        }
        return object == g ? null : object;
    }

    public LogLevel getLogLevel() {
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "getLogLevel()", 87).log();
        }
        return this.b;
    }

    public IdbProcessClient setLogLevel(LogLevel logLevel) {
        if (IdbProcessClient.f.level >= 7) {
            ((LevelAwareLogBuilder)f.lvlBuild(7, "setLogLevel(LogLevel)", 87).addDetail("logLevel", (Object)logLevel)).log();
        }
        this.b = logLevel;
        return this;
    }

    public static i getIdbProcessListener() {
        if (IdbProcessClient.f.level >= 7) {
            f.lvlBuild(7, "getIdbProcessListener()", 88).log();
        }
        return c;
    }

    static final class LogLevel
    extends Enum {
        public static final /* enum */ LogLevel CRITICAL = new LogLevel("CRITICAL", 0);
        public static final /* enum */ LogLevel ERROR = new LogLevel("ERROR", 1);
        public static final /* enum */ LogLevel WARNING = new LogLevel("WARNING", 2);
        public static final /* enum */ LogLevel INFO = new LogLevel("INFO", 3);
        public static final /* enum */ LogLevel DEBUG = new LogLevel("DEBUG", 4);
        private static final /* synthetic */ LogLevel[] a;

        public static LogLevel[] values() {
            return (LogLevel[])a.clone();
        }

        public static LogLevel valueOf(String string) {
            return Enum.valueOf(LogLevel.class, string);
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private LogLevel() {
            void var2_-1;
            void var1_-1;
        }

        private static /* synthetic */ LogLevel[] a() {
            return new LogLevel[]{CRITICAL, ERROR, WARNING, INFO, DEBUG};
        }

        static {
            a = LogLevel.a();
        }
    }
}

