/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.metrics;

import de.qfs.apps.qftest.shared.metrics.OtelProviderHelper;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class OtelProviderHelperImpl
implements OtelProviderHelper {
    private static final String DEFAULT_OPEN_TELEMETRY_SDK = "__DEFAULT_OPEN_TELEMETRY_SDK__";
    private ConcurrentHashMap sdks = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpenTelemetry getOpenTelemetry(String string) {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2 = bl = string == null;
        if (bl) {
            string = DEFAULT_OPEN_TELEMETRY_SDK;
        }
        if ((object2 = this.sdks.putIfAbsent(string, object = new Object())) instanceof OpenTelemetrySdk) {
            return (OpenTelemetrySdk)object2;
        }
        if (object2 == null) {
            object2 = object;
        }
        Object object3 = object2;
        synchronized (object3) {
            String string2;
            Object v2 = this.sdks.get(string);
            if (v2 instanceof OpenTelemetrySdk) {
                return (OpenTelemetrySdk)v2;
            }
            if (bl) {
                string2 = System.getProperty("qftest.opentelemetry.service.name");
                if (Misc.emptyOrNull((String)string2)) {
                    string2 = System.getenv("QFTEST_OPENTELEMETRY_SERVICE_NAME");
                }
                if (Misc.emptyOrNull((String)string2)) {
                    OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
                    this.sdks.put(string, openTelemetry);
                    return openTelemetry;
                }
                string = string2;
            }
            string2 = Resource.getDefault().merge(Resource.builder().put(ResourceAttributes.SERVICE_NAME, (Object)string).build());
            OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().setResource((Resource)string2).addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)OtlpGrpcSpanExporter.builder().setTimeout(2L, TimeUnit.SECONDS).build()).setScheduleDelay(100L, TimeUnit.MILLISECONDS).build()).build()).setMeterProvider(SdkMeterProvider.builder().setResource((Resource)string2).registerMetricReader((MetricReader)PeriodicMetricReader.builder((MetricExporter)OtlpGrpcMetricExporter.getDefault()).setInterval(Duration.ofMillis(1000L)).build()).build()).build();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)openTelemetrySdk.getSdkTracerProvider()).shutdown()));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkMeterProvider)openTelemetrySdk.getSdkMeterProvider()).shutdown()));
            this.sdks.put(string, openTelemetrySdk);
            if (bl) {
                this.sdks.put(DEFAULT_OPEN_TELEMETRY_SDK, openTelemetrySdk);
            }
            return openTelemetrySdk;
        }
    }

    static {
        QFLogger.bridgeJavaLogger((String)"io.opentelemetry.exporter.internal.grpc.OkHttpGrpcExporter", (boolean)false, (int)2);
        QFLogger.bridgeJavaLogger((String)"io.opentelemetry.exporter.internal.okhttp.OkHttpExporter", (boolean)false, (int)2);
    }
}

