/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.rmi;

import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;

public class SocketFactory
implements Serializable,
RMIClientSocketFactory,
RMIServerSocketFactory {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.rmi.SocketFactory");
    static final long serialVersionUID = -2586629603147028926L;
    protected static SocketFactory instance = new SocketFactory();
    private static int sharedServerPort = 0;
    private static volatile boolean sharedServerPortDefined = false;
    private InetAddress hostAddress;
    private static ThreadLocal lastCall = new ThreadLocal();
    private int serverPort;

    protected SocketFactory() {
        if (SocketFactory.logger.level >= 7) {
            logger.lvlBuild(7, "SocketFactory()", 100).dumpStack();
        }
        if (SocketFactory.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "SocketFactory()", 101).add("protectionDomain", (Object)this.getClass().getProtectionDomain())).log();
        }
    }

    public SocketFactory(InetAddress inetAddress) {
        if (SocketFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "SocketFactory(InetAddress)", 113).addDetail("hostAddress", (Object)inetAddress)).dumpStack();
        }
        if (SocketFactory.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "SocketFactory(InetAddress)", 114).add("protectionDomain", (Object)this.getClass().getProtectionDomain())).log();
        }
        this.setHostAddress(inetAddress);
    }

    public static SocketFactory instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSharedServerPort() {
        if (SocketFactory.logger.level >= 7) {
            logger.lvlBuild(7, "getSharedServerPort()", 143).log();
        }
        if (sharedServerPortDefined) {
            return sharedServerPort;
        }
        Class<SocketFactory> clazz = SocketFactory.class;
        synchronized (SocketFactory.class) {
            block19: {
                String string = System.getenv("QFTEST_RMI_SHARED_SERVER_PORT");
                if (SocketFactory.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSharedServerPort()", 150).add("portDef", string)).log();
                }
                sharedServerPortDefined = true;
                if (string != null) {
                    try {
                        sharedServerPort = Integer.parseInt(string);
                        if (SocketFactory.logger.level >= 5) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "getSharedServerPort()", 155).add("sharedServerPort", sharedServerPort)).log();
                        }
                        // ** MonitorExit[var0] (shouldn't be in output)
                        return sharedServerPort;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String[] stringArray = string.split("-");
                        if (stringArray.length == 2) {
                            try {
                                int n2 = Integer.parseInt(stringArray[0]);
                                int n3 = Integer.parseInt(stringArray[1]);
                                if (SocketFactory.logger.level >= 9) {
                                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getSharedServerPort()", 163).add("first", n2)).add("last", n3)).log();
                                }
                                for (int i2 = n2; i2 <= n3; ++i2) {
                                    try {
                                        ServerSocket serverSocket = new ServerSocket(i2);
                                        serverSocket.close();
                                        sharedServerPort = i2;
                                        if (SocketFactory.logger.level >= 5) {
                                            ((LevelAwareLogBuilder)logger.lvlBuild(5, "getSharedServerPort()", 169).add("sharedServerPort", sharedServerPort)).log();
                                        }
                                    }
                                    catch (IOException iOException) {
                                        if (SocketFactory.logger.level < 9) continue;
                                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSharedServerPort()", 172).add("ex2", (Object)iOException)).log();
                                        continue;
                                    }
                                }
                            }
                            catch (NumberFormatException numberFormatException2) {
                                if (SocketFactory.logger.level >= 3) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "getSharedServerPort()", 176).add("ex2", (Object)numberFormatException2)).log();
                                }
                                break block19;
                            }
                        }
                        if (SocketFactory.logger.level < 3) break block19;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "getSharedServerPort()", 179).add("ex", (Object)numberFormatException)).log();
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sharedServerPort;
        }
    }

    public static void setSharedServerPort(int n2) {
        if (SocketFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setSharedServerPort(int)", 190).addDetail("port", n2)).log();
        }
        sharedServerPort = n2;
        sharedServerPortDefined = true;
    }

    public final InetAddress getHostAddress() {
        if (SocketFactory.logger.level >= 7) {
            logger.lvlBuild(7, "getHostAddress()", 208).log();
        }
        return this.hostAddress;
    }

    public final void setHostAddress(InetAddress inetAddress) {
        if (SocketFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setHostAddress(InetAddress)", 221).addDetail("hostAddress", (Object)inetAddress)).log();
        }
        this.hostAddress = inetAddress;
    }

    @Override
    public ServerSocket createServerSocket(int n2) throws IOException {
        if (SocketFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createServerSocket(int)", 247).addDetail("port", n2)).dumpStack();
        }
        try {
            this.serverPort = n2;
            ServerSocket serverSocket = new ServerSocket(n2);
            if (SocketFactory.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "createServerSocket(int)", 252).add("ret", (Object)serverSocket)).log();
            }
            return serverSocket;
        }
        catch (IOException iOException) {
            if (SocketFactory.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "createServerSocket(int)", 255).add("ex", (Object)iOException)).log();
            }
            throw iOException;
        }
    }

    @Override
    public Socket createSocket(String string, int n2) throws IOException {
        Object object;
        if (SocketFactory.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createSocket(String,int)", 281).addDetail("host", string)).addDetail("port", n2)).dumpStack();
        }
        if (Thread.currentThread().getName().startsWith("RMI RenewClean-")) {
            object = (Long)lastCall.get();
            if (object != null) {
                long l2;
                long l3 = System.currentTimeMillis() - (Long)object;
                if (SocketFactory.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "createSocket(String,int)", 286).add("Elapsed since last call: ")).add(l3)).log();
                }
                if (l3 > 0L && l3 < (l2 = (long)Options.cached_OPT_RMI_DGC_MINIMUM_DELAY)) {
                    if (SocketFactory.logger.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "createSocket(String,int)", 290).add("Sleeping for ")).add(l2 - l3)).add(" ms")).log();
                    }
                    Misc.safeSleep((long)(l2 - l3));
                    if (SocketFactory.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "createSocket(String,int)", 292).add("Wakeup")).log();
                    }
                }
            }
            lastCall.set(System.currentTimeMillis());
        }
        try {
            if (SocketFactory.logger.level >= 5) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "createSocket(String,int)", 303).add("hostAddress", (Object)this.hostAddress)).add("this", (Object)this)).log();
            }
            object = this.hostAddress != null ? new Socket(this.hostAddress, n2) : new Socket(string, n2);
            if (SocketFactory.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "createSocket(String,int)", 309).add("ret", object)).log();
            }
            return object;
        }
        catch (IOException iOException) {
            if (SocketFactory.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "createSocket(String,int)", 312).add("ex", (Object)iOException)).log();
            }
            throw iOException;
        }
    }

    public int hashCode() {
        return this.hostAddress == null ? 0 : this.hostAddress.getHostAddress().hashCode() + this.serverPort;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SocketFactory socketFactory = (SocketFactory)object;
        return Misc.equalOrNull((Object)this.hostAddress, (Object)socketFactory.hostAddress) && this.serverPort == socketFactory.serverPort;
    }

    public String toString() {
        return "QFS SocketFactory[hostAddress=" + this.hostAddress + "]";
    }
}

