/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.script.javascript.nashorn_modules;

import de.qfs.apps.qftest.shared.exceptions.ScriptException;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.script.ScriptObjectHelper;
import de.qfs.apps.qftest.shared.script.javascript.b;
import de.qfs.apps.qftest.shared.script.javascript.h;
import de.qfs.apps.qftest.shared.script.javascript.nashorn_modules.Folder;
import de.qfs.apps.qftest.shared.script.javascript.nashorn_modules.ModuleCache;
import de.qfs.apps.qftest.shared.script.javascript.nashorn_modules.Paths;
import de.qfs.apps.qftest.shared.script.javascript.nashorn_modules.RequireFunction;
import de.qfs.lib.json.Json;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;

public class Module
extends SimpleBindings
implements RequireFunction {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.script.javascript.nashorn_modules.Module");
    private ScriptEngine engine;
    private List folders;
    private ModuleCache cache;
    private Module main;
    private Bindings module;
    private List children = new ArrayList();
    private Object exports;
    private final h jsonParser;

    public Module(ScriptEngine scriptEngine, List list, ModuleCache moduleCache, String string, Bindings bindings, Module module, Module module2) throws javax.script.ScriptException {
        this.engine = scriptEngine;
        this.folders = list;
        this.cache = moduleCache;
        this.main = module2 != null ? module2 : this;
        this.module = scriptEngine.createBindings();
        this.put("main", (Object)this.main.module);
        this.exports = scriptEngine.createBindings();
        bindings.put("require", (Object)this);
        bindings.put("module", (Object)this.module);
        bindings.put("exports", this.exports);
        this.module.put("exports", this.exports);
        this.module.put("children", (Object)this.children);
        this.module.put("filename", (Object)string);
        this.module.put("id", (Object)string);
        this.module.put("loaded", (Object)false);
        this.module.put("parent", (Object)(module != null ? module.module : null));
        this.jsonParser = (h)ScriptObjectHelper.a(scriptEngine.eval("JSON"));
    }

    void setLoaded() {
        this.module.put("loaded", (Object)true);
    }

    @Override
    public Object require(String string) throws javax.script.ScriptException {
        Object object = null;
        try {
            for (Folder folder : this.folders) {
                object = this.requireInternal(string, folder);
                if (object == null) continue;
                return object;
            }
            if (Module.shouldLoadFromNodeModules(string)) {
                for (Folder folder : this.folders) {
                    object = this.requireInternal("./" + string, folder);
                    if (object == null) continue;
                    return object;
                }
            }
        }
        catch (javax.script.ScriptException scriptException) {
            return scriptException.toString() + ". Failed to load " + string + ".";
        }
        this.throwModuleNotFoundException(string);
        assert (false) : "An exception has been thrown";
        return null;
    }

    public Module addFolder(Folder folder) {
        this.folders.add(folder);
        return this;
    }

    public void removeLastFolder() {
        if (!Misc.emptyOrNull((Collection)this.folders)) {
            this.folders.remove(this.folders.size() - 1);
        }
    }

    private Object requireInternal(String string, Folder folder) throws javax.script.ScriptException {
        String[] stringArray;
        if (string == null) {
            this.throwModuleNotFoundException("<null>");
        }
        if ((stringArray = Paths.splitPath(string)).length == 0) {
            this.throwModuleNotFoundException(string);
        }
        String[] stringArray2 = Arrays.copyOfRange(stringArray, 0, stringArray.length - 1);
        String[] stringArray3 = Module.getFilenamesToAttempt(stringArray[stringArray.length - 1]);
        Module module = null;
        if (Module.shouldLoadFromNodeModules(string)) {
            if (stringArray2.length == 0 || !stringArray2[0].equals("node_modules")) {
                stringArray2 = (String[])Stream.concat(Stream.of("node_modules"), Arrays.stream(stringArray2)).toArray(String[]::new);
            }
            for (Folder folder2 = folder; folder2 != null && (module = this.attemptToLoadStartingFromFolder(folder2, stringArray2, stringArray3)) == null; folder2 = folder2.getParent()) {
            }
        } else {
            module = this.attemptToLoadStartingFromFolder(folder, stringArray2, stringArray3);
        }
        if (module != null) {
            this.children.add(module.module);
            return module.exports;
        }
        return null;
    }

    private Module attemptToLoadStartingFromFolder(Folder folder, String[] stringArray, String[] stringArray2) throws javax.script.ScriptException {
        Folder folder2 = Module.resolveFolder(folder, stringArray);
        if (folder2 == null) {
            return null;
        }
        return this.attemptToLoadFromThisFolder(folder2, stringArray2);
    }

    private Module attemptToLoadFromThisFolder(Folder folder, String[] stringArray) throws javax.script.ScriptException {
        for (String string : stringArray) {
            Module module = this.loadModule(folder, string);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    private static Folder resolveFolder(Folder folder, String[] stringArray) {
        Folder folder2 = folder;
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        block10: for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            switch (string = stringArray2[i2]) {
                case "": {
                    throw new IllegalArgumentException();
                }
                case ".": {
                    continue block10;
                }
                case "..": {
                    folder2 = folder2.getParent();
                    break;
                }
                default: {
                    folder2 = folder2.getFolder(string);
                }
            }
            if (folder2 != null) continue;
            return null;
        }
        return folder2;
    }

    private Module loadModule(Folder folder, String string) throws javax.script.ScriptException {
        String string2 = folder.getPath() + string;
        Module module = this.cache.get(string2);
        if (module == null) {
            module = this.loadModuleDirectly(folder, string2, string);
        }
        if (module == null) {
            module = this.loadModuleThroughFolderName(folder, string);
        }
        if (module != null) {
            this.cache.put(string2, module);
        }
        return module;
    }

    private Module loadModuleDirectly(Folder folder, String string, String string2) throws javax.script.ScriptException {
        String string3 = folder.getFile(string2);
        if (string3 == null) {
            return null;
        }
        return this.compileModuleAndPutInCache(folder, string, string3);
    }

    private Module loadModuleThroughFolderName(Folder folder, String string) throws javax.script.ScriptException {
        Folder folder2 = folder.getFolder(string);
        if (folder2 == null) {
            return null;
        }
        Module module = this.loadModuleThroughPackageJson(folder2);
        if (module == null) {
            module = this.loadModuleThroughIndexJs(folder2);
        }
        return module;
    }

    private Module loadModuleThroughPackageJson(Folder folder) throws javax.script.ScriptException {
        String string = folder.getFile("package.json");
        if (string == null) {
            return null;
        }
        String string2 = this.getMainFileFromPackageJson(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = Paths.splitPath(string2);
        String[] stringArray2 = Arrays.copyOfRange(stringArray, 0, stringArray.length - 1);
        String string3 = stringArray[stringArray.length - 1];
        Folder folder2 = Module.resolveFolder(folder, stringArray2);
        if (folder2 == null) {
            return null;
        }
        String string4 = folder2.getFile(string3);
        return this.compileModuleAndPutInCache(folder2, folder2.getPath() + string3, string4);
    }

    private Module loadModuleThroughIndexJs(Folder folder) throws javax.script.ScriptException {
        String string = folder.getFile("index.js");
        if (string == null) {
            return null;
        }
        return this.compileModuleAndPutInCache(folder, folder.getPath() + "index.js", string);
    }

    private Module compileModuleAndPutInCache(Folder folder, String string, String string2) throws javax.script.ScriptException {
        Module module;
        String string3 = string.toLowerCase();
        if (string3.endsWith(".js")) {
            module = this.compileJavaScriptModule(folder, string, string2);
        } else if (string3.endsWith(".json")) {
            module = this.compileJsonModule(folder, string, string2);
        } else {
            return null;
        }
        this.cache.put(string, module);
        return module;
    }

    private Module compileJavaScriptModule(Folder folder, String string, String string2) throws javax.script.ScriptException {
        Module module;
        Bindings bindings;
        block4: {
            Bindings bindings2 = this.engine.getBindings(100);
            bindings = this.engine.createBindings();
            bindings.putAll(bindings2);
            LinkedList<Folder> linkedList = new LinkedList<Folder>();
            linkedList.add(folder);
            module = new Module(this.engine, linkedList, this.cache, string, bindings, this, this.main);
            if (Options.cached_OPT_TRANSPILE_JAVASCRIPT_MODULES) {
                try {
                    string2 = b.a().a(string2, true, true).a();
                    if (Module.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "compileJavaScriptModule(Folder,String,String)", 353).add("transpiled", string2)).log();
                    }
                }
                catch (ScriptException scriptException) {
                    if (Module.logger.level < 3) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "compileJavaScriptModule(Folder,String,String)", 355).add("ex", (Object)scriptException)).log();
                }
            }
        }
        this.engine.eval(string2, bindings);
        module.exports = module.module.get("exports");
        module.setLoaded();
        return module;
    }

    private Module compileJsonModule(Folder folder, String string, String string2) throws javax.script.ScriptException {
        Bindings bindings = this.engine.createBindings();
        LinkedList<Folder> linkedList = new LinkedList<Folder>();
        linkedList.add(folder);
        Module module = new Module(this.engine, linkedList, this.cache, string, bindings, this, this.main);
        module.exports = this.parseJson(string2);
        module.setLoaded();
        return module;
    }

    private String getMainFileFromPackageJson(String string) throws javax.script.ScriptException {
        Bindings bindings = (Bindings)this.parseJson(string);
        return (String)bindings.get("main");
    }

    private Object parseJson(String string) throws javax.script.ScriptException {
        return this.jsonParser.a("parse", string);
    }

    private void throwModuleNotFoundException(String string) throws javax.script.ScriptException {
        Object object = this.engine.eval("var error = new Error( " + Json.value((String)("Module not found: " + string)) + "); error.code='MODULE_NOT_FOUND'; error");
        throw ((h)ScriptObjectHelper.a(object)).m();
    }

    private static boolean shouldLoadFromNodeModules(String string) {
        return !string.startsWith("/") && !string.startsWith("../") && !string.startsWith("./");
    }

    private static String[] getFilenamesToAttempt(String string) {
        return new String[]{string, string + ".js", string + ".json"};
    }

    public ModuleCache getCache() {
        return this.cache;
    }
}

