/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import java.io.File;
import java.util.regex.Pattern;

public class FileHelper {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.system.FileHelper");
    private static final Pattern b = Pattern.compile("1");
    private static final Pattern c = Pattern.compile("(?:ELF|Mach-O) 64-bit");

    public FileHelper() {
        if (FileHelper.a.level >= 7) {
            a.lvlBuild(7, "FileHelper.FileHelper()", 31).log();
        }
    }

    public static boolean is64bit(File file) {
        if (FileHelper.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "is64bit(File)", 46).addDetail("target", (Object)file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("target is marked non-null but is null");
        }
        if (!file.exists()) {
            if (FileHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "is64bit(File)", 49).add("Target dows not exists: ")).add((Object)file)).log();
            }
            return false;
        }
        try {
            int n2;
            ProcessManager processManager;
            Pattern pattern;
            if (Misc.OS_IS_WINDOWS) {
                File file2 = new File(Native.getVersionDir(), "bin");
                pattern = b;
                processManager = new ProcessManager("qfps", new String[]{new File(file2, "qfps.exe").getPath(), "-is64", "-path", file.getPath()});
            } else {
                pattern = c;
                processManager = new ProcessManager("file", new String[]{"file", file.getPath()});
            }
            processManager.setCollect(true, false);
            if (FileHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "is64bit(File)", 72).add("Starting process")).log();
            }
            processManager.startProcess();
            if (FileHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "is64bit(File)", 75).add("Waiting for process")).log();
            }
            boolean bl = processManager.waitFor(3000L);
            if (FileHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "is64bit(File)", 77).add("ret", bl)).log();
            }
            if (bl) {
                n2 = processManager.getExitCode();
            } else {
                processManager.terminateProcess(1);
                n2 = 1;
            }
            String string = processManager.getProcessOutputString();
            if (FileHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "is64bit(File)", 87).add("exitCode", n2)).add("out", string)).log();
            }
            boolean bl2 = bl = n2 == 0 && string != null && pattern.matcher(string).find();
            if (FileHelper.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "is64bit(File)", 92).add("ret", bl)).log();
            }
            return bl;
        }
        catch (Throwable throwable) {
            if (FileHelper.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "is64bit(File)", 96).add("ex", (Object)throwable)).log();
            }
            return false;
        }
    }
}

