/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import com.jniwrapper.Int;
import com.jniwrapper.Library;
import com.jniwrapper.Parameter;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.UnixNative;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;

public class LinuxNative
extends UnixNative {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.system.LinuxNative");
    private Library b;

    protected LinuxNative(Library library) {
        this.b = library;
    }

    @Override
    public int getProcessID() {
        if (LinuxNative.a.level >= 7) {
            a.lvlBuild(7, "getProcessID()", 76).log();
        }
        try {
            Int intVal = new Int();
            this.b.getFunction("getpid").invoke((Parameter)intVal);
            if (LinuxNative.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getProcessID()", 81).add("ret", (Object)intVal)).log();
            }
            return (int)intVal.getValue();
        }
        catch (Throwable throwable) {
            if (LinuxNative.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getProcessID()", 84).add("ex", (Object)throwable)).log();
            }
            return super.getProcessID();
        }
    }

    @Override
    public void sendQuitSignal(int n2) {
        block3: {
            if (LinuxNative.a.level >= 7) {
                ((LevelAwareLogBuilder)a.lvlBuild(7, "sendQuitSignal(int)", 101).addDetail("processID", n2)).log();
            }
            try {
                Int intVal = new Int();
                Int intVal2 = new Int((long)n2);
                Int intVal3 = new Int(3L);
                this.b.getFunction("kill").invoke((Parameter)intVal, (Parameter)intVal2, (Parameter)intVal3);
            }
            catch (Throwable throwable) {
                if (LinuxNative.a.level < 5) break block3;
                ((LevelAwareLogBuilder)a.lvlBuild(5, "sendQuitSignal(int)", 109).add("ex", (Object)throwable)).log();
            }
        }
    }

    public static Native createInstance() {
        LinuxNative.setupLoader();
        try {
            Library library = new Library("libc.so.6");
            library.load();
            return new LinuxNative(library);
        }
        catch (Throwable throwable) {
            if (LinuxNative.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "createInstance()", 134).add("ex", (Object)throwable)).log();
            }
            return null;
        }
    }

    @Override
    public int getParentProcessID() {
        if (LinuxNative.a.level >= 7) {
            a.lvlBuild(7, "getParentProcessID()", 154).log();
        }
        try {
            Int intVal = new Int();
            this.b.getFunction("getppid").invoke((Parameter)intVal);
            if (LinuxNative.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getParentProcessID()", 159).add("ret", (Object)intVal)).log();
            }
            return (int)intVal.getValue();
        }
        catch (Throwable throwable) {
            if (LinuxNative.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "getParentProcessID()", 162).add("ex", (Object)throwable)).log();
            }
            return super.getProcessID();
        }
    }

    @Override
    public File getWellKnownDirectory(String string) {
        if (LinuxNative.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getWellKnownDirectory(String)", 171).addDetail("directoryLabel", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        switch (string.toLowerCase()) {
            case "desktop": {
                return this.a("DESKTOP", "Desktop");
            }
            case "documents": {
                return this.a("DOCUMENTS", "Documents");
            }
            case "downloads": {
                return this.a("DOWNLOAD", "Downloads");
            }
            case "music": {
                return this.a("MUSIC", "Music");
            }
            case "pictures": {
                return this.a("PICTURES", "Pictures");
            }
            case "videos": {
                return this.a("VIDEOS", "Videos");
            }
        }
        return null;
    }

    protected File a(String string, String string2) {
        File file;
        String string3;
        block13: {
            if (LinuxNative.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "xdgUserDirLookupWithFallback(String,String)", 216).addDetail("name", string)).addDetail("fallback", string2)).log();
            }
            if (Misc.emptyOrNull((String)(string3 = System.getenv("HOME")))) {
                return null;
            }
            String string4 = System.getenv("XDG_CONFIG_HOME");
            File file2 = Misc.emptyOrNull((String)string4) ? new File(string3, "/.config/user-dirs.dirs") : new File(string4, "/user-dirs.dirs");
            if (LinuxNative.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "xdgUserDirLookupWithFallback(String,String)", 227).add("configFile", (Object)file2)).log();
            }
            file = null;
            if (file2.exists()) {
                try {
                    Scanner scanner = new Scanner(file2);
                    while (scanner.hasNextLine()) {
                        String string5 = scanner.nextLine().trim();
                        if (!string5.startsWith("XDG_" + string + "_DIR")) continue;
                        int n2 = string5.indexOf(61);
                        String string6 = string5.substring(n2 + 1).trim();
                        if (string6.startsWith("\"")) {
                            string6 = string6.substring(1);
                        }
                        if (string6.endsWith("\"")) {
                            string6 = string6.substring(0, string6.length() - 1);
                        }
                        string6 = string6.replace("$HOME", string3);
                        file = new File(string6);
                    }
                    scanner.close();
                }
                catch (IOException iOException) {
                    if (LinuxNative.a.level < 5) break block13;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(5, "xdgUserDirLookupWithFallback(String,String)", 253).add("Could not read ")).add((Object)file2)).log();
                }
            }
        }
        if (LinuxNative.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "xdgUserDirLookupWithFallback(String,String)", 256).add("candidate", (Object)file)).log();
        }
        if (!(Misc.emptyOrNull((String)string2) || file != null && file.exists())) {
            file = new File(string3, string2);
            if (LinuxNative.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "xdgUserDirLookupWithFallback(String,String)", 260).add("candidate", (Object)file)).log();
            }
        }
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }
}

