/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.script.modules.Automac;
import de.qfs.apps.qftest.shared.system.ExternalScreenshotGrabber;
import de.qfs.apps.qftest.shared.system.MacOSScripting;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.NativeRobot;
import de.qfs.apps.qftest.shared.system.UnixNative;
import de.qfs.apps.qftest.shared.system.mac.PListAccess;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.Reflector;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.KeyStroke;

public class MacOSNative
extends UnixNative {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.shared.system.MacOSNative");
    public static final String APP_BUNDLE_ID = "de.qfs.apps.qftest";
    private final AtomicReference i = new AtomicReference();
    private MacOSNativeDirectRobot j = new MacOSNativeDirectRobot();
    final AtomicBoolean a = new AtomicBoolean();

    public MacOSNative() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "MacOSNative()", 48).log();
        }
    }

    static Native a() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "createInstance()", 66).log();
        }
        return new MacOSNative();
    }

    @Override
    public File getApplicationSupportDirectory() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "getApplicationSupportDirectory()", 75).log();
        }
        return this.a(14);
    }

    @Override
    public File getSystemApplicationSupportDirectory(boolean bl) {
        block13: {
            if (MacOSNative.b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "getSystemApplicationSupportDirectory(boolean)", 84).addDetail("interactive", bl)).log();
            }
            try {
                File file;
                block14: {
                    List list = Automac.instance().getSearchPathForDirectoriesInDomains(14, 2, true);
                    if (MacOSNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getSystemApplicationSupportDirectory(boolean)", 89).add("searchPath", (Object)list)).log();
                    }
                    if (list.size() == 0) {
                        return null;
                    }
                    String string = (String)list.get(0);
                    if (Misc.emptyOrNull((String)string)) break block13;
                    file = new File(string, APP_BUNDLE_ID);
                    if (bl) {
                        String string2 = file.getAbsolutePath();
                        if (!file.exists()) {
                            Message.showMessage(null, (String)"macos.admin.createappdata", (Object[])new Object[]{string2});
                            String string3 = String.format("do shell script \"mkdir '%1$s';chmod 777 '%1$s'\" with administrator privileges", string2);
                            try {
                                MacOSScripting.runApplescript(string3);
                            }
                            catch (Exception exception) {
                                if (MacOSNative.b.level >= 5) {
                                    ((LevelAwareLogBuilder)b.lvlBuild(5, "getSystemApplicationSupportDirectory(boolean)", 104).add("e", (Object)exception)).log();
                                }
                                break block14;
                            }
                        }
                        if (!file.canWrite()) {
                            Message.showMessage(null, (String)"macos.admin.writeappdata", (Object[])new Object[]{string2});
                            String string4 = String.format("do shell script \"chmod 777 '%s'\" with administrator privileges", string2);
                            try {
                                MacOSScripting.runApplescript(string4);
                            }
                            catch (Exception exception) {
                                if (MacOSNative.b.level < 5) break block14;
                                ((LevelAwareLogBuilder)b.lvlBuild(5, "getSystemApplicationSupportDirectory(boolean)", 112).add("e", (Object)exception)).log();
                            }
                        }
                    }
                }
                return file;
            }
            catch (Exception exception) {
                if (MacOSNative.b.level < 1) break block13;
                ((LevelAwareLogBuilder)b.lvlBuild(1, "getSystemApplicationSupportDirectory(boolean)", 119).add("ex", (Object)exception)).log();
            }
        }
        return null;
    }

    @Override
    public File getCacheDirectory() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "getCacheDirectory()", 128).log();
        }
        return this.a(13);
    }

    @Override
    public File getAutosaveDirectory() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "getAutosaveDirectory()", 137).log();
        }
        return this.a(11);
    }

    @Override
    public File getWellKnownDirectory(String string) {
        if (MacOSNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getWellKnownDirectory(String)", 146).addDetail("directoryLabel", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        switch (string.toLowerCase()) {
            case "desktop": {
                return this.getDirectoryFromUserSearchPath(12, true);
            }
            case "documents": {
                return this.getDirectoryFromUserSearchPath(9, true);
            }
            case "downloads": {
                return this.getDirectoryFromUserSearchPath(15, true);
            }
            case "music": {
                return this.getDirectoryFromUserSearchPath(18, true);
            }
            case "pictures": {
                return this.getDirectoryFromUserSearchPath(19, true);
            }
            case "videos": {
                return this.getDirectoryFromUserSearchPath(17, true);
            }
        }
        return null;
    }

    public File getDirectoryFromUserSearchPath(int n2, boolean bl) {
        block9: {
            if (MacOSNative.b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getDirectoryFromUserSearchPath(int,boolean)", 171).addDetail("directoryId", n2)).addDetail("mustExists", bl)).log();
            }
            try {
                List list = Automac.instance().getSearchPathForDirectoriesInDomains(n2, 1, true);
                if (MacOSNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getDirectoryFromUserSearchPath(int,boolean)", 175).add("searchPath", (Object)list)).log();
                }
                if (list.size() == 0) {
                    return null;
                }
                String string = (String)list.get(0);
                if (MacOSNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getDirectoryFromUserSearchPath(int,boolean)", 179).add("baseDir", string)).log();
                }
                if (!Misc.emptyOrNull((String)string)) {
                    File file = new File(string);
                    if (MacOSNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getDirectoryFromUserSearchPath(int,boolean)", 182).add("dir", (Object)file)).log();
                    }
                    if (!bl || file.exists()) {
                        return file;
                    }
                }
            }
            catch (Exception exception) {
                if (MacOSNative.b.level < 1) break block9;
                ((LevelAwareLogBuilder)b.lvlBuild(1, "getDirectoryFromUserSearchPath(int,boolean)", 188).add("ex", (Object)exception)).log();
            }
        }
        return null;
    }

    @Override
    public boolean writeToQFTestDirAllowed() {
        String string;
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "writeToQFTestDirAllowed()", 197).log();
        }
        return (string = Globals.getGlobalString("qftestdir", null)) != null && !string.toLowerCase().contains(".app/");
    }

    private File a(int n2) {
        block10: {
            if (MacOSNative.b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "getAppDirectoryFromUserSearchPath(int)", 206).addDetail("directory", n2)).log();
            }
            try {
                List list = Automac.instance().getSearchPathForDirectoriesInDomains(n2, 1, true);
                if (MacOSNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getAppDirectoryFromUserSearchPath(int)", 210).add("searchPath", (Object)list)).log();
                }
                if (list.size() == 0) {
                    return null;
                }
                String string = (String)list.get(0);
                if (MacOSNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getAppDirectoryFromUserSearchPath(int)", 214).add("baseDir", string)).log();
                }
                if (!Misc.emptyOrNull((String)string)) {
                    File file = new File(string, APP_BUNDLE_ID);
                    if (MacOSNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "getAppDirectoryFromUserSearchPath(int)", 217).add("appDir", (Object)file)).log();
                    }
                    if (!file.exists()) {
                        boolean bl = file.mkdirs();
                        if (MacOSNative.b.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "getAppDirectoryFromUserSearchPath(int)", 220).add("Creating dir: ")).add(bl)).log();
                        }
                    }
                    return file;
                }
            }
            catch (Exception exception) {
                if (MacOSNative.b.level < 1) break block10;
                ((LevelAwareLogBuilder)b.lvlBuild(1, "getAppDirectoryFromUserSearchPath(int)", 225).add("ex", (Object)exception)).log();
            }
        }
        return null;
    }

    public static String interpreteCommand(String string) {
        if (MacOSNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "interpreteCommand(String)", 238).addDetail("command", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        int n2 = string.indexOf(".app");
        if (n2 > -1 && n2 < string.length() - 4) {
            return string;
        }
        boolean bl = string.endsWith(".app");
        if (bl) {
            return "open -a \"" + string + "\"";
        }
        if (new File(string + ".app").exists()) {
            return "open -a \"" + string + ".app\"";
        }
        if (new File(string).exists()) {
            return string;
        }
        List list = Automac.instance().getSearchPathForDirectoriesInDomains(100, 65535, true);
        if (MacOSNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "interpreteCommand(String)", 259).add("appDirs", (Object)list)).log();
        }
        for (String string2 : list) {
            File file = new File(string2 + "/" + string + ".app");
            if (MacOSNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "interpreteCommand(String)", 263).add("candidate", (Object)file)).log();
            }
            if (!file.exists()) continue;
            return "open -a \"" + string + "\"";
        }
        if (string.matches("^[A-Z].*")) {
            return "open -a \"" + string + "\"";
        }
        return string;
    }

    @Override
    public String getExecutable(String string) {
        if (MacOSNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getExecutable(String)", 283).addDetail("container", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("container is marked non-null but is null");
        }
        File file = new File(string);
        if (!file.exists()) {
            file = new File(string + ".app");
        }
        if (!(file.exists() && file.isDirectory() && file.getName().endsWith(".app"))) {
            return string;
        }
        File file2 = PListAccess.instance().getExecutable(file);
        if (file2 == null) {
            return string;
        }
        return file2.getAbsolutePath();
    }

    @Override
    public boolean isCompliantInstallation() {
        String string;
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "isCompliantInstallation()", 306).log();
        }
        if ((string = Globals.getGlobalString("qftestdir", null)) == null) {
            return false;
        }
        List list = Automac.instance().getSearchPathForDirectoriesInDomains(1, 65535, true);
        if (MacOSNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "isCompliantInstallation()", 313).add("appDirs", (Object)list)).log();
        }
        for (String string2 : list) {
            if (!string.startsWith(string2 + "/QF-Test")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean showFileInSystemExplorer(File file) {
        if (MacOSNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "showFileInSystemExplorer(File)", 327).addDetail("file", (Object)file)).log();
        }
        this.checkFileExist(file);
        try {
            int n2 = Options.getInt(Options.OPT_OPEN_FILE_IN_EXPLORER_TIMEOUT, 3000);
            if (file.isDirectory()) {
                ProcessManager.runProcess((String[])new String[]{"open", file.getAbsolutePath()}, (int)n2);
            } else {
                ProcessManager.runProcess((String[])new String[]{"open", "-R", file.getAbsolutePath()}, (int)n2);
            }
            return true;
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (MacOSNative.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "showFileInSystemExplorer(File)", 339).add("e", (Object)runProcessException)).log();
            }
            return super.showFileInSystemExplorer(file);
        }
    }

    @Override
    public void keybdEvent(int n2, int n3) {
        block2: {
            try {
                Automac.instance().postKeyboardEvent(n2, 0, (n3 & 0) > 0);
            }
            catch (Throwable throwable) {
                if (MacOSNative.b.level < 5) break block2;
                ((LevelAwareLogBuilder)b.lvlBuild(5, "keybdEvent(int,int)", 354).add("ex", (Object)throwable)).log();
            }
        }
    }

    @Override
    public void charInput(char c2, int n2, int n3) {
        block5: {
            try {
                if (n2 != 0) {
                    Automac.instance().postKeyboardEvent(n2, n3, true);
                    Automac.instance().postKeyboardEvent(n2, n3, false);
                } else {
                    KeyStroke[] keyStrokeArray;
                    for (KeyStroke keyStroke : keyStrokeArray = Automac.instance().keyStrokesForString("" + c2)) {
                        Automac.instance().postKeyboardEvent(keyStroke.getKeyCode(), keyStroke.getModifiers() | n3, true);
                        Automac.instance().postKeyboardEvent(keyStroke.getKeyCode(), keyStroke.getModifiers() | n3, false);
                    }
                }
            }
            catch (Throwable throwable) {
                if (MacOSNative.b.level < 5) break block5;
                ((LevelAwareLogBuilder)b.lvlBuild(5, "charInput(char,int,int)", 377).add("ex", (Object)throwable)).log();
            }
        }
    }

    @Override
    public String stringForKeyCodes(int[] nArray, int n2) {
        if (MacOSNative.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "stringForKeyCodes(int[],int)", 385).addDetail("keyCodes", (Object)nArray)).addDetail("modifiers", n2)).log();
        }
        if (nArray == null) {
            return "";
        }
        KeyStroke[] keyStrokeArray = new KeyStroke[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            keyStrokeArray[i2] = KeyStroke.getKeyStroke(nArray[i2], n2);
        }
        return Automac.instance().stringForKeyStrokes(keyStrokeArray);
    }

    @Override
    public int getProcessID() {
        try {
            Object object = Automac.instance().currentApplication();
            if (MacOSNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getProcessID()", 403).add("currentApplication", object)).log();
            }
            if (object == null) {
                return 0;
            }
            Object object2 = Reflector.safeCall((Object)object, (String)"getProcessIdentifier");
            if (MacOSNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getProcessID()", 408).add("processIdentifier", object2)).log();
            }
            if (object2 == null || (Integer)object2 < 0) {
                return 0;
            }
            return (Integer)object2;
        }
        catch (Exception exception) {
            if (MacOSNative.b.level >= 1) {
                ((LevelAwareLogBuilder)b.lvlBuild(1, "getProcessID()", 414).add("Could not get process id", (Object)exception)).log();
            }
            return 0;
        }
    }

    @Override
    public boolean canDetectSystemDarkMode() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "canDetectSystemDarkMode()", 423).log();
        }
        return this.isAtLeastMacOsMojave();
    }

    private boolean f() {
        String string;
        VersionNumber versionNumber;
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "detectIfAtLeastMacOsMojave()", 430).log();
        }
        return (versionNumber = VersionNumber.fromString((String)(string = System.getProperty("os.version")))).getMajor() > 10 || versionNumber.getMedium() > 13;
    }

    @Override
    public boolean isSystemInDarkMode() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "isSystemInDarkMode()", 441).log();
        }
        if (!this.canDetectSystemDarkMode()) {
            return false;
        }
        return Automac.instance().isSystemInDarkMode();
    }

    @Override
    public void listenForDarkModeSwitch() {
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "listenForDarkModeSwitch()", 453).log();
        }
        if (!this.a.compareAndSet(false, true)) {
            return;
        }
        if (!this.canDetectSystemDarkMode()) {
            return;
        }
        Automac.instance().addDistributedNotificationObserver("AppleInterfaceThemeChangedNotification", (observable, object) -> MacOSNative.a(this.isSystemInDarkMode()));
    }

    @Override
    public void setAppAppearance(boolean bl) {
        if (MacOSNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "setAppAppearance(boolean)", 467).addDetail("dark", bl)).log();
        }
        Automac.instance().setAppAppearance(bl);
    }

    @Override
    public NativeRobot getNativeRobot() {
        return this.j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAtLeastMacOsMojave() {
        Object object;
        if (MacOSNative.b.level >= 7) {
            b.lvlBuild(7, "isAtLeastMacOsMojave()", 41).log();
        }
        if ((object = this.i.get()) == null) {
            AtomicReference atomicReference = this.i;
            synchronized (atomicReference) {
                object = this.i.get();
                if (object == null) {
                    boolean bl = this.f();
                    object = bl;
                    this.i.set(object);
                }
            }
        }
        return (Boolean)object;
    }

    public static class MacOSNativeDirectRobot
    implements NativeRobot {
        public boolean forceExternalScreenshotGrabber;
        ExternalScreenshotGrabber a = new ExternalScreenshotGrabber(){

            @Override
            protected String a(String string, int n2, int n3, int n4, int n5) {
                if (b.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.ExternalScreenshotGrabber.buildScreenshotCommand(String,int,int,int,int)", 502).addDetail("filePath", string)).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
                }
                return String.format("/usr/sbin/screencapture -x -r -t%s -T0 -R%d,%d,%d,%d %s", this.a(), n2, n3, n4, n5, string);
            }
        };

        public MacOSNativeDirectRobot() {
            if (b.level >= 7) {
                b.lvlBuild(7, "MacOSNativeDirectRobot.MacOSNativeDirectRobot()", 491).log();
            }
        }

        @Override
        public int getScreenCount() {
            if (b.level >= 7) {
                b.lvlBuild(7, "MacOSNativeDirectRobot.getScreenCount()", 522).log();
            }
            int n2 = Automac.instance().getScreenCount();
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.getScreenCount()", 525).add("screenCount", n2)).log();
            }
            return n2;
        }

        @Override
        public double getScreenScaling(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.getScreenScaling(int)", 540).addDetail("screen", n2)).log();
            }
            double d2 = Automac.instance().getScreenScaling(n2);
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.getScreenScaling(int)", 543).add("screen", n2)).add("screenScaling", d2)).log();
            }
            return d2;
        }

        @Override
        public boolean isPrimaryScreen(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.isPrimaryScreen(int)", 557).addDetail("screen", n2)).log();
            }
            boolean bl = Automac.instance().isPrimaryScreen(n2);
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.isPrimaryScreen(int)", 560).add("screen", n2)).add("primaryScreen", bl)).log();
            }
            return bl;
        }

        @Override
        public int[] getScreenBounds(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.getScreenBounds(int)", 574).addDetail("screen", n2)).log();
            }
            int[] nArray = Automac.instance().getScreenBounds(n2);
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.getScreenBounds(int)", 577).add("screen", n2)).add("screenBounds", (Object)nArray)).log();
            }
            return nArray;
        }

        @Override
        public int[] getVisualScreenBounds(int n2) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.getVisualScreenBounds(int)", 592).addDetail("screen", n2)).log();
            }
            int[] nArray = Automac.instance().getVisualScreenBounds(n2);
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.getVisualScreenBounds(int)", 595).add("screen", n2)).add("visualScreenBounds", (Object)nArray)).log();
            }
            return nArray;
        }

        @Override
        public int[] grabScreenshot(int n2, int n3, int n4, int n5) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.grabScreenshot(int,int,int,int)", 612).addDetail("x", n2)).addDetail("y", n3)).addDetail("width", n4)).addDetail("height", n5)).log();
            }
            if (Options.cached_OPT_MACOS_USE_SCREENCAPTURE_TOOL || this.forceExternalScreenshotGrabber) {
                return this.a.grabScreenshot(n2, n3, n4, n5);
            }
            try {
                return Automac.instance().grabScreenshot(n2, n3, n4, n5);
            }
            catch (IllegalStateException illegalStateException) {
                if (b.level >= 5) {
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "MacOSNativeDirectRobot.grabScreenshot(int,int,int,int)", 623).add("Falling back to external screenshot grabbing")).log();
                }
                this.forceExternalScreenshotGrabber = true;
                return this.grabScreenshot(n2, n3, n4, n5);
            }
        }

        @Override
        public int[] grabScreenshot(int n2, int n3, int n4, int n5, int n6) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.grabScreenshot(int,int,int,int,int)", 643).addDetail("screen", n2)).addDetail("x", n3)).addDetail("y", n4)).addDetail("width", n5)).addDetail("height", n6)).log();
            }
            if (Options.cached_OPT_MACOS_USE_SCREENCAPTURE_TOOL || this.forceExternalScreenshotGrabber) {
                int[] nArray = this.getScreenBounds(n2);
                return this.a.grabScreenshot(nArray[0] + n3, nArray[1] + n4, n5, n6);
            }
            try {
                return Automac.instance().grabScreenshot(n2, n3, n4, n5, n6);
            }
            catch (IllegalStateException illegalStateException) {
                if (b.level >= 5) {
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "MacOSNativeDirectRobot.grabScreenshot(int,int,int,int,int)", 655).add("Falling back to external screenshot grabbing")).log();
                }
                this.forceExternalScreenshotGrabber = true;
                return this.grabScreenshot(n2, n3, n4, n5, n6);
            }
        }

        @Override
        public void mouseMove(int n2, int n3) {
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.mouseMove(int,int)", 671).addDetail("x", n2)).addDetail("y", n3)).log();
            }
            Automac.instance().postMouseEvent(5, n2, n3, 0, 0, 0);
        }

        @Override
        public void mousePress(int n2) {
            int n3;
            int n4;
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.mousePress(int)", 685).addDetail("button", n2)).log();
            }
            switch (n2) {
                case 0: {
                    n4 = 1;
                    n3 = 0;
                    break;
                }
                case 2: {
                    n4 = 3;
                    n3 = 1;
                    break;
                }
                default: {
                    n4 = 25;
                    n3 = 2;
                }
            }
            int[] nArray = this.getMousePosition();
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.mousePress(int)", 703).add("button", n2)).add("mouseType", n4)).add("mouseButton", n3)).add("pos", (Object)nArray)).log();
            }
            Automac.instance().postMouseEvent(n4, nArray[0], nArray[1], n3, 1, 0);
        }

        @Override
        public void mouseRelease(int n2) {
            int n3;
            int n4;
            if (b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "MacOSNativeDirectRobot.mouseRelease(int)", 716).addDetail("button", n2)).log();
            }
            switch (n2) {
                case 0: {
                    n4 = 2;
                    n3 = 0;
                    break;
                }
                case 2: {
                    n4 = 4;
                    n3 = 1;
                    break;
                }
                default: {
                    n4 = 26;
                    n3 = 2;
                }
            }
            int[] nArray = this.getMousePosition();
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.mouseRelease(int)", 734).add("button", n2)).add("mouseType", n4)).add("mouseButton", n3)).add("pos", (Object)nArray)).log();
            }
            Automac.instance().postMouseEvent(n4, nArray[0], nArray[1], n3, 1, 0);
        }

        @Override
        public int[] getMousePosition() {
            if (b.level >= 7) {
                b.lvlBuild(7, "MacOSNativeDirectRobot.getMousePosition()", 747).log();
            }
            int[] nArray = Automac.instance().getMousePosition();
            if (b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "MacOSNativeDirectRobot.getMousePosition()", 750).add("pos", (Object)nArray)).log();
            }
            return nArray;
        }
    }
}

