/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.script.modules.UserNotifications;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.system.WindowsNativeDirect;
import de.qfs.apps.qftest.shared.system.WindowsNativeWrapped;
import de.qfs.apps.qftest.shared.system.win32.WinMisc;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.Reflector;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class WindowsNative
extends Native {
    private static final QFLogger b = new QFLogger("de.qfs.apps.qftest.shared.system.WindowsNative");
    private static final String g = "qfs".toUpperCase() + File.separator + "QF-Test";
    private static final String h = "setup.txt";
    public static final int KEYEVENTF_EXTENDEDKEY = 1;
    public static final int KEYEVENTF_KEYUP = 2;
    public static final int MAPVK_VK_TO_VSC = 0;
    public static final int WM_CLOSE = 16;
    public static final int WM_KEYDOWN = 256;
    public static final int WM_KEYUP = 257;
    public static final int WM_CHAR = 258;
    public static final int WM_COMMAND = 273;
    public static final int WM_SYSCOMMAND = 274;
    public static final int WM_LBUTTONDOWN = 513;
    public static final int WM_LBUTTONUP = 514;
    private boolean i;
    private final AtomicReference j = new AtomicReference();
    private final AtomicReference k = new AtomicReference();
    final AtomicBoolean a = new AtomicBoolean();

    protected WindowsNative() {
    }

    @Override
    public int getProcessID(@Nullable Process process) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getProcessID(Process)", 116).addDetail("process", (Object)process)).log();
        }
        if (process == null) {
            return 0;
        }
        Long l2 = (Long)Reflector.safeGet((Object)process, (String)"handle", (boolean)true);
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getProcessID(Process)", 120).add("handle", (Object)l2)).log();
        }
        if (l2 != null && l2 != 0L) {
            int n2 = this.getProcessID(l2);
            if (WindowsNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "getProcessID(Process)", 123).add("pid", n2)).log();
            }
            return n2;
        }
        return 0;
    }

    @Override
    public void sendQuitSignal(int n2) {
        block5: {
            if (WindowsNative.b.level >= 7) {
                ((LevelAwareLogBuilder)b.lvlBuild(7, "sendQuitSignal(int)", 141).addDetail("processID", n2)).log();
            }
            if (n2 == 0) {
                return;
            }
            try {
                String string = this.runProcess("qfps -is64 -pid " + n2, 10000);
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "sendQuitSignal(int)", 148).add("is64Bit", string)).log();
                }
                String string2 = "1".equals(string.trim()) ? "SendSignal" : "SendSignal32";
                final Process process = Runtime.getRuntime().exec("cmd /c start " + string2 + " " + n2);
                final byte[] byArray = new byte[32768];
                new DaemonThread(){

                    public void run() {
                        block3: {
                            try {
                                InputStream inputStream = process.getInputStream();
                                while (inputStream.read(byArray) >= 0) {
                                }
                            }
                            catch (Throwable throwable) {
                                if (b.level < 9) break block3;
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "sendQuitSignal(int).DaemonThread.run()", 163).add("ex", (Object)throwable)).log();
                            }
                        }
                    }
                }.start();
                new DaemonThread(){

                    public void run() {
                        block3: {
                            try {
                                InputStream inputStream = process.getErrorStream();
                                while (inputStream.read(byArray) >= 0) {
                                }
                            }
                            catch (Throwable throwable) {
                                if (b.level < 9) break block3;
                                ((LevelAwareLogBuilder)b.lvlBuild(9, "sendQuitSignal(int).DaemonThread.run()", 177).add("ex", (Object)throwable)).log();
                            }
                        }
                    }
                }.start();
            }
            catch (Exception exception) {
                if (WindowsNative.b.level < 3) break block5;
                ((LevelAwareLogBuilder)b.lvlBuild(3, "sendQuitSignal(int)", 182).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public File getApplicationSupportDirectory() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "getApplicationSupportDirectory()", 190).log();
        }
        return this.a("APPDATA");
    }

    @Override
    public File getSystemApplicationSupportDirectory(boolean bl) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getSystemApplicationSupportDirectory(boolean)", 199).addDetail("interactive", bl)).log();
        }
        return this.a("ProgramData");
    }

    @Override
    public File getCacheDirectory() {
        File file;
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "getCacheDirectory()", 208).log();
        }
        if ((file = this.getTopicApplicationSupportDirectory("Cache")).exists() || this.isCompliantInstallation() && file.mkdirs()) {
            return file;
        }
        return null;
    }

    @Override
    public File getWellKnownDirectory(String string) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getWellKnownDirectory(String)", 222).addDetail("directoryLabel", string)).log();
        }
        if (Misc.emptyOrNull((String)string)) {
            return null;
        }
        switch (string.toLowerCase()) {
            case "desktop": {
                return this.a("B4BFCC3A-DB2C-424C-B029-7FE99A87C641", "754AC886-DF64-4CBA-86B5-F7FBF4FBCEF5", "Desktop");
            }
            case "documents": {
                return this.a("FDD39AD0-238F-46AF-ADB4-6C85480369C7", "f42ee2d3-909f-4907-8871-4c22fc0bf756", "Documents");
            }
            case "downloads": {
                return this.a("374DE290-123F-4565-9164-39C4925E467B", "7d83ee9b-2244-4e70-b1f5-5393042af1e4", "Downloads");
            }
            case "music": {
                return this.a("4BD8D571-6D19-48D3-BE97-422220080E43", "a0c69a99-21c8-4671-8703-7934162fcf1d", "Music");
            }
            case "pictures": {
                return this.a("33E28130-4E1E-4676-835A-98395C3BC3BB", "0ddd015d-b06c-45d5-8c4c-f59713854639", "Pictures");
            }
            case "videos": {
                return this.a("18989B1D-99B5-455B-841C-AB7C74E4DDFC", "35286a68-3c57-41a1-bbb1-0eae73d76c95", "Videos");
            }
        }
        return null;
    }

    @Nullable
    private File a(String string, String string2, String string3) {
        File file;
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "determineWellKnownDirectory(String,String,String)", 248).addDetail("knownFolderGUID", string)).addDetail("registryFolderUUID", string2)).addDetail("defaultSubdir", string3)).log();
        }
        String string4 = WinMisc.GetKnownFolder(string);
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "determineWellKnownDirectory(String,String,String)", 252).add("knownFolder", string4)).log();
        }
        if (string4 != null) {
            return new File(string4);
        }
        String string5 = System.getenv("UserProfile");
        if (Misc.emptyOrNull((String)string5)) {
            return null;
        }
        Object object = WinMisc.RegistryGetValue("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FolderDescriptions\\{" + string2 + "}", "RelativePath");
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "determineWellKnownDirectory(String,String,String)", 263).add("relativePath", object)).log();
        }
        if (object != null) {
            file = new File(string5, string3);
            if (WindowsNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "determineWellKnownDirectory(String,String,String)", 266).add("candidate", (Object)file)).log();
            }
            if (file.isDirectory()) {
                return file;
            }
        }
        file = new File(string5, string3);
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "determineWellKnownDirectory(String,String,String)", 273).add("candidate", (Object)file)).log();
        }
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    @Override
    public boolean writeToQFTestDirAllowed() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "writeToQFTestDirAllowed()", 284).log();
        }
        return !this.isCompliantInstallation();
    }

    private File a(String string) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getAppDirectoryBySystemEnv(String)", 292).addDetail("systemEnv", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("systemEnv is marked non-null but is null");
        }
        return this.a(string, null);
    }

    private File a(String string, @Nullable String string2) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "getAppDirectoryBySystemEnv(String,String)", 299).addDetail("systemEnv", string)).addDetail("intermediatePath", string2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("systemEnv is marked non-null but is null");
        }
        if (Boolean.getBoolean("qftest.file.ignoreSystemDirs")) {
            return null;
        }
        String string3 = System.getenv(string);
        if (!Misc.emptyOrNull((String)string3)) {
            File file = Misc.emptyOrNull((String)string2) ? new File(string3) : new File(string3, string2);
            File file2 = new File(file, g);
            return file2;
        }
        return null;
    }

    @Override
    public boolean isCompliantInstallation() {
        String string;
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "isCompliantInstallation()", 320).log();
        }
        if (Misc.emptyOrNull((String)(string = Globals.getGlobalString("qftestdir", null)))) {
            return false;
        }
        boolean bl = new File(string, h).exists();
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "isCompliantInstallation()", 326).add("ret", bl)).log();
        }
        return bl;
    }

    @Override
    public boolean showFileInSystemExplorer(File file) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "showFileInSystemExplorer(File)", 334).addDetail("file", (Object)file)).log();
        }
        this.checkFileExist(file);
        try {
            ProcessManager.runProcess((String[])new String[]{"explorer.exe", "\"/select," + file.getAbsolutePath() + "\""}, (int)Options.getInt(Options.OPT_OPEN_FILE_IN_EXPLORER_TIMEOUT, 3000));
            return true;
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (runProcessException.getExitCode() == 1) {
                return true;
            }
            if (WindowsNative.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "showFileInSystemExplorer(File)", 344).add("e", (Object)runProcessException)).log();
            }
            return super.showFileInSystemExplorer(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForegroundWindow(long l2, String string, long l3) {
        block43: {
            if (WindowsNative.b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "setForegroundWindow(long,String,long)", 363).addDetail("handle", l2)).addDetail("titleRe", string)).addDetail("sleep", l3)).dumpStack();
            }
            long l4 = this.e();
            if (WindowsNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 367).add("fgWnd", l4)).log();
            }
            if (l2 != 0L && l4 == l2) {
                if (WindowsNative.b.level >= 5) {
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "setForegroundWindow(long,String,long)", 369).add("Window already is the foreground window:", l2)).log();
                }
                boolean bl = this.c(l2);
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 371).add("broughtToTop", bl)).log();
                }
                return;
            }
            long l5 = 0L;
            if (l2 != 0L) {
                l5 = l2;
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 380).add("wnd", l5)).log();
                }
                long l6 = this.a(l5);
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 383).add("parent", l6)).log();
                }
                if (l6 != 0L) {
                    Set set = this.g();
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 386).add("toplevels", (Object)set)).log();
                    }
                    while (true) {
                        if (set.contains(l5)) {
                            if (WindowsNative.b.level < 9) break;
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 389).add("Toplevel wnd", l5)).log();
                            break;
                        }
                        if (WindowsNative.b.level >= 9) {
                            ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 392).add("parent", l6)).log();
                        }
                        if (l6 == 0L) {
                            if (WindowsNative.b.level < 5) break;
                            ((LevelAwareLogBuilder)b.lvlBuild(5, "setForegroundWindow(long,String,long)", 394).add("Oops: Final wnd not in toplevels", l5)).log();
                            break;
                        }
                        l5 = l6;
                        l6 = this.a(l6);
                    }
                }
                if (l5 == l4) {
                    if (WindowsNative.b.level >= 5) {
                        ((LevelAwareLogBuilder)b.lvlBuild(5, "setForegroundWindow(long,String,long)", 403).add("Window already is the foreground window:", l5)).log();
                    }
                    boolean bl = this.c(l5);
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 405).add("broughtToTop", bl)).log();
                    }
                    return;
                }
            } else if (string != null) {
                Iterator iterator = this.g().iterator();
                while (iterator.hasNext()) {
                    long l7 = (Long)iterator.next();
                    String string2 = this.d(l7);
                    if (string2 == null || !string2.matches(string)) continue;
                    l5 = l7;
                    if (WindowsNative.b.level < 9) break;
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 413).add("Wnd from title", l5)).log();
                    break;
                }
            }
            if (l5 == 0L) {
                if (WindowsNative.b.level >= 5) {
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "setForegroundWindow(long,String,long)", 419).add("No window to raise")).log();
                }
                return;
            }
            if (this.i) {
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 425).add("Attempting to raise without CONTROL hack")).log();
                }
                boolean bl = this.b(l5);
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 427).add("setForegroundSuccessful", bl)).log();
                }
                if (bl) {
                    if (WindowsNative.b.level >= 5) {
                        ((LevelAwareLogBuilder)b.lvlBuild(5, "setForegroundWindow(long,String,long)", 429).add("Raise without CONTROL successful")).log();
                    }
                    return;
                }
            }
            boolean bl = false;
            try {
                if (!this.a(17)) {
                    l4 = this.e();
                    bl = true;
                    this.keybdEvent(17, 1);
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 442).add("CONTROL pressed")).log();
                    }
                    this.i = true;
                }
                boolean bl2 = this.b(l5);
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 447).add("setForegroundSuccessful", bl2)).log();
                }
                if (WindowsNative.b.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(5, "setForegroundWindow(long,String,long)", 448).add("Raise with CONTROL ")).add(bl2 ? "" : "not ")).add("successful")).log();
                }
            }
            finally {
                if (bl) {
                    this.keybdEvent(17, 3);
                    this.a(l4, 257, 17L, 0L);
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 453).add("CONTROL released")).log();
                    }
                }
            }
            l4 = this.e();
            if (WindowsNative.b.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 457).add("final foreground")).add("fgWnd", l4)).log();
            }
            if (l3 > 0L) {
                try {
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 463).add("sleeping ")).add(l3)).add(" ms")).log();
                    }
                    Thread.sleep(l3);
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "setForegroundWindow(long,String,long)", 465).add("wakeup")).log();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (WindowsNative.b.level < 5) break block43;
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "setForegroundWindow(long,String,long)", 467).add("ex", (Object)interruptedException)).log();
                }
            }
        }
    }

    @Override
    @Nullable
    public ArrayList getProcessTreeList(int n2) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getProcessTreeList(int)", 488).addDetail("pid", n2)).log();
        }
        if (n2 == 0) {
            return null;
        }
        return this.getProcessTreeList(n2, new String[]{this.a(), "-listparent"});
    }

    protected String a() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "getQfPs()", 497).log();
        }
        String string = "qfps";
        String string2 = WindowsNative.getVersionDir();
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getQfPs()", 502).add("versionDir", string2)).log();
        }
        if (string2 != null) {
            string = new File(new File(string2, "bin"), "qfps.exe").getAbsolutePath();
        }
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "getQfPs()", 507).add("qfps", string)).log();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killProcessTreeList(Collection collection, int n2) {
        block15: {
            if (WindowsNative.b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "killProcessTreeList(Collection<Integer>,int)", 521).addDetail("pids", (Object)collection)).addDetail("signal", n2)).log();
            }
            try {
                ProcessManager processManager;
                String string = this.a();
                String[] stringArray = new String[collection.size() * 2 + 2];
                int n3 = 0;
                stringArray[n3++] = string;
                stringArray[n3++] = "-kill";
                for (Integer n4 : collection) {
                    stringArray[n3++] = "-pid";
                    stringArray[n3++] = "" + n4;
                }
                if (WindowsNative.b.level >= 5) {
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "killProcessTreeList(Collection<Integer>,int)", 534).add("cmd", (Object)stringArray)).log();
                }
                if (WindowsNative.b.level >= 5) {
                    try {
                        processManager = new ProcessManager("qfps", new String[]{string, "-list"});
                        processManager.setCollect(true, true);
                        processManager.startProcess();
                        processManager.waitFor(10000L);
                        if (WindowsNative.b.level >= 5) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(5, "killProcessTreeList(Collection<Integer>,int)", 541).add("pm returned", processManager.getExitCode())).add("output")).add("pm.getProcessOutputString()", processManager.getProcessOutputString())).log();
                        }
                    }
                    catch (Throwable throwable) {
                        if (WindowsNative.b.level >= 1) {
                            ((LevelAwareLogBuilder)b.lvlBuild(1, "killProcessTreeList(Collection<Integer>,int)", 543).add("ex", (Object)throwable)).log();
                        }
                    }
                    finally {
                        Log.setQueueing((boolean)false);
                        Log.setQueueing((boolean)true);
                    }
                }
                processManager = new ProcessManager("killtree", stringArray);
                processManager.setCollect(true, true);
                processManager.startProcess();
                processManager.waitFor(10000L);
                if (WindowsNative.b.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(5, "killProcessTreeList(Collection<Integer>,int)", 554).add("pm returned", processManager.getExitCode())).add("output")).add("pm.getProcessOutputString()", processManager.getProcessOutputString())).log();
                }
            }
            catch (Exception exception) {
                if (WindowsNative.b.level < 1) break block15;
                ((LevelAwareLogBuilder)b.lvlBuild(1, "killProcessTreeList(Collection<Integer>,int)", 557).add("ex", (Object)exception)).log();
            }
        }
    }

    @Override
    public void killProcesses(String string, boolean bl) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "killProcesses(String,boolean)", 571).addDetail("processName", string)).addDetail("orphaned", bl)).log();
        }
        ArrayList arrayList = this.getProcessIds(string);
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "killProcesses(String,boolean)", 574).add("pids", (Object)arrayList)).log();
        }
        if (arrayList.size() == 0) {
            return;
        }
        ArrayList arrayList2 = new ArrayList();
        if (bl) {
            arrayList2 = this.getOrphanedProcessIds();
            if (WindowsNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "killProcesses(String,boolean)", 581).add("orphans", (Object)arrayList2)).log();
            }
        }
        for (Integer n2 : arrayList) {
            if (!bl || arrayList2.indexOf(n2) >= 0) {
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "killProcesses(String,boolean)", 585).add("Killing process", (Object)n2)).log();
                }
                String string2 = this.runProcess(this.a() + " -kill -pid " + n2, 10000);
                continue;
            }
            if (WindowsNative.b.level < 9) continue;
            ((LevelAwareLogBuilder)b.lvlBuild(9, "killProcesses(String,boolean)", 588).add("Not orphaned", (Object)n2)).log();
        }
    }

    @Override
    public int getMemoryUsage(int n2) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getMemoryUsage(int)", 607).addDetail("pid", n2)).log();
        }
        return this.getMemoryUsage(n2, true);
    }

    @Override
    public int getMemoryUsageOfProcessTree(int n2) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getMemoryUsageOfProcessTree(int)", 621).addDetail("pid", n2)).log();
        }
        return this.getMemoryUsageOfProcessTree(n2, true);
    }

    static WindowsNative b() {
        WindowsNative windowsNative;
        block11: {
            block9: {
                windowsNative = null;
                if ("true".equalsIgnoreCase(System.getProperty("qfs.native.windows.wrapped"))) {
                    try {
                        windowsNative = WindowsNativeWrapped.i();
                    }
                    catch (Throwable throwable) {
                        if (WindowsNative.b.level < 5) break block9;
                        ((LevelAwareLogBuilder)b.lvlBuild(5, "createInstance()", 645).add("ex", (Object)throwable)).log();
                    }
                }
            }
            if (windowsNative == null) {
                block10: {
                    try {
                        windowsNative = WindowsNativeDirect.i();
                    }
                    catch (Throwable throwable) {
                        if (WindowsNative.b.level < 5) break block10;
                        ((LevelAwareLogBuilder)b.lvlBuild(5, "createInstance()", 653).add("ex", (Object)throwable)).log();
                    }
                }
                if (windowsNative == null) {
                    try {
                        windowsNative = WindowsNativeWrapped.i();
                    }
                    catch (Throwable throwable) {
                        if (WindowsNative.b.level < 5) break block11;
                        ((LevelAwareLogBuilder)b.lvlBuild(5, "createInstance()", 659).add("ex", (Object)throwable)).log();
                    }
                }
            }
        }
        return windowsNative;
    }

    public String runProcess(String string, int n2) {
        String string2;
        block7: {
            if (WindowsNative.b.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "runProcess(String,int)", 676).addDetail("cmd", string)).addDetail("timeout", n2)).log();
            }
            string2 = "";
            ProcessManager processManager = new ProcessManager("proc", string);
            processManager.setCollect(true, false);
            try {
                processManager.startProcess();
                if (processManager.waitFor((long)n2)) {
                    string2 = processManager.getProcessOutputString();
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)b.lvlBuild(9, "runProcess(String,int)", 685).add("output", string2)).log();
                    }
                } else if (WindowsNative.b.level >= 3) {
                    ((LevelAwareLogBuilder)b.lvlBuild(3, "runProcess(String,int)", 688).add("The process timed out")).log();
                }
            }
            catch (IOException iOException) {
                if (WindowsNative.b.level < 1) break block7;
                ((LevelAwareLogBuilder)b.lvlBuild(1, "runProcess(String,int)", 691).add("ex", (Object)iOException)).log();
            }
        }
        return string2;
    }

    public ArrayList getProcessIds(String string) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "getProcessIds(String)", 705).addDetail("processName", string)).log();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string2 = this.runProcess(this.a() + " -list", 10000);
        Pattern pattern = Pattern.compile(string + ".*pid\\s?=\\s?(\\d+)");
        Matcher matcher = pattern.matcher(string2);
        while (matcher.find()) {
            int n2 = Integer.parseInt(matcher.group(1));
            arrayList.add(n2);
        }
        return arrayList;
    }

    public ArrayList getOrphanedProcessIds() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "getOrphanedProcessIds()", 726).log();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string = this.runProcess(this.a() + " -listparent", 10000);
        Pattern pattern = Pattern.compile("(\\d+)\\s+0");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n2 = Integer.parseInt(matcher.group(1));
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public Set getRunningProcessIDs() {
        HashSet<Integer> hashSet;
        block7: {
            if (WindowsNative.b.level >= 7) {
                b.lvlBuild(7, "getRunningProcessIDs()", 743).log();
            }
            hashSet = new HashSet<Integer>();
            try {
                String string = ProcessManager.runProcess((String[])new String[]{this.a(), "-listparent"}, (int)10000);
                if (WindowsNative.b.level >= 9) {
                    ((LevelAwareLogBuilder)b.lvlBuild(9, "getRunningProcessIDs()", 748).add("pids", string)).log();
                }
                for (String string2 : Misc.fastSplit((String)string, (char)'\n')) {
                    string2 = string2.trim();
                    string2 = Misc.fastSplit((String)string2, (char)' ')[0];
                    try {
                        hashSet.add(Integer.parseInt(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (WindowsNative.b.level < 3) continue;
                        ((LevelAwareLogBuilder)b.lvlBuild(3, "getRunningProcessIDs()", 756).add("ex", (Object)numberFormatException)).log();
                    }
                }
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                if (WindowsNative.b.level < 5) break block7;
                ((LevelAwareLogBuilder)b.lvlBuild(5, "getRunningProcessIDs()", 760).add("e", (Object)runProcessException)).log();
            }
        }
        return hashSet;
    }

    @Override
    public boolean isProcessRunning(int n2) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "isProcessRunning(int)", 770).addDetail("targetPid", n2)).log();
        }
        try {
            String string = ProcessManager.runProcess((String[])new String[]{this.a(), "-listparent"}, (int)10000);
            if (WindowsNative.b.level >= 9) {
                ((LevelAwareLogBuilder)b.lvlBuild(9, "isProcessRunning(int)", 773).add("pids", string)).log();
            }
            for (String string2 : Misc.fastSplit((String)string, (char)'\n')) {
                string2 = string2.trim();
                string2 = Misc.fastSplit((String)string2, (char)' ')[0];
                try {
                    if (n2 != Integer.parseInt(string2)) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    if (WindowsNative.b.level < 3) continue;
                    ((LevelAwareLogBuilder)b.lvlBuild(3, "isProcessRunning(int)", 783).add("ex", (Object)numberFormatException)).log();
                }
            }
            return false;
        }
        catch (ProcessManager.RunProcessException runProcessException) {
            if (WindowsNative.b.level >= 5) {
                ((LevelAwareLogBuilder)b.lvlBuild(5, "isProcessRunning(int)", 788).add("e", (Object)runProcessException)).log();
            }
            if (runProcessException.getCause() != null) {
                throw runProcessException.getCause();
            }
            throw runProcessException;
        }
    }

    boolean a(int n2) {
        int n3;
        boolean bl;
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "isKeyPressed(int)", 799).addDetail("key", n2)).log();
        }
        boolean bl2 = bl = ((n3 = this.b(n2)) & 0x8000) != 0;
        if (WindowsNative.b.level >= 9) {
            ((LevelAwareLogBuilder)b.lvlBuild(9, "isKeyPressed(int)", 803).add("ret", bl)).log();
        }
        return bl;
    }

    public int awtKeyCodeToWinKeyCode(int n2) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "awtKeyCodeToWinKeyCode(int)", 810).addDetail("awtKeyCode", n2)).log();
        }
        switch (n2) {
            case 10: {
                return 13;
            }
            case 154: {
                return 44;
            }
            case 155: {
                return 45;
            }
            case 127: {
                return 46;
            }
            case 156: {
                return 47;
            }
            case 157: {
                return 91;
            }
            case 61440: {
                return 124;
            }
            case 61441: {
                return 125;
            }
            case 61442: {
                return 126;
            }
            case 61443: {
                return 127;
            }
            case 61444: {
                return 128;
            }
            case 61445: {
                return 129;
            }
            case 61446: {
                return 130;
            }
            case 61447: {
                return 131;
            }
            case 61448: {
                return 132;
            }
            case 61449: {
                return 133;
            }
            case 61450: {
                return 134;
            }
            case 61451: {
                return 135;
            }
        }
        return n2;
    }

    public int winKeyCodeToAwtKeyCode(int n2) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)b.lvlBuild(7, "winKeyCodeToAwtKeyCode(int)", 839).addDetail("winKeyCode", n2)).log();
        }
        switch (n2) {
            case 13: {
                return 10;
            }
            case 44: {
                return 154;
            }
            case 45: {
                return 155;
            }
            case 46: {
                return 127;
            }
            case 47: {
                return 156;
            }
            case 91: {
                return 157;
            }
            case 124: {
                return 61440;
            }
            case 125: {
                return 61441;
            }
            case 126: {
                return 61442;
            }
            case 127: {
                return 61443;
            }
            case 128: {
                return 61444;
            }
            case 129: {
                return 61445;
            }
            case 130: {
                return 61446;
            }
            case 131: {
                return 61447;
            }
            case 132: {
                return 61448;
            }
            case 133: {
                return 61449;
            }
            case 134: {
                return 61450;
            }
            case 135: {
                return 61451;
            }
        }
        return n2;
    }

    @Override
    public boolean canDetectSystemDarkMode() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "canDetectSystemDarkMode()", 869).log();
        }
        return this.isAtLeastWindows10() && this.isHasThemesPersonalizeKey();
    }

    private boolean i() {
        String string;
        VersionNumber versionNumber;
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "detectIfIsAtLeastWindows10()", 876).log();
        }
        return (versionNumber = VersionNumber.fromString((String)(string = System.getProperty("os.version")))).getMajor() > 6;
    }

    private boolean j() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "detectIfItHasThemesPersonalizeKey()", 886).log();
        }
        return WinMisc.RegistryKeyExists("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize");
    }

    @Override
    public boolean areAppsInDarkMode() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "areAppsInDarkMode()", 895).log();
        }
        if (this.canDetectSystemDarkMode()) {
            Object object = WinMisc.RegistryGetValue("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", "AppsUseLightTheme");
            return object instanceof Number && ((Number)object).intValue() != 1;
        }
        return false;
    }

    @Override
    public boolean isSystemInDarkMode() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "isSystemInDarkMode()", 909).log();
        }
        if (this.canDetectSystemDarkMode()) {
            Object object = WinMisc.RegistryGetValue("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", "SystemUsesLightTheme");
            return object instanceof Number && ((Number)object).intValue() != 1;
        }
        return false;
    }

    @Override
    public void listenForDarkModeSwitch() {
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "listenForDarkModeSwitch()", 923).log();
        }
        if (!this.a.compareAndSet(false, true)) {
            return;
        }
        if (!this.canDetectSystemDarkMode()) {
            return;
        }
        new DaemonThread(() -> {
            boolean bl = this.areAppsInDarkMode();
            boolean bl2 = this.isSystemInDarkMode();
            while (!Thread.currentThread().isInterrupted()) {
                if (WinMisc.WaitForRegistryChangeKeyValue("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", Integer.MAX_VALUE)) {
                    boolean bl3 = this.areAppsInDarkMode();
                    boolean bl4 = bl != bl3;
                    bl = bl3;
                    boolean bl5 = this.isSystemInDarkMode();
                    boolean bl6 = bl2 != bl5;
                    bl2 = bl5;
                    if (WindowsNative.b.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(9, "listenForDarkModeSwitch()", 946).add("appsAreInDarkMode", bl)).add("appsAreNowInDarkMode", bl3)).add("systemIsInDarkMode", bl2)).add("systemIsNowInDarkMode", bl5)).log();
                    }
                    if (!bl4 && !bl6 || UserNotifications.NOTIFIER.level < 1) continue;
                    UserNotifications.NOTIFIER.postNotification(1, "user.theme.systemChanged", null, new Object[]{"didChangeAppsTheme", bl4, "appsAreInDarkMode", bl3, "didChangeSystemTheme", bl6, "systemIsInDarkMode", bl2});
                    continue;
                }
                if (WindowsNative.b.level >= 5) {
                    ((LevelAwareLogBuilder)b.lvlBuild(5, "listenForDarkModeSwitch()", 955).add("Local personalization key does not exists. Stopping watching the key for changes.")).log();
                }
                return;
            }
            this.a.set(false);
        }, "Windows App Theme Change Listener").start();
    }

    @Override
    public void setWindowAppearance(long l2, boolean bl) {
        if (WindowsNative.b.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)b.lvlBuild(7, "setWindowAppearance(long,boolean)", 968).addDetail("handle", l2)).addDetail("dark", bl)).log();
        }
        WinMisc.DwmSetWindowAttributeInt(l2, 20, bl ? 1 : 0);
    }

    protected abstract long e();

    protected abstract List f();

    protected abstract Set g();

    protected abstract long a(long var1);

    protected abstract boolean b(long var1);

    protected abstract boolean c(long var1);

    protected abstract String d(long var1);

    protected abstract int b(int var1);

    @Override
    public abstract void keybdEvent(int var1, int var2);

    @Override
    protected abstract void a(long var1, int var3, long var4, long var6);

    @Override
    protected abstract void b(long var1, int var3, long var4, long var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAtLeastWindows10() {
        Object object;
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "isAtLeastWindows10()", 90).log();
        }
        if ((object = this.j.get()) == null) {
            AtomicReference atomicReference = this.j;
            synchronized (atomicReference) {
                object = this.j.get();
                if (object == null) {
                    boolean bl = this.i();
                    object = bl;
                    this.j.set(object);
                }
            }
        }
        return (Boolean)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHasThemesPersonalizeKey() {
        Object object;
        if (WindowsNative.b.level >= 7) {
            b.lvlBuild(7, "isHasThemesPersonalizeKey()", 91).log();
        }
        if ((object = this.k.get()) == null) {
            AtomicReference atomicReference = this.k;
            synchronized (atomicReference) {
                object = this.k.get();
                if (object == null) {
                    boolean bl = this.j();
                    object = bl;
                    this.k.set(object);
                }
            }
        }
        return (Boolean)object;
    }
}

