/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.system.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.VerRsrc;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.system.win32.WinApiAccessHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class WinApiAccessHelperImpl
extends ExternalClassWrapperHelper
implements WinApiAccessHelper {
    private static final QFLogger d = new QFLogger("de.qfs.apps.qftest.shared.system.win32.WinApiAccessHelperImpl");
    static final AtomicBoolean c = new AtomicBoolean();
    public static final long DWMWA_USE_IMMERSIVE_DARK_MODE = 20L;

    public WinApiAccessHelperImpl() {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            d.lvlBuild(7, "WinApiAccessHelperImpl.WinApiAccessHelperImpl()", 70).log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preload() {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            d.lvlBuild(7, "preload()", 82).log();
        }
        AtomicBoolean atomicBoolean = c;
        synchronized (atomicBoolean) {
            block7: {
                if (c.getAndSet(true)) {
                    return;
                }
                try {
                    new IntByReference();
                    new PointerByReference();
                    Version.INSTANCE.getClass();
                    Advapi32.INSTANCE.getClass();
                }
                catch (Exception exception) {
                    if (WinApiAccessHelperImpl.d.level < 3) break block7;
                    ((LevelAwareLogBuilder)d.lvlBuild(3, "preload()", 91).add("ex", (Object)exception)).log();
                }
            }
        }
    }

    @Override
    @Nullable
    public VersionNumber getFileVersion(@Nullable File file) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)d.lvlBuild(7, "getFileVersion(File)", 104).addDetail("file", (Object)file)).log();
        }
        if (file == null || !file.exists()) {
            return null;
        }
        String string = file.getAbsolutePath();
        if (WinApiAccessHelperImpl.d.level >= 9) {
            ((LevelAwareLogBuilder)d.lvlBuild(9, "getFileVersion(File)", 108).add("filePath", string)).log();
        }
        try {
            IntByReference intByReference = new IntByReference();
            intByReference.setValue(0);
            int n2 = Version.INSTANCE.GetFileVersionInfoSize(string, intByReference);
            if (n2 <= 0) {
                return null;
            }
            byte[] byArray = new byte[n2];
            Memory memory = new Memory((long)byArray.length);
            PointerByReference pointerByReference = new PointerByReference();
            IntByReference intByReference2 = new IntByReference();
            boolean bl = Version.INSTANCE.GetFileVersionInfo(string, 0, n2, (Pointer)memory);
            if (WinApiAccessHelperImpl.d.level >= 5) {
                ((LevelAwareLogBuilder)d.lvlBuild(5, "getFileVersion(File)", 130).add("fileInfoResult", bl)).log();
            }
            if (!bl) {
                return null;
            }
            boolean bl2 = Version.INSTANCE.VerQueryValue((Pointer)memory, "\\", pointerByReference, intByReference2);
            if (WinApiAccessHelperImpl.d.level >= 5) {
                ((LevelAwareLogBuilder)d.lvlBuild(5, "getFileVersion(File)", 136).add("verQueryVal", bl2)).log();
            }
            if (!bl2) {
                return null;
            }
            VerRsrc.VS_FIXEDFILEINFO vS_FIXEDFILEINFO = new VerRsrc.VS_FIXEDFILEINFO(pointerByReference.getValue());
            vS_FIXEDFILEINFO.read();
            int n3 = vS_FIXEDFILEINFO.dwFileVersionMS.intValue() >> 16;
            int n4 = vS_FIXEDFILEINFO.dwFileVersionMS.intValue() & 0xFFFF;
            int n5 = vS_FIXEDFILEINFO.dwFileVersionLS.intValue() >> 16;
            int n6 = vS_FIXEDFILEINFO.dwFileVersionLS.intValue() & 0xFFFF;
            return new VersionNumber(Integer.valueOf(n3), Integer.valueOf(n4), Integer.valueOf(n5), Integer.valueOf(n6));
        }
        catch (Exception exception) {
            if (WinApiAccessHelperImpl.d.level >= 1) {
                ((LevelAwareLogBuilder)d.lvlBuild(1, "getFileVersion(File)", 151).add("ex", (Object)exception)).log();
            }
            return null;
        }
    }

    @Override
    @Nullable
    public File getKnownFolder(String string) {
        String string2;
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)d.lvlBuild(7, "getKnownFolder(String)", 160).addDetail("folderGuid", string)).log();
        }
        if ((string2 = Shell32Util.getKnownFolderPath((Guid.GUID)Guid.GUID.fromString((String)string))) != null) {
            return new File(string2);
        }
        return null;
    }

    @Override
    public boolean registryKeyExists(String string) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)d.lvlBuild(7, "registryKeyExists(String)", 180).addDetail("keyString", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("keyString is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        boolean bl = Advapi32Util.registryKeyExists((WinReg.HKEY)regKey.a, (String)regKey.b);
        if (WinApiAccessHelperImpl.d.level >= 9) {
            ((LevelAwareLogBuilder)d.lvlBuild(9, "registryKeyExists(String)", 184).add("exists", bl)).log();
        }
        return bl;
    }

    @Override
    public boolean registryValueExists(String string, String string2) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)d.lvlBuild(7, "registryValueExists(String,String)", 198).addDetail("keyString", string)).addDetail("valueName", string2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("keyString is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("valueName is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        boolean bl = Advapi32Util.registryValueExists((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2);
        if (WinApiAccessHelperImpl.d.level >= 9) {
            ((LevelAwareLogBuilder)d.lvlBuild(9, "registryValueExists(String,String)", 202).add("exists", bl)).log();
        }
        return bl;
    }

    @Override
    public List registryGetKeys(String string) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)d.lvlBuild(7, "registryGetKeys(String)", 216).addDetail("parent", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("parent is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        String[] stringArray = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.a, (String)regKey.b);
        if (WinApiAccessHelperImpl.d.level >= 9) {
            ((LevelAwareLogBuilder)d.lvlBuild(9, "registryGetKeys(String)", 220).add("keys", (Object)stringArray)).log();
        }
        if (stringArray != null) {
            return Arrays.asList(stringArray);
        }
        return Collections.emptyList();
    }

    @Override
    public Map registryGetValues(String string) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)d.lvlBuild(7, "registryGetValues(String)", 238).addDetail("keyString", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("keyString is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        TreeMap treeMap = Advapi32Util.registryGetValues((WinReg.HKEY)regKey.a, (String)regKey.b);
        if (WinApiAccessHelperImpl.d.level >= 9) {
            ((LevelAwareLogBuilder)d.lvlBuild(9, "registryGetValues(String)", 242).add("values", (Object)treeMap)).log();
        }
        if (treeMap != null) {
            return treeMap;
        }
        return Collections.emptyMap();
    }

    @Override
    public Object registryGetValue(String string, String string2) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)d.lvlBuild(7, "registryGetValue(String,String)", 262).addDetail("keyString", string)).addDetail("valueName", string2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("keyString is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("valueName is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        if (Advapi32Util.registryValueExists((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2)) {
            Object object = Advapi32Util.registryGetValue((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2);
            if (WinApiAccessHelperImpl.d.level >= 9) {
                ((LevelAwareLogBuilder)d.lvlBuild(9, "registryGetValue(String,String)", 267).add("value", object)).log();
            }
            return object;
        }
        if (WinApiAccessHelperImpl.d.level >= 9) {
            ((LevelAwareLogBuilder)d.lvlBuild(9, "registryGetValue(String,String)", 270).add("Value does not exists")).log();
        }
        return null;
    }

    @Override
    public void registrySetValue(String string, String string2, @Nullable Object object) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)d.lvlBuild(7, "registrySetValue(String,String,Object)", 288).addDetail("keyString", string)).addDetail("valueName", string2)).addDetail("value", object)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("keyString is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("valueName is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        if (object == null) {
            if (WinApiAccessHelperImpl.d.level >= 9) {
                ((LevelAwareLogBuilder)d.lvlBuild(9, "registrySetValue(String,String,Object)", 292).add("Deleting value")).log();
            }
            if (Advapi32Util.registryValueExists((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2)) {
                Advapi32Util.registryDeleteValue((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2);
            }
        } else if (object instanceof Integer) {
            Advapi32Util.registrySetIntValue((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2, (int)((Integer)object));
        } else if (object instanceof Long) {
            Advapi32Util.registrySetLongValue((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2, (long)((Long)object));
        } else if (object instanceof byte[]) {
            Advapi32Util.registrySetBinaryValue((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2, (byte[])((byte[])object));
        } else {
            Advapi32Util.registrySetStringValue((WinReg.HKEY)regKey.a, (String)regKey.b, (String)string2, (String)object.toString());
        }
    }

    @Override
    public void registryDeleteKey(String string) {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)d.lvlBuild(7, "registryDeleteKey(String)", 320).addDetail("keyString", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("keyString is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        Advapi32Util.registryDeleteKey((WinReg.HKEY)regKey.a, (String)regKey.b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForRegistryChangeKeyValue(String string, int n2) throws TimeoutException {
        if (WinApiAccessHelperImpl.d.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)d.lvlBuild(7, "waitForRegistryChangeKeyValue(String,int)", 369).addDetail("keyString", string)).addDetail("timeout", n2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("keyString is marked non-null but is null");
        }
        RegKey regKey = RegKey.fromString(string);
        WinReg.HKEYByReference hKEYByReference = new WinReg.HKEYByReference();
        Advapi32.INSTANCE.RegOpenKeyEx(regKey.getRoot(), regKey.getKey(), 0, 16, hKEYByReference);
        if (hKEYByReference.getValue() == null) {
            throw new RuntimeException("Could not open key " + string);
        }
        try {
            WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateEvent(null, true, false, null);
            if (hANDLE == null) {
                throw new RuntimeException("Could not install event");
            }
            try {
                if (0 != Advapi32Ext.INSTANCE.RegNotifyChangeKeyValue(hKEYByReference.getValue(), true, 5, hANDLE, true)) {
                    throw new RuntimeException("Could not listen for changes on key " + string);
                }
                int n3 = Kernel32.INSTANCE.WaitForSingleObject(hANDLE, n2);
                if (n3 == 258) {
                    throw new TimeoutException();
                }
                if (n3 != 0) {
                    throw new RuntimeException("Unexpected wait result: " + n3);
                }
            }
            finally {
                if (!Kernel32.INSTANCE.CloseHandle(hANDLE)) {
                    throw new RuntimeException("Could not uninstall event");
                }
            }
        }
        finally {
            if (0 != Advapi32.INSTANCE.RegCloseKey(hKEYByReference.getValue())) {
                throw new RuntimeException("Could not close key " + string);
            }
        }
    }

    @Override
    public void setWindowDarkMode(long l2, boolean bl) {
        block3: {
            if (WinApiAccessHelperImpl.d.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)d.lvlBuild(7, "setWindowDarkMode(long,boolean)", 420).addDetail("hwnd", l2)).addDetail("dark", bl)).log();
            }
            try {
                WinDef.HWND hWND = new WinDef.HWND(Pointer.createConstant((long)l2));
                WinDef.DWORD dWORD = new WinDef.DWORD(20L);
                IntByReference intByReference = new IntByReference();
                intByReference.setValue(bl ? 1 : 0);
                WinDef.DWORD dWORD2 = new WinDef.DWORD(4L);
                Dwmapi.INSTANCE.DwmSetWindowAttribute(hWND, dWORD, intByReference, dWORD2);
            }
            catch (Exception exception) {
                if (WinApiAccessHelperImpl.d.level < 5) break block3;
                ((LevelAwareLogBuilder)d.lvlBuild(5, "setWindowDarkMode(long,boolean)", 434).add("Could not set window dark mode", (Object)exception)).log();
            }
        }
    }

    public static interface Dwmapi
    extends StdCallLibrary {
        public static final Dwmapi INSTANCE = (Dwmapi)Native.loadLibrary((String)"dwmapi", Dwmapi.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public WinNT.HRESULT DwmSetWindowAttribute(WinDef.HWND var1, WinDef.DWORD var2, IntByReference var3, WinDef.DWORD var4);
    }

    static interface Advapi32Ext
    extends Advapi32 {
        public static final Advapi32Ext INSTANCE = (Advapi32Ext)Native.loadLibrary((String)"Advapi32", Advapi32Ext.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

        public int RegNotifyChangeKeyValue(WinReg.HKEY var1, boolean var2, int var3, WinNT.HANDLE var4, boolean var5);
    }

    private static class RegKey {
        final WinReg.HKEY a;
        final String b;

        public static RegKey fromString(String string) {
            if (d.level >= 7) {
                ((LevelAwareLogBuilder)d.lvlBuild(7, "RegKey.fromString(String)", 335).addDetail("keyString", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("keyString is marked non-null but is null");
            }
            String string2 = string.replaceAll("\\\\.*$", "").toUpperCase();
            if (d.level >= 9) {
                ((LevelAwareLogBuilder)d.lvlBuild(9, "RegKey.fromString(String)", 337).add("rootString", string2)).log();
            }
            WinReg.HKEY hKEY = RegKey.rootFromString(string2);
            if (d.level >= 9) {
                ((LevelAwareLogBuilder)d.lvlBuild(9, "RegKey.fromString(String)", 339).add("root", (Object)hKEY)).log();
            }
            if (hKEY == null) {
                return new RegKey(WinReg.HKEY_CLASSES_ROOT, string);
            }
            String string3 = string.replaceAll("^.*?\\\\", "");
            if (d.level >= 9) {
                ((LevelAwareLogBuilder)d.lvlBuild(9, "RegKey.fromString(String)", 344).add("key", string3)).log();
            }
            return new RegKey(hKEY, string3);
        }

        @Nullable
        public static WinReg.HKEY rootFromString(String string) {
            if (d.level >= 7) {
                ((LevelAwareLogBuilder)d.lvlBuild(7, "RegKey.rootFromString(String)", 350).addDetail("rootString", string)).log();
            }
            if (string == null) {
                throw new IllegalArgumentException("rootString is marked non-null but is null");
            }
            if ("HKEY_CLASSES_ROOT".equals(string) || "HKCR".equals(string)) {
                return WinReg.HKEY_CLASSES_ROOT;
            }
            if ("HKEY_CURRENT_USER".equals(string) || "HKCU".equals(string)) {
                return WinReg.HKEY_CURRENT_USER;
            }
            if ("HKEY_LOCAL_MACHINE".equals(string) || "HKLM".equals(string)) {
                return WinReg.HKEY_LOCAL_MACHINE;
            }
            if ("HKEY_USERS".equals(string) || "HKU".equals(string)) {
                return WinReg.HKEY_USERS;
            }
            if ("HKEY_PERFORMANCE_DATA".equals(string) || "HKPD".equals(string)) {
                return WinReg.HKEY_PERFORMANCE_DATA;
            }
            if ("HKEY_PERFORMANCE_TEXT".equals(string) || "HKPT".equals(string)) {
                return WinReg.HKEY_PERFORMANCE_TEXT;
            }
            if ("HKEY_PERFORMANCE_NLSTEXT".equals(string) || "HKPN".equals(string)) {
                return WinReg.HKEY_PERFORMANCE_NLSTEXT;
            }
            if ("HKEY_CURRENT_CONFIG".equals(string) || "HKCC".equals(string)) {
                return WinReg.HKEY_CURRENT_CONFIG;
            }
            if ("HKEY_DYN_DATA".equals(string) || "HKDD".equals(string)) {
                return WinReg.HKEY_DYN_DATA;
            }
            return null;
        }

        public RegKey(WinReg.HKEY hKEY, String string) {
            if (d.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)d.lvlBuild(7, "RegKey.RegKey(HKEY,String)", 330).addDetail("root", (Object)hKEY)).addDetail("key", string)).log();
            }
            this.a = hKEY;
            this.b = string;
        }

        public WinReg.HKEY getRoot() {
            if (d.level >= 7) {
                d.lvlBuild(7, "RegKey.getRoot()", 332).log();
            }
            return this.a;
        }

        public String getKey() {
            if (d.level >= 7) {
                d.lvlBuild(7, "RegKey.getKey()", 333).log();
            }
            return this.b;
        }

        public boolean equals(Object object) {
            if (d.level >= 7) {
                ((LevelAwareLogBuilder)d.lvlBuild(7, "RegKey.equals(Object)", 330).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof RegKey)) {
                return false;
            }
            RegKey regKey = (RegKey)object;
            if (!regKey.a(this)) {
                return false;
            }
            WinReg.HKEY hKEY = this.getRoot();
            WinReg.HKEY hKEY2 = regKey.getRoot();
            if (hKEY == null ? hKEY2 != null : !hKEY.equals(hKEY2)) {
                return false;
            }
            String string = this.getKey();
            String string2 = regKey.getKey();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean a(Object object) {
            if (d.level >= 7) {
                ((LevelAwareLogBuilder)d.lvlBuild(7, "RegKey.canEqual(Object)", 330).addDetail("other", object)).log();
            }
            return object instanceof RegKey;
        }

        public int hashCode() {
            if (d.level >= 7) {
                d.lvlBuild(7, "RegKey.hashCode()", 330).log();
            }
            int n2 = 1;
            WinReg.HKEY hKEY = this.getRoot();
            n2 = n2 * 59 + (hKEY == null ? 43 : hKEY.hashCode());
            String string = this.getKey();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        public String toString() {
            if (d.level >= 7) {
                d.lvlBuild(7, "RegKey.toString()", 330).log();
            }
            return "WinApiAccessHelperImpl.RegKey(root=" + this.getRoot() + ", key=" + this.getKey() + ")";
        }
    }
}

