/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import com.steadystate.css.dom.CSSImportRuleImpl;
import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.CSSValueImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.LexicalUnitImpl;
import com.steadystate.css.parser.SACParserCSS3;
import de.qfs.apps.qftest.shared.ExternalClassWrapperHelper;
import de.qfs.apps.qftest.shared.ui.CssParserHelper;
import de.qfs.lib.json.Json;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;
import org.w3c.dom.stylesheets.MediaList;

public class CssParserHelperImpl
extends ExternalClassWrapperHelper
implements CssParserHelper {
    private static final QFLogger h = new QFLogger("de.qfs.apps.qftest.shared.ui.CssParserHelperImpl");
    static final LexicalUnit c = LexicalUnitImpl.createIdent(null, (String)"none");
    static final short d = 0;
    static final Object[] e = new Object[0];
    static final ErrorHandler f = new ErrorHandler(){

        public void warning(CSSParseException cSSParseException) throws CSSException {
            if (h.level >= 3) {
                ((LevelAwareLogBuilder)h.lvlBuild(3, "ErrorHandler.warning(CSSParseException)", 99).add("Warning during CSS parsing", this.a(cSSParseException) + cSSParseException.getMessage())).log();
            }
        }

        public void error(CSSParseException cSSParseException) throws CSSException {
            if (h.level >= 1) {
                ((LevelAwareLogBuilder)h.lvlBuild(1, "ErrorHandler.error(CSSParseException)", 103).add("Error during CSS parsing", this.a(cSSParseException) + cSSParseException.getMessage())).log();
            }
        }

        public void fatalError(CSSParseException cSSParseException) throws CSSException {
            if (h.level >= 1) {
                ((LevelAwareLogBuilder)h.lvlBuild(1, "ErrorHandler.fatalError(CSSParseException)", 107).add("Fatal error during CSS parsing", this.a(cSSParseException) + cSSParseException.getMessage())).log();
            }
        }

        private String a(CSSParseException cSSParseException) {
            return cSSParseException.getURI() + "[" + cSSParseException.getLineNumber() + ":" + cSSParseException.getColumnNumber() + "] ";
        }
    };
    static final AtomicBoolean g = new AtomicBoolean(false);

    @Override
    public void bridgeJavaLoggers() {
        if (g.getAndSet(true)) {
            return;
        }
        QFLogger.bridgeJavaLogger((String)"com.steadystate.css");
    }

    @Override
    public HashMap readCssRules(String string, @Nullable List list, @Nullable Set set, @Nullable Map map) throws IOException {
        if (CssParserHelperImpl.h.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(7, "readCssRules(String,List<Object>,Set<String>,Map<String, CssFunctionTextMapping>)", 139).addDetail("fileName", string)).addDetail("searchPath", (Object)list)).addDetail("validMedias", (Object)set)).addDetail("functionMappings", (Object)map)).log();
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (Misc.emptyOrNull((Collection)list)) {
            list = Misc.listOf((Object[])new Object[]{new File(".")});
        }
        this.a(string, list, set, false, new HashSet(), linkedHashMap);
        this.a(map, linkedHashMap);
        return linkedHashMap;
    }

    private void a(String string, List list, @Nullable Set set, boolean bl, Set set2, HashMap hashMap) throws IOException {
        if (CssParserHelperImpl.h.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(7, "readCSS(String,List<Object>,Set<String>,boolean,Set<String>,HashMap<String, Object>)", 159).addDetail("fileName", string)).addDetail("searchPath", (Object)list)).addDetail("validMedias", (Object)set)).addDetail("isOptional", bl)).addDetail("importedFiles", (Object)set2)).addDetail("styleRules", (Object)hashMap)).log();
        }
        if (set2 == null) {
            throw new IllegalArgumentException("importedFiles is marked non-null but is null");
        }
        try (InputStreamWithURI inputStreamWithURI = CssParserHelperImpl.a(string, list);){
            if (inputStreamWithURI == null) {
                int n2 = bl ? 9 : 1;
                int n3 = n2;
                if (CssParserHelperImpl.h.level >= n3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(n3, "readCSS(String,List<Object>,Set<String>,boolean,Set<String>,HashMap<String, Object>)", 164).add("Could not read ")).add(string)).log();
                }
                return;
            }
            InputSource inputSource = new InputSource();
            inputSource.setByteStream((InputStream)inputStreamWithURI);
            inputSource.setURI(string.startsWith("css:") ? "Inline CSS" : inputStreamWithURI.getUri());
            CSSOMParser cSSOMParser = new CSSOMParser((Parser)new SACParserCSS3());
            cSSOMParser.setErrorHandler(f);
            CSSStyleSheet cSSStyleSheet = cSSOMParser.parseStyleSheet(inputSource, null, null);
            CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
            for (int i2 = 0; i2 < cSSRuleList.getLength(); ++i2) {
                CSSRule cSSRule = cSSRuleList.item(i2);
                if (cSSRule.getType() == 3) {
                    this.a((CSSImportRuleImpl)cSSRule, list, set, set2, hashMap);
                }
                if (cSSRule.getType() != 1) continue;
                CSSStyleRuleImpl cSSStyleRuleImpl = (CSSStyleRuleImpl)cSSRule;
                List list2 = CssParserHelperImpl.a(hashMap, cSSStyleRuleImpl);
                for (CSSStyleRuleImpl cSSStyleRuleImpl2 : list2) {
                    CSSStyleDeclarationImpl cSSStyleDeclarationImpl = CssParserHelperImpl.a(cSSStyleRuleImpl2);
                    CssParserHelperImpl.a((CSSStyleDeclarationImpl)cSSStyleRuleImpl.getStyle(), cSSStyleDeclarationImpl);
                }
            }
        }
    }

    private static InputStreamWithURI a(String string, List list) throws FileNotFoundException {
        if (string.startsWith("css:")) {
            return new InputStreamWithURI(new ByteArrayInputStream(string.substring(4).getBytes(Misc.UTF8_CHARSET)), "");
        }
        for (Object e2 : list) {
            Object object;
            if (e2 instanceof File) {
                object = new File((File)e2, string);
                if (CssParserHelperImpl.h.level >= 9) {
                    ((LevelAwareLogBuilder)h.lvlBuild(9, "readStylesheet(String,List<Object>)", 205).add("candidate", object)).log();
                }
                if (!((File)object).exists()) continue;
                return new InputStreamWithURI(new FileInputStream((File)object), ((File)object).getAbsolutePath());
            }
            if (e2 instanceof String) {
                InputStream inputStream;
                object = ((String)e2).replace('.', '/') + "/" + string;
                if (CssParserHelperImpl.h.level >= 9) {
                    ((LevelAwareLogBuilder)h.lvlBuild(9, "readStylesheet(String,List<Object>)", 211).add("resourcePath", (String)object)).log();
                }
                if ((inputStream = CssParserHelper.class.getClassLoader().getResourceAsStream((String)object)) == null) continue;
                return new InputStreamWithURI(inputStream, (String)object);
            }
            if (CssParserHelperImpl.h.level < 1) continue;
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(1, "readStylesheet(String,List<Object>)", 217).add("Cannot search for css files in ")).add(e2)).log();
        }
        return null;
    }

    private void a(CSSImportRuleImpl cSSImportRuleImpl, @Nullable List list, @Nullable Set set, Set set2, HashMap hashMap) throws IOException {
        if (set2 == null) {
            throw new IllegalArgumentException("importedFiles is marked non-null but is null");
        }
        MediaList mediaList = cSSImportRuleImpl.getMedia();
        boolean bl = false;
        boolean bl2 = true;
        if (mediaList != null) {
            int n2 = mediaList.getLength();
            if (n2 > 0) {
                bl2 = false;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = mediaList.item(i2);
                    if ("optional".equals(string)) {
                        bl = true;
                        continue;
                    }
                    if (set == null || !set.contains(string)) continue;
                    bl2 = true;
                }
            }
            if (n2 == 1 && bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            String string = cSSImportRuleImpl.getHref();
            if (set2.add(string)) {
                this.a(string, list, set, bl, set2, hashMap);
            } else if (CssParserHelperImpl.h.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(3, "maybeImportStyleSheet(CSSImportRuleImpl,List<Object>,Set<String>,Set<String>,HashMap<String, Object>)", 258).add("Cyclic import detected, skipping ")).add(string)).log();
            }
        }
    }

    private static List a(HashMap hashMap, CSSStyleRuleImpl cSSStyleRuleImpl) {
        LinkedList<CSSStyleRuleImpl> linkedList = new LinkedList<CSSStyleRuleImpl>();
        SelectorList selectorList = cSSStyleRuleImpl.getSelectors();
        int n2 = selectorList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Selector selector = selectorList.item(i2);
            String string = selector.toString();
            CSSStyleRuleImpl cSSStyleRuleImpl2 = (CSSStyleRuleImpl)hashMap.get(string);
            if (cSSStyleRuleImpl2 == null) {
                cSSStyleRuleImpl2 = new CSSStyleRuleImpl();
                hashMap.put(string, cSSStyleRuleImpl2);
                cSSStyleRuleImpl2.setSelectorText(string);
            }
            linkedList.add(cSSStyleRuleImpl2);
        }
        return linkedList;
    }

    private static CSSStyleDeclarationImpl a(CSSStyleRuleImpl cSSStyleRuleImpl) {
        CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)cSSStyleRuleImpl.getStyle();
        if (cSSStyleDeclarationImpl == null) {
            cSSStyleDeclarationImpl = new CSSStyleDeclarationImpl();
            cSSStyleRuleImpl.setStyle((CSSStyleDeclaration)cSSStyleDeclarationImpl);
        }
        return cSSStyleDeclarationImpl;
    }

    private static void a(CSSStyleDeclarationImpl cSSStyleDeclarationImpl, CSSStyleDeclarationImpl cSSStyleDeclarationImpl2) {
        for (Property property : cSSStyleDeclarationImpl.getProperties()) {
            String string = property.getName();
            Property property2 = cSSStyleDeclarationImpl2.getPropertyDeclaration(string);
            CSSValue cSSValue = property.getValue();
            boolean bl = property.isImportant();
            if (property2 == null) {
                cSSStyleDeclarationImpl2.addProperty(new Property(string, cSSValue, bl));
                continue;
            }
            property2.setValue(cSSValue);
            property2.setImportant(bl);
        }
    }

    private void a(@Nullable Map map, HashMap hashMap) {
        int n2;
        HashMap hashMap2 = new HashMap();
        LinkedList linkedList = new LinkedList();
        int n3 = Integer.MAX_VALUE;
        do {
            n2 = n3;
            linkedList.clear();
            this.a(hashMap, map, hashMap2, linkedList);
        } while ((n3 = linkedList.size()) > 0 && n3 < n2);
        if (n3 > 0) {
            linkedList.forEach(string -> {
                if (CssParserHelperImpl.h.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(1, "resolveRulesWithRetry(Map<String, CssFunctionTextMapping>,HashMap<String, Object>)", 344).add("Resolve error: ")).add(string)).log();
                }
            });
        }
    }

    private void a(HashMap hashMap, @Nullable Map map, HashMap hashMap2, List list) {
        if (CssParserHelperImpl.h.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(7, "resolveRules(HashMap<String, Object>,Map<String, CssFunctionTextMapping>,HashMap<String, LexicalUnit>,List<String>)", 357).addDetail("styleRules", (Object)hashMap)).addDetail("functionMappings", (Object)map)).addDetail("variableValues", (Object)hashMap2)).addDetail("resolveErrors", (Object)list)).log();
        }
        if (hashMap2 == null) {
            throw new IllegalArgumentException("variableValues is marked non-null but is null");
        }
        if (list == null) {
            throw new IllegalArgumentException("resolveErrors is marked non-null but is null");
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            CSSStyleRuleImpl cSSStyleRuleImpl = (CSSStyleRuleImpl)entry.getValue();
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)cSSStyleRuleImpl.getStyle();
            ListIterator listIterator = cSSStyleDeclarationImpl.getProperties().listIterator();
            while (listIterator.hasNext()) {
                Property property = (Property)listIterator.next();
                String string2 = property.getName();
                CSSValueImpl cSSValueImpl = (CSSValueImpl)property.getValue();
                cSSValueImpl = CssParserHelperImpl.a(string, cSSValueImpl, hashMap2, map, list);
                property.setValue((CSSValue)cSSValueImpl);
                if (!string2.startsWith("--")) continue;
                Object object = cSSValueImpl.getValue();
                LexicalUnitImpl lexicalUnitImpl = object instanceof LexicalUnitImpl ? (LexicalUnitImpl)object : CssParserHelperImpl.a(cSSValueImpl.getCssText());
                if (lexicalUnitImpl != null) {
                    hashMap2.put(string + "." + string2, lexicalUnitImpl);
                }
                listIterator.remove();
            }
        }
    }

    @Nullable
    private static LexicalUnitImpl a(String string) {
        LexicalUnitImpl lexicalUnitImpl;
        block2: {
            lexicalUnitImpl = null;
            try {
                InputSource inputSource = new InputSource((Reader)new StringReader(string));
                SACParserCSS3 sACParserCSS3 = new SACParserCSS3();
                lexicalUnitImpl = (LexicalUnitImpl)sACParserCSS3.parsePropertyValue(inputSource);
            }
            catch (Exception exception) {
                if (CssParserHelperImpl.h.level < 1) break block2;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(1, "getLexicalUnitOfCssText(String)", 401).add("Could not parse input")).add(string)).add("ex", (Object)exception)).log();
            }
        }
        return lexicalUnitImpl;
    }

    private static CSSValueImpl a(String string, CSSValueImpl cSSValueImpl, HashMap hashMap, @Nullable Map map, List list) {
        LexicalUnitImpl lexicalUnitImpl;
        if (list == null) {
            throw new IllegalArgumentException("resolveErrors is marked non-null but is null");
        }
        Object object = cSSValueImpl.getValue();
        if (object instanceof List) {
            ListIterator<CSSValueImpl> listIterator = ((List)object).listIterator();
            while (listIterator.hasNext()) {
                listIterator.set(CssParserHelperImpl.a(string, (CSSValueImpl)listIterator.next(), hashMap, map, list));
            }
        } else if (object instanceof LexicalUnitImpl && (lexicalUnitImpl = CssParserHelperImpl.a(string, (LexicalUnitImpl)object, hashMap, map, list)) != null) {
            return new CSSValueImpl((LexicalUnit)lexicalUnitImpl, true);
        }
        return cSSValueImpl;
    }

    @Nullable
    private static LexicalUnitImpl a(String string, LexicalUnitImpl lexicalUnitImpl, HashMap hashMap, @Nullable Map map, List list) {
        Object object;
        LexicalUnitImpl lexicalUnitImpl2;
        if (list == null) {
            throw new IllegalArgumentException("resolveErrors is marked non-null but is null");
        }
        String string2 = lexicalUnitImpl.getFunctionName();
        if (string2 == null) {
            return lexicalUnitImpl;
        }
        Object object2 = (LexicalUnitImpl)lexicalUnitImpl.getParameters();
        Object object3 = null;
        while (object2 != null) {
            lexicalUnitImpl2 = (LexicalUnitImpl)object2.getNextLexicalUnit();
            if (object2.getLexicalUnitType() != 0 && (object = CssParserHelperImpl.a(string, (LexicalUnitImpl)object2, hashMap, map, list)) != object2) {
                object.setNextLexicalUnit((LexicalUnit)lexicalUnitImpl2);
                if (lexicalUnitImpl2 != null) {
                    lexicalUnitImpl2.setPreviousLexicalUnit((LexicalUnit)object);
                }
                object.setPreviousLexicalUnit((LexicalUnit)object3);
                if (object3 != null) {
                    object3.setNextLexicalUnit((LexicalUnit)object);
                } else {
                    lexicalUnitImpl.setParameters((LexicalUnit)object);
                }
                object2 = object;
            }
            object3 = object2;
            object2 = lexicalUnitImpl2;
        }
        if ("var".equals(string2)) {
            object2 = lexicalUnitImpl.getParameters().getStringValue();
            if (((String)object2).startsWith("--__") && (object3 = CssParserHelperImpl.a(((String)object2).substring(2), string, lexicalUnitImpl)) != null) {
                return (LexicalUnitImpl)LexicalUnitImpl.createIdent(null, (String)Json.value((String)object3).toString());
            }
            object3 = (LexicalUnit)hashMap.get(string + "." + (String)object2);
            if (object3 == null) {
                object3 = (LexicalUnit)hashMap.get(":root." + (String)object2);
            }
            if (object3 == null) {
                list.add("Cannot resolve variable " + (String)object2 + ", selector: " + string);
                object3 = lexicalUnitImpl;
            }
            return object3;
        }
        if (map != null) {
            object2 = (CssParserHelper.CssFunctionTextMapping)map.get(string2);
            if (object2 == null) {
                object2 = (CssParserHelper.CssFunctionTextMapping)map.get("*");
            }
            if (object2 != null) {
                try {
                    object3 = new LinkedList();
                    for (lexicalUnitImpl2 = lexicalUnitImpl.getParameters(); lexicalUnitImpl2 != null; lexicalUnitImpl2 = lexicalUnitImpl2.getNextLexicalUnit()) {
                        if (lexicalUnitImpl2.getLexicalUnitType() == 0) continue;
                        ((LinkedList)object3).add(lexicalUnitImpl2.getCssText());
                    }
                    String string3 = object = object2 instanceof CssParserHelper.CssFunctionTextMappingWithSource ? ((CssParserHelper.CssFunctionTextMappingWithSource)object2).map(string, string2, (LinkedList)object3, lexicalUnitImpl.getLocator().getURI()) : object2.map(string, string2, (LinkedList)object3);
                    if (object != null) {
                        return CssParserHelperImpl.a((String)object);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    if (CssParserHelperImpl.h.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(9, "replaceFunctionsInLexicalUnit(String,LexicalUnitImpl,HashMap<String, LexicalUnit>,Map<String, CssFunctionTextMapping>,List<String>)", 510).add("Function not implemented: ", string2)).add("ex", (Object)unsupportedOperationException)).log();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    list.add("Function error: " + illegalArgumentException.getMessage() + ", functionName: " + string2);
                }
            }
        }
        return lexicalUnitImpl;
    }

    private static String a(String string, String string2, LexicalUnitImpl lexicalUnitImpl) {
        switch (string) {
            case "__file__": {
                return lexicalUnitImpl.getLocator().getURI();
            }
            case "__path__": {
                return new File(lexicalUnitImpl.getLocator().getURI()).getParent();
            }
        }
        return null;
    }

    @Override
    public void applyCssRules(Map map, Map map2, @Nullable Map map3) {
        if (CssParserHelperImpl.h.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(7, "applyCssRules(Map<String, Object>,Map<Object, Object>,Map<String, CssFunctionObjectMapping>)", 543).addDetail("styleRules", (Object)map)).addDetail("map", (Object)map2)).addDetail("functionMappings", (Object)map3)).log();
        }
        if (map == null) {
            throw new IllegalArgumentException("styleRules is marked non-null but is null");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("map is marked non-null but is null");
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            CSSStyleRuleImpl cSSStyleRuleImpl = (CSSStyleRuleImpl)entry.getValue();
            CSSStyleDeclarationImpl cSSStyleDeclarationImpl = (CSSStyleDeclarationImpl)cSSStyleRuleImpl.getStyle();
            ListIterator listIterator = cSSStyleDeclarationImpl.getProperties().listIterator();
            while (listIterator.hasNext()) {
                Property property = (Property)listIterator.next();
                String string2 = property.getName();
                CSSValueImpl cSSValueImpl = (CSSValueImpl)property.getValue();
                CssParserHelperImpl.a(string, string2, cSSValueImpl, map2, map3);
            }
        }
    }

    private static void a(String string, String string2, CSSValueImpl cSSValueImpl, Map map, @Nullable Map map2) {
        String string3 = ":root".equals(string) ? string2 : string + "." + string2;
        Object object = CssParserHelperImpl.a(cSSValueImpl, map2);
        if (CssParserHelperImpl.h.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(9, "putObjectInMap(String,String,CSSValueImpl,Map<Object, Object>,Map<String, CssFunctionObjectMapping>)", 568).add("object", object)).add("cl", (Object)object.getClass().getClassLoader())).log();
        }
        if (object == null) {
            if (CssParserHelperImpl.h.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(1, "putObjectInMap(String,String,CSSValueImpl,Map<Object, Object>,Map<String, CssFunctionObjectMapping>)", 571).add("Could not put value of ")).add(string3)).add(" into map: ")).add((Object)cSSValueImpl)).log();
            }
        } else if (object == e) {
            map.put(string3, null);
        } else {
            map.put(string3, object);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object a(CSSValueImpl cSSValueImpl, @Nullable Map map) {
        try {
            short s2 = cSSValueImpl.getPrimitiveType();
            switch (s2) {
                case 25: {
                    RGBColor rGBColor = cSSValueImpl.getRGBColorValue();
                    return CssParserHelperImpl.a(rGBColor);
                }
                case 24: {
                    Rect rect = cSSValueImpl.getRectValue();
                    return new Insets((int)rect.getTop().getFloatValue((short)0), (int)rect.getLeft().getFloatValue((short)0), (int)rect.getBottom().getFloatValue((short)0), (int)rect.getRight().getFloatValue((short)0));
                }
                case 21: {
                    String string;
                    switch (string = cSSValueImpl.getStringValue()) {
                        case "none": {
                            return e;
                        }
                        case "true": 
                        case "false": {
                            return Boolean.valueOf(string);
                        }
                    }
                    return string;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    String string = cSSValueImpl.getCssText();
                    try {
                        return Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return Float.valueOf(cSSValueImpl.getFloatValue((short)0));
                    }
                }
                case 0: 
                case 19: 
                case 20: {
                    LexicalUnitImpl lexicalUnitImpl;
                    String string;
                    Object object = cSSValueImpl.getValue();
                    if (map == null || !(object instanceof LexicalUnitImpl) || (string = (lexicalUnitImpl = (LexicalUnitImpl)object).getFunctionName()) == null) return cSSValueImpl.getStringValue();
                    CssParserHelper.CssFunctionObjectMapping cssFunctionObjectMapping = (CssParserHelper.CssFunctionObjectMapping)map.get(string);
                    if (cssFunctionObjectMapping == null) {
                        cssFunctionObjectMapping = (CssParserHelper.CssFunctionObjectMapping)map.get("*");
                    }
                    if (cssFunctionObjectMapping != null) {
                        try {
                            LinkedList<Object> linkedList = new LinkedList<Object>();
                            for (LexicalUnit lexicalUnit = lexicalUnitImpl.getParameters(); lexicalUnit != null; lexicalUnit = lexicalUnit.getNextLexicalUnit()) {
                                if (lexicalUnit.getLexicalUnitType() == 0) continue;
                                linkedList.add(CssParserHelperImpl.a(new CSSValueImpl(lexicalUnit, true), map));
                            }
                            Object object2 = cssFunctionObjectMapping instanceof CssParserHelper.CssFunctionObjectMappingWithSource ? ((CssParserHelper.CssFunctionObjectMappingWithSource)cssFunctionObjectMapping).map(string, linkedList, lexicalUnitImpl.getLocator().getURI()) : cssFunctionObjectMapping.map(string, linkedList);
                            return object2 == null ? e : object2;
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            if (CssParserHelperImpl.h.level < 1) return null;
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(1, "getMapObjectForValue(CSSValueImpl,Map<String, CssFunctionObjectMapping>)", 657).add("Function not implemented: ", string)).add("ex", (Object)unsupportedOperationException)).add("value", (Object)cSSValueImpl)).log();
                            return null;
                        }
                    } else {
                        if (CssParserHelperImpl.h.level < 1) return null;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(1, "getMapObjectForValue(CSSValueImpl,Map<String, CssFunctionObjectMapping>)", 660).add("Function not found: ", string)).add("value", (Object)cSSValueImpl)).log();
                    }
                    return null;
                }
            }
            return cSSValueImpl.getCssText();
        }
        catch (Exception exception) {
            if (CssParserHelperImpl.h.level < 1) return null;
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(1, "getMapObjectForValue(CSSValueImpl,Map<String, CssFunctionObjectMapping>)", 670).add("Error reading css value")).add("value", (Object)cSSValueImpl)).add("ex", (Object)exception)).log();
            return null;
        }
    }

    private static Color a(RGBColor rGBColor) {
        return new Color((int)rGBColor.getRed().getFloatValue((short)0), (int)rGBColor.getGreen().getFloatValue((short)0), (int)rGBColor.getBlue().getFloatValue((short)0));
    }

    @Override
    public String getFullStylesheet(Map map, boolean bl) {
        if (CssParserHelperImpl.h.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)h.lvlBuild(7, "getFullStylesheet(Map<String, Object>,boolean)", 692).addDetail("rulesList", (Object)map)).addDetail("compact", bl)).log();
        }
        CSSStyleSheetImpl cSSStyleSheetImpl = this.a(map);
        return cSSStyleSheetImpl.getCssText((CSSFormat)new ConcreteCSSFormat(bl)).replace("\r\n", bl ? " " : "\n");
    }

    private CSSStyleSheetImpl a(Map map) {
        CSSStyleSheetImpl cSSStyleSheetImpl = new CSSStyleSheetImpl();
        int n2 = 0;
        for (Object v2 : map.values()) {
            CSSStyleRuleImpl cSSStyleRuleImpl = (CSSStyleRuleImpl)v2;
            if (cSSStyleRuleImpl.getStyle() == null || cSSStyleRuleImpl.getStyle().getLength() == 0) continue;
            cSSStyleSheetImpl.insertRule(cSSStyleRuleImpl.getCssText(), n2++);
        }
        return cSSStyleSheetImpl;
    }

    static final class InputStreamWithURI
    extends InputStream {
        final InputStream a;
        final String b;

        @Override
        public int read() throws IOException {
            return this.a.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            if (byArray == null) {
                throw new IllegalArgumentException("b is marked non-null but is null");
            }
            return this.a.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            if (byArray == null) {
                throw new IllegalArgumentException("b is marked non-null but is null");
            }
            return this.a.read(byArray, n2, n3);
        }

        @Override
        public long skip(long l2) throws IOException {
            return this.a.skip(l2);
        }

        @Override
        public int available() throws IOException {
            return this.a.available();
        }

        @Override
        public void close() throws IOException {
            this.a.close();
        }

        @Override
        public synchronized void mark(int n2) {
            this.a.mark(n2);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.a.reset();
        }

        @Override
        public boolean markSupported() {
            return this.a.markSupported();
        }

        public InputStreamWithURI(InputStream inputStream, String string) {
            this.a = inputStream;
            this.b = string;
        }

        public String getUri() {
            return this.b;
        }
    }

    static class ConcreteCSSFormat
    extends CSSFormat {
        final boolean a;

        ConcreteCSSFormat(boolean bl) {
            this.a = bl;
            this.setUseSourceStringValues(true);
            this.setUseSingleQuotes(true);
            if (bl) {
                this.setRgbAsHex(true);
            } else {
                this.setPropertiesInSeparateLines(4);
            }
        }

        public String getNewLine() {
            return this.a ? "" : "\n";
        }
    }
}

