/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import de.qfs.apps.qftest.shared.ui.FlatMenuItemRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;

public class FlatMenuUI
extends BasicMenuUI {
    private static final String MENU_PROPERTY_PREFIX = "Menu";
    private static final String SUBMENU_PROPERTY_PREFIX = "MenuItem";
    private String propertyPrefix = "Menu";
    private FlatMenuItemRenderer renderer;
    private MouseListener mouseListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon("Menu.arrowIcon");
        }
        this.renderer = new FlatMenuItemRenderer(this.menuItem, false, this.acceleratorFont, this.selectionForeground, this.disabledForeground, this.acceleratorForeground, this.acceleratorSelectionForeground);
        Integer n2 = (Integer)UIManager.get(this.getPropertyPrefix() + ".textIconGap");
        this.defaultTextIconGap = n2 != null ? n2 : 2;
        LookAndFeel.installBorder(this.menuItem, this.getPropertyPrefix() + ".border");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.renderer = null;
    }

    @Override
    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n2) {
        if (FlatMenuUI.isSubMenu(this.menuItem)) {
            this.ensureSubMenuInstalled();
            return this.renderer.getPreferredMenuItemSize(jComponent, icon, icon2, n2);
        }
        return super.getPreferredMenuItemSize(jComponent, icon, icon2, n2);
    }

    @Override
    protected void paintMenuItem(Graphics graphics, JComponent jComponent, Icon icon, Icon icon2, Color color, Color color2, int n2) {
        if (FlatMenuUI.isSubMenu(this.menuItem)) {
            this.renderer.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n2);
        } else {
            super.paintMenuItem(graphics, jComponent, icon, icon2, color, color2, n2);
        }
    }

    private void ensureSubMenuInstalled() {
        if (!this.propertyPrefix.equals(SUBMENU_PROPERTY_PREFIX)) {
            ButtonModel buttonModel = this.menuItem.getModel();
            boolean bl = buttonModel.isArmed();
            boolean bl2 = buttonModel.isSelected();
            this.uninstallRolloverListener();
            this.uninstallDefaults();
            this.propertyPrefix = SUBMENU_PROPERTY_PREFIX;
            this.installDefaults();
            buttonModel.setArmed(bl);
            buttonModel.setSelected(bl2);
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.mouseListener = new RolloverHandler();
        this.menuItem.addMouseListener(this.mouseListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.uninstallRolloverListener();
    }

    private void uninstallRolloverListener() {
        if (this.mouseListener != null) {
            this.menuItem.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
    }

    private static boolean isSubMenu(JMenuItem jMenuItem) {
        return !((JMenu)jMenuItem).isTopLevelMenu();
    }

    private static final class RolloverHandler
    extends MouseAdapter {
        private RolloverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            abstractButton.getModel().setRollover(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            abstractButton.getModel().setRollover(false);
        }
    }
}

