/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import de.qfs.apps.qftest.shared.ui.UIHelpers;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class FlatSplitPaneUI
extends BasicSplitPaneUI {
    private final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.ui.FlatSplitPaneUI");
    private static final Color COLOR_SEPARATOR_LINE = new Color(150, 150, 150);

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatSplitPaneUI();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new FlatSplitPaneDivider(this);
    }

    class FlatSplitPaneDivider
    extends BasicSplitPaneDivider {
        private int b;

        public FlatSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
            super(basicSplitPaneUI);
            this.b = UIManager.getInt("SplitPaneDivider.oneTouchButtonSize");
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public void paint(Graphics graphics) {
            Color color = this.getBackground();
            if (color != null) {
                graphics.setColor(color);
                UIHelpers.fillRectScaled(this, graphics, 0, 0, this.getWidth(), this.getHeight());
            }
            super.paint(graphics);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            if (this.orientation == 0) {
                int n2 = Math.min(15, Math.max(this.getWidth() / 2, Math.min(this.getWidth(), 15)));
                int n3 = (this.getWidth() - n2) / 2;
                int n4 = (this.getHeight() + 1) / 2;
                UIHelpers.drawLineScaled(this, graphics, 1, n3, n4 - 1, n3 + n2 - 1, n4 - 1);
                UIHelpers.drawLineScaled(this, graphics, 1, n3, n4 + 1, n3 + n2 - 1, n4 + 1);
            } else {
                int n5 = this.getWidth() / 2;
                int n6 = Math.min(15, Math.max(this.getHeight() / 2, Math.min(this.getHeight(), 15)));
                int n7 = (this.getHeight() - n6) / 2;
                UIHelpers.drawLineScaled(this, graphics, 1, n5 - 1, n7, n5 - 1, n7 + n6 - 1);
                UIHelpers.drawLineScaled(this, graphics, 1, n5 + 1, n7, n5 + 1, n7 + n6 - 1);
            }
        }

        @Override
        protected JButton createLeftOneTouchButton() {
            if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createLeftOneTouchButton()", 101).log();
            }
            JButton jButton = new JButton(){

                @Override
                public void setBorder(Border border) {
                    if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                        ((LevelAwareLogBuilder)FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createLeftOneTouchButton().JButton.setBorder(Border)", 103).addDetail("b", (Object)border)).log();
                    }
                }

                @Override
                public void paint(Graphics graphics) {
                    if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                        ((LevelAwareLogBuilder)FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createLeftOneTouchButton().JButton.paint(Graphics)", 105).addDetail("g", (Object)graphics)).log();
                    }
                    super.paint(graphics);
                    if (FlatSplitPaneDivider.this.splitPane != null) {
                        graphics.setColor(this.getBackground());
                        UIHelpers.fillRectScaled(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                        if (FlatSplitPaneDivider.this.orientation == 0) {
                            this.setIcon(UIManager.getIcon("SplitPaneDivider.buttonUp"));
                        } else {
                            this.setIcon(UIManager.getIcon("SplitPaneDivider.buttonLeft"));
                        }
                        this.getIcon().paintIcon(this, graphics, 0, 0);
                    }
                }

                @Override
                public boolean isFocusTraversable() {
                    if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                        FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createLeftOneTouchButton().JButton.isFocusTraversable()", 118).log();
                    }
                    return false;
                }
            };
            jButton.setMinimumSize(new Dimension(this.b, this.b));
            jButton.setCursor(Cursor.getPredefinedCursor(0));
            jButton.setFocusPainted(false);
            jButton.setBorderPainted(false);
            jButton.setRequestFocusEnabled(false);
            return jButton;
        }

        @Override
        protected JButton createRightOneTouchButton() {
            if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createRightOneTouchButton()", 135).log();
            }
            JButton jButton = new JButton(){

                @Override
                public void setBorder(Border border) {
                    if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                        ((LevelAwareLogBuilder)FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createRightOneTouchButton().JButton.setBorder(Border)", 137).addDetail("border", (Object)border)).log();
                    }
                }

                @Override
                public void paint(Graphics graphics) {
                    if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                        ((LevelAwareLogBuilder)FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createRightOneTouchButton().JButton.paint(Graphics)", 139).addDetail("g", (Object)graphics)).log();
                    }
                    super.paint(graphics);
                    if (FlatSplitPaneDivider.this.splitPane != null) {
                        graphics.setColor(this.getBackground());
                        UIHelpers.fillRectScaled(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                        if (FlatSplitPaneDivider.this.orientation == 0) {
                            this.setIcon(UIManager.getIcon("SplitPaneDivider.buttonDown"));
                        } else {
                            this.setIcon(UIManager.getIcon("SplitPaneDivider.buttonRight"));
                        }
                        this.getIcon().paintIcon(this, graphics, 0, 0);
                    }
                }

                @Override
                public boolean isFocusTraversable() {
                    if (((FlatSplitPaneUI)FlatSplitPaneUI.this).logger.level >= 7) {
                        FlatSplitPaneUI.this.logger.lvlBuild(7, "FlatSplitPaneDivider.createRightOneTouchButton().JButton.isFocusTraversable()", 152).log();
                    }
                    return false;
                }
            };
            jButton.setMinimumSize(new Dimension(this.b, this.b));
            jButton.setCursor(Cursor.getPredefinedCursor(0));
            jButton.setFocusPainted(false);
            jButton.setBorderPainted(false);
            jButton.setRequestFocusEnabled(false);
            return jButton;
        }
    }
}

