/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import de.qfs.lib.log.QFLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FlatTableUI
extends BasicTableUI {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.shared.ui.FlatTableUI");

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTableUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            this.paintDropLines(graphics);
            return;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.rowAtPoint(point2);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        int n4 = this.table.columnAtPoint(bl ? point : point2);
        int n5 = this.table.columnAtPoint(bl ? point2 : point);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n2, n3, n4, n5);
        this.paintCells(graphics, n2, n3, n4, n5);
        this.paintDropLines(graphics);
    }

    private void paintDropLines(Graphics graphics) {
        int n2;
        int n3;
        JTable.DropLocation dropLocation = this.table.getDropLocation();
        if (dropLocation == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color color2 = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && color2 == null) {
            return;
        }
        Rectangle rectangle = this.getHDropLineRect(dropLocation);
        if (rectangle != null) {
            n3 = rectangle.x;
            n2 = rectangle.width;
            if (color != null) {
                this.extendRect(rectangle, true);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertColumn() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(n3, rectangle.y, n2, rectangle.height);
            }
        }
        if ((rectangle = this.getVDropLineRect(dropLocation)) != null) {
            n3 = rectangle.y;
            n2 = rectangle.height;
            if (color != null) {
                this.extendRect(rectangle, false);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertRow() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, n3, rectangle.width, n2);
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertRow()) {
            return null;
        }
        int n2 = dropLocation.getRow();
        int n3 = dropLocation.getColumn();
        if (n3 >= this.table.getColumnCount()) {
            --n3;
        }
        Rectangle rectangle = this.table.getCellRect(n2, n3, true);
        if (n2 >= this.table.getRowCount()) {
            Rectangle rectangle2 = this.table.getCellRect(--n2, n3, true);
            rectangle.y = rectangle2.y + rectangle2.height;
        }
        rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
        rectangle.height = 3;
        return rectangle;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertColumn()) {
            return null;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        int n2 = dropLocation.getColumn();
        Rectangle rectangle = this.table.getCellRect(dropLocation.getRow(), n2, true);
        if (n2 >= this.table.getColumnCount()) {
            rectangle = this.table.getCellRect(dropLocation.getRow(), --n2, true);
            if (bl) {
                rectangle.x += rectangle.width;
            }
        } else if (!bl) {
            rectangle.x += rectangle.width;
        }
        rectangle.x = rectangle.x == 0 ? -1 : (rectangle.x -= 2);
        rectangle.width = 3;
        return rectangle;
    }

    private Rectangle extendRect(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return rectangle;
        }
        if (bl) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            rectangle.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rectangle.height = rectangle2.y + rectangle2.height;
            } else {
                rectangle.height = this.table.getHeight();
            }
        }
        return rectangle;
    }

    private void paintGrid(Graphics graphics, int n2, int n3, int n4, int n5) {
        block8: {
            int n6;
            int n7;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle = this.table.getCellRect(n2, n4, true);
            Rectangle rectangle2 = this.table.getCellRect(n3, n5, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            if (this.table.getShowHorizontalLines()) {
                n7 = rectangle3.x + rectangle3.width;
                int n8 = rectangle3.y;
                for (n6 = n2; n6 <= n3; ++n6) {
                    graphics.drawLine(rectangle3.x, (n8 += this.table.getRowHeight(n6)) - 1, n7 - 1, n8 - 1);
                }
            }
            if (!this.table.getShowVerticalLines()) break block8;
            n7 = -1;
            if (this.table.getParent() instanceof JViewport) {
                Rectangle rectangle4 = ((JViewport)this.table.getParent()).getViewRect();
                if (rectangle4.x + rectangle4.width == this.table.getWidth()) {
                    n7 = this.table.getWidth();
                }
            }
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n6 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int n9 = rectangle3.x;
                graphics.drawLine(n9, 0, n9, n6 - 1);
                for (int i2 = n4; i2 <= n5; ++i2) {
                    int n10 = tableColumnModel.getColumn(i2).getWidth();
                    if ((n9 += n10) == n7) continue;
                    graphics.drawLine(n9 - 1, 0, n9 - 1, n6 - 1);
                }
            } else {
                int n11 = rectangle3.x;
                for (int i3 = n5; i3 >= n4; --i3) {
                    int n12 = tableColumnModel.getColumn(i3).getWidth();
                    graphics.drawLine((n11 += n12) - 1, 0, n11 - 1, n6 - 1);
                }
            }
        }
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n2, int n3, int n4, int n5) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnMargin();
        boolean bl = this.hasGutter();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                Rectangle rectangle = this.table.getCellRect(i2, n4, false);
                for (int i3 = n4; i3 <= n5; ++i3) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(i3);
                    int n7 = tableColumn2.getWidth();
                    rectangle.width = n7 - n6;
                    int n8 = i3 == n4 && bl ? n6 : 0;
                    rectangle.x += n8;
                    rectangle.width -= n8;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, i2, i3);
                    }
                    rectangle.x -= n8;
                    rectangle.width += n8;
                    rectangle.x += n7;
                }
            }
        } else {
            for (int i4 = n2; i4 <= n3; ++i4) {
                int n9;
                Rectangle rectangle = this.table.getCellRect(i4, n4, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n4);
                if (tableColumn3 != tableColumn) {
                    n9 = tableColumn3.getWidth();
                    rectangle.width = n9 - n6;
                    this.paintCell(graphics, rectangle, i4, n4);
                }
                for (int i5 = n4 + 1; i5 <= n5; ++i5) {
                    tableColumn3 = tableColumnModel.getColumn(i5);
                    n9 = tableColumn3.getWidth();
                    rectangle.width = n9 - n6;
                    rectangle.x -= n9;
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(graphics, rectangle, i4, i5);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n2, n3, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private boolean hasGutter() {
        try {
            return ((JScrollPane)this.table.getParent().getParent()).getRowHeader().getSize().getWidth() > 0.0;
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    private void paintDraggedArea(Graphics graphics, int n2, int n3, TableColumn tableColumn, int n4) {
        int n5;
        int n6;
        int n7 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n2, n7, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n7, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n4;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n6 = rectangle3.x;
            int n8 = rectangle3.y;
            int n9 = n6 + rectangle3.width - 1;
            n5 = n8 + rectangle3.height - 1;
            graphics.drawLine(n6 - 1, n8, n6 - 1, n5);
            graphics.drawLine(n9, n8, n9, n5);
        }
        for (n6 = n2; n6 <= n3; ++n6) {
            Rectangle rectangle4 = this.table.getCellRect(n6, n7, false);
            rectangle4.x += n4;
            this.paintCell(graphics, rectangle4, n6, n7);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n6, n7, true);
            rectangle5.x += n4;
            n5 = rectangle5.x;
            int n10 = rectangle5.y;
            int n11 = n5 + rectangle5.width - 1;
            int n12 = n10 + rectangle5.height - 1;
            graphics.drawLine(n5, n12, n11, n12);
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n2, n3);
            Component component = this.table.prepareRenderer(tableCellRenderer, n2, n3);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }
}

