/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.ui;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticTheme;
import de.qfs.apps.qftest.shared.metrics.OtelSetup;
import de.qfs.apps.qftest.shared.script.modules.UserNotifications;
import de.qfs.apps.qftest.shared.system.Native;
import de.qfs.apps.qftest.shared.ui.BaseFocusManager;
import de.qfs.apps.qftest.shared.ui.DerivedFontSet;
import de.qfs.apps.qftest.shared.ui.SkyQfsLookAndFeel;
import de.qfs.apps.qftest.shared.ui.plaf.SkyQfs;
import de.qfs.lib.gui.ModalDialog;
import de.qfs.lib.gui.NotifyingJDialog;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.util.ExceptionHandler;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Observer;
import de.qfs.lib.util.Reflector;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public abstract class UISetup {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.ui.UISetup");
    private static Tracer b = OtelSetup.getTracer("qftest.startup");
    private static final AtomicReference c = new AtomicReference();
    private static final AtomicReference d = new AtomicReference();
    private static final AtomicReference e = new AtomicReference();
    private static final AtomicReference f = new AtomicReference();
    private static final AtomicReference g = new AtomicReference();
    private static final AtomicReference h = new AtomicReference();
    private static SkyQfs i;
    private static boolean j;
    private static DerivedFontSet k;
    private static Observer l;
    private static int m;
    private static Observer n;

    private UISetup() {
    }

    public static void setupUI(ExceptionHandler exceptionHandler, final KeyStroke keyStroke) {
        if (UISetup.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "setupUI(ExceptionHandler,KeyStroke)", 141).addDetail("exHandler", (Object)exceptionHandler)).addDetail("defaultButtonKeyStroke", (Object)keyStroke)).log();
        }
        System.setProperty("javax.swing.adjustPopupLocationToFit", "false");
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Throwable throwable;
                Scope scope;
                Span span = b.spanBuilder("UI setup init").startSpan();
                try {
                    scope = span.makeCurrent();
                    throwable = null;
                    try {
                        UIManager.getColor("textText");
                        FocusManager.setCurrentManager(new BaseFocusManager());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scope != null) {
                            if (throwable != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                scope.close();
                            }
                        }
                    }
                }
                finally {
                    span.end();
                }
                span = b.spanBuilder("set look and feel").startSpan();
                try {
                    scope = span.makeCurrent();
                    throwable = null;
                    try {
                        boolean bl;
                        String string = System.getProperty("qftest.macos.ui.native", "false");
                        boolean bl2 = bl = Misc.OS_IS_MAC_OS_X && Boolean.parseBoolean(string);
                        if (!bl) {
                            this.a();
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (scope != null) {
                            if (throwable != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                scope.close();
                            }
                        }
                    }
                }
                finally {
                    span.end();
                }
                span = b.spanBuilder("keymaps").startSpan();
                try {
                    scope = span.makeCurrent();
                    throwable = null;
                    try {
                        SwingUtil.prepareKeymaps();
                        SwingUtil.setTextActionsForInputMap((InputMap)((InputMap)UIManager.get("TextField.focusInputMap")));
                        SwingUtil.setTextActionsForInputMap((InputMap)((InputMap)UIManager.get("TextArea.focusInputMap")));
                        SwingUtil.setTextActionsForInputMap((InputMap)((InputMap)UIManager.get("EditorPane.focusInputMap")));
                        SwingUtil.setTextActionsForInputMap((InputMap)((InputMap)UIManager.get("TextPane.focusInputMap")));
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (scope != null) {
                            if (throwable != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                scope.close();
                            }
                        }
                    }
                }
                finally {
                    span.end();
                }
                SwingUtil.activateWindowTracking();
            }

            protected void a() {
                try {
                    try {
                        ThemeSupport.init();
                        Options.setSelectOnFocusGainEnabled((boolean)false);
                        i = UISetup.i();
                        j = UISetup.isDarkTheme(i);
                        if (keyStroke != null) {
                            i.setDefaultButtonKeyStroke(keyStroke);
                            ModalDialog.setDefaultButtonKeyStroke((KeyStroke)keyStroke);
                        }
                        i.updateUI();
                        SkyQfsLookAndFeel.setPlasticTheme((PlasticTheme)i);
                        Native.instance().setAppAppearance(i.isDarkTheme());
                        UIManager.setLookAndFeel("de.qfs.apps.qftest.shared.ui.SkyQfsLookAndFeel");
                        SwingUtilities.invokeLater(() -> {
                            if (UserNotifications.NOTIFIER.level >= 1) {
                                UserNotifications.NOTIFIER.postNotification(1, "user.theme.initialized", (Object)i, new Object[]{"theme", i.getName(), "isDarkTheme", j, "suffix", i.getPropertySuffix()});
                            }
                            UISetup.k();
                            if (UserNotifications.NOTIFIER.level >= 1) {
                                UserNotifications.NOTIFIER.postNotification(1, "user.theme.updatedUI", (Object)i, new Object[]{"theme", i.getName(), "isDarkTheme", j, "suffix", i.getPropertySuffix()});
                            }
                        });
                    }
                    catch (Exception exception) {
                        String string;
                        if (a.level >= 3) {
                            ((LevelAwareLogBuilder)a.lvlBuild(3, "setupUI(ExceptionHandler,KeyStroke).Runnable.setQFTestLookAndFeel()", 221).add("e", (Object)exception)).log();
                        }
                        if ((string = UIManager.getSystemLookAndFeelClassName()).endsWith("MotifLookAndFeel")) {
                            string = UIManager.getCrossPlatformLookAndFeelClassName();
                        }
                        UIManager.setLookAndFeel(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    a.log("main(String[])", (Throwable)exception);
                }
            }
        });
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (UISetup.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "setupUI(ExceptionHandler,KeyStroke)", 239).add("queue", (Object)eventQueue)).log();
        }
        if (eventQueue.getClass().getName().startsWith("de.qfs.apps.qftest.client.awt.")) {
            Reflector.safeCall((Object)eventQueue, (String)"setTabHackEnabled", (Class[])new Class[]{Boolean.class}, (Object[])new Object[]{Boolean.TRUE});
            Reflector.safeCall((Object)eventQueue, (String)"setMetaHackEnabled", (Class[])new Class[]{Boolean.class}, (Object[])new Object[]{Boolean.TRUE});
        } else {
            de.qfs.lib.gui.EventQueue.install();
            de.qfs.lib.gui.EventQueue.setTabHackEnabled((boolean)true);
            de.qfs.lib.gui.EventQueue.setMetaHackEnabled((boolean)true);
            if (exceptionHandler != null && de.qfs.lib.gui.EventQueue.instance() instanceof de.qfs.lib.gui.EventQueue) {
                ((de.qfs.lib.gui.EventQueue)de.qfs.lib.gui.EventQueue.instance()).setExceptionHandler(exceptionHandler);
            }
        }
        System.getProperties().put("de.qfs.lib.FixSplitPaneCanvas", "false");
        UISetup.j();
        de.qfs.apps.qftest.shared.extensions.Options.getOption(de.qfs.apps.qftest.shared.extensions.Options.OPT_UI_MINIMUM_FONT_SIZE).addObserver(n);
        n.update(null, null);
    }

    private static SkyQfs i() {
        boolean bl;
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getThemeFromOption()", 271).log();
        }
        int n2 = de.qfs.apps.qftest.shared.extensions.Options.cached_OPT_UI_THEME_MODE;
        int n3 = de.qfs.apps.qftest.shared.extensions.Options.cached_OPT_UI_THEME_NAME;
        if (UISetup.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getThemeFromOption()", 275).add("selectedMode", n2)).log();
        }
        if (UISetup.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getThemeFromOption()", 276).add("selectedTheme", n3)).log();
        }
        switch (n2) {
            case 1: {
                bl = Native.instance().areAppsInDarkMode();
                if (UISetup.a.level < 9) break;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getThemeFromOption()", 281).add("selectedOption from System: ")).add(bl ? 3 : 2)).log();
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        switch (n3) {
            case 2: {
                return bl ? UISetup.getHighContrastThemeDark() : UISetup.getHighContrastTheme();
            }
            case 3: {
                return bl ? UISetup.getSolarizedThemeDark() : UISetup.getSolarizedTheme();
            }
        }
        return bl ? UISetup.getDefaultThemeDark() : UISetup.getDefaultTheme();
    }

    private static void j() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "listenForDarkModeSwitch()", 302).log();
        }
        DefaultNotificationCenter.instance().addObserver(notification -> {
            if (1 == de.qfs.apps.qftest.shared.extensions.Options.cached_OPT_UI_THEME_MODE && ((Boolean)notification.getUserInfoValue("didChangeAppsTheme")).booleanValue()) {
                UISetup.setTheme(UISetup.i());
            }
        }, "user.theme.systemChanged");
        Native.instance().listenForDarkModeSwitch();
    }

    protected static void a() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "setFonts()", 315).log();
        }
        FontPolicy fontPolicy = new FontPolicy(){

            public FontSet getFontSet(String string, UIDefaults uIDefaults) {
                k = new DerivedFontSet(FontPolicies.getDefaultPlasticPolicy().getFontSet(string, uIDefaults));
                return k;
            }
        };
        fontPolicy = FontPolicies.customSettingsPolicy((FontPolicy)fontPolicy);
        SkyQfsLookAndFeel.setFontPolicy((FontPolicy)fontPolicy);
    }

    public static void setTheme(SkyQfs skyQfs) {
        if (UISetup.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setTheme(SkyQfs)", 335).addDetail("_theme", (Object)skyQfs)).log();
        }
        if (Misc.equalOrNull((Object)((Object)i), (Object)((Object)skyQfs))) {
            return;
        }
        j = UISetup.isDarkTheme(i);
        UISetup.forceSetTheme(skyQfs);
    }

    public static void reloadTheme() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "reloadTheme()", 351).log();
        }
        i.updateStyleCacheFromCss();
        UISetup.forceSetTheme(i);
    }

    public static void forceSetTheme(SkyQfs skyQfs) {
        if (UISetup.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "forceSetTheme(SkyQfs)", 360).addDetail("_theme", (Object)skyQfs)).log();
        }
        i = skyQfs;
        j = UISetup.isDarkTheme(i);
        SwingUtil.invokeAndWait(() -> {
            if (UserNotifications.NOTIFIER.level >= 1) {
                UserNotifications.NOTIFIER.postNotification(1, "user.theme.willChange", (Object)skyQfs, new Object[]{"theme", i.getName(), "isDarkTheme", j, "suffix", i.getPropertySuffix()});
            }
        });
        if (k != null) {
            k.a();
        } else {
            UISetup.a();
        }
        i.updateUI();
        SkyQfsLookAndFeel.setPlasticTheme((PlasticTheme)i);
        Native.instance().setAppAppearance(i.isDarkTheme());
        SwingUtilities.invokeLater(() -> {
            if (UserNotifications.NOTIFIER.level >= 1) {
                UserNotifications.NOTIFIER.postNotification(1, "user.theme.changed", (Object)skyQfs, new Object[]{"theme", i.getName(), "isDarkTheme", j, "suffix", i.getPropertySuffix()});
            }
            UISetup.k();
            if (UserNotifications.NOTIFIER.level >= 1) {
                UserNotifications.NOTIFIER.postNotification(1, "user.theme.updatedUI", (Object)skyQfs, new Object[]{"theme", i.getName(), "isDarkTheme", j, "suffix", i.getPropertySuffix()});
            }
        });
    }

    private static void k() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "updateExistingWindows()", 388).log();
        }
        for (Window window : Window.getWindows()) {
            try {
                if (!window.isDisplayable() && (!(window instanceof NotifyingJDialog) || !((NotifyingJDialog)window).isReusable())) continue;
                UISetup.adjustWindowAppearance(window);
                window.setBackground(UIManager.getColor("control"));
                SwingUtilities.updateComponentTreeUI(window);
            }
            catch (Throwable throwable) {
                if (UISetup.a.level < 3) continue;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "updateExistingWindows()", 398).add("ex", (Object)throwable)).log();
            }
        }
    }

    public static SkyQfs getCurrentTheme() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getCurrentTheme()", 406).log();
        }
        return i;
    }

    public static boolean isDarkTheme() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "isDarkTheme()", 413).log();
        }
        return j;
    }

    public static boolean isDarkTheme(SkyQfs skyQfs) {
        if (UISetup.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isDarkTheme(SkyQfs)", 421).addDetail("theme", (Object)skyQfs)).log();
        }
        return skyQfs != null && skyQfs.isDarkTheme();
    }

    public static String getCurrentThemeName() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getCurrentThemeName()", 429).log();
        }
        return i == null ? "" : i.getName();
    }

    public static String getThemePropertySuffix() {
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getThemePropertySuffix()", 437).log();
        }
        return i == null ? "" : i.getPropertySuffix();
    }

    public static void adjustWindowAppearance(Object object) {
        if (UISetup.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "adjustWindowAppearance(Object)", 445).addDetail("window", object)).log();
        }
        if (!(object instanceof Component)) {
            return;
        }
        long l2 = SwingUtil.getWindowHandle((Component)((Component)object));
        if (l2 > 0L) {
            Native.instance().setWindowAppearance(l2, j);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkyQfs getDefaultTheme() {
        Object object;
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getDefaultTheme()", 73).log();
        }
        if ((object = c.get()) == null) {
            AtomicReference atomicReference = c;
            synchronized (atomicReference) {
                object = c.get();
                if (object == null) {
                    SkyQfs skyQfs = new SkyQfs("qfs-user.css");
                    object = skyQfs == null ? c : skyQfs;
                    c.set(object);
                }
            }
        }
        return object == c ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkyQfs getDefaultThemeDark() {
        Object object;
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getDefaultThemeDark()", 74).log();
        }
        if ((object = d.get()) == null) {
            AtomicReference atomicReference = d;
            synchronized (atomicReference) {
                object = d.get();
                if (object == null) {
                    SkyQfs skyQfs = new SkyQfs("qfs-user-dark.css");
                    object = skyQfs == null ? d : skyQfs;
                    d.set(object);
                }
            }
        }
        return object == d ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkyQfs getHighContrastTheme() {
        Object object;
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getHighContrastTheme()", 75).log();
        }
        if ((object = e.get()) == null) {
            AtomicReference atomicReference = e;
            synchronized (atomicReference) {
                object = e.get();
                if (object == null) {
                    SkyQfs skyQfs = new SkyQfs("qfs-user-hc.css");
                    object = skyQfs == null ? e : skyQfs;
                    e.set(object);
                }
            }
        }
        return object == e ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkyQfs getHighContrastThemeDark() {
        Object object;
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getHighContrastThemeDark()", 76).log();
        }
        if ((object = f.get()) == null) {
            AtomicReference atomicReference = f;
            synchronized (atomicReference) {
                object = f.get();
                if (object == null) {
                    SkyQfs skyQfs = new SkyQfs("qfs-user-hc-dark.css");
                    object = skyQfs == null ? f : skyQfs;
                    f.set(object);
                }
            }
        }
        return object == f ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkyQfs getSolarizedTheme() {
        Object object;
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getSolarizedTheme()", 77).log();
        }
        if ((object = g.get()) == null) {
            AtomicReference atomicReference = g;
            synchronized (atomicReference) {
                object = g.get();
                if (object == null) {
                    SkyQfs skyQfs = new SkyQfs("qfs-user-solarized.css");
                    object = skyQfs == null ? g : skyQfs;
                    g.set(object);
                }
            }
        }
        return object == g ? null : object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SkyQfs getSolarizedThemeDark() {
        Object object;
        if (UISetup.a.level >= 7) {
            a.lvlBuild(7, "getSolarizedThemeDark()", 78).log();
        }
        if ((object = h.get()) == null) {
            AtomicReference atomicReference = h;
            synchronized (atomicReference) {
                object = h.get();
                if (object == null) {
                    SkyQfs skyQfs = new SkyQfs("qfs-user-solarized-dark.css");
                    object = skyQfs == null ? h : skyQfs;
                    h.set(object);
                }
            }
        }
        return object == h ? null : object;
    }

    static {
        l = (observable, object) -> UISetup.setTheme(UISetup.i());
        m = de.qfs.apps.qftest.shared.extensions.Options.cached_OPT_UI_MINIMUM_FONT_SIZE;
        n = (observable, object) -> {
            int n2 = de.qfs.apps.qftest.shared.extensions.Options.cached_OPT_UI_MINIMUM_FONT_SIZE;
            if (n2 != m) {
                UISetup.reloadTheme();
            }
            m = n2;
            ThemeSupport.setFontScale((double)((double)n2 / 14.0));
        };
        de.qfs.apps.qftest.shared.extensions.Options.getOption(de.qfs.apps.qftest.shared.extensions.Options.OPT_UI_THEME_NAME).addObserver(l);
        de.qfs.apps.qftest.shared.extensions.Options.getOption(de.qfs.apps.qftest.shared.extensions.Options.OPT_UI_THEME_MODE).addObserver(l);
        UISetup.a();
        DefaultNotificationCenter.instance().addObserver(notification -> UISetup.adjustWindowAppearance(notification.getObject()), "de.qfs.lib.gui.WindowNotification.peerCreated");
    }
}

