/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.web;

import de.qfs.apps.qftest.shared.Util;
import de.qfs.apps.qftest.shared.script.modules.Automac;
import de.qfs.apps.qftest.shared.system.mac.PListAccess;
import de.qfs.apps.qftest.shared.system.win32.WinApiAccess;
import de.qfs.apps.qftest.shared.web.BrowserReleaseChannel;
import de.qfs.apps.qftest.shared.web.ConnectionMode;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonSerializable;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class WebBrowserInfo
implements JsonSerializable {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.shared.web.WebBrowserInfo");
    public static final String PROGRAM_FILES_SYSTEM_ENV = "ProgramFiles";
    public static final String PROGRAM_FILES_64_SYSTEM_ENV = "ProgramW6432";
    public static final String PROGRAM_FILES_32_SYSTEM_ENV = "ProgramFiles(X86)";
    public static final String LOCAL_APPDATA_ENV = "LOCALAPPDATA";
    public static final String APPDATA_ENV = "APPDATA";
    public static final String NOTIFICATION_DOWNLOAD_START = "WebBrowserInfo.download.start";
    public static final String NOTIFICATION_DOWNLOAD_END = "WebBrowserInfo.download.end";
    public static final String NOTIFICATION_VERSIONDETECT_START = "WebBrowserInfo.versiondetect.start";
    public static final String NOTIFICATION_VERSIONDETECT_END = "WebBrowserInfo.versiondetect.end";
    private static final String b = "QFTEST_WEBDRIVERS_ROOT";
    public static final List BITNESS_SUFFIXES = WebBrowserInfo.d();
    protected String f;
    protected String g;
    protected final Map h = new HashMap();
    protected File i;
    protected VersionNumber j;
    protected File k;
    protected VersionNumber l;
    private BrowserReleaseChannel c;
    private boolean d;

    public JsonValue asJsonValue() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "asJsonValue()", 114).log();
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("name", this.getBrowserName());
        jsonObject.add("simpleName", this.getSimpleBrowserName());
        if (this.i != null) {
            jsonObject.add("executable", this.i.getAbsolutePath());
        }
        if (this.j != null) {
            jsonObject.add("executableVersion", this.j.asJsonValue());
        }
        if (this.k != null) {
            jsonObject.add("driver", this.k.getAbsolutePath());
        }
        if (this.l != null) {
            jsonObject.add("driverVersion", this.l.asJsonValue());
        }
        if (this.c != null) {
            jsonObject.add("executableChannel", Json.value((Object)((Object)this.c)));
        }
        return jsonObject;
    }

    public WebBrowserInfo setupDriver() throws IOException {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "setupDriver()", 149).log();
        }
        try {
            try {
                if (WebBrowserInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "setupDriver()", 153).add("executable", (Object)this.i)).log();
                }
                this.assureExecutableVersion();
                if (this.k == null) {
                    this.setDriverVersion(null);
                    this.findDriverFromProperties();
                    if (WebBrowserInfo.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "setupDriver()", 158).add("driver", (Object)this.k)).log();
                    }
                    if (this.k == null) {
                        this.findDefaultDriver();
                        if (WebBrowserInfo.a.level >= 9) {
                            ((LevelAwareLogBuilder)a.lvlBuild(9, "setupDriver()", 161).add("driver", (Object)this.k)).log();
                        }
                    }
                }
            }
            finally {
                if (this.l == null) {
                    this.detectDriverVersion();
                    if (WebBrowserInfo.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "setupDriver()", 167).add("driverVersion", (Object)this.l)).log();
                    }
                }
            }
        }
        finally {
            this.adaptDriverProperty();
        }
        return this;
    }

    @Nullable
    public WebBrowserInfo findExecutable() {
        File file;
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "findExecutable()", 184).log();
        }
        if ((file = this.e()) == null && Misc.emptyOrNull((String)this.f)) {
            file = this.getBinaryFromDefaultPaths();
        }
        this.setExecutable(file);
        return this;
    }

    private File e() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getBinaryFromSpecification()", 198).log();
        }
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryFromSpecification()", 200).add("browserDir", this.f)).add("browserFileName", this.g)).log();
        }
        String string = this.getFullFixedBrowserFilename();
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryFromSpecification()", 204).add("fullFixedBrowserFileName", string)).log();
        }
        File file = null;
        if (!Misc.emptyOrNull((String)this.f)) {
            file = this.a(this.f);
        }
        if (!(Misc.emptyOrNull((String)string) || file != null && Misc.emptyOrNull((String)this.g))) {
            File file2 = new File(string);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryFromSpecification()", 215).add("fixedBrowserFile", (Object)file2)).log();
            }
            if (Misc.OS_IS_MAC_OS_X && !file2.isFile()) {
                File file3 = PListAccess.instance().getExecutable(file2);
                if (WebBrowserInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryFromSpecification()", 218).add("executable", (Object)file3)).log();
                }
                if (file3 != null && this.d(file3)) {
                    return file3;
                }
            }
            if (file2.isFile()) {
                return file2;
            }
        }
        return file;
    }

    @Nullable
    public String getFullFixedBrowserFilename() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getFullFixedBrowserFilename()", 239).log();
        }
        return Misc.emptyOrNull((String)this.f) ? this.g : (Misc.emptyOrNull((String)this.g) ? this.f : this.f + File.separator + this.g);
    }

    public abstract List getBinaryNames();

    public abstract String getBrowserName();

    public abstract String getSimpleBrowserName();

    @Nullable
    protected File a(String string) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getBinaryInBrowserDir(String)", 274).addDetail("browserDir", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("browserDir is marked non-null but is null");
        }
        List list = Misc.emptyOrNull((String)this.g) ? this.getBinaryNames() : Misc.listOf((Object[])new String[]{this.g});
        for (String string2 : list) {
            File file = new File(string, string2);
            boolean bl = this.d(file);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryInBrowserDir(String)", 283).add("Testing ")).add((Object)file)).add("exists", bl)).log();
            }
            if (this.a(file)) {
                return file;
            }
            if (!Misc.OS_IS_MAC_OS_X) continue;
            File file2 = PListAccess.instance().getExecutable(file);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryInBrowserDir(String)", 289).add("executable", (Object)file2)).log();
            }
            if (!this.a(file2)) continue;
            return file2;
        }
        if (Misc.OS_IS_MAC_OS_X) {
            File file = PListAccess.instance().getExecutable(new File(string));
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryInBrowserDir(String)", 298).add("executable", (Object)file)).log();
            }
            if (file != null) {
                String string2;
                string2 = PListAccess.instance().getBundleIdentifier(new File(string));
                if (WebBrowserInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryInBrowserDir(String)", 303).add("bundleIdentifier", string2)).log();
                }
                if (!"de.qfs.apps.qftest".equals(string2) && this.a(file)) {
                    return file;
                }
            }
        }
        return null;
    }

    protected boolean a(@Nullable File file) {
        boolean bl;
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "isExecutableBinaryFine(File)", 317).addDetail("executable", (Object)file)).log();
        }
        boolean bl2 = bl = file != null && this.d(file);
        if (bl && this.c != null) {
            assert (file != null);
            BrowserReleaseChannel browserReleaseChannel = this.b(file);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "isExecutableBinaryFine(File)", 323).add("detectedExecutableChannel", (Object)browserReleaseChannel)).add("executableChannel", (Object)this.c)).log();
            }
            if (browserReleaseChannel != this.c) {
                return false;
            }
        }
        return bl;
    }

    protected File getBinaryFromDefaultPaths() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getBinaryFromDefaultPaths()", 335).log();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Misc.OS_IS_MAC_OS_X) {
            this.a(linkedList);
        } else if (Misc.OS_IS_WINDOWS) {
            this.b(linkedList);
        } else {
            this.c(linkedList);
        }
        String string = System.getenv("PATH");
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryFromDefaultPaths()", 348).add("systemPath", string)).log();
        }
        if (string != null) {
            linkedList.addAll(Arrays.asList(Misc.fastSplit((String)string, (char)File.pathSeparatorChar)));
        }
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryFromDefaultPaths()", 352).add("defaultPaths", linkedList)).log();
        }
        for (String string2 : linkedList) {
            if (Misc.emptyOrNull((String)string2)) continue;
            File file = this.a(string2);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getBinaryFromDefaultPaths()", 358).add("executable", (Object)file)).log();
            }
            if (file == null) continue;
            return file;
        }
        return null;
    }

    protected void a(LinkedList linkedList) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "addMacOSDefaultPaths(LinkedList<String>)", 369).addDetail("defaultPaths", (Object)linkedList)).log();
        }
        try {
            linkedList.addAll(Automac.instance().getSearchPathForDirectoriesInDomains(1, 3, true));
        }
        catch (Exception exception) {
            if (WebBrowserInfo.a.level >= 5) {
                ((LevelAwareLogBuilder)a.lvlBuild(5, "addMacOSDefaultPaths(LinkedList<String>)", 375).add("ex", (Object)exception)).log();
            }
            linkedList.add(System.getProperty("user.home") + File.separator + "/Applications");
            linkedList.add("/Applications");
        }
    }

    protected void b(LinkedList linkedList) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "addWindowsExecutableDefaultPaths(LinkedList<String>)", 385).addDetail("defaultPaths", (Object)linkedList)).log();
        }
        List list = this.getWindowsProgramFilesSubdirs();
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "addWindowsExecutableDefaultPaths(LinkedList<String>)", 388).add("programFilesSubdirs", (Object)list)).log();
        }
        this.a(linkedList, list);
    }

    protected void a(LinkedList linkedList, List list) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addWindowsDefaultPaths(LinkedList<String>,List<String>)", 395).addDetail("defaultPaths", (Object)linkedList)).addDetail("programFilesSubdirs", (Object)list)).log();
        }
        if (list == null) {
            throw new IllegalArgumentException("programFilesSubdirs is marked non-null but is null");
        }
        for (String string : list) {
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "addWindowsDefaultPaths(LinkedList<String>,List<String>)", 398).add("windowsProgramFilesSubdir", string)).log();
            }
            for (String string2 : this.a()) {
                this.a(linkedList, string2, string);
                this.a(linkedList, string2, "Programs" + File.separator + string);
            }
        }
    }

    protected List a() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getWindowsProgramFilesEnvironments()", 410).log();
        }
        return Misc.listOf((Object[])new String[]{LOCAL_APPDATA_ENV, PROGRAM_FILES_SYSTEM_ENV, PROGRAM_FILES_64_SYSTEM_ENV, PROGRAM_FILES_32_SYSTEM_ENV, APPDATA_ENV});
    }

    protected List getWindowsProgramFilesSubdirs() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getWindowsProgramFilesSubdirs()", 424).log();
        }
        return Collections.emptyList();
    }

    protected void c(LinkedList linkedList) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "addLinuxDefaultPaths(LinkedList<String>)", 432).addDetail("defaultPaths", (Object)linkedList)).log();
        }
        linkedList.add("/usr/local/sbin");
        linkedList.add("/usr/local/bin");
        linkedList.add("/usr/sbin");
        linkedList.add("/usr/bin");
        linkedList.add("/sbin");
        linkedList.add("/bin");
    }

    protected void a(List list, String string, @Nullable String string2) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "addSystemEnvBasedDirToPath(List<String>,String,String)", 446).addDetail("paths", (Object)list)).addDetail("systemEnvName", string)).addDetail("subfolderName", string2)).log();
        }
        if (list == null) {
            throw new IllegalArgumentException("paths is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("systemEnvName is marked non-null but is null");
        }
        String string3 = WebBrowserInfo.getSystemEnvBasedDir(string, string2, true);
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "addSystemEnvBasedDirToPath(List<String>,String,String)", 449).add("dir", string3)).log();
        }
        if (string3 != null) {
            list.add(string3);
        }
    }

    @Nullable
    public static String getSystemEnvBasedDir(String string, @Nullable String string2, boolean bl) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getSystemEnvBasedDir(String,String,boolean)", 459).addDetail("systemEnvName", string)).addDetail("subfolderName", string2)).addDetail("mustExists", bl)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("systemEnvName is marked non-null but is null");
        }
        String string3 = System.getenv(string);
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getSystemEnvBasedDir(String,String,boolean)", 462).add("dir", string3)).log();
        }
        if (string3 != null) {
            File file;
            File file2 = file = Misc.emptyOrNull((String)string2) ? new File(string3) : new File(string3, string2);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "getSystemEnvBasedDir(String,String,boolean)", 465).add("fullDir", (Object)file)).log();
            }
            if (!bl || file.exists()) {
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    @Nullable
    public WebBrowserInfo assureExecutableVersion() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "assureExecutableVersion()", 480).log();
        }
        if (this.j == null) {
            this.b();
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "assureExecutableVersion()", 484).add("executableVersion", (Object)this.j)).log();
            }
        }
        return this;
    }

    @Nullable
    protected WebBrowserInfo b() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "detectExecutableVersion()", 496).log();
        }
        this.setExecutableVersion(null);
        this.detectExecutableChannel();
        return this;
    }

    public WebBrowserInfo detectExecutableChannel() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "detectExecutableChannel()", 507).log();
        }
        this.setExecutableChannel(this.b(this.i));
        return this;
    }

    protected BrowserReleaseChannel b(@Nullable File file) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "detectExecutableChannel(File)", 515).addDetail("executable", (Object)file)).log();
        }
        return null;
    }

    public VersionNumber getVersionByRunningFile(File file, String string) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getVersionByRunningFile(File,String)", 523).addDetail("file", (Object)file)).addDetail("argument", string)).log();
        }
        String string2 = this.a(file, string);
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "getVersionByRunningFile(File,String)", 525).add("output", string2)).log();
        }
        if (string2 == null) {
            return null;
        }
        if ((string2 = this.b(string2)) == null) {
            return null;
        }
        return VersionNumber.fromString((String)string2);
    }

    @Nullable
    protected String b(String string2) {
        int n2;
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "prepareOutputToReadVersionNumber(String)", 534).addDetail("output", string2)).log();
        }
        if ((string2 = string2.trim()).isEmpty()) {
            return null;
        }
        string2 = Arrays.stream(Misc.fastSplit((String)string2, (char)'\n')).filter(string -> string.length() > 0 && string.charAt(0) != '[').collect(Collectors.joining("\n"));
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "prepareOutputToReadVersionNumber(String)", 539).add("output", string2)).log();
        }
        if ((n2 = string2.indexOf(40)) > 1) {
            string2 = string2.substring(0, n2);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "prepareOutputToReadVersionNumber(String)", 545).add("output", string2)).log();
            }
        }
        string2 = string2.trim();
        return string2;
    }

    @Nullable
    protected String a(File file, String string) {
        block8: {
            if (WebBrowserInfo.a.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getOutputOfRunningFile(File,String)", 555).addDetail("file", (Object)file)).addDetail("argument", string)).log();
            }
            if (file == null || !this.d(file)) {
                return null;
            }
            try {
                int n2 = Integer.getInteger("qftest.web.webdriver.versionDetectTimeout", 3000);
                if (WebBrowserInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getOutputOfRunningFile(File,String)", 562).add("timeout", n2)).log();
                }
                String string2 = ProcessManager.runProcess((String[])new String[]{file.getAbsolutePath(), string}, (int)n2);
                if (WebBrowserInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)a.lvlBuild(9, "getOutputOfRunningFile(File,String)", 564).add("output", string2)).log();
                }
                return string2;
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                if (WebBrowserInfo.a.level >= 5) {
                    ((LevelAwareLogBuilder)a.lvlBuild(5, "getOutputOfRunningFile(File,String)", 567).add("e", (Object)runProcessException)).log();
                }
            }
            catch (Exception exception) {
                if (WebBrowserInfo.a.level < 3) break block8;
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getOutputOfRunningFile(File,String)", 569).add("e", (Object)exception)).log();
            }
        }
        return null;
    }

    protected VersionNumber c(File file) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "getVersionFromWindowsFile(File)", 577).addDetail("file", (Object)file)).log();
        }
        try {
            return WinApiAccess.instance().getFileVersion(file);
        }
        catch (Exception exception) {
            if (WebBrowserInfo.a.level >= 3) {
                ((LevelAwareLogBuilder)a.lvlBuild(3, "getVersionFromWindowsFile(File)", 582).add("e", (Object)exception)).log();
            }
            return null;
        }
    }

    public WebBrowserInfo findDriverFromProperties() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "findDriverFromProperties()", 595).log();
        }
        Stream<String> stream = Stream.of(this.getDriverProperty(), "qftest.web.webdriver.driver").filter(string -> !Misc.emptyOrNull((String)string)).map(string -> {
            String string2 = System.getProperty(string);
            this.h.put(string, string2);
            return string2;
        }).filter(string -> !"autodetect".equals(string));
        String string2 = System.getenv(b);
        this.h.put(b, string2);
        stream = Stream.concat(stream, Stream.of(string2));
        this.setDriver(stream.filter(string -> !Misc.emptyOrNull((String)string)).map(string -> {
            File file;
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverFromProperties()", 613).add("dir", string)).log();
            }
            if (!(file = new File((String)string)).isFile()) {
                File file2 = this.a(Misc.listOf((Object[])new File[]{file}));
                if (file2 != null) {
                    if (WebBrowserInfo.a.level >= 9) {
                        ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverFromProperties()", 618).add("driverInSubdir", (Object)file2)).log();
                    }
                    return file2;
                }
                if (WebBrowserInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverFromProperties()", 621).add("No driver found in dir: ")).add((Object)file)).log();
                }
                return null;
            }
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverFromProperties()", 626).add("driverFile", (Object)file)).log();
            }
            return file;
        }).filter(file -> file != null).findFirst().orElse(null));
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverFromProperties()", 631).add("this.driver", (Object)this.k)).log();
        }
        return this;
    }

    @Nullable
    protected File a(List list) {
        String string;
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "findDriverInDirs(List<File>)", 640).addDetail("baseDirCandidates", (Object)list)).log();
        }
        String string2 = this.getDriverExecutableName();
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverInDirs(List<File>)", 643).add("drivername", string2)).log();
        }
        if (string2 == null) {
            return null;
        }
        String string3 = Misc.OS_IS_MAC_OS_X ? "mac" : (string = Misc.OS_IS_LINUX ? "linux" : "win");
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverInDirs(List<File>)", 648).add("osString", string)).log();
        }
        string2 = WebBrowserInfo.exeName(string2);
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverInDirs(List<File>)", 652).add("baseDirCandidates", (Object)list)).log();
        }
        for (File file : list) {
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverInDirs(List<File>)", 655).add("baseDirCandidate", (Object)file)).log();
            }
            if (file == null) continue;
            File file2 = new File(file, string2);
            boolean bl = this.d(file2);
            if (WebBrowserInfo.a.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverInDirs(List<File>)", 663).add("Checking ")).add((Object)file2)).add("exists", bl)).log();
            }
            if (bl) {
                return file2;
            }
            for (String string4 : BITNESS_SUFFIXES) {
                file2 = new File(file, string + string4 + File.separator + string2);
                bl = this.d(file2);
                if (WebBrowserInfo.a.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "findDriverInDirs(List<File>)", 673).add("Checking ")).add((Object)file2)).add("exists", bl)).log();
                }
                if (!bl) continue;
                return file2;
            }
        }
        return null;
    }

    protected boolean d(File file) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "fileOrReferenceExists(File)", 683).addDetail("file", (Object)file)).log();
        }
        if (file == null) {
            return false;
        }
        if (this.d) {
            return Misc.fileOrReferenceExists((File)file);
        }
        return file.exists();
    }

    @Nullable
    public String getDriverProperty() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getDriverProperty()", 700).log();
        }
        return null;
    }

    @Nullable
    public abstract String getDriverExecutableName();

    public WebBrowserInfo findDefaultDriver() throws IOException {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "findDefaultDriver()", 723).log();
        }
        this.findLocalDefaultDriver();
        return this;
    }

    public WebBrowserInfo findLocalDefaultDriver() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "findLocalDefaultDriver()", 736).log();
        }
        List list = this.c();
        this.setDriver(this.a(list));
        return this;
    }

    protected List c() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "createListOfDefaultDriverPaths()", 751).log();
        }
        LinkedList linkedList = new LinkedList();
        Util.getTopicDirs("webdriver", Util.LocationPreference.PREFER_SYSTEM_DIR).stream().map(string -> new File((String)string)).forEach(file -> linkedList.add(file));
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)a.lvlBuild(9, "createListOfDefaultDriverPaths()", 757).add("paths", linkedList)).log();
        }
        return linkedList;
    }

    @Nullable
    public WebBrowserInfo detectDriverVersion() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "detectDriverVersion()", 768).log();
        }
        this.l = null;
        return this;
    }

    public WebBrowserInfo adaptDriverProperty() {
        String string;
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "adaptDriverProperty()", 782).log();
        }
        String string2 = this.getDriverProperty();
        String string3 = string = this.k == null ? null : this.k.getAbsolutePath();
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "adaptDriverProperty()", 786).add("Set ")).add(string2)).add(" to ")).add(string)).log();
        }
        if (string == null) {
            System.getProperties().remove(string2);
        } else {
            System.setProperty(string2, string);
        }
        if (WebBrowserInfo.a.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(9, "adaptDriverProperty()", 792).add("propName", string2)).add("System.getProperty(propName)", System.getProperty(string2))).add("newPropValue", string)).log();
        }
        return this;
    }

    static List d() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getBitnessSuffixesInSystemOrder()", 801).log();
        }
        List list = Misc.listOf((Object[])new String[]{"32", "64"});
        if (Misc.isSystemWith64Bit()) {
            Collections.reverse(list);
        }
        return list;
    }

    public static String exeName(String string) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "exeName(String)", 816).addDetail("fileName", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("fileName is marked non-null but is null");
        }
        if (Misc.OS_IS_WINDOWS && !string.toUpperCase().endsWith(".EXE")) {
            return string + ".exe";
        }
        return string;
    }

    public abstract boolean supportsConnectionMode(ConnectionMode var1);

    public boolean binaryNameMatchesDefault(File file) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "binaryNameMatchesDefault(File)", 833).addDetail("binary", (Object)file)).log();
        }
        if (file == null) {
            return false;
        }
        String string = file.getName();
        for (String string2 : this.getBinaryNames()) {
            if (!(Misc.OS_IS_WINDOWS ? string.equalsIgnoreCase(string2) || string.equalsIgnoreCase(string2 + ".exe") : string.equals(string2))) continue;
            return true;
        }
        return false;
    }

    public WebBrowserInfo() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "WebBrowserInfo()", 68).log();
        }
    }

    public String getBrowserDir() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getBrowserDir()", 92).log();
        }
        return this.f;
    }

    public String getBrowserFileName() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getBrowserFileName()", 93).log();
        }
        return this.g;
    }

    public Map getInputData() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getInputData()", 98).log();
        }
        return this.h;
    }

    public File getExecutable() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getExecutable()", 103).log();
        }
        return this.i;
    }

    public VersionNumber getExecutableVersion() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getExecutableVersion()", 104).log();
        }
        return this.j;
    }

    public File getDriver() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getDriver()", 105).log();
        }
        return this.k;
    }

    public VersionNumber getDriverVersion() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getDriverVersion()", 106).log();
        }
        return this.l;
    }

    public boolean isEvaluateFileReferences() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "isEvaluateFileReferences()", 109).log();
        }
        return this.d;
    }

    public WebBrowserInfo setBrowserDir(String string) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setBrowserDir(String)", 68).addDetail("browserDir", string)).log();
        }
        this.f = string;
        return this;
    }

    public WebBrowserInfo setBrowserFileName(String string) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setBrowserFileName(String)", 68).addDetail("browserFileName", string)).log();
        }
        this.g = string;
        return this;
    }

    public WebBrowserInfo setExecutable(File file) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setExecutable(File)", 68).addDetail("executable", (Object)file)).log();
        }
        this.i = file;
        return this;
    }

    public WebBrowserInfo setExecutableVersion(VersionNumber versionNumber) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setExecutableVersion(VersionNumber)", 68).addDetail("executableVersion", (Object)versionNumber)).log();
        }
        this.j = versionNumber;
        return this;
    }

    public WebBrowserInfo setDriver(File file) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setDriver(File)", 68).addDetail("driver", (Object)file)).log();
        }
        this.k = file;
        return this;
    }

    public WebBrowserInfo setDriverVersion(VersionNumber versionNumber) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setDriverVersion(VersionNumber)", 68).addDetail("driverVersion", (Object)versionNumber)).log();
        }
        this.l = versionNumber;
        return this;
    }

    public WebBrowserInfo setEvaluateFileReferences(boolean bl) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setEvaluateFileReferences(boolean)", 68).addDetail("evaluateFileReferences", bl)).log();
        }
        this.d = bl;
        return this;
    }

    public boolean equals(Object object) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "equals(Object)", 68).addDetail("o", object)).log();
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof WebBrowserInfo)) {
            return false;
        }
        WebBrowserInfo webBrowserInfo = (WebBrowserInfo)object;
        if (!webBrowserInfo.a(this)) {
            return false;
        }
        if (this.isEvaluateFileReferences() != webBrowserInfo.isEvaluateFileReferences()) {
            return false;
        }
        String string = this.getBrowserDir();
        String string2 = webBrowserInfo.getBrowserDir();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getBrowserFileName();
        String string4 = webBrowserInfo.getBrowserFileName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        Map map = this.getInputData();
        Map map2 = webBrowserInfo.getInputData();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        File file = this.getExecutable();
        File file2 = webBrowserInfo.getExecutable();
        if (file == null ? file2 != null : !((Object)file).equals(file2)) {
            return false;
        }
        VersionNumber versionNumber = this.getExecutableVersion();
        VersionNumber versionNumber2 = webBrowserInfo.getExecutableVersion();
        if (versionNumber == null ? versionNumber2 != null : !versionNumber.equals(versionNumber2)) {
            return false;
        }
        File file3 = this.getDriver();
        File file4 = webBrowserInfo.getDriver();
        if (file3 == null ? file4 != null : !((Object)file3).equals(file4)) {
            return false;
        }
        VersionNumber versionNumber3 = this.getDriverVersion();
        VersionNumber versionNumber4 = webBrowserInfo.getDriverVersion();
        if (versionNumber3 == null ? versionNumber4 != null : !versionNumber3.equals(versionNumber4)) {
            return false;
        }
        BrowserReleaseChannel browserReleaseChannel = this.getExecutableChannel();
        BrowserReleaseChannel browserReleaseChannel2 = webBrowserInfo.getExecutableChannel();
        return !(browserReleaseChannel == null ? browserReleaseChannel2 != null : !((Object)((Object)browserReleaseChannel)).equals((Object)browserReleaseChannel2));
    }

    protected boolean a(Object object) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "canEqual(Object)", 68).addDetail("other", object)).log();
        }
        return object instanceof WebBrowserInfo;
    }

    public int hashCode() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "hashCode()", 68).log();
        }
        int n2 = 1;
        n2 = n2 * 59 + (this.isEvaluateFileReferences() ? 79 : 97);
        String string = this.getBrowserDir();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getBrowserFileName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        Map map = this.getInputData();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        File file = this.getExecutable();
        n2 = n2 * 59 + (file == null ? 43 : ((Object)file).hashCode());
        VersionNumber versionNumber = this.getExecutableVersion();
        n2 = n2 * 59 + (versionNumber == null ? 43 : versionNumber.hashCode());
        File file2 = this.getDriver();
        n2 = n2 * 59 + (file2 == null ? 43 : ((Object)file2).hashCode());
        VersionNumber versionNumber2 = this.getDriverVersion();
        n2 = n2 * 59 + (versionNumber2 == null ? 43 : versionNumber2.hashCode());
        BrowserReleaseChannel browserReleaseChannel = this.getExecutableChannel();
        n2 = n2 * 59 + (browserReleaseChannel == null ? 43 : ((Object)((Object)browserReleaseChannel)).hashCode());
        return n2;
    }

    public String toString() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "toString()", 68).log();
        }
        return "WebBrowserInfo(browserDir=" + this.getBrowserDir() + ", browserFileName=" + this.getBrowserFileName() + ", inputData=" + this.getInputData() + ", executable=" + this.getExecutable() + ", executableVersion=" + this.getExecutableVersion() + ", driver=" + this.getDriver() + ", driverVersion=" + this.getDriverVersion() + ", executableChannel=" + (Object)((Object)this.getExecutableChannel()) + ", evaluateFileReferences=" + this.isEvaluateFileReferences() + ")";
    }

    public BrowserReleaseChannel getExecutableChannel() {
        if (WebBrowserInfo.a.level >= 7) {
            a.lvlBuild(7, "getExecutableChannel()", 108).log();
        }
        return this.c;
    }

    public WebBrowserInfo setExecutableChannel(BrowserReleaseChannel browserReleaseChannel) {
        if (WebBrowserInfo.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "setExecutableChannel(BrowserReleaseChannel)", 108).addDetail("executableChannel", (Object)browserReleaseChannel)).log();
        }
        this.c = browserReleaseChannel;
        return this;
    }
}

