/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.shared.web.edge;

import de.qfs.apps.qftest.shared.Globals;
import de.qfs.apps.qftest.shared.extensions.Options;
import de.qfs.apps.qftest.shared.extensions.TestOptionsProvider;
import de.qfs.apps.qftest.shared.web.BrowserReleaseChannel;
import de.qfs.apps.qftest.shared.web.ConnectionMode;
import de.qfs.apps.qftest.shared.web.WebBrowserInfo;
import de.qfs.apps.qftest.shared.web.chrome.ChromeBrowserInfo;
import de.qfs.lib.json.Json;
import de.qfs.lib.json.JsonObject;
import de.qfs.lib.json.JsonValue;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.util.Environment;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.VersionNumber;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class MSEdgeBrowserInfo
extends ChromeBrowserInfo {
    private static final QFLogger y = new QFLogger("de.qfs.apps.qftest.shared.web.edge.MSEdgeBrowserInfo");
    final String r = "Microsoft Edge";
    final String s = "edge";
    final List t = Misc.listOf((Object[])new String[]{"msedge.exe", "msedge", "Microsoft Edge", "Microsoft Edge Beta", "Microsoft Edge Dev", "Microsoft Edge Canary", "microsoft-edge"});
    final List u = Misc.listOf((Object[])new String[]{"\\Microsoft\\Edge\\Application", "\\Microsoft\\Edge Beta\\Application", "\\Microsoft\\Edge Dev\\Application", "\\Microsoft\\Edge SxS\\Application"});
    final String v = "webdriver.chrome.driver";
    final String w = MSEdgeBrowserInfo.exeName("msedgedriver");
    final String x = "https://developer.microsoft.com/en-us/microsoft-edge/tools/webdriver/";
    private static final String z = "msedgedrivers";
    private static ChromeBrowserInfo.b A;
    private static ChromeBrowserInfo.b B;

    public MSEdgeBrowserInfo() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "MSEdgeBrowserInfo.MSEdgeBrowserInfo()", 63).log();
        }
    }

    @Override
    protected void c(LinkedList linkedList) {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            ((LevelAwareLogBuilder)y.lvlBuild(7, "addLinuxDefaultPaths(LinkedList<String>)", 97).addDetail("defaultPaths", (Object)linkedList)).log();
        }
        super.c(linkedList);
        linkedList.add("/opt/microsoft/msedge");
        linkedList.add("/opt/microsoft/msedge-beta");
        linkedList.add("/opt/microsoft/msedge-dev");
    }

    @Override
    protected boolean c(VersionNumber versionNumber) {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            ((LevelAwareLogBuilder)y.lvlBuild(7, "expectedDriverIsBundled(VersionNumber)", 109).addDetail("expectedDriverVersion", (Object)versionNumber)).log();
        }
        return false;
    }

    @Override
    protected boolean e(File file) {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            ((LevelAwareLogBuilder)y.lvlBuild(7, "canGetVersionByRunningFile(File)", 118).addDetail("binary", (Object)file)).log();
        }
        return !Misc.OS_IS_WINDOWS;
    }

    @Override
    protected String b(VersionNumber versionNumber) {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            ((LevelAwareLogBuilder)y.lvlBuild(7, "getDriverDirName(VersionNumber)", 126).addDetail("driverVersion", (Object)versionNumber)).log();
        }
        if (versionNumber == null) {
            throw new IllegalArgumentException("driverVersion is marked non-null but is null");
        }
        return z;
    }

    @Override
    protected ChromeBrowserInfo.b a(VersionNumber versionNumber, VersionNumber versionNumber2) throws IOException {
        ChromeBrowserInfo.b b2;
        VersionNumber versionNumber3;
        ChromeBrowserInfo.b b3;
        block13: {
            if (MSEdgeBrowserInfo.y.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)y.lvlBuild(7, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 135).addDetail("executableVersion", (Object)versionNumber)).addDetail("expectedDriverVersion", (Object)versionNumber2)).log();
            }
            if (versionNumber == null) {
                throw new IllegalArgumentException("executableVersion is marked non-null but is null");
            }
            if (versionNumber2 == null) {
                throw new IllegalArgumentException("expectedDriverVersion is marked non-null but is null");
            }
            b3 = null;
            versionNumber3 = null;
            try {
                b3 = this.h();
                if (b3 != null) {
                    versionNumber3 = b3.a(versionNumber2);
                    if (MSEdgeBrowserInfo.y.level >= 9) {
                        ((LevelAwareLogBuilder)y.lvlBuild(9, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 144).add("bestMatchingVersionXml", (Object)versionNumber3)).log();
                    }
                }
                if (versionNumber2.compareTo(versionNumber3, 3) == 0) {
                    if (MSEdgeBrowserInfo.y.level >= 9) {
                        ((LevelAwareLogBuilder)y.lvlBuild(9, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 147).add("XML returns matching result, use it")).log();
                    }
                    return b3;
                }
            }
            catch (IOException iOException) {
                if (MSEdgeBrowserInfo.y.level < 3) break block13;
                ((LevelAwareLogBuilder)y.lvlBuild(3, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 151).add("ex", (Object)iOException)).log();
            }
        }
        if ((b2 = this.i()) != null) {
            VersionNumber versionNumber4 = b2.a(versionNumber2);
            if (MSEdgeBrowserInfo.y.level >= 9) {
                ((LevelAwareLogBuilder)y.lvlBuild(9, "getDriverDownloaderForVersion(VersionNumber,VersionNumber)", 157).add("bestMatchingVersionJson", (Object)versionNumber4)).log();
            }
            if (versionNumber4 == null) {
                return b3 == null ? b2 : b3;
            }
            if (versionNumber4.compareTo(versionNumber3) > 0) {
                return b2;
            }
        }
        return b3;
    }

    protected synchronized ChromeBrowserInfo.b h() throws IOException {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getXmlBasedMSEdgeDriverDownloader()", 173).log();
        }
        if (A != null) {
            return A;
        }
        A = new b();
        return A;
    }

    protected synchronized ChromeBrowserInfo.b i() throws IOException {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getJsonBasedMSEdgeDriverDownloader()", 184).log();
        }
        if (B != null) {
            return B;
        }
        B = new a();
        return B;
    }

    public static void main(String[] stringArray) {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            ((LevelAwareLogBuilder)y.lvlBuild(7, "main(String[])", 420).addDetail("args", (Object)stringArray)).log();
        }
        Options.setOptionsProvider(new TestOptionsProvider());
        Globals.addGlobal((Option)new StringOption("qftestversiondir", "/Users/pascal/qfs_drives/H/prj/install/qftest/qftest-master"));
        MSEdgeBrowserInfo mSEdgeBrowserInfo = new MSEdgeBrowserInfo();
        mSEdgeBrowserInfo.setBrowserDir("");
        mSEdgeBrowserInfo.setBrowserFileName("");
        mSEdgeBrowserInfo.setExecutableChannel(BrowserReleaseChannel.CANARY);
        mSEdgeBrowserInfo.findExecutable();
        try {
            mSEdgeBrowserInfo.setupDriver();
        }
        catch (IOException iOException) {
            if (MSEdgeBrowserInfo.y.level >= 3) {
                ((LevelAwareLogBuilder)y.lvlBuild(3, "main(String[])", 438).add("e", (Object)iOException)).log();
            }
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        System.out.println(mSEdgeBrowserInfo.asJsonValue());
    }

    @Override
    public boolean supportsConnectionMode(ConnectionMode connectionMode) {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            ((LevelAwareLogBuilder)y.lvlBuild(7, "supportsConnectionMode(ConnectionMode)", 449).addDetail("connectionMode", (Object)connectionMode)).log();
        }
        return connectionMode != ConnectionMode.QFDRIVER;
    }

    @Override
    public String getBrowserName() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getBrowserName()", 68).log();
        }
        return this.r;
    }

    @Override
    public String getSimpleBrowserName() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getSimpleBrowserName()", 69).log();
        }
        return this.s;
    }

    @Override
    public List getBinaryNames() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getBinaryNames()", 70).log();
        }
        return this.t;
    }

    @Override
    public List getWindowsProgramFilesSubdirs() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getWindowsProgramFilesSubdirs()", 73).log();
        }
        return this.u;
    }

    @Override
    public String getDriverProperty() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getDriverProperty()", 81).log();
        }
        return this.v;
    }

    @Override
    public String getDriverExecutableName() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getDriverExecutableName()", 82).log();
        }
        return this.w;
    }

    @Override
    public String getDriverDownloadHomepage() {
        if (MSEdgeBrowserInfo.y.level >= 7) {
            y.lvlBuild(7, "getDriverDownloadHomepage()", 83).log();
        }
        return this.x;
    }

    protected static class a
    implements ChromeBrowserInfo.b {
        static final String a = "https://www.qftest.com/fileadmin/Webdata/pub/qftest/msedgedriver.json";
        @Nullable
        final TreeMap b;

        public a() throws IOException {
            if (y.level >= 7) {
                y.lvlBuild(7, "JsonBasedMSEdgeDriverDownloader.JsonBasedMSEdgeDriverDownloader()", 280).log();
            }
            this.b = new TreeMap();
            this.a();
        }

        protected void a() throws MalformedURLException, IOException {
            String string;
            block21: {
                if (y.level >= 7) {
                    y.lvlBuild(7, "JsonBasedMSEdgeDriverDownloader.init()", 289).log();
                }
                string = null;
                try {
                    string = ((Environment)Globals.getGlobalValue("env", "MSEdgeDriverUrl")).getEnv("MSEdgeDriverUrl");
                    if (y.level >= 9) {
                        ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.init()", 294).add("baseUrl", string)).log();
                    }
                }
                catch (Throwable throwable) {
                    if (y.level < 9) break block21;
                    ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.init()", 296).add("t", (Object)throwable)).log();
                }
            }
            if (Misc.emptyOrNull((String)string)) {
                string = a;
            }
            URL uRL = new URL(string);
            int n2 = Options.cached_OPT_PLAY_TIMEOUT_DEADLOCK * 1000;
            try (InputStreamReader inputStreamReader = new InputStreamReader(this.a(uRL, n2 / 4, n2 / 4));){
                try {
                    JsonObject jsonObject = Json.parse((Reader)inputStreamReader).asObject();
                    if (y.level >= 9) {
                        ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.init()", 309).add("edgeDriverInfo", (Object)jsonObject)).log();
                    }
                    jsonObject.forEach(member -> this.b.put(VersionNumber.fromString((String)member.getName()), member.getValue()));
                    if (y.level >= 9) {
                        ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.init()", 312).add("driverDownloadInfo", (Object)this.b)).log();
                    }
                }
                catch (Exception exception) {
                    throw new IOException("Parsing Exception", exception);
                }
            }
        }

        @Override
        public VersionNumber a(VersionNumber versionNumber) {
            if (y.level >= 7) {
                ((LevelAwareLogBuilder)y.lvlBuild(7, "JsonBasedMSEdgeDriverDownloader.getBestMatchingVersion(VersionNumber)", 323).addDetail("targetVersion", (Object)versionNumber)).log();
            }
            if (versionNumber == null) {
                throw new IllegalArgumentException("targetVersion is marked non-null but is null");
            }
            int n2 = versionNumber.getSignificantDigits();
            String string = MSEdgeBrowserInfo.f();
            if (y.level >= 9) {
                ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.getBestMatchingVersion(VersionNumber)", 330).add("osSuffix", string)).log();
            }
            Iterator iterator = this.b.navigableKeySet().descendingIterator();
            while (iterator.hasNext()) {
                VersionNumber versionNumber2 = (VersionNumber)iterator.next();
                int n3 = versionNumber.compareTo(versionNumber2, n2);
                JsonValue jsonValue = (JsonValue)this.b.get(versionNumber2);
                if (y.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.getBestMatchingVersion(VersionNumber)", 337).add("versionNumber", (Object)versionNumber2)).add("comparsion", n3)).add("driversForVersion", (Object)jsonValue)).log();
                }
                if (n3 == 0) {
                    return versionNumber2;
                }
                if (n3 <= 0 || jsonValue.isObject() && jsonValue.asObject().getString(string, null) == null) continue;
                return versionNumber2;
            }
            return null;
        }

        @Override
        public URL b(@Nullable VersionNumber versionNumber) throws IOException {
            if (y.level >= 7) {
                ((LevelAwareLogBuilder)y.lvlBuild(7, "JsonBasedMSEdgeDriverDownloader.getURLForVersion(VersionNumber)", 354).addDetail("version", (Object)versionNumber)).log();
            }
            if (versionNumber == null) {
                return null;
            }
            JsonValue jsonValue = (JsonValue)this.b.get(versionNumber);
            if (y.level >= 9) {
                ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.getURLForVersion(VersionNumber)", 359).add("driversForVersion", (Object)jsonValue)).log();
            }
            if (jsonValue == null) {
                return null;
            }
            String string = MSEdgeBrowserInfo.f();
            if (y.level >= 9) {
                ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.getURLForVersion(VersionNumber)", 364).add("osSuffix", string)).log();
            }
            String string2 = null;
            string2 = jsonValue.isString() ? jsonValue.asString() : jsonValue.asObject().getString(string, null);
            if (y.level >= 9) {
                ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.getURLForVersion(VersionNumber)", 372).add("urlString", string2)).log();
            }
            if (string2 == null) {
                string2 = jsonValue.asObject().getString("default", null);
                if (y.level >= 9) {
                    ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.getURLForVersion(VersionNumber)", 375).add("urlString", string2)).log();
                }
            }
            if (string2 != null) {
                if (string2.startsWith("http")) {
                    try {
                        return new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (y.level >= 3) {
                            ((LevelAwareLogBuilder)y.lvlBuild(3, "JsonBasedMSEdgeDriverDownloader.getURLForVersion(VersionNumber)", 382).add("e", (Object)malformedURLException)).log();
                        }
                    }
                } else {
                    throw new IOException(string2);
                }
            }
            return null;
        }

        @Override
        public void a(WebBrowserInfo webBrowserInfo, VersionNumber versionNumber, File file, String string) throws IOException {
            if (y.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)y.lvlBuild(7, "JsonBasedMSEdgeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 395).addDetail("info", (Object)webBrowserInfo)).addDetail("version", (Object)versionNumber)).addDetail("targetDir", (Object)file)).addDetail("driverFileName", string)).log();
            }
            URL uRL = this.b(versionNumber);
            if (y.level >= 9) {
                ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 399).add("url", (Object)uRL)).log();
            }
            if (uRL == null) {
                throw new IOException("Could not get driver download url for version " + versionNumber);
            }
            file = MSEdgeBrowserInfo.f(file);
            if (y.level >= 9) {
                ((LevelAwareLogBuilder)y.lvlBuild(9, "JsonBasedMSEdgeDriverDownloader.downloadVersionToDir(WebBrowserInfo,VersionNumber,File,String)", 406).add("targetDir", (Object)file)).log();
            }
            ChromeBrowserInfo.a.a(webBrowserInfo, file, string, uRL, this.b(uRL), false);
        }

        @Nullable
        public TreeMap b() {
            if (y.level >= 7) {
                y.lvlBuild(7, "JsonBasedMSEdgeDriverDownloader.getDriverDownloadInfo()", 275).log();
            }
            return this.b;
        }
    }

    protected static class b
    extends ChromeBrowserInfo.a {
        static final String j = "https://msedgewebdriverstorage.blob.core.windows.net/edgewebdriver";
        static final String k = "https://msedgewebdriverstorage.blob.core.windows.net/edgewebdriver?restype=container&comp=list";
        static final String l = "%s/edgedriver_%s%s.zip";

        public b() throws IOException {
            if (y.level >= 7) {
                y.lvlBuild(7, "XmlBasedMSEdgeDriverDownloader.XmlBasedMSEdgeDriverDownloader()", 206).log();
            }
        }

        @Override
        protected String a() {
            if (y.level >= 7) {
                y.lvlBuild(7, "XmlBasedMSEdgeDriverDownloader.getKeyName()", 215).log();
            }
            return "Name";
        }

        @Override
        protected URL b() throws MalformedURLException {
            if (y.level >= 7) {
                y.lvlBuild(7, "XmlBasedMSEdgeDriverDownloader.getIndexXmlUrl()", 224).log();
            }
            return new URL(k);
        }

        @Override
        protected String a(VersionNumber versionNumber, String string, String string2) {
            if (y.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)y.lvlBuild(7, "XmlBasedMSEdgeDriverDownloader.getFilename(VersionNumber,String,String)", 233).addDetail("version", (Object)versionNumber)).addDetail("osString", string)).addDetail("suffix", string2)).log();
            }
            return String.format(l, versionNumber.toString(), string, string2);
        }

        @Override
        protected String a(String string) {
            if (y.level >= 7) {
                ((LevelAwareLogBuilder)y.lvlBuild(7, "XmlBasedMSEdgeDriverDownloader.getUrlForFilename(String)", 242).addDetail("filename", string)).log();
            }
            return "https://msedgewebdriverstorage.blob.core.windows.net/edgewebdriver/" + string;
        }
    }
}

