/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import junitx.framework.Assert;
import junitx.framework.AssertionFailedError;

public class FileAssert {
    private FileAssert() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertEquals(String message, File expected, File actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Assert.assertTrue((String)("File does not exist [" + expected.getAbsolutePath() + "]"), (boolean)expected.exists());
        Assert.assertTrue((String)("File does not exist [" + actual.getAbsolutePath() + "]"), (boolean)actual.exists());
        Assert.assertTrue((String)"Expected file not readable", (boolean)expected.canRead());
        Assert.assertTrue((String)"Actual file not readable", (boolean)actual.canRead());
        FileInputStream eis = null;
        FileInputStream ais = null;
        try {
            try {
                eis = new FileInputStream(expected);
                ais = new FileInputStream(actual);
                BufferedReader expData = new BufferedReader(new InputStreamReader(eis));
                BufferedReader actData = new BufferedReader(new InputStreamReader(ais));
                Assert.assertNotNull((String)message, (Object)expData);
                Assert.assertNotNull((String)message, (Object)actData);
                FileAssert.assertEquals(message, expData, actData);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                eis.close();
                ais.close();
                throw throwable;
            }
            eis.close();
            ais.close();
            {
            }
        }
        catch (IOException e) {
            throw new AssertionFailedError(e);
        }
    }

    public static void assertEquals(File expected, File actual) {
        FileAssert.assertEquals(null, expected, actual);
    }

    protected static void assertEquals(String message, Reader expected, Reader actual) {
        Assert.assertNotNull((String)message, (Object)expected);
        Assert.assertNotNull((String)message, (Object)actual);
        LineNumberReader expReader = new LineNumberReader(expected);
        LineNumberReader actReader = new LineNumberReader(actual);
        Assert.assertNotNull((String)message, (Object)expReader);
        Assert.assertNotNull((String)message, (Object)actReader);
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        try {
            while (true) {
                if (!expReader.ready() && !actReader.ready()) {
                    return;
                }
                String expLine = expReader.readLine();
                String actLine = actReader.readLine();
                if (expLine == null && actLine == null) {
                    return;
                }
                int line = expReader.getLineNumber() + 1;
                if (expReader.ready()) {
                    if (actReader.ready()) {
                        Assert.assertEquals(formatted + "Line [" + line + "]", expLine, actLine);
                        continue;
                    }
                    Assert.fail((String)(formatted + "Line [" + line + "] expected <" + expLine + "> but was <EOF>"));
                    continue;
                }
                if (actReader.ready()) {
                    Assert.fail((String)(formatted + "Line [" + line + "] expected <EOF> but was <" + actLine + ">"));
                    continue;
                }
                Assert.assertEquals(formatted + "Line [" + line + "]", expLine, actLine);
            }
        }
        catch (IOException e) {
            throw new AssertionFailedError(e);
        }
    }

    public static void assertBinaryEquals(File expected, File actual) {
        FileAssert.assertBinaryEquals(null, expected, actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void assertBinaryEquals(String message, File expected, File actual) {
        Assert.assertNotNull((String)message, (Object)expected);
        Assert.assertNotNull((String)message, (Object)actual);
        Assert.assertTrue((String)("File does not exist [" + expected.getAbsolutePath() + "]"), (boolean)expected.exists());
        Assert.assertTrue((String)("File does not exist [" + actual.getAbsolutePath() + "]"), (boolean)actual.exists());
        Assert.assertTrue((String)"Expected file not readable", (boolean)expected.canRead());
        Assert.assertTrue((String)"Actual file not readable", (boolean)actual.canRead());
        FileInputStream eis = null;
        FileInputStream ais = null;
        try {
            block12: {
                block11: {
                    try {
                        eis = new FileInputStream(expected);
                        ais = new FileInputStream(actual);
                        Assert.assertNotNull((String)message, (Object)expected);
                        Assert.assertNotNull((String)message, (Object)actual);
                        byte[] expBuff = new byte[8192];
                        byte[] actBuff = new byte[8192];
                        long pos = 0L;
                        int expLength = eis.read(expBuff, 0, 8192);
                        int actLength = ais.read(actBuff, 0, 8192);
                        if (expLength < actLength) {
                            Assert.fail((String)"actual file is longer");
                        }
                        if (expLength > actLength) {
                            Assert.fail((String)"actual file is shorter");
                        }
                        if (expLength == 0) {
                            Object var14_11 = null;
                            break block11;
                        }
                        int i2 = 0;
                        while (true) {
                            if (i2 >= expBuff.length) {
                                pos += (long)expBuff.length;
                                break block12;
                            }
                            if (expBuff[i2] != actBuff[i2]) {
                                String formatted = "";
                                if (message != null) {
                                    formatted = message + " ";
                                }
                                Assert.fail((String)(formatted + "files differ at byte " + (pos + (long)i2 + 1L)));
                            }
                            ++i2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_13 = null;
                        eis.close();
                        ais.close();
                        throw throwable;
                    }
                }
                eis.close();
                ais.close();
                return;
            }
            Object var14_12 = null;
            eis.close();
            ais.close();
            return;
        }
        catch (IOException e) {
            throw new AssertionFailedError(e);
        }
    }
}

