/*
 * Decompiled with CFR 0.152.
 */
package junitx.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

class TestSuite
implements Test {
    protected List fTests = new Vector(10);
    private String fName;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$java$lang$String;

    public TestSuite() {
    }

    public TestSuite(Class theClass) {
        this.fName = theClass.getName();
        Constructor constructor = null;
        try {
            constructor = this.getConstructor(theClass);
        }
        catch (NoSuchMethodException e) {
            this.addTest(this.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name)"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(this.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        while ((class$junit$framework$Test == null ? TestSuite.class$("junit.framework.Test") : class$junit$framework$Test).isAssignableFrom(superClass)) {
            Method[] methods = superClass.getDeclaredMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                this.addTestMethod(methods[i2], names, constructor);
                ++i2;
            }
            superClass = superClass.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(this.warning("No tests found in " + theClass.getName()));
        }
    }

    public TestSuite(String name) {
        this.fName = name;
    }

    public void addTest(Test test) {
        this.fTests.add(test);
    }

    public void addTestSuite(Class testClass) {
        this.addTest(new TestSuite(testClass));
    }

    private void addTestMethod(Method m, List names, Constructor constructor) {
        String name = m.getName();
        if (names.contains(name)) {
            return;
        }
        if (this.isPublicTestMethod(m)) {
            names.add(name);
            Object[] args = new Object[]{name};
            try {
                this.addTest((Test)constructor.newInstance(args));
            }
            catch (InstantiationException e) {
                this.addTest(this.warning("Cannot instantiate test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
            catch (InvocationTargetException e) {
                this.addTest(this.warning("Exception in constructor: " + name + " (" + this.exceptionToString(e.getTargetException()) + ")"));
            }
            catch (IllegalAccessException e) {
                this.addTest(this.warning("Cannot access test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
        } else if (this.isTestMethod(m)) {
            this.addTest(this.warning("Test method isn't public: " + m.getName()));
        }
    }

    private String exceptionToString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Test test = (Test)e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    private Constructor getConstructor(Class theClass) throws NoSuchMethodException {
        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TestSuite.class$("java.lang.String")) : class$java$lang$String};
        return theClass.getConstructor(args);
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    public void run(TestResult result) {
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            if (result.shouldStop()) break;
            Test test = (Test)e.nextElement();
            this.runTest(test, result);
        }
    }

    public void runTest(Test test, TestResult result) {
        test.run(result);
    }

    public Test testAt(int index) {
        return (Test)this.fTests.get(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return new Vector(this.fTests).elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    private Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                Assert.fail((String)message);
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

