/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.AnnotationBasedArgumentsProvider;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsUtils;
import org.junit.jupiter.params.provider.FieldSource;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class FieldArgumentsProvider
extends AnnotationBasedArgumentsProvider<FieldSource> {
    FieldArgumentsProvider() {
    }

    @Override
    protected Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context, FieldSource fieldSource) {
        Class<?> testClass = context.getRequiredTestClass();
        Object testInstance = context.getTestInstance().orElse(null);
        String[] fieldNames = fieldSource.value();
        if (fieldNames.length == 0) {
            Optional<Method> testMethod = context.getTestMethod();
            Preconditions.condition(testMethod.isPresent(), "You must specify a field name when using @FieldSource with @ParameterizedClass");
            fieldNames = new String[]{testMethod.get().getName()};
        }
        return Arrays.stream(fieldNames).map(fieldName -> FieldArgumentsProvider.findField(testClass, fieldName)).map(field -> FieldArgumentsProvider.validateField(field, testInstance)).map(field -> FieldArgumentsProvider.readField(field, testInstance)).flatMap(fieldValue -> {
            if (fieldValue instanceof Supplier) {
                fieldValue = ((Supplier)fieldValue).get();
            }
            return CollectionUtils.toStream(fieldValue);
        }).map(ArgumentsUtils::toArguments);
    }

    static Field findField(Class<?> testClass, String fieldName) {
        Preconditions.notBlank(fieldName, "Field name must not be blank");
        fieldName = fieldName.trim();
        Class<?> clazz = testClass;
        if (fieldName.contains("#") || fieldName.contains(".")) {
            String[] fieldParts = ReflectionUtils.parseFullyQualifiedFieldName(fieldName);
            String className = fieldParts[0];
            fieldName = fieldParts[1];
            ClassLoader classLoader = ClassLoaderUtils.getClassLoader(testClass);
            clazz = ReflectionUtils.loadRequiredClass(className, classLoader);
        }
        Class<?> resolvedClass = clazz;
        String resolvedFieldName = fieldName;
        Predicate<Field> nameMatches = field -> field.getName().equals(resolvedFieldName);
        Field field2 = ReflectionUtils.streamFields(resolvedClass, nameMatches, ReflectionUtils.HierarchyTraversalMode.BOTTOM_UP).findFirst().orElse(null);
        Preconditions.notNull(field2, () -> String.format("Could not find field named [%s] in class [%s]", resolvedFieldName, resolvedClass.getName()));
        return field2;
    }

    private static Field validateField(Field field, Object testInstance) {
        Preconditions.condition(field.getDeclaringClass().isInstance(testInstance) || ModifierSupport.isStatic(field), () -> String.format("Field '%s' must be static: local @FieldSource fields must be static unless the PER_CLASS @TestInstance lifecycle mode is used; external @FieldSource fields must always be static.", field.toGenericString()));
        return field;
    }

    private static Object readField(Field field, Object testInstance) {
        Object value = ReflectionSupport.tryToReadFieldValue(field, testInstance).getOrThrow(cause -> new JUnitException(String.format("Could not read field [%s]", field.getName()), (Throwable)cause));
        String fieldName = field.getName();
        String declaringClass = field.getDeclaringClass().getName();
        Preconditions.notNull(value, () -> String.format("The value of field [%s] in class [%s] must not be null", fieldName, declaringClass));
        Preconditions.condition(!(value instanceof BaseStream), () -> String.format("The value of field [%s] in class [%s] must not be a stream", fieldName, declaringClass));
        Preconditions.condition(!(value instanceof Iterator), () -> String.format("The value of field [%s] in class [%s] must not be an Iterator", fieldName, declaringClass));
        Preconditions.condition(FieldArgumentsProvider.isConvertibleToStream(field, value), () -> String.format("The value of field [%s] in class [%s] must be convertible to a Stream", fieldName, declaringClass));
        return value;
    }

    private static boolean isConvertibleToStream(Field field, Object value) {
        ParameterizedType parameterizedType;
        Type[] typeArguments;
        Type genericType;
        if (CollectionUtils.isConvertibleToStream(value.getClass())) {
            return true;
        }
        if (Supplier.class.isAssignableFrom(field.getType()) && (genericType = field.getGenericType()) instanceof ParameterizedType && (typeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            Type rawType;
            Type type = typeArguments[0];
            if (type instanceof Class) {
                Class clazz = (Class)type;
                return CollectionUtils.isConvertibleToStream(clazz);
            }
            if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
                Class clazz = (Class)rawType;
                return CollectionUtils.isConvertibleToStream(clazz);
            }
        }
        return false;
    }
}

