/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.commons.io.ResourceFilter;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.scanning.ClassFilter;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.1")
public class ModuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(ModuleUtils.class);

    public static Set<String> findAllNonSystemBootModuleNames() {
        logger.config(() -> "Basic version of findAllNonSystemBootModuleNames() always returns an empty set!");
        return Collections.emptySet();
    }

    public static boolean isJavaPlatformModuleSystemAvailable() {
        return false;
    }

    public static Optional<String> getModuleName(Class<?> type) {
        return Optional.empty();
    }

    public static Optional<String> getModuleVersion(Class<?> type) {
        return Optional.empty();
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, ClassFilter filter) {
        Preconditions.notBlank(moduleName, "Module name must not be null or empty");
        Preconditions.notNull(filter, "Class filter must not be null");
        logger.config(() -> "Basic version of findAllClassesInModule() always returns an empty list!");
        return Collections.emptyList();
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static List<Resource> findAllResourcesInModule(String moduleName, ResourceFilter filter) {
        Preconditions.notBlank(moduleName, "Module name must not be null or empty");
        Preconditions.notNull(filter, "Resource filter must not be null");
        logger.config(() -> "Basic version of findAllResourcesInModule() always returns an empty list!");
        return Collections.emptyList();
    }
}

