/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.classification;

import dev.langchain4j.classification.ClassificationResult;
import dev.langchain4j.classification.ScoredLabel;
import dev.langchain4j.classification.TextClassifier;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.store.embedding.CosineSimilarity;
import dev.langchain4j.store.embedding.RelevanceScore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class EmbeddingModelTextClassifier<L>
implements TextClassifier<L> {
    private final EmbeddingModel embeddingModel;
    private final Map<L, List<Embedding>> exampleEmbeddingsByLabel;
    private final int maxResults;
    private final double minScore;
    private final double meanToMaxScoreRatio;

    public EmbeddingModelTextClassifier(EmbeddingModel embeddingModel, Map<L, ? extends Collection<String>> examplesByLabel) {
        this(embeddingModel, examplesByLabel, 1, 0.0, 0.5);
    }

    public EmbeddingModelTextClassifier(EmbeddingModel embeddingModel, Map<L, ? extends Collection<String>> examplesByLabel, int maxResults, double minScore, double meanToMaxScoreRatio) {
        this.embeddingModel = ValidationUtils.ensureNotNull(embeddingModel, "embeddingModel");
        ValidationUtils.ensureNotNull(examplesByLabel, "examplesByLabel");
        this.exampleEmbeddingsByLabel = new HashMap<L, List<Embedding>>();
        examplesByLabel.forEach((label, examples) -> this.exampleEmbeddingsByLabel.put(label, embeddingModel.embedAll(examples.stream().map(TextSegment::from).collect(Collectors.toList())).content()));
        this.maxResults = ValidationUtils.ensureGreaterThanZero(maxResults, "maxResults");
        this.minScore = ValidationUtils.ensureBetween(minScore, 0.0, 1.0, "minScore");
        this.meanToMaxScoreRatio = ValidationUtils.ensureBetween(meanToMaxScoreRatio, 0.0, 1.0, "meanToMaxScoreRatio");
    }

    @Override
    public ClassificationResult<L> classifyWithScores(String text) {
        Embedding textEmbedding = this.embeddingModel.embed(text).content();
        ArrayList scoredLabels = new ArrayList();
        this.exampleEmbeddingsByLabel.forEach((label, exampleEmbeddings) -> {
            double meanScore = 0.0;
            double maxScore = 0.0;
            for (Embedding exampleEmbedding : exampleEmbeddings) {
                double cosineSimilarity = CosineSimilarity.between(textEmbedding, exampleEmbedding);
                double score = RelevanceScore.fromCosineSimilarity(cosineSimilarity);
                meanScore += score;
                maxScore = Math.max(score, maxScore);
            }
            double aggregateScore = this.aggregatedScore(meanScore /= (double)exampleEmbeddings.size(), maxScore);
            if (aggregateScore >= this.minScore) {
                scoredLabels.add(new ScoredLabel<Object>(label, aggregateScore));
            }
        });
        return new ClassificationResult(scoredLabels.stream().sorted(Comparator.comparingDouble(classificationResult -> 1.0 - classificationResult.score())).limit(this.maxResults).collect(Collectors.toList()));
    }

    private double aggregatedScore(double meanScore, double maxScore) {
        return this.meanToMaxScoreRatio * meanScore + (1.0 - this.meanToMaxScoreRatio) * maxScore;
    }
}

