/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal;

import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.model.openai.internal.ErrorHandling;
import dev.langchain4j.model.openai.internal.Json;
import dev.langchain4j.model.openai.internal.ParsedAndRawResponse;
import dev.langchain4j.model.openai.internal.ResponseHandle;
import dev.langchain4j.model.openai.internal.StreamingCompletionHandling;
import dev.langchain4j.model.openai.internal.StreamingResponseHandling;
import java.util.function.Consumer;

class StreamingRequestExecutor<Response> {
    private final HttpClient httpClient;
    private final HttpRequest streamingHttpRequest;
    private final Class<Response> responseClass;

    StreamingRequestExecutor(HttpClient httpClient, HttpRequest streamingHttpRequest, Class<Response> responseClass) {
        this.httpClient = httpClient;
        this.streamingHttpRequest = streamingHttpRequest;
        this.responseClass = responseClass;
    }

    StreamingResponseHandling onPartialResponse(final Consumer<ParsedAndRawResponse<Response>> partialResponseHandler) {
        return new StreamingResponseHandling(){

            @Override
            public StreamingCompletionHandling onComplete(final Runnable streamingCompletionCallback) {
                return new StreamingCompletionHandling(){

                    @Override
                    public ErrorHandling onError(final Consumer<Throwable> errorHandler) {
                        return new ErrorHandling(){

                            @Override
                            public ResponseHandle execute() {
                                return StreamingRequestExecutor.this.stream(partialResponseHandler, streamingCompletionCallback, errorHandler);
                            }
                        };
                    }

                    @Override
                    public ErrorHandling ignoreErrors() {
                        return new ErrorHandling(){

                            @Override
                            public ResponseHandle execute() {
                                return StreamingRequestExecutor.this.stream(partialResponseHandler, streamingCompletionCallback, e -> {});
                            }
                        };
                    }
                };
            }

            @Override
            public ErrorHandling onError(final Consumer<Throwable> errorHandler) {
                return new ErrorHandling(){

                    @Override
                    public ResponseHandle execute() {
                        return StreamingRequestExecutor.this.stream(partialResponseHandler, () -> {}, errorHandler);
                    }
                };
            }

            @Override
            public ErrorHandling ignoreErrors() {
                return new ErrorHandling(){

                    @Override
                    public ResponseHandle execute() {
                        return StreamingRequestExecutor.this.stream(partialResponseHandler, () -> {}, e -> {});
                    }
                };
            }
        };
    }

    private ResponseHandle stream(final Consumer<ParsedAndRawResponse<Response>> partialResponseHandler, final Runnable streamingCompletionCallback, final Consumer<Throwable> errorHandler) {
        ServerSentEventListener listener = new ServerSentEventListener(){

            @Override
            public void onEvent(ServerSentEvent event) {
                if ("[DONE]".equals(event.data())) {
                    return;
                }
                try {
                    if ("error".equals(event.event())) {
                        errorHandler.accept(new RuntimeException(event.data()));
                        return;
                    }
                    Object response = Json.fromJson(event.data(), StreamingRequestExecutor.this.responseClass);
                    if (response != null) {
                        partialResponseHandler.accept(new ParsedAndRawResponse(response, event));
                    }
                }
                catch (Exception e) {
                    errorHandler.accept(e);
                }
            }

            @Override
            public void onClose() {
                streamingCompletionCallback.run();
            }

            @Override
            public void onError(Throwable t) {
                errorHandler.accept(t);
            }
        };
        this.httpClient.execute(this.streamingHttpRequest, listener);
        return new ResponseHandle();
    }
}

