/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.guardrail;

import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.guardrail.InputGuardrail;
import dev.langchain4j.guardrail.InputGuardrailRequest;
import dev.langchain4j.guardrail.InputGuardrailResult;
import dev.langchain4j.guardrail.OutputGuardrail;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import dev.langchain4j.guardrail.config.InputGuardrailsConfig;
import dev.langchain4j.guardrail.config.OutputGuardrailsConfig;
import dev.langchain4j.service.guardrail.GuardrailServiceBuilder;
import dev.langchain4j.service.guardrail.spi.GuardrailServiceBuilderFactory;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

public interface GuardrailService {
    public Class<?> aiServiceClass();

    public <MethodKey> InputGuardrailResult executeInputGuardrails(MethodKey var1, InputGuardrailRequest var2);

    default public <MethodKey> UserMessage executeGuardrails(MethodKey method, InputGuardrailRequest params) {
        return this.executeInputGuardrails(method, params).userMessage(params);
    }

    public <MethodKey> OutputGuardrailResult executeOutputGuardrails(MethodKey var1, OutputGuardrailRequest var2);

    public <MethodKey> boolean hasInputGuardrails(MethodKey var1);

    public <MethodKey> boolean hasOutputGuardrails(MethodKey var1);

    default public <MethodKey, T> T executeGuardrails(MethodKey method, OutputGuardrailRequest params) {
        return this.executeOutputGuardrails(method, params).response(params);
    }

    public static Builder builder(Class<?> aiServiceClass) {
        return ServiceLoader.load(GuardrailServiceBuilderFactory.class).findFirst().map(builderFactory -> builderFactory.getBuilder(aiServiceClass)).orElseGet(() -> new GuardrailServiceBuilder(aiServiceClass));
    }

    public static interface Builder {
        public Builder inputGuardrailsConfig(InputGuardrailsConfig var1);

        public Builder outputGuardrailsConfig(OutputGuardrailsConfig var1);

        public <I extends InputGuardrail> Builder inputGuardrailClasses(List<Class<? extends I>> var1);

        default public <I extends InputGuardrail> Builder inputGuardrailClasses(Class<? extends I> ... guardrailClasses) {
            return Optional.ofNullable(guardrailClasses).map(g -> this.inputGuardrailClasses(List.of(g))).orElse(this);
        }

        public <O extends OutputGuardrail> Builder outputGuardrailClasses(List<Class<? extends O>> var1);

        default public <O extends OutputGuardrail> Builder outputGuardrailClasses(Class<? extends O> ... guardrailClasses) {
            return Optional.ofNullable(guardrailClasses).map(g -> this.outputGuardrailClasses(List.of(g))).orElse(this);
        }

        public <I extends InputGuardrail> Builder inputGuardrails(List<I> var1);

        default public <I extends InputGuardrail> Builder inputGuardrails(I ... guardrails) {
            return Optional.ofNullable(guardrails).map(ig -> this.inputGuardrails(List.of(ig))).orElse(this);
        }

        public <O extends OutputGuardrail> Builder outputGuardrails(List<O> var1);

        default public <O extends OutputGuardrail> Builder outputGuardrails(O ... guardrails) {
            return Optional.ofNullable(guardrails).map(og -> this.outputGuardrails(List.of(og))).orElse(this);
        }

        public GuardrailService build();
    }
}

