/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    RGB[] rgbs;

    public ColorDialog(Shell shell) {
        this(shell, 65536);
    }

    public ColorDialog(Shell shell, int n) {
        super(shell, ColorDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB[] getRGBs() {
        return this.rgbs;
    }

    public RGB open() {
        boolean bl;
        byte[] byArray = Converter.wcsToMbcs((String)this.title, (boolean)true);
        long l = GTK.gtk_color_chooser_dialog_new((byte[])byArray, (long)this.parent.topHandle());
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        GdkRGBA gdkRGBA = new GdkRGBA();
        if (this.rgb != null) {
            gdkRGBA.red = (double)this.rgb.red / 255.0;
            gdkRGBA.green = (double)this.rgb.green / 255.0;
            gdkRGBA.blue = (double)this.rgb.blue / 255.0;
            gdkRGBA.alpha = 1.0;
        }
        GTK.gtk_color_chooser_set_rgba((long)l, (GdkRGBA)gdkRGBA);
        display.runDialogShownHooks(this, l);
        if (this.rgbs != null) {
            int n = 9;
            long l2 = OS.g_malloc(GdkRGBA.sizeof * this.rgbs.length);
            gdkRGBA = new GdkRGBA();
            for (int i = 0; i < this.rgbs.length; ++i) {
                RGB rGB = this.rgbs[i];
                if (rGB == null) continue;
                gdkRGBA.red = (double)rGB.red / 255.0;
                gdkRGBA.green = (double)rGB.green / 255.0;
                gdkRGBA.blue = (double)rGB.blue / 255.0;
                OS.memmove(l2 + (long)(i * GdkRGBA.sizeof), gdkRGBA, (long)GdkRGBA.sizeof);
            }
            GTK.gtk_color_chooser_add_palette((long)l, (int)0, (int)n, (int)this.rgbs.length, (long)l2);
            GTK.gtk_color_chooser_set_rgba((long)l, (GdkRGBA)gdkRGBA);
            if (GTK.gtk_color_chooser_get_use_alpha((long)l)) {
                GTK.gtk_color_chooser_set_use_alpha((long)l, (boolean)false);
            }
            OS.g_free(l2);
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (GTK.gtk_window_get_modal((long)l)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        int n = 0;
        long l3 = 0L;
        if ((this.style & 0x4000000) != 0) {
            n = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            l3 = OS.g_signal_add_emission_hook(n, 0, display.emissionProc, l, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int n2 = GTK.gtk_dialog_run((long)l);
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n, l3);
        }
        if (GTK.gtk_window_get_modal((long)l)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n2 == -5;
        if (bl) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            gdkRGBA = new GdkRGBA();
            GTK.gtk_color_chooser_get_rgba((long)l, (GdkRGBA)gdkRGBA);
            n3 = (int)(gdkRGBA.red * 255.0);
            n4 = (int)(gdkRGBA.green * 255.0);
            n5 = (int)(gdkRGBA.blue * 255.0);
            this.rgb = new RGB(n3, n4, n5);
        }
        this.rgb = (RGB)display.runDialogClosedHooks(this, bl ? this.rgb : null);
        if (this.rgb != null) {
            bl = true;
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy((long)l);
        if (!bl) {
            return null;
        }
        return this.rgb;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    public void setRGBs(RGB[] rGBArray) {
        this.rgbs = rGBArray;
    }

    static String[] splitString(String string, char c) {
        String[] stringArray = new String[1];
        int n = 0;
        int n2 = 0;
        while (n2 != -1) {
            n2 = string.indexOf(c, n);
            if (n2 == -1) {
                stringArray[stringArray.length - 1] = string.substring(n);
                continue;
            }
            stringArray[stringArray.length - 1] = string.substring(n, n2);
            n = n2 + 1;
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return stringArray;
    }
}

