/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.SwtCallable;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DefaultExceptionHandler;
import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.GDBus;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.SessionManagerDBus;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GdkKeymapKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventButton;
import org.eclipse.swt.internal.gtk3.GdkEventKey;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device
implements Executor {
    private static final Logger logger;
    static final Object classLock;
    static IDisplayCreationHook[] creationHooks;
    private IDialogHook[] dialogHooks;
    private IDNDHook[] dndHooks;
    IGdkEventFilter[] gdkEventFilters;
    IdleProc[] idleProcs;
    long[] charOverride = new long[32000];
    int charOverrideHead = 0;
    int charOverrideTail = 0;
    boolean extraDeferred;
    static boolean strictChecks;
    private static final int SLOT_IN_USE = -2;
    private static final int LAST_TABLE_INDEX = -1;
    int gdkEventCount;
    long[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    long fds;
    int allocated_nfds;
    boolean wake;
    boolean windowSizeSet;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    long eventProc;
    long windowProc2;
    long windowProc3;
    long windowProc4;
    long windowProc5;
    long windowProc6;
    long changeValueProc;
    long snapshotDrawProc;
    long keyPressReleaseProc;
    long focusProc;
    long windowActiveProc;
    long enterMotionProc;
    long leaveProc;
    long scrollProc;
    long resizeProc;
    long activateProc;
    long gesturePressReleaseProc;
    long notifyProc;
    long computeSizeProc;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    Callback windowCallback6;
    Callback changeValue;
    Callback snapshotDraw;
    Callback keyPressReleaseCallback;
    Callback focusCallback;
    Callback windowActiveCallback;
    Callback enterMotionCallback;
    Callback computeSizeCallback;
    Callback scrollCallback;
    Callback leaveCallback;
    Callback resizeCallback;
    Callback activateCallback;
    Callback gesturePressReleaseCallback;
    Callback notifyCallback;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME;
    static String APP_VERSION;
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String EXTERNAL_EVENT_LOOP_KEY = "org.eclipse.swt.internal.gtk.externalEventLoop";
    long[] closures;
    long[] closuresProc;
    int[] closuresCount;
    int[] signalIds;
    long shellMapProcClosure;
    boolean externalEventLoop;
    int[] indexTable;
    int freeSlot;
    long lastHandle;
    Widget lastWidget;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final int SWT_OBJECT_INDEX1;
    static final int SWT_OBJECT_INDEX2;
    Shell[] modalShells;
    Dialog modalDialog;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    int focusEvent;
    Control focusControl;
    Shell activeShell;
    boolean activePending;
    boolean ignoreActivate;
    boolean ignoreFocus;
    Tracker tracker;
    Control imControl;
    long preeditWindow;
    long preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Consumer<RuntimeException> runtimeExceptionHandler = DefaultExceptionHandler.RUNTIME_EXCEPTION_HANDLER;
    Consumer<Error> errorHandler = DefaultExceptionHandler.RUNTIME_ERROR_HANDLER;
    Thread thread;
    SessionManagerDBus sessionManagerDBus;
    SessionManagerListener sessionManagerListener;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    TrayItem currentTrayItem;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    long timerProc;
    Callback windowTimerCallback;
    long windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    long caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    long mouseHoverHandle;
    long mouseHoverProc;
    Callback mouseHoverCallback;
    long sizeAllocateProc;
    Callback sizeAllocateCallback;
    long sizeRequestProc;
    Callback sizeRequestCallback;
    long shellMapProc;
    Callback shellMapCallback;
    long idleProc;
    int idleHandle;
    Callback idleCallback;
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    Object idleLock = new Object();
    boolean idleNeeded;
    long cellDataProc;
    Callback cellDataCallback;
    long setDirectionProc;
    Callback setDirectionCallback;
    static final String GET_DIRECTION_PROC_KEY = "org.eclipse.swt.internal.gtk.getDirectionProc";
    long emissionProc;
    Callback emissionProcCallback;
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";
    long allChildrenProc;
    long allChildren;
    Callback allChildrenCallback;
    long signalProc;
    Callback signalCallback;
    long shellHandle;
    boolean settingsChanged;
    boolean runSettings;
    static final int STYLE_UPDATED = 1;
    boolean entrySelectOnFocus;
    Control currentControl;
    long checkIfEventProc;
    Callback checkIfEventCallback;
    long flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    long[] flushData = new long[1];
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    GdkRGBA COLOR_WIDGET_DARK_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_NORMAL_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_LIGHT_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA;
    GdkRGBA COLOR_WIDGET_BACKGROUND_RGBA;
    GdkRGBA COLOR_WIDGET_FOREGROUND_RGBA;
    GdkRGBA COLOR_WIDGET_BORDER_RGBA;
    GdkRGBA COLOR_LIST_FOREGROUND_RGBA;
    GdkRGBA COLOR_LIST_BACKGROUND_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_TEXT_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_INACTIVE_RGBA;
    GdkRGBA COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA;
    GdkRGBA COLOR_INFO_BACKGROUND_RGBA;
    GdkRGBA COLOR_INFO_FOREGROUND_RGBA;
    GdkRGBA COLOR_LINK_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_BACKGROUND_RGBA;
    GdkRGBA COLOR_TITLE_BACKGROUND_GRADIENT_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_FOREGROUND_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_BACKGROUND_RGBA;
    GdkRGBA COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA;
    GdkRGBA COLOR_WIDGET_DISABLED_FOREGROUND_RGBA;
    GdkRGBA COLOR_TEXT_DISABLED_BACKGROUND_RGBA;
    GdkRGBA COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA;
    ArrayList<String> colorList;
    final int SWT_COLOR_LIST_SELECTION_TEXT_INACTIVE = 38;
    final int SWT_COLOR_LIST_SELECTION_INACTIVE = 39;
    static String themeName;
    static boolean themeDark;
    private static final Pattern colorPattern;
    Menu[] popups;
    int clickCount = 1;
    static final int INNER_BORDER = 2;
    int lastEventTime;
    int lastUserEventTime;
    long pangoLayoutNewProc;
    long pangoFontFamilyNewProc;
    long pangoFontFaceNewProc;
    long imContextNewProc;
    long printerOptionWidgetNewProc;
    double resizeLocationX;
    double resizeLocationY;
    int resizeBoundsX;
    int resizeBoundsY;
    int resizeBoundsWidth;
    int resizeBoundsHeight;
    int resizeMode;
    static long fixed_type;
    static long text_renderer_type;
    static long pixbuf_renderer_type;
    static long toggle_renderer_type;
    static long text_renderer_info_ptr;
    static long pixbuf_renderer_info_ptr;
    static long toggle_renderer_info_ptr;
    static Callback rendererClassInitCallback;
    static Callback rendererRenderCallback;
    static Callback rendererSnapshotCallback;
    static Callback rendererGetPreferredWidthCallback;
    static long rendererClassInitProc;
    static long rendererRenderProc;
    static long rendererSnapshotProc;
    static long rendererGetPreferredWidthProc;
    static final int[][] KeyTable;
    int cachedModifierState = 0;
    private int latinKeyGroup;
    Map<Integer, Integer> groupKeysCount;
    long keysChangedProc;
    Callback keysChangedCallback;
    static Display Default;
    static Display[] Displays;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final int GTK3_MAJOR = 3;
    static final int GTK3_MINOR = 22;
    static final int GTK3_MICRO = 0;
    static final int GTK4_MAJOR = 4;
    static final int GTK4_MINOR = 0;
    static final int GTK4_MICRO = 0;
    Object data;
    String[] keys;
    Object[] values;
    static final int TRIM_NONE = 0;
    static final int TRIM_BORDER = 1;
    static final int TRIM_RESIZE = 2;
    static final int TRIM_TITLE_BORDER = 3;
    static final int TRIM_TITLE_RESIZE = 4;
    static final int TRIM_TITLE = 5;
    int[] trimWidths = new int[6];
    int[] trimHeights = new int[6];
    boolean ignoreTrim;
    String windowManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDisplayCreationHook(IDisplayCreationHook iDisplayCreationHook) {
        Object object = classLock;
        synchronized (object) {
            if (creationHooks == null) {
                creationHooks = new IDisplayCreationHook[]{iDisplayCreationHook};
                return;
            }
            for (int i = 0; i < creationHooks.length; ++i) {
                if (creationHooks[i] != iDisplayCreationHook) continue;
                if (i == 0) {
                    return;
                }
                System.arraycopy(creationHooks, 0, creationHooks, 1, i);
                Display.creationHooks[0] = iDisplayCreationHook;
            }
            IDisplayCreationHook[] iDisplayCreationHookArray = new IDisplayCreationHook[creationHooks.length + 1];
            iDisplayCreationHookArray[0] = iDisplayCreationHook;
            System.arraycopy(creationHooks, 0, iDisplayCreationHookArray, 1, creationHooks.length);
            creationHooks = iDisplayCreationHookArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDisplayCreationHook(IDisplayCreationHook iDisplayCreationHook) {
        Object object = classLock;
        synchronized (object) {
            if (creationHooks == null) {
                return;
            }
            for (int i = 0; i < creationHooks.length; ++i) {
                if (creationHooks[i] != iDisplayCreationHook) continue;
                if (creationHooks.length == 1) {
                    creationHooks = null;
                    return;
                }
                IDisplayCreationHook[] iDisplayCreationHookArray = new IDisplayCreationHook[creationHooks.length - 1];
                if (i > 0) {
                    System.arraycopy(creationHooks, 0, iDisplayCreationHookArray, 0, i - 1);
                }
                if (i < creationHooks.length - 1) {
                    System.arraycopy(creationHooks, i + 1, iDisplayCreationHookArray, i, creationHooks.length - i - 1);
                }
                creationHooks = iDisplayCreationHookArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runDisplayCreationHooks(Display display) {
        IDisplayCreationHook[] iDisplayCreationHookArray;
        Object object = classLock;
        synchronized (object) {
            if (creationHooks == null) {
                return;
            }
            iDisplayCreationHookArray = (IDisplayCreationHook[])creationHooks.clone();
        }
        if (iDisplayCreationHookArray != null) {
            for (int i = 0; i < iDisplayCreationHookArray.length; ++i) {
                try {
                    iDisplayCreationHookArray[i].displayCreated(display);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public void addDialogHook(IDialogHook iDialogHook) {
        if (Display.logger.level >= 7) {
            Logger.Builder builder = logger.build("addDialogHook(IDialogHook)");
            (Display.logger.level < 8 ? builder : builder.add("hook: ").add((Object)iDialogHook)).log(7);
        }
        this.checkDevice();
        if (this.dialogHooks == null) {
            this.dialogHooks = new IDialogHook[]{iDialogHook};
            return;
        }
        for (int i = 0; i < this.dialogHooks.length; ++i) {
            if (this.dialogHooks[i] != iDialogHook) continue;
            if (i == 0) {
                return;
            }
            System.arraycopy(this.dialogHooks, 0, this.dialogHooks, 1, i);
            this.dialogHooks[0] = iDialogHook;
        }
        IDialogHook[] iDialogHookArray = new IDialogHook[this.dialogHooks.length + 1];
        iDialogHookArray[0] = iDialogHook;
        System.arraycopy(this.dialogHooks, 0, iDialogHookArray, 1, this.dialogHooks.length);
        this.dialogHooks = iDialogHookArray;
    }

    public void removeDialogHook(IDialogHook iDialogHook) {
        if (Display.logger.level >= 7) {
            Logger.Builder builder = logger.build("removeDialogHook(IDialogHook)");
            (Display.logger.level < 8 ? builder : builder.add("hook: ").add((Object)iDialogHook)).log(7);
        }
        this.checkDevice();
        if (this.dialogHooks == null) {
            return;
        }
        for (int i = 0; i < this.dialogHooks.length; ++i) {
            if (this.dialogHooks[i] != iDialogHook) continue;
            if (this.dialogHooks.length == 1) {
                this.dialogHooks = null;
                return;
            }
            IDialogHook[] iDialogHookArray = new IDialogHook[this.dialogHooks.length - 1];
            if (i > 0) {
                System.arraycopy(this.dialogHooks, 0, iDialogHookArray, 0, i - 1);
            }
            if (i < this.dialogHooks.length - 1) {
                System.arraycopy(this.dialogHooks, i + 1, iDialogHookArray, i, this.dialogHooks.length - i - 1);
            }
            this.dialogHooks = iDialogHookArray;
        }
    }

    public void runDialogCreationHooks(Dialog dialog) {
        Logger.Builder builder;
        if (Display.logger.level >= 7) {
            builder = logger.build("runDialogCreationHooks(Dialog)");
            (Display.logger.level < 8 ? builder : builder.add("dialog: ").add((Object)dialog)).log(7);
        }
        this.checkDevice();
        if (this.dialogHooks == null) {
            return;
        }
        builder = (Logger.Builder)this.dialogHooks.clone();
        for (int i = 0; i < ((Logger.Builder)builder).length; ++i) {
            try {
                builder[i].dialogCreated(dialog);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void runDialogShownHooks(Dialog dialog, long l) {
        Logger.Builder builder;
        if (Display.logger.level >= 7) {
            builder = logger.build("runDialogShownHooks(Dialog,long)");
            (Display.logger.level < 8 ? builder : builder.add("dialog: ").add((Object)dialog).add(", handle: ").add(l)).log(7);
        }
        this.checkDevice();
        if (this.dialogHooks == null) {
            return;
        }
        builder = (Logger.Builder)this.dialogHooks.clone();
        for (int i = 0; i < ((IDialogHook[])builder).length; ++i) {
            try {
                builder[i].dialogShown(dialog, new Long(l));
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public Object runDialogClosedHooks(Dialog dialog, Object object) {
        Logger.Builder builder;
        if (Display.logger.level >= 7) {
            builder = logger.build("runDialogClosedHooks(Dialog,Object)");
            (Display.logger.level < 8 ? builder : builder.add("dialog: ").add((Object)dialog).add(", result: ").add(object)).log(7);
        }
        this.checkDevice();
        if (this.dialogHooks == null) {
            return object;
        }
        builder = (Logger.Builder)this.dialogHooks.clone();
        for (int i = 0; i < ((IDialogHook[])builder).length; ++i) {
            try {
                object = builder[i].dialogClosed(dialog, object);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return object;
    }

    public void addDNDHook(IDNDHook iDNDHook) {
        if (Display.logger.level >= 7) {
            Logger.Builder builder = logger.build("addDNDHook(IDNDHook)");
            (Display.logger.level < 8 ? builder : builder.add("hook: ").add((Object)iDNDHook)).log(7);
        }
        this.checkDevice();
        if (this.dndHooks == null) {
            this.dndHooks = new IDNDHook[]{iDNDHook};
            return;
        }
        for (int i = 0; i < this.dndHooks.length; ++i) {
            if (this.dndHooks[i] != iDNDHook) continue;
            if (i == 0) {
                return;
            }
            System.arraycopy(this.dndHooks, 0, this.dndHooks, 1, i);
            this.dndHooks[0] = iDNDHook;
        }
        IDNDHook[] iDNDHookArray = new IDNDHook[this.dndHooks.length + 1];
        iDNDHookArray[0] = iDNDHook;
        System.arraycopy(this.dndHooks, 0, iDNDHookArray, 1, this.dndHooks.length);
        this.dndHooks = iDNDHookArray;
    }

    public void removeDNDHook(IDNDHook iDNDHook) {
        if (Display.logger.level >= 7) {
            Logger.Builder builder = logger.build("removeDNDHook(IDNDHook)");
            (Display.logger.level < 8 ? builder : builder.add("hook: ").add((Object)iDNDHook)).log(7);
        }
        this.checkDevice();
        if (this.dndHooks == null) {
            return;
        }
        for (int i = 0; i < this.dndHooks.length; ++i) {
            if (this.dndHooks[i] != iDNDHook) continue;
            if (this.dndHooks.length == 1) {
                this.dndHooks = null;
                return;
            }
            IDNDHook[] iDNDHookArray = new IDNDHook[this.dndHooks.length - 1];
            if (i > 0) {
                System.arraycopy(this.dndHooks, 0, iDNDHookArray, 0, i - 1);
            }
            if (i < this.dndHooks.length - 1) {
                System.arraycopy(this.dndHooks, i + 1, iDNDHookArray, i, this.dndHooks.length - i - 1);
            }
            this.dndHooks = iDNDHookArray;
        }
    }

    public void runDNDCreationHooks(DragSource dragSource) {
        Logger.Builder builder;
        if (Display.logger.level >= 7) {
            builder = logger.build("runDNDCreationHooks(DragSource)");
            (Display.logger.level < 8 ? builder : builder.add("dragSource: ").add((Object)dragSource)).log(7);
        }
        this.checkDevice();
        if (this.dndHooks == null) {
            return;
        }
        builder = (Logger.Builder)this.dndHooks.clone();
        for (int i = 0; i < ((Logger.Builder)builder).length; ++i) {
            try {
                builder[i].dragSourceCreated(dragSource);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void runDNDCreationHooks(DropTarget dropTarget) {
        Logger.Builder builder;
        if (Display.logger.level >= 7) {
            builder = logger.build("runDNDCreationHooks(DropTarget)");
            (Display.logger.level < 8 ? builder : builder.add("dropTarget: ").add((Object)dropTarget)).log(7);
        }
        this.checkDevice();
        if (this.dndHooks == null) {
            return;
        }
        builder = (Logger.Builder)this.dndHooks.clone();
        for (int i = 0; i < ((Logger.Builder)builder).length; ++i) {
            try {
                builder[i].dropTargetCreated(dropTarget);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void runDNDTrackerHooks(boolean bl, boolean bl2) {
        Logger.Builder builder;
        if (Display.logger.level >= 7) {
            builder = logger.build("runDNDTrackerHooks(boolean,boolean)");
            (Display.logger.level < 8 ? builder : builder.add("start: ").add(bl).add(", cancelled: ").add(bl2)).log(7);
        }
        this.checkDevice();
        if (this.dndHooks == null) {
            return;
        }
        builder = (Logger.Builder)this.dndHooks.clone();
        for (int i = 0; i < ((IDNDHook[])builder).length; ++i) {
            try {
                if (bl) {
                    builder[i].trackerDragStarted();
                    continue;
                }
                builder[i].trackerDragFinished(bl2);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGdkEventFilter(IGdkEventFilter iGdkEventFilter) {
        Object object = classLock;
        synchronized (object) {
            if (this.gdkEventFilters == null) {
                this.gdkEventFilters = new IGdkEventFilter[]{iGdkEventFilter};
                return;
            }
            for (int i = 0; i < this.gdkEventFilters.length; ++i) {
                if (this.gdkEventFilters[i] != iGdkEventFilter) continue;
                if (i == 0) {
                    return;
                }
                System.arraycopy(this.gdkEventFilters, 0, this.gdkEventFilters, 1, i);
                this.gdkEventFilters[0] = iGdkEventFilter;
            }
            IGdkEventFilter[] iGdkEventFilterArray = new IGdkEventFilter[this.gdkEventFilters.length + 1];
            iGdkEventFilterArray[0] = iGdkEventFilter;
            System.arraycopy(this.gdkEventFilters, 0, iGdkEventFilterArray, 1, this.gdkEventFilters.length);
            this.gdkEventFilters = iGdkEventFilterArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGdkEventFilter(IGdkEventFilter iGdkEventFilter) {
        Object object = classLock;
        synchronized (object) {
            if (this.gdkEventFilters == null) {
                return;
            }
            for (int i = 0; i < this.gdkEventFilters.length; ++i) {
                if (this.gdkEventFilters[i] != iGdkEventFilter) continue;
                if (this.gdkEventFilters.length == 1) {
                    this.gdkEventFilters = null;
                    return;
                }
                IGdkEventFilter[] iGdkEventFilterArray = new IGdkEventFilter[this.gdkEventFilters.length - 1];
                if (i > 0) {
                    System.arraycopy(this.gdkEventFilters, 0, iGdkEventFilterArray, 0, i - 1);
                }
                if (i < this.gdkEventFilters.length - 1) {
                    System.arraycopy(this.gdkEventFilters, i + 1, iGdkEventFilterArray, i, this.gdkEventFilters.length - i - 1);
                }
                this.gdkEventFilters = iGdkEventFilterArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runGdkEventFilters(long l, int n) {
        Logger.Builder builder;
        if (Display.logger.level >= 7) {
            builder = logger.build("runGdkEventFilters(int,int)");
            (Display.logger.level < 8 ? builder : builder.add("gdkEvent: ").add(l).add(", type: ").add(n)).log(7);
        }
        Object object = classLock;
        synchronized (object) {
            if (this.gdkEventFilters == null) {
                return true;
            }
            builder = (Logger.Builder)this.gdkEventFilters.clone();
        }
        if (builder != null) {
            for (int i = 0; i < ((Logger.Builder)builder).length; ++i) {
                try {
                    if (!builder[i].filterGdkEvent(l, n)) {
                        if (Display.logger.level >= 9) {
                            logger.log(9, "runGdkEventFilters(int,int)", "Event filtered out");
                        }
                        return false;
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleProc(IdleProc idleProc) {
        Object object = classLock;
        synchronized (object) {
            if (this.idleProcs == null) {
                this.idleProcs = new IdleProc[]{idleProc};
                return;
            }
            for (int i = 0; i < this.idleProcs.length; ++i) {
                if (this.idleProcs[i] != idleProc) continue;
                if (i == 0) {
                    return;
                }
                System.arraycopy(this.idleProcs, 0, this.idleProcs, 1, i);
                this.idleProcs[0] = idleProc;
            }
            IdleProc[] idleProcArray = new IdleProc[this.idleProcs.length + 1];
            idleProcArray[0] = idleProc;
            System.arraycopy(this.idleProcs, 0, idleProcArray, 1, this.idleProcs.length);
            this.idleProcs = idleProcArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleProc(IdleProc idleProc) {
        Object object = classLock;
        synchronized (object) {
            if (this.idleProcs == null) {
                return;
            }
            for (int i = 0; i < this.idleProcs.length; ++i) {
                if (this.idleProcs[i] != idleProc) continue;
                if (this.idleProcs.length == 1) {
                    this.idleProcs = null;
                    return;
                }
                IdleProc[] idleProcArray = new IdleProc[this.idleProcs.length - 1];
                if (i > 0) {
                    System.arraycopy(this.idleProcs, 0, idleProcArray, 0, i - 1);
                }
                if (i < this.idleProcs.length - 1) {
                    System.arraycopy(this.idleProcs, i + 1, idleProcArray, i, this.idleProcs.length - i - 1);
                }
                this.idleProcs = idleProcArray;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runIdleProcs() {
        IdleProc[] idleProcArray;
        if (Display.logger.level >= 7) {
            logger.log(7, "runIdleProcs()", "");
        }
        Object object = classLock;
        synchronized (object) {
            if (this.idleProcs == null) {
                return true;
            }
            idleProcArray = (IdleProc[])this.idleProcs.clone();
        }
        if (idleProcArray != null) {
            for (int i = 0; i < idleProcArray.length; ++i) {
                try {
                    idleProcArray[i].idleProc(0L);
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return true;
    }

    public void clearCharOverride() {
        this.charOverrideHead = 0;
        this.charOverrideTail = 0;
    }

    public void pushCharOverride(int n, char c) {
        if (this.charOverrideHead < 32000) {
            this.charOverride[this.charOverrideHead++] = (long)c << 32 | (long)n;
        } else if (Display.logger.level >= 3) {
            logger.log(3, "pushCharOverride(int,char)", "Overflow in charOverride buffer");
        }
    }

    public void needExtraDeferred() {
        if (Display.logger.level >= 7) {
            logger.log(7, "needExtraDeferred()", "");
        }
        this.extraDeferred = true;
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
        File file;
        this.trimWidths[0] = 0;
        this.trimHeights[0] = 0;
        this.trimWidths[1] = 4;
        this.trimHeights[1] = 4;
        this.trimWidths[2] = 6;
        this.trimHeights[2] = 6;
        this.trimWidths[3] = 5;
        this.trimHeights[3] = 28;
        this.trimWidths[4] = 6;
        this.trimHeights[4] = 29;
        this.trimWidths[5] = 0;
        this.trimHeights[5] = 23;
        String string = System.getProperty("user.home");
        if (string != null && (file = new File(string, ".swt/trims.prefs")).exists() && file.isFile()) {
            Properties properties = new Properties();
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
                String string2 = properties.getProperty("trimWidths");
                String string3 = properties.getProperty("trimHeights");
                if (string2 != null && string3 != null) {
                    int n;
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    for (n = 0; n < this.trimWidths.length && stringTokenizer.hasMoreTokens(); ++n) {
                        this.trimWidths[n] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    stringTokenizer = new StringTokenizer(string3);
                    for (n = 0; n < this.trimHeights.length && stringTokenizer.hasMoreTokens(); ++n) {
                        this.trimHeights[n] = Integer.parseInt(stringTokenizer.nextToken());
                    }
                }
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
        }
        Display.runDisplayCreationHooks(this);
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    void addLayoutDeferred(Composite composite) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] compositeArray = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, compositeArray, 0, this.layoutDeferred.length);
            this.layoutDeferred = compositeArray;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = composite;
    }

    void addGdkEvent(long l) {
        int n;
        if (this.gdkEvents == null) {
            n = 1024;
            this.gdkEvents = new long[n];
            this.gdkEventWidgets = new Widget[n];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            n = this.gdkEventCount + 1024;
            long[] lArray = new long[n];
            System.arraycopy(this.gdkEvents, 0, lArray, 0, this.gdkEventCount);
            this.gdkEvents = lArray;
            Widget[] widgetArray = new Widget[n];
            System.arraycopy(this.gdkEventWidgets, 0, widgetArray, 0, this.gdkEventCount);
            this.gdkEventWidgets = widgetArray;
        }
        Widget widget = null;
        long l2 = GTK3.gtk_get_event_widget((long)l);
        if (l2 != 0L) {
            while ((widget = this.getWidget(l2)) == null && (l2 = GTK.gtk_widget_get_parent((long)l2)) != 0L) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = l;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            this.idleNeeded = true;
            if (this.idleHandle == 0) {
                this.idleHandle = GTK.GTK4 ? OS.g_idle_add(this.idleProc, 0L) : GDK.gdk_threads_add_idle((long)this.idleProc, (long)0L);
            }
        }
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        if (n == 46 || n == 54) {
            this.gdbus_init_methods();
        }
        this.eventTable.hook(n, listener);
    }

    private void gdbus_init_methods() {
        GDBus.GDBusMethod[] gDBusMethodArray = new GDBus.GDBusMethod[]{new GDBus.GDBusMethod("FileOpen", (String[][])new String[][]{{"as", "A String array containing file paths or URLs for OpenDocument/OpenUrl signal"}}, new String[0][0], objectArray -> {
            String[] stringArray = (String[])objectArray[0];
            for (int i = 0; i < stringArray.length; ++i) {
                Event event = new Event();
                event.text = stringArray[i];
                try {
                    if (new URI(stringArray[i]).getScheme() == null) {
                        throw new URISyntaxException(stringArray[i], "Not a valid Url. Probably file.");
                    }
                    this.sendEvent(54, event);
                    continue;
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.sendEvent(46, event);
                }
            }
            return null;
        })};
        GDBus.init((GDBus.GDBusMethod[])gDBusMethodArray, (String)Display.getAppName());
    }

    long allChildrenProc(long l, long l2) {
        this.allChildren = OS.g_list_append(this.allChildren, l);
        if (l2 != 0L && GTK.GTK_IS_CONTAINER((long)l)) {
            GTK3.gtk_container_forall((long)l, (long)this.allChildrenProc, (long)l2);
        }
        return 0L;
    }

    void addMouseHoverTimeout(long l) {
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = GTK.GTK4 ? OS.g_timeout_add(400, this.mouseHoverProc, l) : GDK.gdk_threads_add_timeout((int)400, (long)this.mouseHoverProc, (long)l);
        this.mouseHoverHandle = l;
    }

    void addPopup(Menu menu) {
        int n;
        if (Display.logger.level >= 7) {
            Logger.Builder builder = logger.build("addPopup(Menu)");
            (Display.logger.level < 8 ? builder : builder.add("menu: ").add((Object)menu)).log(7);
        }
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n2 = this.popups.length;
        for (n = 0; n < n2; ++n) {
            if (this.popups[n] == menu) {
                return;
            }
            if (this.popups[n] == null || !this.popups[n].getNameText().equals(menu.getNameText())) continue;
            return;
        }
        for (n = 0; n < n2 && this.popups[n] != null; ++n) {
        }
        if (n == n2) {
            Menu[] menuArray = new Menu[n2 + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n2);
            this.popups = menuArray;
        }
        this.popups[n] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] widgetArray = new Widget[(this.skinList.length + 1) * 3 / 2];
            System.arraycopy(this.skinList, 0, widgetArray, 0, this.skinList.length);
            this.skinList = widgetArray;
        }
        this.skinList[this.skinCount++] = widget;
    }

    void addWidget(long l, Widget widget) {
        long l2;
        int n;
        if (l == 0L) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n = this.freeSlot + 1024;
            int[] nArray = new int[n];
            Widget[] widgetArray = new Widget[n];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, widgetArray, 0, this.freeSlot);
            for (int i = this.freeSlot; i < n - 1; ++i) {
                nArray[i] = i + 1;
            }
            nArray[n - 1] = -1;
            this.indexTable = nArray;
            this.widgetTable = widgetArray;
        }
        n = this.freeSlot + 1;
        if (strictChecks && (l2 = OS.g_object_get_qdata(l, SWT_OBJECT_INDEX)) > 0L && l2 != (long)n) {
            SWT.error(5, null, ". Potential leak of " + widget + this.debugInfoForIndex(l2 - 1L));
        }
        OS.g_object_set_qdata(l, SWT_OBJECT_INDEX, n);
        int n2 = this.freeSlot;
        this.freeSlot = this.indexTable[n2];
        this.indexTable[n2] = -2;
        if (this.widgetTable[n2] != null) {
            SWT.error(5, null, ". Trying to override non empty slot with " + widget + this.debugInfoForIndex(n2));
        }
        this.widgetTable[n2] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = GTK.GTK4 ? OS.g_idle_add(this.idleProc, 0L) : GDK.gdk_threads_add_idle((long)this.idleProc, (long)0L);
                }
            }
            this.synchronizer.internalAsyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void execute(Runnable runnable) {
        Objects.requireNonNull(runnable);
        if (this.isDisposed()) {
            throw new RejectedExecutionException((Throwable)new SWTException(24, null));
        }
        if (this.thread == Thread.currentThread()) {
            this.syncExec(runnable);
        } else {
            this.asyncExec(runnable);
        }
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        GDK.gdk_display_beep((long)GDK.gdk_display_get_default());
    }

    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        Widget widget = this.getWidget(l5);
        if (widget == null) {
            return 0L;
        }
        return widget.cellDataProc(l, l2, l3, l4, l5);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] == null) continue;
                if (!bl) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i].thread != thread) continue;
                SWT.error(22);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    long checkIfEventProc(long l, long l2, long l3) {
        int n = OS.X_EVENT_TYPE(l2);
        switch (n) {
            case 12: 
            case 13: {
                break;
            }
            default: {
                return 0L;
            }
        }
        long l4 = GDK.gdk_x11_window_lookup_for_display((long)GDK.gdk_display_get_default(), (long)OS.X_EVENT_WINDOW(l2));
        if (l4 == 0L) {
            return 0L;
        }
        if (this.flushWindow != 0L) {
            if (this.flushAll) {
                long l5 = l4;
                while (l5 != this.flushWindow && (l5 = GDK.gdk_window_get_parent((long)l5)) != 0L) {
                }
                if (l5 != this.flushWindow) {
                    return 0L;
                }
            } else if (l4 != this.flushWindow) {
                return 0L;
            }
        }
        OS.memmove(this.exposeEvent, l2, (long)XExposeEvent.sizeof);
        switch (n) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = Math.max(0, this.exposeEvent.width);
                this.flushRect.height = Math.max(0, this.exposeEvent.height);
                GDK.gdk_window_invalidate_rect((long)l4, (GdkRectangle)this.flushRect, (boolean)true);
                this.exposeEvent.type = -1;
                OS.memmove(l2, this.exposeEvent, (long)XExposeEvent.sizeof);
            }
        }
        return 0L;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void clearModal(Shell shell) {
        int n;
        if (this.modalShells == null) {
            return;
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2 && this.modalShells[n] != shell; ++n) {
            if (this.modalShells[n] != null) continue;
            return;
        }
        if (n == n2) {
            return;
        }
        System.arraycopy(this.modalShells, n + 1, this.modalShells, n, --n2 - n);
        this.modalShells[n2] = null;
        if (n == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void checkIMModule() {
        Map<String, String> map = System.getenv();
        String string = map.get("GTK_IM_MODULE");
        if (string != null && string.equals("xim")) {
            System.err.println("***WARNING: Detected: GTK_IM_MODULE=xim. This input method is unsupported and can cause graphical issues.");
            System.err.println("***WARNING: Unset GTK_IM_MODULE or set GTK_IM_MODULE=ibus if flicking is experienced. ");
        }
        if (OS.isGNOME) {
            long l = GTK.gtk_settings_get_default();
            byte[] byArray = Converter.wcsToMbcs((String)"ibus", (boolean)true);
            if (l != 0L) {
                OS.g_object_set(l, GTK.gtk_im_module, byArray, 0L);
            }
        }
    }

    boolean checkAndSetThemeDetails(String string) {
        if (string.endsWith("-dark") || string.endsWith(":dark")) {
            System.setProperty("org.eclipse.swt.internal.gtk.theme", string);
            return true;
        }
        long l = GTK.gtk_settings_get_default();
        int[] nArray = new int[1];
        OS.g_object_get(l, GTK.gtk_application_prefer_dark_theme, nArray, 0L);
        if (nArray[0] != 0) {
            System.setProperty("org.eclipse.swt.internal.gtk.theme", string.concat(":dark"));
        } else {
            System.setProperty("org.eclipse.swt.internal.gtk.theme", string);
        }
        return nArray[0] != 0;
    }

    void createDisplay(DeviceData deviceData) {
        byte[] byArray;
        long l;
        if (!GTK.GTK4) {
            OS.swt_set_lock_functions();
            GDK.gdk_threads_init();
            GDK.gdk_threads_enter();
        }
        this.windowSizeSet = false;
        boolean bl = GTK.GTK4 ? GTK4.gtk_init_check() : GTK3.gtk_init_check((long[])new long[]{0L}, null);
        if (!bl) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        this.checkIMModule();
        themeName = OS.GTK_THEME_SET ? OS.GTK_THEME_SET_NAME : OS.getThemeName();
        themeDark = this.checkAndSetThemeDetails(themeName);
        if (OS.isX11()) {
            long l2 = this.xDisplay = GTK.GTK4 ? 0L : GDK.gdk_x11_get_default_xdisplay();
        }
        if (OS.SWT_DEBUG) {
            Device.DEBUG = true;
        }
        if ((l = GTK.gtk_check_version((int)3, (int)22, (int)0)) != 0L) {
            int n = C.strlen((long)l);
            byArray = new byte[n];
            C.memmove((byte[])byArray, (long)l, (long)n);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs((byte[])byArray)));
            System.out.println("***WARNING: SWT requires GTK 3.22.0");
            int n2 = GTK.gtk_get_major_version();
            int n3 = GTK.gtk_get_minor_version();
            int n4 = GTK.gtk_get_micro_version();
            System.out.println("***WARNING: Detected: " + n2 + "." + n3 + "." + n4);
        }
        fixed_type = OS.swt_fixed_get_type();
        if (rendererClassInitProc == 0L) {
            rendererClassInitCallback = new Callback(this.getClass(), "rendererClassInitProc", 2);
            rendererClassInitProc = rendererClassInitCallback.getAddress();
        }
        if (GTK.GTK4) {
            if (rendererSnapshotProc == 0L) {
                rendererSnapshotCallback = new Callback(this.getClass(), "rendererSnapshotProc", 6);
                rendererSnapshotProc = rendererSnapshotCallback.getAddress();
            }
        } else if (rendererRenderProc == 0L) {
            rendererRenderCallback = new Callback(this.getClass(), "rendererRenderProc", 6);
            rendererRenderProc = rendererRenderCallback.getAddress();
        }
        if (rendererGetPreferredWidthProc == 0L) {
            rendererGetPreferredWidthCallback = new Callback(this.getClass(), "rendererGetPreferredWidthProc", 4);
            rendererGetPreferredWidthProc = rendererGetPreferredWidthCallback.getAddress();
        }
        if (text_renderer_type == 0L) {
            GTypeInfo gTypeInfo = new GTypeInfo();
            gTypeInfo.class_size = (short)GTK.GtkCellRendererTextClass_sizeof();
            gTypeInfo.class_init = rendererClassInitProc;
            gTypeInfo.instance_size = (short)GTK.GtkCellRendererText_sizeof();
            text_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(text_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
            byArray = Converter.wcsToMbcs((String)"SwtTextRenderer", (boolean)true);
            text_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_TEXT(), byArray, text_renderer_info_ptr, 0);
        }
        if (!GTK.GTK4) {
            if (pixbuf_renderer_type == 0L) {
                GTypeInfo gTypeInfo = new GTypeInfo();
                gTypeInfo.class_size = (short)GTK.GtkCellRendererPixbufClass_sizeof();
                gTypeInfo.class_init = rendererClassInitProc;
                gTypeInfo.instance_size = (short)GTK.GtkCellRendererPixbuf_sizeof();
                pixbuf_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
                OS.memmove(pixbuf_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
                byArray = Converter.wcsToMbcs((String)"SwtPixbufRenderer", (boolean)true);
                pixbuf_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_PIXBUF(), byArray, pixbuf_renderer_info_ptr, 0);
            }
            if (toggle_renderer_type == 0L) {
                GTypeInfo gTypeInfo = new GTypeInfo();
                gTypeInfo.class_size = (short)GTK.GtkCellRendererToggleClass_sizeof();
                gTypeInfo.class_init = rendererClassInitProc;
                gTypeInfo.instance_size = (short)GTK.GtkCellRendererToggle_sizeof();
                toggle_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
                OS.memmove(toggle_renderer_info_ptr, gTypeInfo, GTypeInfo.sizeof);
                byArray = Converter.wcsToMbcs((String)"SwtToggleRenderer", (boolean)true);
                toggle_renderer_type = OS.g_type_register_static(GTK.GTK_TYPE_CELL_RENDERER_TOGGLE(), byArray, toggle_renderer_info_ptr, 0);
            }
        }
        GTK.gtk_widget_set_default_direction((int)1);
        byte[] byArray2 = Converter.wcsToMbcs((String)APP_NAME, (boolean)true);
        OS.g_set_prgname(byArray2);
        if (OS.isX11() && !GTK.GTK4) {
            GDK.gdk_set_program_class((byte[])byArray2);
        }
        this.shellHandle = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new((int)0);
        if (this.shellHandle == 0L) {
            this.error(2);
        }
        GTK.gtk_widget_realize((long)this.shellHandle);
        this.eventCallback = new Callback((Object)this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        GDK.gdk_event_handler_set((long)this.eventProc, (long)0L, (long)0L);
        this.signalCallback = new Callback((Object)this, "signalProc", 3);
        this.signalProc = this.signalCallback.getAddress();
        if (!GTK.GTK4) {
            byArray = Converter.wcsToMbcs((String)("SWT_Window_" + APP_NAME), (boolean)true);
            long l3 = GDK.gdk_atom_intern((byte[])byArray, (boolean)false);
            GDK.gdk_selection_owner_set((long)GTK3.gtk_widget_get_window((long)this.shellHandle), (long)l3, (int)0, (boolean)false);
            GDK.gdk_selection_owner_get((long)l3);
        }
        this.latinKeyGroup = this.findLatinKeyGroup();
        this.keysChangedCallback = new Callback((Object)this, "keysChangedProc", 2);
        this.keysChangedProc = this.keysChangedCallback.getAddress();
        long l4 = GDK.gdk_display_get_default();
        if (GTK.GTK4) {
            long l5 = GDK.gdk_seat_get_keyboard((long)GDK.gdk_display_get_default_seat((long)l4));
            OS.g_signal_connect(l5, OS.changed, this.keysChangedProc, 0L);
        } else {
            long l6 = GDK.gdk_keymap_get_for_display((long)l4);
            OS.g_signal_connect(l6, OS.keys_changed, this.keysChangedProc, 0L);
        }
    }

    private int findLatinKeyGroup() {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        this.groupKeysCount = new HashMap<Integer, Integer>();
        long l = GDK.gdk_display_get_default();
        for (n = 97; n <= 122; ++n) {
            boolean bl;
            object2 = new long[1];
            object = new int[1];
            if (GTK.GTK4) {
                bl = GDK.gdk_display_map_keyval((long)l, (int)n, (long[])object2, (int[])object);
            } else {
                long l2 = GDK.gdk_keymap_get_for_display((long)l);
                bl = GDK.gdk_keymap_get_entries_for_keyval((long)l2, (int)n, (long[])object2, (int[])object);
            }
            if (!bl) continue;
            GdkKeymapKey gdkKeymapKey = new GdkKeymapKey();
            for (int i = 0; i < object[0]; ++i) {
                OS.memmove(gdkKeymapKey, (long)(object2[0] + (long)(i * GdkKeymapKey.sizeof)), (long)GdkKeymapKey.sizeof);
                Integer n3 = this.groupKeysCount.get(gdkKeymapKey.group);
                if (n3 != null) {
                    Integer n4 = n3;
                    Integer n5 = n3 = Integer.valueOf(n3 + 1);
                } else {
                    n3 = 1;
                }
                this.groupKeysCount.put(gdkKeymapKey.group, n3);
            }
            OS.g_free((long)object2[0]);
        }
        n = 0;
        object2 = this.groupKeysCount.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            Integer n6 = (Integer)object.getKey();
            Integer n7 = (Integer)object.getValue();
            if (n7 <= n) continue;
            n2 = n6;
            n = n7;
        }
        return n2;
    }

    int getLatinKeyGroup() {
        return this.latinKeyGroup;
    }

    Map<Integer, Integer> getGroupKeysCount() {
        return this.groupKeysCount;
    }

    long keysChangedProc(long l, long l2) {
        this.latinKeyGroup = this.findLatinKeyGroup();
        return 0L;
    }

    Image createImage(String string) {
        long l;
        long l2;
        long l3;
        byte[] byArray = Converter.wcsToMbcs((String)string, (boolean)true);
        if (GTK.GTK4) {
            l3 = GTK4.gtk_icon_theme_get_for_display((long)GDK.gdk_display_get_default());
            long l4 = GTK4.gtk_icon_theme_lookup_icon((long)l3, (byte[])byArray, (long)0L, (int)48, (int)1, (int)1, (int)32);
            l2 = GTK4.gtk_icon_paintable_get_file((long)l4);
            long l5 = GDK.gdk_texture_new_from_file((long)l2, (long)0L);
            l = GDK.gdk_pixbuf_get_from_texture((long)l5);
            OS.g_object_unref(l5);
            OS.g_object_unref(l2);
            OS.g_object_unref(l4);
        } else {
            l3 = GTK3.gtk_icon_theme_get_default();
            l = GTK3.gtk_icon_theme_load_icon((long)l3, (byte[])byArray, (int)48, (int)36, (long)0L);
        }
        if (l == 0L) {
            return null;
        }
        int n = GDK.gdk_pixbuf_get_width((long)l);
        int n2 = GDK.gdk_pixbuf_get_height((long)l);
        int n3 = GDK.gdk_pixbuf_get_rowstride((long)l);
        boolean bl = GDK.gdk_pixbuf_get_has_alpha((long)l);
        l2 = GDK.gdk_pixbuf_get_pixels((long)l);
        byte[] byArray2 = new byte[n3 * n2];
        C.memmove((byte[])byArray2, (long)l2, (long)byArray2.length);
        OS.g_object_unref(l);
        ImageData imageData = null;
        if (bl) {
            PaletteData paletteData = new PaletteData(-16777216, 0xFF0000, 65280);
            imageData = new ImageData(n, n2, 32, paletteData);
            byte[] byArray3 = new byte[n3 * n2];
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    byArray3[i * n + j] = byArray2[i * n3 + j * 4 + 3];
                    byArray2[i * n3 + j * 4 + 3] = 0;
                }
            }
            imageData.setAlphas(0, 0, n * n2, byArray3, 0);
        } else {
            PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(n, n2, 24, paletteData);
        }
        imageData.data = byArray2;
        imageData.bytesPerLine = n3;
        return new Image((Device)this, imageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (display != Displays[i]) continue;
                Display.Displays[i] = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
    }

    long emissionProc(long l, long l2, long l3, long l4) {
        long l5 = GTK.GTK4 ? GTK4.gtk_widget_get_native((long)OS.g_value_peek_pointer(l3)) : GTK3.gtk_widget_get_toplevel((long)OS.g_value_peek_pointer(l3));
        if (l5 == l4) {
            GTK.gtk_widget_set_direction((long)OS.g_value_peek_pointer(l3), (int)2);
        }
        return 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                Display display = Displays[i];
                if (display == null || display.thread != thread) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return display;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        for (int i = 0; i < this.disposeList.length; ++i) {
            if (this.disposeList[i] != null) continue;
            this.disposeList[i] = runnable;
            return;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    long eventProc(long l, long l2) {
        int n;
        if (Display.logger.level >= 7) {
            Logger.Builder builder = logger.build("eventProc(int,int)");
            (Display.logger.level < 8 ? builder : builder.add("event: ").add(l).add("time: ").add(GDK.gdk_event_get_time((long)l)).add(", data: ").add(l2)).log(7);
        }
        if ((n = GDK.gdk_event_get_time((long)l)) != 0) {
            this.lastEventTime = n;
        }
        int n2 = GTK.GTK4 ? GDK.gdk_event_get_event_type((long)l) : GDK.GDK_EVENT_TYPE((long)l);
        Control.fixGdkEventTypeValues(n2);
        if (Display.logger.level >= 9) {
            logger.build("eventProc(int,int)").add("eventType: ").add(n2).log(9);
        }
        switch (n2) {
            case 4: 
            case 8: {
                this.lastUserEventTime = n;
            }
        }
        boolean bl = true;
        if (Display.logger.level >= 9) {
            logger.build("eventProc(int,int)").add("dispatchEvents: ").addAll(this.dispatchEvents).log(9);
        }
        if (this.dispatchEvents != null) {
            bl = false;
            for (int i = 0; i < this.dispatchEvents.length; ++i) {
                if (n2 != this.dispatchEvents[i]) continue;
                bl = true;
                break;
            }
        }
        if (Display.logger.level >= 9) {
            logger.build("eventProc(int,int)").add("dispatch: ").add(bl).log(9);
        }
        if (!bl) {
            long l3 = GTK.GTK4 ? GDK.gdk_event_ref((long)l) : GDK.gdk_event_copy((long)l);
            this.addGdkEvent(l3);
            return 0L;
        }
        if (this.runGdkEventFilters(l, n2)) {
            if (Display.logger.level >= 9) {
                logger.log(9, "eventProc(int,int)", "Running gtk_main_do_event");
            }
            bl = true;
            if (this.tracker != null) {
                bl = this.tracker.processEvent(l);
            }
            if (bl) {
                GTK3.gtk_main_do_event((long)l);
            }
            if (Display.logger.level >= 9) {
                logger.log(9, "eventProc(int,int)", "Done running gtk_main_do_event");
            }
        }
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        return 0L;
    }

    public Widget findWidget(long l) {
        this.checkDevice();
        return this.getWidget(l);
    }

    public Widget findWidget(long l, long l2) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, long l) {
        this.checkDevice();
        return null;
    }

    static long rendererClassInitProc(long l, long l2) {
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l);
        if (GTK.GTK4) {
            gtkCellRendererClass.snapshot = rendererSnapshotProc;
        } else {
            gtkCellRendererClass.render = rendererRenderProc;
        }
        gtkCellRendererClass.get_preferred_width = rendererGetPreferredWidthProc;
        OS.memmove(l, gtkCellRendererClass);
        return 0L;
    }

    void snapshotDrawProc(long l, long l2) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l);
        if (widget != null) {
            widget.snapshotToDraw(l, l2);
        }
        long l3 = GTK4.gtk_widget_get_first_child((long)l);
        while (l3 != 0L) {
            GTK4.gtk_widget_snapshot_child((long)l, (long)l3, (long)l2);
            l3 = GTK4.gtk_widget_get_next_sibling((long)l3);
        }
    }

    static long rendererGetPreferredWidthProc(long l, long l2, long l3, long l4) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l2);
        if (widget != null) {
            return widget.rendererGetPreferredWidthProc(l, l2, l3, l4);
        }
        return 0L;
    }

    static long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l3);
        if (widget != null) {
            return widget.rendererRenderProc(l, l2, l3, l4, l5, l6);
        }
        return 0L;
    }

    static long rendererSnapshotProc(long l, long l2, long l3, long l4, long l5, long l6) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(l3);
        if (widget != null) {
            return widget.rendererSnapshotProc(l, l2, l3, l4, l5, l6);
        }
        return 0L;
    }

    void flushExposes(long l, boolean bl) {
        if (OS.isX11()) {
            this.flushWindow = l;
            this.flushAll = bl;
            long l2 = GDK.gdk_x11_display_get_xdisplay((long)GDK.gdk_display_get_default());
            long l3 = OS.g_malloc(XEvent.sizeof);
            OS.XCheckIfEvent(l2, l3, this.checkIfEventProc, 0L);
            OS.g_free(l3);
            this.flushWindow = 0L;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    public Rectangle getClientArea() {
        Rectangle rectangle;
        if (OS.isX11() && (rectangle = this.getWorkArea()) != null) {
            return rectangle;
        }
        return super.getClientArea();
    }

    Rectangle getBoundsInPixels() {
        this.checkDevice();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int n = 0;
        int n2 = 0;
        long l = GDK.gdk_display_get_default();
        int n3 = 0;
        long l2 = 0L;
        if (GTK.GTK4) {
            l2 = GDK.gdk_display_get_monitors((long)l);
            n3 = OS.g_list_model_get_n_items(l2);
        } else {
            n3 = GDK.gdk_display_get_n_monitors((long)l);
        }
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                long l3 = GTK.GTK4 ? OS.g_list_model_get_item(l2, i) : GDK.gdk_display_get_monitor((long)l, (int)i);
                GdkRectangle gdkRectangle = new GdkRectangle();
                GDK.gdk_monitor_get_geometry((long)l3, (GdkRectangle)gdkRectangle);
                if (gdkRectangle.x + gdkRectangle.width > n) {
                    n = gdkRectangle.x + gdkRectangle.width;
                }
                if (gdkRectangle.y + gdkRectangle.height <= n2) continue;
                n2 = gdkRectangle.y + gdkRectangle.height;
            }
            rectangle.width = n;
            rectangle.height = n2;
            return rectangle;
        }
        if (GTK.GTK4) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(0, 0, GDK.gdk_screen_width(), GDK.gdk_screen_height());
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getCaretBlinkTime() {
        long l = GTK.gtk_settings_get_default();
        if (l == 0L) {
            return 500;
        }
        int[] nArray = new int[1];
        OS.g_object_get(l, GTK.gtk_cursor_blink, nArray, 0L);
        if (nArray[0] == 0) {
            return 0;
        }
        OS.g_object_get(l, GTK.gtk_cursor_blink_time, nArray, 0L);
        if (nArray[0] == 0) {
            return 500;
        }
        return nArray[0] / 2;
    }

    long getClosure(int n) {
        if (this.closures[n] != 0L) {
            OS.g_closure_unref(this.closures[n]);
        }
        this.closures[n] = OS.g_cclosure_new(this.closuresProc[n], n, 0L);
        OS.g_closure_ref(this.closures[n]);
        OS.g_closure_sink(this.closures[n]);
        this.closuresCount[n] = 0;
        return this.closures[n];
    }

    public Control getCursorControl() {
        long l;
        Object object;
        Object object2;
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long l2 = 0L;
        long[] lArray = new long[1];
        if (GTK.GTK4) {
            object2 = new double[1];
            object = new double[1];
            l = this.gdk_device_get_surface_at_position((double[])object2, (double[])object);
            nArray[0] = (int)object2[0];
            nArray2[0] = (int)object[0];
        } else {
            l = this.gdk_device_get_window_at_position(nArray, nArray2);
        }
        if (l != 0L) {
            if (!GTK.GTK4) {
                GDK.gdk_window_get_user_data((long)l, (long[])lArray);
            }
            l2 = lArray[0];
        } else {
            long l3;
            if (!OS.isX11() || GTK.GTK4) {
                return null;
            }
            long l4 = GDK.gdk_display_get_default();
            if (OS.isX11()) {
                GDK.gdk_x11_display_error_trap_push((long)l4);
            }
            int[] nArray3 = new int[1];
            long[] lArray2 = new long[1];
            long[] lArray3 = new long[1];
            long l5 = OS.XDefaultRootWindow(this.xDisplay);
            do {
                if (OS.XQueryPointer(this.xDisplay, l5, lArray2, lArray3, nArray3, nArray3, nArray3, nArray3, nArray3) == 0) {
                    l2 = 0L;
                    break;
                }
                l3 = lArray3[0];
                if (l3 == 0L) continue;
                l5 = l3;
                long l6 = GDK.gdk_x11_window_lookup_for_display((long)l4, (long)l3);
                if (l6 == 0L) continue;
                GDK.gdk_window_get_user_data((long)l6, (long[])lArray);
                if (lArray[0] == 0L) continue;
                l2 = lArray[0];
            } while (l3 != 0L);
            if (OS.isX11()) {
                GDK.gdk_x11_display_error_trap_pop_ignored((long)l4);
            }
        }
        if (l2 == 0L) {
            return null;
        }
        do {
            if ((object2 = (Object)this.getWidget(l2)) == null || !(object2 instanceof Control) || !((Control)(object = (Object)((Control)object2))).isEnabled()) continue;
            return object;
        } while ((l2 = GTK.gtk_widget_get_parent((long)l2)) != 0L);
        return null;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int n = event.type;
            this.sendPreEvent(n);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(n);
            }
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    public Point getCursorLocation() {
        return DPIUtil.autoScaleDown(this.getCursorLocationInPixels());
    }

    Point getCursorLocationInPixels() {
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            double[] dArray = new double[1];
            double[] dArray2 = new double[1];
            this.getPointerPosition(dArray, dArray2);
            nArray[0] = (int)dArray[0];
            nArray2[0] = (int)dArray2[0];
        } else {
            this.getWindowPointerPosition(0L, nArray, nArray2, null);
            if (!OS.isX11() && this.activeShell != null) {
                Shell shell = this.activeShell;
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                while (shell.getParent() != null) {
                    GTK3.gtk_window_get_position((long)shell.shellHandle, (int[])nArray3, (int[])nArray4);
                    nArray[0] = nArray[0] + nArray3[0];
                    nArray2[0] = nArray2[0] + nArray4[0];
                    shell = shell.getParent().getShell();
                }
            }
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (string.equals(GET_MODAL_DIALOG)) {
            return this.modalDialog;
        }
        if (string.equals(GET_DIRECTION_PROC_KEY)) {
            return new LONG(this.setDirectionProc);
        }
        if (string.equals(GET_EMISSION_PROC_KEY)) {
            return new LONG(this.emissionProc);
        }
        if (this.keys == null) {
            return null;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            return this.values[i];
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    long gtk_fixed_get_type() {
        return fixed_type;
    }

    long gtk_cell_renderer_text_get_type() {
        return text_renderer_type;
    }

    long gtk_cell_renderer_pixbuf_get_type() {
        return pixbuf_renderer_type;
    }

    long gtk_cell_renderer_toggle_get_type() {
        return toggle_renderer_type;
    }

    String gtk_css_create_css_color_string(String string, String string2, int n) {
        switch (n) {
            case 16: {
                if (string2 != null && string != null) {
                    return string2 + "\n" + string;
                }
                if (string2 != null) {
                    return string2;
                }
                return "";
            }
            case 8: {
                if (string2 != null && string != null) {
                    return string + "\n" + string2;
                }
                if (string != null) {
                    return string;
                }
                return "";
            }
        }
        return "";
    }

    GdkRGBA gtk_css_parse_background(String string, String string2) {
        GdkRGBA gdkRGBA = new GdkRGBA();
        if (string.isEmpty()) {
            return this.COLOR_WIDGET_BACKGROUND_RGBA;
        }
        String string3 = "";
        if (string2 != null) {
            if (string.contains(string2)) {
                string3 = string.substring(string.indexOf(string2));
            }
        } else {
            string3 = string;
        }
        if (string3.isEmpty()) {
            return this.COLOR_WIDGET_BACKGROUND_RGBA;
        }
        if (string3.contains("background-color:")) {
            int n = string3.indexOf("background-color:");
            String string4 = string3.substring(n + 18);
            gdkRGBA = this.gtk_css_property_to_rgba(string4);
        } else if (string3.contains("background:")) {
            int n = string3.indexOf("background:");
            String string5 = string3.substring(n + 13);
            gdkRGBA = this.gtk_css_property_to_rgba(string5);
        }
        return gdkRGBA;
    }

    String gtk_css_provider_to_string(long l) {
        if (l == 0L) {
            return "";
        }
        long l2 = GTK.gtk_css_provider_to_string((long)l);
        if (l2 == 0L) {
            return "";
        }
        int n = C.strlen((long)l2);
        byte[] byArray = new byte[n];
        C.memmove((byte[])byArray, (long)l2, (long)n);
        OS.g_free(l2);
        return new String(Converter.mbcsToWcs((byte[])byArray));
    }

    GdkRGBA gtk_css_parse_foreground(String string, String string2) {
        if (string.isEmpty()) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        String string3 = "";
        if (string2 != null) {
            if (string.contains(string2)) {
                string3 = string.substring(string.indexOf(string2));
            }
        } else {
            string3 = string;
        }
        if (string3.isEmpty()) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        Matcher matcher = colorPattern.matcher(string3);
        if (!matcher.find()) {
            return this.COLOR_WIDGET_FOREGROUND_RGBA;
        }
        String string4 = matcher.group(1);
        gdkRGBA = this.gtk_css_property_to_rgba(string4);
        return gdkRGBA;
    }

    GdkRGBA gtk_css_property_to_rgba(String string) {
        GdkRGBA gdkRGBA = new GdkRGBA();
        String[] stringArray = new String[1];
        stringArray = string.split(";");
        GDK.gdk_rgba_parse((GdkRGBA)gdkRGBA, (byte[])Converter.wcsToMbcs((String)stringArray[0], (boolean)true));
        return gdkRGBA;
    }

    String gtk_rgba_to_css_string(GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2 = gdkRGBA != null ? gdkRGBA : this.COLOR_WIDGET_BACKGROUND_RGBA;
        long l = GDK.gdk_rgba_to_string((GdkRGBA)gdkRGBA2);
        int n = C.strlen((long)l);
        byte[] byArray = new byte[n];
        C.memmove((byte[])byArray, (long)l, (long)n);
        OS.g_free(l);
        return new String(Converter.mbcsToWcs((byte[])byArray));
    }

    String gtk_widget_get_name(long l) {
        String string;
        long l2 = GTK.gtk_widget_get_name((long)l);
        if (l2 == 0L) {
            string = "*";
        } else {
            int n = C.strlen((long)l2);
            byte[] byArray = new byte[n];
            C.memmove((byte[])byArray, (long)l2, (long)n);
            string = new String(Converter.mbcsToWcs((byte[])byArray));
        }
        return string;
    }

    String gtk_widget_class_get_css_name(long l) {
        String string;
        long l2 = GTK.gtk_widget_class_get_css_name((long)GTK.GTK_WIDGET_GET_CLASS((long)l));
        if (l2 == 0L) {
            string = "*";
        } else {
            int n = C.strlen((long)l2);
            byte[] byArray = new byte[n];
            C.memmove((byte[])byArray, (long)l2, (long)n);
            string = new String(Converter.mbcsToWcs((byte[])byArray));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    static boolean isValidClass(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        int[] nArray = new int[1];
        long l = GTK.gtk_settings_get_default();
        OS.g_object_get(l, GTK.gtk_alternative_button_order, nArray, 0L);
        return nArray[0] == 1 ? 16384 : 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        long l = GTK.gtk_settings_get_default();
        int[] nArray = new int[1];
        OS.g_object_get(l, GTK.gtk_double_click_time, nArray, 0L);
        return nArray[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        if (this.activeShell == null) {
            return null;
        }
        long l = this.activeShell.shellHandle;
        long l2 = GTK.gtk_window_get_focus((long)l);
        if (l2 == 0L) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(l2)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((l2 = GTK.gtk_widget_get_parent((long)l2)) != 0L);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getDepth() {
        this.checkDevice();
        if (GTK.GTK4) {
            return 32;
        }
        long l = GDK.gdk_screen_get_default();
        long l2 = GDK.gdk_screen_get_system_visual((long)l);
        return GDK.gdk_visual_get_depth((long)l2);
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public static boolean isSystemDarkTheme() {
        return themeDark;
    }

    public int getLastEventTime() {
        return this.lastEventTime;
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    Rectangle getWorkArea() {
        byte[] byArray = Converter.wcsToMbcs((String)"_NET_WORKAREA", (boolean)true);
        long l = GDK.gdk_atom_intern((byte[])byArray, (boolean)true);
        if (l == 0L) {
            return null;
        }
        long[] lArray = new long[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        long[] lArray2 = new long[1];
        if (!GDK.gdk_property_get((long)GDK.gdk_get_default_root_window(), (long)l, (long)0L, (long)0L, (long)16L, (int)0, (long[])lArray, (int[])nArray, (int[])nArray2, (long[])lArray2)) {
            return null;
        }
        Rectangle rectangle = null;
        if (lArray2[0] != 0L) {
            if (nArray2[0] == 16) {
                int[] nArray3 = new int[4];
                C.memmove((int[])nArray3, (long)lArray2[0], (long)16L);
                rectangle = new Rectangle(nArray3[0], nArray3[1], nArray3[2], nArray3[3]);
            } else if (nArray2[0] == 32) {
                long[] lArray3 = new long[4];
                C.memmove((long[])lArray3, (long)lArray2[0], (long)32L);
                rectangle = new Rectangle((int)lArray3[0], (int)lArray3[1], (int)lArray3[2], (int)lArray3[3]);
            }
            OS.g_free(lArray2[0]);
        }
        return rectangle;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        Monitor[] monitorArray = null;
        Rectangle rectangle = DPIUtil.autoScaleDown(this.getWorkArea());
        long l = GDK.gdk_display_get_default();
        if (l != 0L) {
            int n;
            long l2 = 0L;
            if (GTK.GTK4) {
                l2 = GDK.gdk_display_get_monitors((long)l);
                n = OS.g_list_model_get_n_items(l2);
            } else {
                n = GDK.gdk_display_get_n_monitors((long)l);
            }
            if (n > 0) {
                monitorArray = new Monitor[n];
                GdkRectangle gdkRectangle = new GdkRectangle();
                for (int i = 0; i < n; ++i) {
                    long l3 = GTK.GTK4 ? OS.g_list_model_get_item(l2, i) : GDK.gdk_display_get_monitor((long)l, (int)i);
                    GDK.gdk_monitor_get_geometry((long)l3, (GdkRectangle)gdkRectangle);
                    Monitor monitor = new Monitor();
                    monitor.handle = l3;
                    monitor.x = DPIUtil.autoScaleDown(gdkRectangle.x);
                    monitor.y = DPIUtil.autoScaleDown(gdkRectangle.y);
                    monitor.width = DPIUtil.autoScaleDown(gdkRectangle.width);
                    monitor.height = DPIUtil.autoScaleDown(gdkRectangle.height);
                    if (!OS.isX11()) {
                        int n2 = GDK.gdk_monitor_get_scale_factor((long)l3);
                        monitor.zoom = n2 * 100;
                    } else {
                        monitor.zoom = Display._getDeviceZoom(monitor.handle);
                    }
                    if (!GTK.GTK4) {
                        GDK.gdk_monitor_get_workarea((long)l3, (GdkRectangle)gdkRectangle);
                    }
                    monitor.clientX = DPIUtil.autoScaleDown(gdkRectangle.x);
                    monitor.clientY = DPIUtil.autoScaleDown(gdkRectangle.y);
                    monitor.clientWidth = DPIUtil.autoScaleDown(gdkRectangle.width);
                    monitor.clientHeight = DPIUtil.autoScaleDown(gdkRectangle.height);
                    monitorArray[i] = monitor;
                }
            }
        }
        if (monitorArray == null) {
            Monitor monitor = new Monitor();
            Rectangle rectangle2 = this.getBounds();
            monitor.x = rectangle2.x;
            monitor.y = rectangle2.y;
            monitor.width = rectangle2.width;
            monitor.height = rectangle2.height;
            if (rectangle != null) {
                monitor.clientX = rectangle.x;
                monitor.clientY = rectangle.y;
                monitor.clientWidth = rectangle.width;
                monitor.clientHeight = rectangle.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            monitorArray = new Monitor[]{monitor};
        }
        return monitorArray;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitorArray = this.getMonitors();
        int n = 0;
        if (GTK.GTK4) {
            n = 0;
        } else {
            long l = GDK.gdk_display_get_default();
            long l2 = GDK.gdk_display_get_primary_monitor((long)l);
            for (int i = 0; i < monitorArray.length; ++i) {
                long l3 = GDK.gdk_display_get_monitor((long)l, (int)i);
                if (l3 != l2) continue;
                n = i;
                break;
            }
        }
        return monitorArray[n];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        Shell[] shellArray = new Shell[16];
        for (int i = 0; i < this.widgetTable.length; ++i) {
            int n2;
            Widget widget = this.widgetTable[i];
            if (!(widget instanceof Shell)) continue;
            if (!widget.isDisposed()) {
                for (n2 = 0; n2 < n && shellArray[n2] != widget; ++n2) {
                }
                if (n2 != n) continue;
                if (n == shellArray.length) {
                    Shell[] shellArray2 = new Shell[n + 16];
                    System.arraycopy(shellArray, 0, shellArray2, 0, n);
                    shellArray = shellArray2;
                }
                shellArray[n++] = (Shell)widget;
                continue;
            }
            System.err.println("SWT ERROR: disposed shell detected in the table" + this.debugInfoForIndex(i));
            for (n2 = i; n2 < this.widgetTable.length; ++n2) {
                if (this.widgetTable[n2] != widget) continue;
                this.widgetTable[n2] = null;
            }
        }
        if (n == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n];
        System.arraycopy(shellArray, 0, shellArray3, 0, n);
        return shellArray3;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        GdkRGBA gdkRGBA = null;
        switch (n) {
            case 36: {
                gdkRGBA = this.copyRGBA(this.COLOR_LINK_FOREGROUND_RGBA);
                break;
            }
            case 28: {
                gdkRGBA = this.copyRGBA(this.COLOR_INFO_FOREGROUND_RGBA);
                break;
            }
            case 29: {
                gdkRGBA = this.copyRGBA(this.COLOR_INFO_BACKGROUND_RGBA);
                break;
            }
            case 30: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_FOREGROUND_RGBA);
                break;
            }
            case 31: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_BACKGROUND_RGBA);
                break;
            }
            case 32: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA);
                break;
            }
            case 33: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA);
                break;
            }
            case 34: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA);
                break;
            }
            case 35: {
                gdkRGBA = this.copyRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA);
                break;
            }
            case 17: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_DARK_SHADOW_RGBA);
                break;
            }
            case 18: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_NORMAL_SHADOW_RGBA);
                break;
            }
            case 19: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_LIGHT_SHADOW_RGBA);
                break;
            }
            case 20: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA);
                break;
            }
            case 22: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA);
                break;
            }
            case 21: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_FOREGROUND_RGBA);
                break;
            }
            case 23: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_BORDER_RGBA);
                break;
            }
            case 24: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_FOREGROUND_RGBA);
                break;
            }
            case 25: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_BACKGROUND_RGBA);
                break;
            }
            case 26: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_SELECTION_RGBA);
                break;
            }
            case 27: {
                gdkRGBA = this.copyRGBA(this.COLOR_LIST_SELECTION_TEXT_RGBA);
                break;
            }
            case 39: {
                gdkRGBA = this.copyRGBA(this.COLOR_WIDGET_DISABLED_FOREGROUND_RGBA);
                break;
            }
            case 38: {
                gdkRGBA = this.copyRGBA(this.COLOR_TEXT_DISABLED_BACKGROUND_RGBA);
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        if (gdkRGBA == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new((Device)this, (GdkRGBA)gdkRGBA);
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (0 > n || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor((Device)this, n);
        }
        return this.cursors[n];
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        switch (n) {
            case 1: {
                if (this.errorImage == null) {
                    this.errorImage = this.createImage("dialog-error-symbolic");
                }
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage == null) {
                    this.infoImage = this.createImage("dialog-information-symbolic");
                }
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage == null) {
                    this.questionImage = this.createImage("dialog-question-symbolic");
                }
                return this.questionImage;
            }
            case 8: {
                if (this.warningImage == null) {
                    this.warningImage = this.createImage("dialog-warning-symbolic");
                }
                return this.warningImage;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    GdkRGBA toGdkRGBA(GdkRGBA gdkRGBA, double d) {
        GdkRGBA gdkRGBA2 = new GdkRGBA();
        gdkRGBA2.alpha = gdkRGBA.alpha;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        if (GTK.GTK4) {
            float[] fArray = new float[1];
            float[] fArray2 = new float[1];
            float[] fArray3 = new float[1];
            GTK4.gtk_rgb_to_hsv((float)((float)gdkRGBA.red), (float)((float)gdkRGBA.green), (float)((float)gdkRGBA.blue), (float[])fArray, (float[])fArray2, (float[])fArray3);
            dArray[0] = fArray[0];
            dArray2[0] = fArray2[0];
            dArray3[0] = fArray3[0];
        } else {
            GTK3.gtk_rgb_to_hsv((double)gdkRGBA.red, (double)gdkRGBA.green, (double)gdkRGBA.blue, (double[])dArray, (double[])dArray2, (double[])dArray3);
        }
        double d2 = (2.0 - dArray2[0]) * dArray3[0] / 2.0;
        double d3 = dArray2[0] * dArray3[0];
        d3 /= d2 <= 1.0 ? d2 : 2.0 - d2;
        d3 = Math.max(0.0, Math.min(1.0, d3 * d));
        d2 = Math.max(0.0, Math.min(1.0, d2 * d));
        dArray3[0] = (d2 + (d3 *= d2 <= 1.0 ? d2 : 2.0 - (d2 *= 2.0))) / 2.0;
        dArray2[0] = 2.0 * d3 / (d2 + d3);
        if (GTK.GTK4) {
            float[] fArray = new float[1];
            float[] fArray4 = new float[1];
            float[] fArray5 = new float[1];
            GTK4.gtk_hsv_to_rgb((float)((float)dArray[0]), (float)((float)dArray2[0]), (float)((float)dArray3[0]), (float[])fArray, (float[])fArray4, (float[])fArray5);
            gdkRGBA2.red = fArray[0];
            gdkRGBA2.green = fArray4[0];
            gdkRGBA2.blue = fArray5[0];
        } else {
            GTK3.gtk_hsv_to_rgb((double)dArray[0], (double)dArray2[0], (double)dArray3[0], (double[])dArray, (double[])dArray2, (double[])dArray3);
            gdkRGBA2.red = dArray[0];
            gdkRGBA2.green = dArray2[0];
            gdkRGBA2.blue = dArray3[0];
        }
        return gdkRGBA2;
    }

    static int inversePremultipliedColor(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return (255 * n + n2 - 1) / n2;
    }

    private static void renderAllBackgrounds(long l, long l2) {
        long l3;
        if (!GTK.GTK4 && (l3 = GTK3.gtk_style_context_get_parent((long)l)) != 0L) {
            Display.renderAllBackgrounds(l3, l2);
        }
        GTK.gtk_render_background((long)l, (long)l2, (double)-50.0, (double)-50.0, (double)100.0, (double)100.0);
    }

    GdkRGBA styleContextEstimateBackgroundColor(long l, int n) {
        GTK.gtk_style_context_save((long)l);
        GTK.gtk_style_context_set_state((long)l, (long)n);
        long l2 = Cairo.cairo_image_surface_create((int)0, (int)1, (int)1);
        long l3 = Cairo.cairo_create((long)l2);
        Display.renderAllBackgrounds(l, l3);
        Cairo.cairo_fill((long)l3);
        Cairo.cairo_surface_flush((long)l2);
        byte[] byArray = new byte[4];
        C.memmove((byte[])byArray, (long)Cairo.cairo_image_surface_get_data((long)l2), (long)byArray.length);
        Cairo.cairo_surface_destroy((long)l2);
        Cairo.cairo_destroy((long)l3);
        GTK.gtk_style_context_restore((long)l);
        int n2 = Byte.toUnsignedInt(byArray[3]);
        int n3 = Byte.toUnsignedInt(byArray[2]);
        int n4 = Byte.toUnsignedInt(byArray[1]);
        int n5 = Byte.toUnsignedInt(byArray[0]);
        GdkRGBA gdkRGBA = new GdkRGBA();
        gdkRGBA.alpha = (float)n2 / 255.0f;
        gdkRGBA.red = (float)Display.inversePremultipliedColor(n3, n2) / 255.0f;
        gdkRGBA.green = (float)Display.inversePremultipliedColor(n4, n2) / 255.0f;
        gdkRGBA.blue = (float)Display.inversePremultipliedColor(n5, n2) / 255.0f;
        return gdkRGBA;
    }

    GdkRGBA copyRGBA(GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2 = new GdkRGBA();
        if (gdkRGBA != null) {
            gdkRGBA2.alpha = gdkRGBA.alpha;
            gdkRGBA2.red = gdkRGBA.red;
            gdkRGBA2.green = gdkRGBA.green;
            gdkRGBA2.blue = gdkRGBA.blue;
        }
        return gdkRGBA2;
    }

    void initializeSystemColors() {
        this.COLOR_WIDGET_DARK_SHADOW_RGBA = new GdkRGBA();
        this.COLOR_WIDGET_DARK_SHADOW_RGBA.alpha = 1.0;
        this.initializeNamedColorList();
        long l = GTK.gtk_widget_get_style_context((long)this.shellHandle);
        this.initializeSystemColorsWidget(l);
        this.initializeSystemColorsList(l);
        this.initializeSystemColorsTitle(l);
        this.initializeSystemColorsLink();
        this.initializeSystemColorsTooltip();
        this.initializeSystemColorsToggleButton();
        this.initializeSystemColorsDisabled();
        this.COLOR_TITLE_FOREGROUND_RGBA = this.COLOR_LIST_SELECTION_TEXT_RGBA;
        this.COLOR_TITLE_BACKGROUND_RGBA = this.COLOR_LIST_SELECTION_RGBA;
        this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA = this.toGdkRGBA(this.COLOR_LIST_SELECTION_RGBA, 1.3);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA = this.toGdkRGBA(this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA, 1.3);
    }

    void initializeSystemColorsWidget(long l) {
        this.COLOR_WIDGET_FOREGROUND_RGBA = this.styleContextGetColor(l, 0);
        this.COLOR_WIDGET_LIGHT_SHADOW_RGBA = this.COLOR_WIDGET_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(l, 0);
        this.COLOR_WIDGET_NORMAL_SHADOW_RGBA = this.toGdkRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA, 0.7);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA = this.toGdkRGBA(this.COLOR_WIDGET_BACKGROUND_RGBA, 1.3);
    }

    void initializeSystemColorsList(long l) {
        GTK.gtk_style_context_save((long)l);
        GTK.gtk_style_context_add_class((long)l, (byte[])GTK.GTK_STYLE_CLASS_VIEW);
        GTK.gtk_style_context_add_class((long)l, (byte[])GTK.GTK_STYLE_CLASS_CELL);
        if (!GTK.GTK4) {
            GTK3.gtk_style_context_invalidate((long)l);
        }
        this.COLOR_LIST_FOREGROUND_RGBA = this.styleContextGetColor(l, 0);
        this.COLOR_LIST_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(l, 0);
        this.COLOR_LIST_SELECTION_TEXT_RGBA = this.styleContextGetColor(l, 36);
        this.COLOR_LIST_SELECTION_RGBA = this.styleContextEstimateBackgroundColor(l, 36);
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA = this.styleContextGetColor(l, 68);
        this.COLOR_LIST_SELECTION_INACTIVE_RGBA = this.styleContextEstimateBackgroundColor(l, 68);
        GTK.gtk_style_context_restore((long)l);
    }

    void initializeSystemColorsTitle(long l) {
        long l2 = OS.g_object_new(GTK.gtk_label_get_type(), 0L);
        OS.g_object_ref_sink(l2);
        long l3 = GTK.gtk_widget_get_style_context((long)l2);
        this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA = this.styleContextGetColor(l3, 8);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(l, 8);
        OS.g_object_unref(l2);
    }

    private void initializeSystemColorsLink() {
        long l = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new((int)0);
        long l2 = GTK.gtk_label_new(null);
        if (GTK.GTK4) {
            GTK4.gtk_window_set_child((long)l, (long)l2);
        } else {
            GTK3.gtk_container_add((long)l, (long)l2);
        }
        long l3 = GTK.gtk_widget_get_style_context((long)l2);
        this.COLOR_LINK_FOREGROUND_RGBA = this.styleContextGetColor(l3, 512);
        if (GTK.GTK4) {
            GTK4.gtk_window_destroy((long)l);
        } else {
            GTK3.gtk_widget_destroy((long)l);
        }
    }

    void initializeSystemColorsTooltip() {
        long l = OS.g_object_new(GTK.gtk_tooltip_get_type(), 0L);
        long l2 = OS.g_object_new(GTK.gtk_label_get_type(), 0L);
        GTK.gtk_tooltip_set_custom((long)l, (long)l2);
        long l3 = GTK.gtk_widget_get_style_context((long)l2);
        this.COLOR_INFO_FOREGROUND_RGBA = this.styleContextGetColor(l3, 0);
        this.COLOR_INFO_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(l3, 0);
        OS.g_object_unref(l);
    }

    void initializeSystemColorsToggleButton() {
        long l = GTK.gtk_check_button_new();
        OS.g_object_ref_sink(l);
        long l2 = GTK.gtk_widget_get_style_context((long)l);
        this.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA = this.styleContextGetColor(l2, 0);
        OS.g_object_unref(l);
    }

    void initializeSystemColorsDisabled() {
        long l = GTK.GTK4 ? GTK4.gtk_window_new() : GTK3.gtk_window_new((int)0);
        long l2 = GTK.gtk_entry_new();
        if (GTK.GTK4) {
            GTK4.gtk_window_set_child((long)l, (long)l2);
        } else {
            GTK3.gtk_container_add((long)l, (long)l2);
        }
        long l3 = GTK.gtk_widget_get_style_context((long)l2);
        this.COLOR_WIDGET_DISABLED_FOREGROUND_RGBA = this.styleContextGetColor(l3, 8);
        this.COLOR_TEXT_DISABLED_BACKGROUND_RGBA = this.styleContextEstimateBackgroundColor(l3, 8);
        if (GTK.GTK4) {
            GTK4.gtk_window_destroy((long)l);
        } else {
            GTK3.gtk_widget_destroy((long)l);
        }
    }

    GdkRGBA styleContextGetColor(long l, int n) {
        GdkRGBA gdkRGBA = new GdkRGBA();
        if (GTK.GTK4) {
            GTK4.gtk_style_context_get_color((long)l, (GdkRGBA)gdkRGBA);
        } else {
            GTK.gtk_style_context_save((long)l);
            GTK.gtk_style_context_set_state((long)l, (long)n);
            GTK3.gtk_style_context_get_color((long)l, (int)n, (GdkRGBA)gdkRGBA);
            GTK.gtk_style_context_restore((long)l);
        }
        return gdkRGBA;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        return false;
    }

    Widget getWidget(long l) {
        if (l == 0L) {
            return null;
        }
        if (this.lastWidget != null && this.lastHandle == l) {
            return this.lastWidget;
        }
        long l2 = OS.g_object_get_qdata(l, SWT_OBJECT_INDEX) - 1L;
        if (0L <= l2 && l2 < (long)this.widgetTable.length) {
            this.lastHandle = l;
            this.lastWidget = this.widgetTable[(int)l2];
            return this.lastWidget;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long idleProc(long l) {
        boolean bl = this.runAsyncMessages(false);
        if (!bl) {
            Object object = this.idleLock;
            synchronized (object) {
                this.idleHandle = 0;
            }
        }
        return bl ? 1L : 0L;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSubclasses();
        this.initializeSystemColors();
        this.initializeSystemSettings();
        this.initializeWidgetTable();
        this.initializeSessionManager();
    }

    void initializeCallbacks() {
        this.closures = new long[109];
        this.closuresCount = new int[109];
        this.closuresProc = new long[109];
        this.signalIds = new int[109];
        this.signalIds[2] = OS.g_signal_lookup(OS.button_press_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[4] = OS.g_signal_lookup(OS.button_release_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[10] = OS.g_signal_lookup(OS.configure_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[11] = OS.g_signal_lookup(OS.delete_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[14] = OS.g_signal_lookup(OS.enter_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[16] = OS.g_signal_lookup(OS.event_after, GTK.GTK_TYPE_WIDGET());
        this.signalIds[18] = OS.g_signal_lookup(OS.draw, GTK.GTK_TYPE_WIDGET());
        this.signalIds[19] = OS.g_signal_lookup(OS.draw, GTK.GTK_TYPE_WIDGET());
        this.signalIds[20] = OS.g_signal_lookup(OS.focus, GTK.GTK_TYPE_WIDGET());
        this.signalIds[21] = OS.g_signal_lookup(OS.focus_in_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[22] = OS.g_signal_lookup(OS.focus_out_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[23] = OS.g_signal_lookup(OS.grab_focus, GTK.GTK_TYPE_WIDGET());
        this.signalIds[24] = OS.g_signal_lookup(OS.hide, GTK.GTK_TYPE_WIDGET());
        this.signalIds[27] = OS.g_signal_lookup(OS.key_press_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[28] = OS.g_signal_lookup(OS.key_release_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[29] = OS.g_signal_lookup(OS.leave_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[30] = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
        this.signalIds[31] = OS.g_signal_lookup(OS.map_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[32] = OS.g_signal_lookup(OS.mnemonic_activate, GTK.GTK_TYPE_WIDGET());
        this.signalIds[33] = OS.g_signal_lookup(OS.motion_notify_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[108] = OS.g_signal_lookup(OS.compute_size, GTK.GTK_TYPE_WIDGET());
        if (OS.SWT_MENU_LOCATION_DEBUGGING) {
            long l = GTK3.GTK_TYPE_MENU();
            OS.g_type_class_ref(l);
            this.signalIds[85] = OS.g_signal_lookup(OS.popped_up, l);
        } else {
            this.signalIds[85] = 0;
        }
        this.signalIds[38] = OS.g_signal_lookup(OS.popup_menu, GTK.GTK_TYPE_WIDGET());
        this.signalIds[40] = OS.g_signal_lookup(OS.realize, GTK.GTK_TYPE_WIDGET());
        this.signalIds[43] = OS.g_signal_lookup(OS.scroll_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[45] = OS.g_signal_lookup(OS.show, GTK.GTK_TYPE_WIDGET());
        if (!GTK.GTK4) {
            this.signalIds[46] = OS.g_signal_lookup(OS.show_help, GTK.GTK_TYPE_WIDGET());
        }
        if (!GTK.GTK4) {
            this.signalIds[47] = OS.g_signal_lookup(OS.size_allocate, GTK.GTK_TYPE_WIDGET());
        }
        this.signalIds[48] = OS.g_signal_lookup(OS.style_updated, GTK.GTK_TYPE_WIDGET());
        this.signalIds[54] = OS.g_signal_lookup(OS.unmap, GTK.GTK_TYPE_WIDGET());
        this.signalIds[55] = OS.g_signal_lookup(OS.unmap_event, GTK.GTK_TYPE_WIDGET());
        this.signalIds[56] = OS.g_signal_lookup(OS.realize, GTK.GTK_TYPE_WIDGET());
        this.signalIds[59] = OS.g_signal_lookup(OS.window_state_event, GTK.GTK_TYPE_WIDGET());
        this.windowCallback2 = new Callback((Object)this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (GTK.GTK4) {
            this.snapshotDraw = new Callback((Object)this, "snapshotDrawProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.snapshotDrawProc = this.snapshotDraw.getAddress();
            this.keyPressReleaseCallback = new Callback((Object)this, "keyPressReleaseProc", Boolean.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE});
            this.keyPressReleaseProc = this.keyPressReleaseCallback.getAddress();
            this.focusCallback = new Callback((Object)this, "focusProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.focusProc = this.focusCallback.getAddress();
            this.windowActiveCallback = new Callback((Object)this, "windowActiveProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.windowActiveProc = this.windowActiveCallback.getAddress();
            this.enterMotionCallback = new Callback((Object)this, "enterMotionProc", Void.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
            this.enterMotionProc = this.enterMotionCallback.getAddress();
            this.scrollCallback = new Callback((Object)this, "scrollProc", Boolean.TYPE, new Type[]{Long.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
            this.scrollProc = this.scrollCallback.getAddress();
            this.gesturePressReleaseCallback = new Callback((Object)this, "gesturePressReleaseProc", Void.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Long.TYPE});
            this.gesturePressReleaseProc = this.gesturePressReleaseCallback.getAddress();
            this.leaveCallback = new Callback((Object)this, "leaveProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE});
            this.leaveProc = this.leaveCallback.getAddress();
            this.resizeCallback = new Callback((Object)this, "resizeProc", Void.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Integer.TYPE});
            this.resizeProc = this.resizeCallback.getAddress();
            this.activateCallback = new Callback((Object)this, "activateProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            this.activateProc = this.activateCallback.getAddress();
            this.computeSizeCallback = new Callback((Object)this, "computeSizeProc", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            this.computeSizeProc = this.computeSizeCallback.getAddress();
        }
        this.notifyCallback = new Callback((Object)this, "notifyProc", Long.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        this.closuresProc[102] = this.notifyProc = this.notifyCallback.getAddress();
        this.closuresProc[104] = this.notifyProc;
        this.closuresProc[1] = this.windowProc2;
        this.closuresProc[60] = this.windowProc2;
        this.closuresProc[6] = this.windowProc2;
        this.closuresProc[8] = this.windowProc2;
        this.closuresProc[99] = this.windowProc2;
        this.closuresProc[83] = this.windowProc2;
        this.closuresProc[61] = this.windowProc2;
        this.closuresProc[66] = this.windowProc2;
        this.closuresProc[24] = this.windowProc2;
        this.closuresProc[23] = this.windowProc2;
        this.closuresProc[30] = this.windowProc2;
        this.closuresProc[62] = this.windowProc2;
        this.closuresProc[36] = this.windowProc2;
        this.closuresProc[38] = this.windowProc2;
        this.closuresProc[39] = this.windowProc2;
        this.closuresProc[40] = this.windowProc2;
        this.closuresProc[44] = this.windowProc2;
        this.closuresProc[68] = this.windowProc2;
        this.closuresProc[45] = this.windowProc2;
        this.closuresProc[69] = this.windowProc2;
        this.closuresProc[48] = this.windowProc2;
        this.closuresProc[57] = this.windowProc2;
        this.closuresProc[54] = this.windowProc2;
        this.closuresProc[56] = this.windowProc2;
        this.closuresProc[70] = this.windowProc2;
        this.closuresProc[71] = this.windowProc2;
        this.closuresProc[72] = this.windowProc2;
        this.closuresProc[73] = this.windowProc2;
        this.closuresProc[74] = this.windowProc2;
        this.closuresProc[75] = this.windowProc2;
        this.closuresProc[76] = this.windowProc2;
        this.closuresProc[77] = this.windowProc2;
        this.windowCallback3 = new Callback((Object)this, "windowProc", 3);
        this.closuresProc[2] = this.windowProc3 = this.windowCallback3.getAddress();
        this.closuresProc[3] = this.windowProc3;
        this.closuresProc[4] = this.windowProc3;
        this.closuresProc[5] = this.windowProc3;
        this.closuresProc[9] = this.windowProc3;
        this.closuresProc[10] = this.windowProc3;
        this.closuresProc[11] = this.windowProc3;
        this.closuresProc[14] = this.windowProc3;
        this.closuresProc[16] = this.windowProc3;
        this.closuresProc[18] = this.windowProc3;
        this.closuresProc[19] = this.windowProc3;
        this.closuresProc[20] = this.windowProc3;
        this.closuresProc[21] = this.windowProc3;
        this.closuresProc[22] = this.windowProc3;
        this.closuresProc[27] = this.windowProc3;
        this.closuresProc[28] = this.windowProc3;
        this.closuresProc[25] = this.windowProc3;
        this.closuresProc[29] = this.windowProc3;
        this.closuresProc[31] = this.windowProc3;
        this.closuresProc[32] = this.windowProc3;
        this.closuresProc[33] = this.windowProc3;
        this.closuresProc[34] = this.windowProc3;
        this.closuresProc[35] = this.windowProc3;
        this.closuresProc[37] = this.windowProc3;
        this.closuresProc[43] = this.windowProc3;
        this.closuresProc[46] = this.windowProc3;
        this.closuresProc[47] = this.windowProc3;
        this.closuresProc[53] = this.windowProc3;
        this.closuresProc[55] = this.windowProc3;
        this.closuresProc[59] = this.windowProc3;
        this.closuresProc[82] = this.windowProc3;
        this.windowCallback4 = new Callback((Object)this, "windowProc", 4);
        this.closuresProc[12] = this.windowProc4 = this.windowCallback4.getAddress();
        this.closuresProc[13] = this.windowProc4;
        this.closuresProc[67] = this.windowProc4;
        this.closuresProc[41] = this.windowProc4;
        this.closuresProc[42] = this.windowProc4;
        this.closuresProc[63] = this.windowProc4;
        this.closuresProc[49] = this.windowProc4;
        this.closuresProc[50] = this.windowProc4;
        this.closuresProc[51] = this.windowProc4;
        this.closuresProc[84] = this.windowProc4;
        this.closuresProc[78] = this.windowProc4;
        this.closuresProc[79] = this.windowProc4;
        this.closuresProc[103] = this.windowProc4;
        this.windowCallback5 = new Callback((Object)this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        this.changeValue = new Callback((Object)this, "changeValue", Boolean.TYPE, new Type[]{Long.TYPE, Integer.TYPE, Double.TYPE, Long.TYPE});
        this.closuresProc[7] = this.changeValueProc = this.changeValue.getAddress();
        this.closuresProc[17] = this.windowProc5;
        this.closuresProc[26] = this.windowProc5;
        this.closuresProc[52] = this.windowProc5;
        this.closuresProc[80] = this.windowProc5;
        this.closuresProc[81] = this.windowProc5;
        if (this.signalIds[85] != 0) {
            this.windowCallback6 = new Callback((Object)this, "windowProc", 6);
            this.closuresProc[85] = this.windowProc6 = this.windowCallback6.getAddress();
        }
        for (int i = 0; i < 109; ++i) {
            if (this.closuresProc[i] != 0L) {
                this.closures[i] = OS.g_cclosure_new(this.closuresProc[i], i, 0L);
            }
            if (this.closures[i] == 0L) continue;
            OS.g_closure_ref(this.closures[i]);
            OS.g_closure_sink(this.closures[i]);
        }
        this.timerCallback = new Callback((Object)this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        this.windowTimerCallback = new Callback((Object)this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        this.mouseHoverCallback = new Callback((Object)this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        this.caretCallback = new Callback((Object)this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        this.sizeAllocateCallback = new Callback((Object)this, "sizeAllocateProc", 3);
        this.sizeAllocateProc = this.sizeAllocateCallback.getAddress();
        this.sizeRequestCallback = new Callback((Object)this, "sizeRequestProc", 3);
        this.sizeRequestProc = this.sizeRequestCallback.getAddress();
        this.shellMapCallback = new Callback((Object)this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        this.shellMapProcClosure = OS.g_cclosure_new(this.shellMapProc, 0L, 0L);
        OS.g_closure_ref(this.shellMapProcClosure);
        this.cellDataCallback = new Callback((Object)this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        this.setDirectionCallback = new Callback((Object)this, "setDirectionProc", 2);
        this.setDirectionProc = this.setDirectionCallback.getAddress();
        this.emissionProcCallback = new Callback((Object)this, "emissionProc", 4);
        this.emissionProc = this.emissionProcCallback.getAddress();
        this.allChildrenCallback = new Callback((Object)this, "allChildrenProc", 2);
        this.allChildrenProc = this.allChildrenCallback.getAddress();
        this.checkIfEventCallback = new Callback((Object)this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        this.idleCallback = new Callback((Object)this, "idleProc", 1);
        this.idleProc = this.idleCallback.getAddress();
    }

    void initializeNamedColorList() {
        this.colorList = new ArrayList();
        this.colorList.add("black");
        this.colorList.add("darkred");
        this.colorList.add("darkgreen");
        this.colorList.add("darkyellow");
        this.colorList.add("darkblue");
        this.colorList.add("darkmagenta");
        this.colorList.add("darkcyan");
        this.colorList.add("darkgray");
        this.colorList.add("gray");
        this.colorList.add("red");
        this.colorList.add("green");
        this.colorList.add("yellow");
        this.colorList.add("blue");
        this.colorList.add("magenta");
        this.colorList.add("cyan");
        this.colorList.add("white");
    }

    void initializeSubclasses() {
        if (!GTK.GTK4) {
            long l = OS.PANGO_TYPE_LAYOUT();
            long l2 = OS.g_type_class_ref(l);
            this.pangoLayoutNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l2);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l2, OS.pangoLayoutNewProc_CALLBACK(this.pangoLayoutNewProc));
            OS.g_type_class_unref(l2);
            long l3 = GTK.GTK_TYPE_IM_MULTICONTEXT();
            long l4 = OS.g_type_class_ref(l3);
            this.imContextNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l4);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l4, OS.imContextNewProc_CALLBACK(this.imContextNewProc));
            OS.g_type_class_unref(l4);
            long l5 = OS.PANGO_TYPE_FONT_FAMILY();
            long l6 = OS.g_type_class_ref(l5);
            this.pangoFontFamilyNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l6);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l6, OS.pangoFontFamilyNewProc_CALLBACK(this.pangoFontFamilyNewProc));
            OS.g_type_class_unref(l6);
            long l7 = OS.PANGO_TYPE_FONT_FACE();
            long l8 = OS.g_type_class_ref(l7);
            this.pangoFontFaceNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l8);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l8, OS.pangoFontFaceNewProc_CALLBACK(this.pangoFontFaceNewProc));
            OS.g_type_class_unref(l8);
            long l9 = GTK.gtk_printer_option_widget_get_type();
            long l10 = OS.g_type_class_ref(l9);
            this.printerOptionWidgetNewProc = OS.G_OBJECT_CLASS_CONSTRUCTOR(l10);
            OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l10, OS.printerOptionWidgetNewProc_CALLBACK(this.printerOptionWidgetNewProc));
            OS.g_type_class_unref(l10);
        }
    }

    void initializeSystemSettings() {
        if (!GTK.GTK4) {
            OS.g_signal_connect(this.shellHandle, OS.style_updated, this.signalProc, 1L);
            OS.g_signal_connect(GTK.gtk_settings_get_default(), OS.notify_theme_change, this.signalProc, 1L);
        }
        int[] nArray = new int[1];
        long l = GTK.gtk_settings_get_default();
        OS.g_object_get(l, GTK.gtk_entry_select_on_focus, nArray, 0L);
        this.entrySelectOnFocus = nArray[0] != 0;
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        for (int i = 0; i < 1023; ++i) {
            this.indexTable[i] = i + 1;
        }
        this.indexTable[1023] = -1;
    }

    void initializeSessionManager() {
        this.sessionManagerDBus = new SessionManagerDBus();
        this.sessionManagerListener = new SessionManagerListener(this);
        this.sessionManagerDBus.addListener((SessionManagerDBus.IListener)this.sessionManagerListener);
    }

    public static String extractFreeGError(long l) {
        long l2 = OS.g_error_get_message(l);
        String string = Converter.cCharPtrToJavaString((long)l2, (boolean)false);
        OS.g_error_free(l);
        return string;
    }

    void releaseSessionManager() {
        if (this.sessionManagerDBus != null) {
            this.sessionManagerDBus.dispose();
            this.sessionManagerDBus = null;
        }
        this.sessionManagerListener = null;
    }

    public void internal_dispose_GC(long l, GCData gCData) {
        Cairo.cairo_destroy((long)l);
    }

    public long internal_new_GC(GCData gCData) {
        if (this.isDisposed()) {
            this.error(45);
        }
        long l = 0L;
        long l2 = 0L;
        if (GTK.GTK4) {
            long l3 = Cairo.cairo_image_surface_create((int)2, (int)gCData.width, (int)gCData.height);
            l = Cairo.cairo_create((long)l3);
        } else {
            l2 = GDK.gdk_get_default_root_window();
            l = GDK.gdk_cairo_create((long)l2);
        }
        if (l == 0L) {
            this.error(2);
        }
        if (gCData != null) {
            int n = 0x6000000;
            if ((gCData.style & n) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.drawable = l2;
            gCData.backgroundRGBA = this.getSystemColor((int)1).handle;
            gCData.foregroundRGBA = this.getSystemColor((int)2).handle;
            gCData.font = this.getSystemFont();
        }
        return l;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point2 = new Point(n, n2);
        if (control == control2) {
            return point2;
        }
        if (control != null) {
            point = DPIUtil.autoScaleDown(GTK.GTK4 ? control.getSurfaceOrigin() : control.getWindowOrigin());
            if ((control.style & 0x8000000) != 0) {
                point2.x = DPIUtil.autoScaleDown(control.getClientWidth()) - point2.x;
            }
            point2.x += point.x;
            point2.y += point.y;
        }
        if (control2 != null) {
            point = DPIUtil.autoScaleDown(GTK.GTK4 ? control2.getSurfaceOrigin() : control2.getWindowOrigin());
            point2.x -= point.x;
            point2.y -= point.y;
            if ((control2.style & 0x8000000) != 0) {
                point2.x = DPIUtil.autoScaleDown(control2.getClientWidth()) - point2.x;
            }
        }
        return point2;
    }

    Point mapInPixels(Control control, Control control2, int n, int n2) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point2 = new Point(n, n2);
        if (control == control2) {
            return point2;
        }
        if (control != null) {
            Point point3 = point = GTK.GTK4 ? control.getSurfaceOrigin() : control.getWindowOrigin();
            if ((control.style & 0x8000000) != 0) {
                point2.x = control.getClientWidth() - point2.x;
            }
            point2.x += point.x;
            point2.y += point.y;
        }
        if (control2 != null) {
            point = GTK.GTK4 ? control2.getSurfaceOrigin() : control2.getWindowOrigin();
            point2.x -= point.x;
            point2.y -= point.y;
            if ((control2.style & 0x8000000) != 0) {
                point2.x = control2.getClientWidth() - point2.x;
            }
        }
        return point2;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    Rectangle mapInPixels(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.mapInPixels(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (control != null) {
            point = DPIUtil.autoScaleDown(GTK.GTK4 ? control.getSurfaceOrigin() : control.getWindowOrigin());
            bl = (control.style & 0x8000000) != 0;
            if (bl) {
                rectangle.x = DPIUtil.autoScaleDown(control.getClientWidth()) - rectangle.x;
            }
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        if (control2 != null) {
            point = DPIUtil.autoScaleDown(GTK.GTK4 ? control2.getSurfaceOrigin() : control2.getWindowOrigin());
            rectangle.x -= point.x;
            rectangle.y -= point.y;
            bl2 = (control2.style & 0x8000000) != 0;
            if (bl2) {
                rectangle.x = DPIUtil.autoScaleDown(control2.getClientWidth()) - rectangle.x;
            }
        }
        if (bl != bl2) {
            rectangle.x -= rectangle.width;
        }
        return rectangle;
    }

    Rectangle mapInPixels(Control control, Control control2, int n, int n2, int n3, int n4) {
        Point point;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        if (GTK.GTK4) {
            return new Rectangle(n, n2, 0, 0);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (control != null) {
            point = control.getWindowOrigin();
            bl = (control.style & 0x8000000) != 0;
            if (bl) {
                rectangle.x = control.getClientWidth() - rectangle.x;
            }
            rectangle.x += point.x;
            rectangle.y += point.y;
        }
        if (control2 != null) {
            point = control2.getWindowOrigin();
            rectangle.x -= point.x;
            rectangle.y -= point.y;
            bl2 = (control2.style & 0x8000000) != 0;
            if (bl2) {
                rectangle.x = control2.getClientWidth() - rectangle.x;
            }
        }
        if (bl != bl2) {
            rectangle.x -= rectangle.width;
        }
        return rectangle;
    }

    long mouseHoverProc(long l) {
        Widget widget = this.getWidget(l);
        this.mouseHoverId = 0;
        if (widget == null) {
            return 0L;
        }
        return widget.hoverProc(l);
    }

    long findFocusedWindow() {
        long l = 0L;
        long l2 = GDK.gdk_window_get_children((long)GDK.gdk_get_default_root_window());
        if (l2 != 0L) {
            long l3 = l2;
            while (l3 != 0L) {
                long l4 = OS.g_list_data(l3);
                int n = GDK.gdk_window_get_state((long)l4);
                if ((n & 0x80) != 0 && (n & 1) == 0) {
                    l = l4;
                    OS.g_object_ref(l);
                    break;
                }
                l3 = OS.g_list_next(l3);
            }
            OS.g_list_free(l2);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event) {
        if (GTK.GTK4) {
            return false;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int n;
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            if ((n = event.type) == 5) {
                Rectangle rectangle = DPIUtil.autoScaleUp(event.getBounds());
                this.setCursorLocationInPixels(new Point(rectangle.x, rectangle.y));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            long l = GDK.gdk_display_get_default();
            long l2 = GDK.gdk_display_get_default_seat((long)l);
            switch (n) {
                case 1: 
                case 2: {
                    boolean bl;
                    int n2;
                    long l3 = this.findFocusedWindow();
                    if (l3 == 0L) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    int n3 = n2 = n == 1 ? 1024 : 2048;
                    if (this.cachedModifierState != 0) {
                        n2 |= this.cachedModifierState;
                    }
                    int n4 = 1;
                    int n5 = event.stateMask != 0 ? event.stateMask : event.keyCode;
                    switch (n5) {
                        case 131072: {
                            n2 |= 1;
                            break;
                        }
                        case 65536: {
                            n2 |= 8;
                            break;
                        }
                        case 262144: {
                            n2 |= 4;
                            break;
                        }
                        case 32768: {
                            n2 |= 0x80;
                            break;
                        }
                        default: {
                            n4 = this.cachedModifierState == 0 ? 0 : 1;
                        }
                    }
                    this.cachedModifierState = n4 == 1 && n == 1 ? n2 & 0xFFFFFFFF : 0;
                    int n6 = 0;
                    int n7 = Display.untranslateKey(event.keyCode);
                    if (n7 == 0) {
                        n7 = event.character;
                    }
                    long[] lArray = new long[1];
                    int[] nArray = new int[1];
                    int[] nArray2 = new int[1];
                    int[] nArray3 = new int[1];
                    int[] nArray4 = new int[1];
                    int[] nArray5 = new int[1];
                    int n8 = n7;
                    long l4 = 0L;
                    if (GTK.GTK4) {
                        bl = GDK.gdk_display_map_keyval((long)l, (int)n7, (long[])lArray, (int[])nArray);
                    } else {
                        l4 = GDK.gdk_keymap_get_for_display((long)l);
                        bl = GDK.gdk_keymap_get_entries_for_keyval((long)l4, (int)n7, (long[])lArray, (int[])nArray);
                    }
                    if (bl) {
                        GdkKeymapKey gdkKeymapKey = new GdkKeymapKey();
                        if (nArray[0] > 0) {
                            OS.memmove(gdkKeymapKey, lArray[0], (long)GdkKeymapKey.sizeof);
                            n6 = gdkKeymapKey.keycode;
                        }
                        OS.g_free(lArray[0]);
                        GDK.gdk_keymap_translate_keyboard_state((long)l4, (int)n6, (int)n2, (int)0, (int[])nArray2, (int[])nArray3, (int[])nArray4, (int[])nArray5);
                        if (n4 == 1) {
                            n8 = nArray2[0];
                        }
                    }
                    long l5 = GDK.gdk_event_new((int)(n == 1 ? 8 : 9));
                    GdkEventKey gdkEventKey = new GdkEventKey();
                    gdkEventKey.type = n == 1 ? 8 : 9;
                    gdkEventKey.window = l3;
                    gdkEventKey.send_event = 1;
                    gdkEventKey.time = 0;
                    gdkEventKey.keyval = n8;
                    gdkEventKey.state = n2;
                    gdkEventKey.hardware_keycode = (short)n6;
                    gdkEventKey.group = (byte)nArray3[0];
                    gdkEventKey.is_modifier = n4;
                    GTK3.memmove((long)l5, (GdkEventKey)gdkEventKey, (long)GdkEventKey.sizeof);
                    GDK.gdk_event_set_device((long)l5, (long)GDK.gdk_seat_get_keyboard((long)l2));
                    if (GTK.GTK4) {
                        GDK.gdk_display_put_event((long)l, (long)l5);
                    } else {
                        GDK.gdk_event_put((long)l5);
                    }
                    if (GTK.GTK4) {
                        GDK.gdk_event_unref((long)l5);
                    } else {
                        GDK.gdk_event_free((long)l5);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                case 3: 
                case 4: {
                    int[] nArray = new int[1];
                    int[] nArray6 = new int[1];
                    int[] nArray7 = new int[1];
                    long l6 = GDK.gdk_seat_get_pointer((long)l2);
                    long l7 = GDK.gdk_device_get_window_at_position((long)l6, (int[])nArray, (int[])nArray6);
                    if (l7 == 0L) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    OS.g_object_ref(l7);
                    long l8 = GDK.gdk_event_new((int)(n == 3 ? 4 : 7));
                    GdkEventButton gdkEventButton = new GdkEventButton();
                    gdkEventButton.type = n == 3 ? 4 : 7;
                    gdkEventButton.window = l7;
                    gdkEventButton.send_event = 1;
                    gdkEventButton.time = 0;
                    gdkEventButton.x = nArray[0];
                    gdkEventButton.y = nArray6[0];
                    gdkEventButton.state = nArray7[0];
                    gdkEventButton.button = event.button;
                    gdkEventButton.device = l6;
                    GTK3.memmove((long)l8, (GdkEventButton)gdkEventButton, (long)GdkEventButton.sizeof);
                    GDK.gdk_event_set_device((long)l8, (long)l6);
                    GDK.gdk_event_put((long)l8);
                    if (GTK.GTK4) {
                        GDK.gdk_event_unref((long)l8);
                    } else {
                        GDK.gdk_event_free((long)l8);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    void postEvent(Event event) {
        int n;
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n2 = this.eventQueue.length;
        for (n = 0; n < n2 && this.eventQueue[n] != null; ++n) {
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    void putGdkEvents() {
        if (Display.logger.level >= 7) {
            logger.log(7, "putGdkEvents()", "");
        }
        if (this.gdkEventCount != 0) {
            for (int i = 0; i < this.gdkEventCount; ++i) {
                long l = this.gdkEvents[i];
                Widget widget = this.gdkEventWidgets[i];
                if (widget == null || !widget.isDisposed()) {
                    if (GTK.GTK4) {
                        long l2 = GDK.gdk_display_get_default();
                        GDK.gdk_display_put_event((long)l2, (long)l);
                    } else {
                        GDK.gdk_event_put((long)l);
                    }
                }
                if (GTK.GTK4) {
                    GDK.gdk_event_unref((long)l);
                } else {
                    GDK.gdk_event_free((long)l);
                }
                this.gdkEvents[i] = 0L;
                this.gdkEventWidgets[i] = null;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        if (Display.logger.level >= 7) {
            logger.log(7, "readAndDispatch()", "");
        }
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        boolean bl = false;
        bl |= this.runSettings();
        bl |= this.runPopups();
        if (GTK.GTK4) {
            bl |= OS.g_main_context_iteration(0L, false);
        } else {
            bl |= GTK3.gtk_events_pending();
            GTK3.gtk_main_iteration_do((boolean)false);
        }
        if (Display.logger.level >= 9) {
            logger.build("readAndDispatch()").add("events: ").add(bl).log(9);
        }
        if (bl) {
            this.runDeferredEvents();
            return true;
        }
        if (this.isDisposed()) {
            return true;
        }
        boolean bl2 = this.runAsyncMessages(false);
        if (this.extraDeferred) {
            this.extraDeferred = false;
            this.runDeferredEvents();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            for (int i = 0; i < Displays.length; ++i) {
                if (Displays[i] != null) continue;
                Display.Displays[i] = display;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        try (ExceptionStash exceptionStash = new ExceptionStash();){
            try {
                this.sendEvent(12, new Event());
            }
            catch (Error | RuntimeException throwable) {
                exceptionStash.stash(throwable);
            }
            for (Shell shell : this.getShells()) {
                try {
                    if (shell.isDisposed()) continue;
                    shell.dispose();
                }
                catch (Error | RuntimeException throwable) {
                    exceptionStash.stash(throwable);
                }
            }
            try {
                if (this.tray != null) {
                    this.tray.dispose();
                }
            }
            catch (Error | RuntimeException throwable) {
                exceptionStash.stash(throwable);
            }
            this.tray = null;
            while (true) {
                try {
                    while (this.readAndDispatch()) {
                    }
                }
                catch (Error | RuntimeException throwable) {
                    exceptionStash.stash(throwable);
                    continue;
                }
                break;
            }
            if (this.disposeList != null) {
                for (Runnable runnable : this.disposeList) {
                    if (runnable == null) continue;
                    try {
                        runnable.run();
                    }
                    catch (Error | RuntimeException throwable) {
                        exceptionStash.stash(throwable);
                    }
                }
            }
            this.disposeList = null;
            this.synchronizer.releaseSynchronizer();
            this.synchronizer = null;
            this.releaseSessionManager();
            this.releaseDisplay();
            super.release();
        }
    }

    void releaseDisplay() {
        File file;
        int n;
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        if (this.windowCallback6 != null) {
            this.windowCallback6.dispose();
            this.windowCallback6 = null;
        }
        this.windowProc6 = 0L;
        this.windowProc5 = 0L;
        this.windowProc4 = 0L;
        this.windowProc3 = 0L;
        this.windowProc2 = 0L;
        if (this.changeValue != null) {
            this.changeValue.dispose();
            this.changeValue = null;
        }
        this.changeValueProc = 0L;
        if (GTK.GTK4) {
            this.keyPressReleaseCallback.dispose();
            this.keyPressReleaseCallback = null;
            this.keyPressReleaseProc = 0L;
            this.focusCallback.dispose();
            this.focusCallback = null;
            this.focusProc = 0L;
            this.windowActiveCallback.dispose();
            this.windowActiveCallback = null;
            this.windowActiveProc = 0L;
            this.enterMotionCallback.dispose();
            this.enterMotionCallback = null;
            this.enterMotionProc = 0L;
            this.scrollCallback.dispose();
            this.scrollCallback = null;
            this.scrollProc = 0L;
            this.leaveCallback.dispose();
            this.leaveCallback = null;
            this.leaveProc = 0L;
            this.resizeCallback.dispose();
            this.resizeCallback = null;
            this.resizeProc = 0L;
            this.activateCallback.dispose();
            this.activateCallback = null;
            this.activateProc = 0L;
            this.gesturePressReleaseCallback.dispose();
            this.gesturePressReleaseCallback = null;
            this.gesturePressReleaseProc = 0L;
            this.snapshotDraw.dispose();
            this.snapshotDraw = null;
            this.snapshotDrawProc = 0L;
        }
        this.notifyCallback.dispose();
        this.notifyCallback = null;
        this.notifyProc = 0L;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0L;
        if (this.preeditWindow != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_window_destroy((long)this.preeditWindow);
            } else {
                GTK3.gtk_widget_destroy((long)this.preeditWindow);
            }
        }
        this.preeditWindow = 0L;
        this.imControl = null;
        this.sizeAllocateCallback.dispose();
        this.sizeAllocateCallback = null;
        this.sizeAllocateProc = 0L;
        this.sizeRequestCallback.dispose();
        this.sizeRequestCallback = null;
        this.sizeRequestProc = 0L;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0L;
        this.idleCallback.dispose();
        this.idleCallback = null;
        this.idleProc = 0L;
        if (this.idleHandle != 0) {
            OS.g_source_remove(this.idleHandle);
        }
        this.idleHandle = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0L;
        this.setDirectionCallback.dispose();
        this.setDirectionCallback = null;
        this.setDirectionProc = 0L;
        this.emissionProcCallback.dispose();
        this.emissionProcCallback = null;
        this.emissionProc = 0L;
        this.allChildrenCallback.dispose();
        this.allChildrenCallback = null;
        this.allChildrenProc = 0L;
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0L;
        this.caretCallback.dispose();
        this.caretCallback = null;
        for (n = 0; n < 109; ++n) {
            if (this.closures[n] == 0L) continue;
            OS.g_closure_unref(this.closures[n]);
        }
        if (this.shellMapProcClosure != 0L) {
            OS.g_closure_unref(this.shellMapProcClosure);
        }
        if (this.timerIds != null) {
            for (n = 0; n < this.timerIds.length; ++n) {
                if (this.timerIds[n] == 0) continue;
                OS.g_source_remove(this.timerIds[n]);
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0L;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0L;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0L;
        this.mouseHoverHandle = 0L;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        for (n = 0; n < this.cursors.length; ++n) {
            if (this.cursors[n] == null) continue;
            this.cursors[n].dispose();
        }
        this.cursors = null;
        if (this.resources != null) {
            for (n = 0; n < this.resources.length; ++n) {
                if (this.resources[n] == null) continue;
                this.resources[n].dispose();
            }
            this.resources = null;
        }
        this.COLOR_TEXT_DISABLED_BACKGROUND_RGBA = null;
        this.COLOR_WIDGET_DISABLED_FOREGROUND_RGBA = null;
        this.COLOR_LINK_FOREGROUND_RGBA = null;
        this.COLOR_INFO_FOREGROUND_RGBA = null;
        this.COLOR_INFO_BACKGROUND_RGBA = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT_RGBA = null;
        this.COLOR_TITLE_INACTIVE_BACKGROUND_RGBA = null;
        this.COLOR_TITLE_INACTIVE_FOREGROUND_RGBA = null;
        this.COLOR_TITLE_BACKGROUND_GRADIENT_RGBA = null;
        this.COLOR_TITLE_BACKGROUND_RGBA = null;
        this.COLOR_TITLE_FOREGROUND_RGBA = null;
        this.COLOR_WIDGET_FOREGROUND_RGBA = null;
        this.COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA = null;
        this.COLOR_LIST_SELECTION_INACTIVE_RGBA = null;
        this.COLOR_LIST_SELECTION_TEXT_RGBA = null;
        this.COLOR_LIST_SELECTION_RGBA = null;
        this.COLOR_LIST_BACKGROUND_RGBA = null;
        this.COLOR_LIST_FOREGROUND_RGBA = null;
        this.COLOR_WIDGET_BORDER_RGBA = null;
        this.COLOR_WIDGET_BACKGROUND_RGBA = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW_RGBA = null;
        this.COLOR_WIDGET_LIGHT_SHADOW_RGBA = null;
        this.COLOR_WIDGET_NORMAL_SHADOW_RGBA = null;
        this.COLOR_WIDGET_DARK_SHADOW_RGBA = null;
        this.COLOR_TOGGLE_BUTTON_FOREGROUND_RGBA = null;
        GDK.gdk_event_handler_set((long)0L, (long)0L, (long)0L);
        this.eventCallback.dispose();
        this.eventCallback = null;
        if (this.shellHandle != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_window_destroy((long)this.shellHandle);
            } else {
                GTK3.gtk_widget_destroy((long)this.shellHandle);
            }
        }
        this.shellHandle = 0L;
        this.signalCallback.dispose();
        this.signalCallback = null;
        this.signalProc = 0L;
        this.keysChangedCallback.dispose();
        this.keysChangedCallback = null;
        this.keysChangedProc = 0L;
        long l = OS.PANGO_TYPE_LAYOUT();
        long l2 = OS.g_type_class_ref(l);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l2, this.pangoLayoutNewProc);
        OS.g_type_class_unref(l2);
        this.pangoLayoutNewProc = 0L;
        long l3 = GTK.GTK_TYPE_IM_MULTICONTEXT();
        long l4 = OS.g_type_class_ref(l3);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l4, this.imContextNewProc);
        OS.g_type_class_unref(l4);
        this.imContextNewProc = 0L;
        long l5 = OS.PANGO_TYPE_FONT_FAMILY();
        long l6 = OS.g_type_class_ref(l5);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l6, this.pangoFontFamilyNewProc);
        OS.g_type_class_unref(l6);
        this.pangoFontFamilyNewProc = 0L;
        long l7 = OS.PANGO_TYPE_FONT_FACE();
        long l8 = OS.g_type_class_ref(l7);
        OS.G_OBJECT_CLASS_SET_CONSTRUCTOR(l8, this.pangoFontFaceNewProc);
        OS.g_type_class_unref(l8);
        this.pangoFontFaceNewProc = 0L;
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0L) {
            OS.g_free(this.fds);
        }
        this.fds = 0L;
        this.popups = null;
        this.thread = null;
        this.activeShell = null;
        this.lastWidget = null;
        this.closures = null;
        this.flushData = null;
        this.signalIds = null;
        this.indexTable = null;
        this.modalShells = null;
        this.widgetTable = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.filterTable = null;
        this.eventTable = null;
        this.modalDialog = null;
        this.flushRect = null;
        this.exposeEvent = null;
        this.idleLock = null;
        String string = System.getProperty("user.home");
        if (string != null && ((file = new File(string, ".swt")).exists() && file.isDirectory() || file.mkdirs())) {
            File file2 = new File(file, "trims.prefs");
            Properties properties = new Properties();
            StringBuilder stringBuilder = new StringBuilder();
            for (int n2 : this.trimWidths) {
                stringBuilder.append(n2).append(' ');
            }
            properties.put("trimWidths", stringBuilder.toString());
            stringBuilder = new StringBuilder();
            for (int n2 : this.trimHeights) {
                stringBuilder.append(n2).append(' ');
            }
            properties.put("trimHeights", stringBuilder.toString());
            try (Object object = new FileOutputStream(file2);){
                properties.store((OutputStream)object, null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    long removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0L;
        }
        long l = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0L;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIdleProc() {
        Object object = this.idleLock;
        synchronized (object) {
            if (this.idleHandle != 0) {
                OS.g_source_remove(this.idleHandle);
            }
            this.idleNeeded = false;
            this.idleHandle = 0;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    void removeMouseHoverTimeout(long l) {
        if (l != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.g_source_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0L;
    }

    void removePopup(Menu menu) {
        if (Display.logger.level >= 7) {
            Logger.Builder builder = logger.build("removePopup(Menu)");
            (Display.logger.level < 8 ? builder : builder.add("menu: ").add((Object)menu)).log(7);
        }
        if (this.popups == null) {
            return;
        }
        for (int i = 0; i < this.popups.length; ++i) {
            if (this.popups[i] != menu) continue;
            this.popups[i] = null;
            return;
        }
    }

    Widget removeWidget(long l) {
        int n;
        if (l == 0L) {
            return null;
        }
        this.lastWidget = null;
        Widget widget = null;
        long l2 = OS.g_object_get_qdata(l, SWT_OBJECT_INDEX) - 1L;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            SWT.error(51, null, ". g_object_get_qdata returned unexpected index value" + this.debugInfoForIndex(l2));
        }
        if (0 <= (n = (int)l2) && n < this.widgetTable.length) {
            widget = this.widgetTable[n];
            this.widgetTable[n] = null;
            this.indexTable[n] = this.freeSlot;
            this.freeSlot = n;
            OS.g_object_set_qdata(l, SWT_OBJECT_INDEX, 0L);
            if (widget == null) {
                SWT.error(5, null, ". Widget already released" + this.debugInfoForIndex(n));
            }
        } else {
            SWT.error(5, null, ". Invalid index for handle " + l + this.debugInfoForIndex(n));
        }
        return widget;
    }

    String debugInfoForIndex(long l) {
        String string = ", index: " + l;
        int n = (int)l;
        if (n >= 0 && n < this.widgetTable.length) {
            string = string + ", current value at: " + this.widgetTable[n];
        }
        string = string + this.dumpWidgetTableInfo();
        return string;
    }

    void dpiChanged(int n) {
        DPIUtil.setDeviceZoom(DPIUtil.mapDPIToZoom(this.getDPI().x * n));
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].layout(true, true);
        }
    }

    String dumpWidgetTableInfo() {
        StringBuilder stringBuilder = new StringBuilder(", table size: ");
        stringBuilder.append(this.widgetTable.length);
        IdentityHashMap<Widget, Collection> identityHashMap = new IdentityHashMap<Widget, Collection>();
        for (int i = 0; i < this.widgetTable.length; ++i) {
            Widget widget2 = this.widgetTable[i];
            if (widget2 == null || !widget2.isDisposed()) continue;
            identityHashMap.computeIfAbsent(widget2, widget -> new ArrayList()).add(i);
        }
        if (!identityHashMap.isEmpty()) {
            stringBuilder.append(", leaked elements:");
            Set set = identityHashMap.entrySet();
            for (Map.Entry entry : set) {
                stringBuilder.append(" ").append(entry.getKey()).append(" at ").append(entry.getValue()).append(",");
            }
        }
        return stringBuilder.toString();
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        Event event;
        if (Display.logger.level >= 7) {
            logger.log(7, "runDeferredEvents()", "");
        }
        boolean bl = false;
        while (this.eventQueue != null && (event = this.eventQueue[0]) != null) {
            Widget widget;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl = true;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return bl;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] compositeArray = this.layoutDeferred;
            int n = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            for (int i = 0; i < n; ++i) {
                Composite composite = compositeArray[i];
                if (composite.isDisposed()) continue;
                composite.setLayoutDeferred(false);
            }
            this.update();
            return true;
        }
        return false;
    }

    boolean runPopups() {
        if (Display.logger.level >= 7) {
            logger.log(7, "runPopups()", "");
        }
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (Display.logger.level >= 9) {
                logger.build("runPopups()").add("menu: ").add((Object)menu).log(9);
            }
            if (menu == null) break;
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.saveResources();
        this.initializeSystemColors();
        this.sendEvent(39, null);
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            Shell shell = shellArray[i];
            if (shell.isDisposed()) continue;
            shell.fixStyle();
            shell.redraw(true);
            shell.layout(true, true);
        }
        return true;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] widgetArray = this.skinList;
            int n = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                for (int i = 0; i < n; ++i) {
                    Widget widget = widgetArray[i];
                    if (widget == null || widget.isDisposed()) continue;
                    widget.state &= 0xFEFFFFFF;
                    widgetArray[i] = null;
                    Event event = new Event();
                    event.widget = widget;
                    this.sendEvent(45, event);
                }
            }
            return true;
        }
        return false;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    public static void setAppVersion(String string) {
        APP_VERSION = string;
    }

    public void setCursorLocation(int n, int n2) {
        if (!OS.isX11()) {
            System.err.println("SWT Display.java Error: setCursorLocation only supported on X11. \n");
        }
        this.setCursorLocation(new Point(n, n2));
    }

    void setCursorLocationInPixels(Point point) {
        long l = GDK.gdk_display_get_default();
        long l2 = GDK.gdk_get_pointer((long)l);
        if (!GTK.GTK4) {
            long l3 = GDK.gdk_screen_get_default();
            GDK.gdk_device_warp((long)l2, (long)l3, (int)point.x, (int)point.y);
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        this.setCursorLocationInPixels(point);
    }

    public void setData(String string, Object object) {
        Object object2;
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(DISPATCH_EVENT_KEY) && (object == null || object instanceof int[])) {
            this.dispatchEvents = (int[])object;
            if (object == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (string.equals(SET_MODAL_DIALOG)) {
            this.setModalDialog((Dialog)object);
            return;
        }
        if (string.equals(ADD_WIDGET_KEY)) {
            object2 = (Object[])object;
            long l = ((LONG)object2[0]).value;
            Widget widget = (Widget)object2[1];
            if (widget != null) {
                this.addWidget(l, widget);
            } else {
                this.removeWidget(l);
            }
        }
        if (string.equals(ADD_IDLE_PROC_KEY)) {
            this.addIdleProc();
            return;
        }
        if (string.equals(REMOVE_IDLE_PROC_KEY)) {
            this.removeIdleProc();
            return;
        }
        if (string.equals(EXTERNAL_EVENT_LOOP_KEY)) {
            object2 = (Boolean)object;
            this.externalEventLoop = object2 != null && ((Boolean)object2).booleanValue();
            return;
        }
        if (object == null) {
            int n;
            if (this.keys == null) {
                return;
            }
            for (n = 0; n < this.keys.length && !this.keys[n].equals(string); ++n) {
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!this.keys[i].equals(string)) continue;
            this.values[i] = object;
            return;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    long setDirectionProc(long l, long l2) {
        long l3;
        GTK.gtk_widget_set_direction((long)l, (int)((int)l2));
        if (!GTK.GTK4 && GTK3.GTK_IS_MENU_ITEM((long)l) && (l3 = GTK3.gtk_menu_item_get_submenu((long)l)) != 0L) {
            GTK.gtk_widget_set_direction((long)l3, (int)((int)l2));
            GTK3.gtk_container_forall((long)l3, (long)this.setDirectionProc, (long)l2);
        }
        if (GTK.GTK_IS_CONTAINER((long)l)) {
            GTK3.gtk_container_forall((long)l, (long)this.setDirectionProc, (long)l2);
        }
        return 0L;
    }

    void setModalDialog(Dialog dialog) {
        this.modalDialog = dialog;
        Shell[] shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        int n;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n2 = this.modalShells.length;
        for (n = 0; n < n2; ++n) {
            if (this.modalShells[n] == shell) {
                return;
            }
            if (this.modalShells[n] == null) break;
        }
        if (n == n2) {
            shellArray = new Shell[n2 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n2);
            this.modalShells = shellArray;
        }
        this.modalShells[n] = shell;
        shellArray = this.getShells();
        for (int i = 0; i < shellArray.length; ++i) {
            shellArray[i].updateModal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.moveAllEventsTo(synchronizer);
            }
            return;
        }
    }

    public final void setRuntimeExceptionHandler(Consumer<RuntimeException> consumer) {
        this.checkDevice();
        this.runtimeExceptionHandler = Objects.requireNonNull(consumer);
    }

    public final Consumer<RuntimeException> getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public final void setErrorHandler(Consumer<Error> consumer) {
        this.checkDevice();
        this.errorHandler = Objects.requireNonNull(consumer);
    }

    public final Consumer<Error> getErrorHandler() {
        return this.errorHandler;
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0L) {
            this.preeditWindow = GTK3.gtk_window_new((int)1);
            if (this.preeditWindow == 0L) {
                this.error(2);
            }
            this.preeditLabel = GTK.gtk_label_new(null);
            if (this.preeditLabel == 0L) {
                this.error(2);
            }
            if (GTK.GTK4) {
                GTK4.gtk_window_set_child((long)this.preeditWindow, (long)this.preeditLabel);
            } else {
                GTK3.gtk_container_add((long)this.preeditWindow, (long)this.preeditLabel);
                GTK.gtk_widget_show((long)this.preeditLabel);
            }
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long l = control.imHandle();
        GTK.gtk_im_context_get_preedit_string((long)l, (long[])lArray, (long[])lArray2, null);
        if (lArray[0] != 0L && C.strlen((long)lArray[0]) > 0) {
            Control control2 = control.findBackgroundControl();
            if (control2 == null) {
                control2 = control;
            }
            control2.setBackgroundGdkRGBA(this.preeditWindow, control.getBackgroundGdkRGBA());
            control2.setForegroundGdkRGBA(this.preeditLabel, control.getForegroundGdkRGBA());
            long l2 = control.getFontDescription();
            control2.setFontDescription(this.preeditLabel, l2);
            OS.pango_font_description_free(l2);
            if (lArray2[0] != 0L) {
                GTK.gtk_label_set_attributes((long)this.preeditLabel, (long)lArray2[0]);
            }
            GTK.gtk_label_set_text((long)this.preeditLabel, (long)lArray[0]);
            Point point = control.toDisplayInPixels(control.getIMCaretPos());
            GTK3.gtk_window_move((long)this.preeditWindow, (int)point.x, (int)point.y);
            GtkRequisition gtkRequisition = new GtkRequisition();
            GTK.gtk_widget_get_preferred_size((long)this.preeditLabel, (GtkRequisition)gtkRequisition, null);
            GTK3.gtk_window_resize((long)this.preeditWindow, (int)gtkRequisition.width, (int)gtkRequisition.height);
            GTK.gtk_widget_show((long)this.preeditWindow);
        } else {
            GTK.gtk_widget_hide((long)this.preeditWindow);
        }
        if (lArray[0] != 0L) {
            OS.g_free(lArray[0]);
        }
        if (lArray2[0] != 0L) {
            OS.pango_attr_list_unref(lArray2[0]);
        }
    }

    public boolean sleep() {
        if (Display.logger.level >= 7) {
            logger.log(7, "sleep()", "");
        }
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.settingsChanged) {
            this.settingsChanged = false;
            this.runSettings = true;
            if (Display.logger.level >= 9) {
                logger.log(9, "sleep()", "Settings changed, returning");
            }
            return false;
        }
        if (!this.synchronizer.isMessagesEmpty()) {
            if (Display.logger.level >= 9) {
                logger.log(9, "sleep()", "Message count != 0, returning");
            }
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        if (!GTK.GTK4) {
            GDK.gdk_threads_leave();
        }
        if (this.fds == 0L) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        long l = OS.g_main_context_default();
        boolean bl = false;
        do {
            int n;
            if (!OS.g_main_context_acquire(l)) continue;
            bl = OS.g_main_context_prepare(l, this.max_priority);
            while ((n = OS.g_main_context_query(l, this.max_priority[0], this.timeout, this.fds, this.allocated_nfds)) > this.allocated_nfds) {
                OS.g_free(this.fds);
                this.allocated_nfds = n;
                this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
            }
            long l2 = OS.g_main_context_get_poll_func(l);
            if (l2 != 0L && (n > 0 || this.timeout[0] != 0)) {
                if (this.timeout[0] < 0) {
                    this.timeout[0] = 50;
                }
                this.wake = false;
                OS.Call(l2, this.fds, n, this.timeout[0]);
            }
            OS.g_main_context_check(l, this.max_priority[0], this.fds, n);
            OS.g_main_context_release(l);
        } while (!bl && this.synchronizer.isMessagesEmpty() && !this.wake);
        this.wake = false;
        if (Display.logger.level >= 9) {
            logger.log(9, "sleep()", "Done");
        }
        if (!GTK.GTK4) {
            GDK.gdk_threads_enter();
        }
        this.sendPostExternalEventDispatchEvent();
        return true;
    }

    public void timerExec(int n, Runnable runnable) {
        int n2;
        int n3;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != runnable; ++n3) {
        }
        if (n3 != this.timerList.length) {
            OS.g_source_remove(this.timerIds[n3]);
            this.timerList[n3] = null;
            this.timerIds[n3] = 0;
            if (n < 0) {
                return;
            }
        } else {
            if (n < 0) {
                return;
            }
            for (n3 = 0; n3 < this.timerList.length && this.timerList[n3] != null; ++n3) {
            }
            if (n3 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n2 = GTK.GTK4 ? OS.g_timeout_add(n, this.timerProc, n3) : GDK.gdk_threads_add_timeout((int)n, (long)this.timerProc, (long)n3)) != 0) {
            this.timerIds[n3] = n2;
            this.timerList[n3] = runnable;
        }
    }

    long timerProc(long l) {
        if (this.timerList == null) {
            return 0L;
        }
        int n = (int)l;
        if (0 <= n && n < this.timerList.length) {
            Runnable runnable = this.timerList[n];
            this.timerList[n] = null;
            this.timerIds[n] = 0;
            if (runnable != null) {
                try {
                    runnable.run();
                }
                catch (RuntimeException runtimeException) {
                    this.runtimeExceptionHandler.accept(runtimeException);
                }
                catch (Error error) {
                    this.errorHandler.accept(error);
                }
            }
        }
        return 0L;
    }

    long caretProc(long l) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0L;
        }
        if (this.currentCaret.blinkCaret()) {
            int n = this.currentCaret.blinkRate;
            if (n == 0) {
                return 0L;
            }
            this.currentCaret.getParent().blink = true;
            this.caretId = GTK.GTK4 ? OS.g_timeout_add(n, this.caretProc, 0L) : GDK.gdk_threads_add_timeout((int)n, (long)this.caretProc, (long)0L);
        } else {
            this.currentCaret = null;
        }
        return 0L;
    }

    void resetCaretTiming() {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
            this.caretId = GTK.GTK4 ? OS.g_timeout_add(this.currentCaret.blinkRate, this.caretProc, 0L) : GDK.gdk_threads_add_timeout((int)this.currentCaret.blinkRate, (long)this.caretProc, (long)0L);
        }
    }

    long sizeAllocateProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l3);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeAllocateProc(l, l2, l3);
    }

    long sizeRequestProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l3);
        if (widget == null) {
            return 0L;
        }
        return widget.sizeRequestProc(l, l2, l3);
    }

    void saveResources() {
        int n = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            n = this.resources.length;
            Resource[] resourceArray = new Resource[n + 27];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
        if (this.errorImage != null) {
            this.resources[n++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[n++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[n++] = this.questionImage;
        }
        if (this.warningImage != null) {
            this.resources[n++] = this.warningImage;
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        for (int i = 0; i < this.cursors.length; ++i) {
            if (this.cursors[i] != null) {
                this.resources[n++] = this.cursors[i];
            }
            this.cursors[i] = null;
        }
        if (n < 27) {
            Resource[] resourceArray = new Resource[n];
            System.arraycopy(this.resources, 0, resourceArray, 0, n);
            this.resources = resourceArray;
        }
    }

    private void sendJDKInternalEvent(int n) {
        this.sendJDKInternalEvent(n, 0);
    }

    private void sendJDKInternalEvent(int n, int n2) {
        if (this.eventTable == null || !this.eventTable.hooks(n)) {
            return;
        }
        Event event = new Event();
        event.detail = n2;
        event.display = this;
        event.type = n;
        event.time = (int)(System.nanoTime() / 1000000L);
        if (!this.filterEvent(event)) {
            this.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(EventTable eventTable, Event event) {
        int n = event.type;
        this.sendPreEvent(n);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(n);
        }
    }

    void sendPreEvent(int n) {
        if (n != 50 && n != 51 && n != 52 && n != 53) {
            this.sendJDKInternalEvent(50, n);
        }
    }

    void sendPostEvent(int n) {
        if (n != 50 && n != 51 && n != 52 && n != 53) {
            this.sendJDKInternalEvent(51, n);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        this.sendJDKInternalEvent(52);
    }

    public void sendPostExternalEventDispatchEvent() {
        this.sendJDKInternalEvent(53);
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.g_source_remove(this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int n = this.currentCaret.blinkRate;
        this.caretId = GTK.GTK4 ? OS.g_timeout_add(n, this.caretProc, 0L) : GDK.gdk_threads_add_timeout((int)n, (long)this.caretProc, (long)0L);
    }

    long shellMapProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.shellMapProc(l, l2, l3);
    }

    long signalProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 1: {
                this.settingsChanged = true;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            Object object = this.idleLock;
            synchronized (object) {
                if (this.idleNeeded && this.idleHandle == 0) {
                    this.idleHandle = GTK.GTK4 ? OS.g_idle_add(this.idleProc, 0L) : GDK.gdk_threads_add_idle((long)this.idleProc, (long)0L);
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.internalSyncExec(runnable);
            return;
        }
    }

    public <T, E extends Exception> T syncCall(SwtCallable<T, E> swtCallable) throws E {
        Objects.nonNull(swtCallable);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[1];
        this.syncExec(() -> {
            try {
                objectArray[0] = swtCallable.call();
            }
            catch (Exception exception) {
                objectArray2[0] = exception;
            }
        });
        if (objectArray2[0] != null) {
            Exception exception = (Exception)objectArray2[0];
            throw exception;
        }
        return (T)objectArray[0];
    }

    public static int translateKey(int n) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][0] != n) continue;
            return KeyTable[i][1];
        }
        return 0;
    }

    public static int untranslateKey(int n) {
        for (int i = 0; i < KeyTable.length; ++i) {
            if (KeyTable[i][1] != n) continue;
            return KeyTable[i][0];
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        if (Display.logger.level >= 7) {
            logger.log(7, "wakeThread()", "");
        }
        OS.g_main_context_wakeup(0L);
        this.wake = true;
    }

    void enterMotionProc(long l, double d, double d2, long l2) {
        long l3 = GTK.gtk_event_controller_get_widget((long)l);
        Widget widget = this.getWidget(l3);
        if (widget != null) {
            widget.enterMotionProc(l, d, d2, l2);
        }
    }

    boolean scrollProc(long l, double d, double d2, long l2) {
        long l3 = GTK.gtk_event_controller_get_widget((long)l);
        Widget widget = this.getWidget(l3);
        if (widget != null) {
            return widget.scrollProc(l, d, d2, l2);
        }
        return false;
    }

    void focusProc(long l, long l2) {
        long l3 = GTK.gtk_event_controller_get_widget((long)l);
        Widget widget = this.getWidget(l3);
        if (widget != null) {
            widget.focusProc(l, l2);
        }
    }

    void windowActiveProc(long l, long l2) {
        Widget widget = this.getWidget(l);
        if (widget != null) {
            widget.windowActiveProc(l, l2);
        }
    }

    boolean keyPressReleaseProc(long l, int n, int n2, int n3, long l2) {
        long l3 = GTK.gtk_event_controller_get_widget((long)l);
        Widget widget = this.getWidget(l3);
        if (widget == null) {
            return false;
        }
        return widget.keyPressReleaseProc(l, n, n2, n3, l2);
    }

    void gesturePressReleaseProc(long l, int n, double d, double d2, long l2) {
        long l3 = GTK.gtk_event_controller_get_widget((long)l);
        Widget widget = this.getWidget(l3);
        if (widget != null) {
            widget.gesturePressReleaseProc(l, n, d, d2, l2);
        }
    }

    void leaveProc(long l, long l2) {
        long l3 = GTK.gtk_event_controller_get_widget((long)l);
        Widget widget = this.getWidget(l3);
        if (widget != null) {
            widget.leaveProc(l, l3, l2);
        }
    }

    void computeSizeProc(long l, long l2, long l3) {
    }

    void activateProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l3);
        if (widget == null) {
            return;
        }
        widget.gtk_activate(l3);
    }

    void resizeProc(long l, int n, int n2) {
        Widget widget = this.getWidget(l);
        if (widget != null) {
            widget.gtk_size_allocate(l, 0L);
        }
    }

    long notifyProc(long l, long l2, long l3) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            widget = this.getWidget(l3);
            if (widget == null) {
                return 0L;
            }
            return widget.notifyProc(l, l2, 102L);
        }
        return widget.notifyProc(l, l2, l3);
    }

    boolean changeValue(long l, int n, double d, long l2) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return false;
        }
        return widget.gtk_change_value(l, n, d, l2);
    }

    long windowProc(long l, long l2) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2);
    }

    long windowProc(long l, long l2, long l3) {
        Object object;
        if (Display.logger.level >= 7) {
            object = logger.build("windowProc(int,int,int)");
            (Display.logger.level < 8 ? object : object.add("handle: ").add(l).add(", arg0: ").add(l2).add(", user_data: ").add(l3)).log(7);
        }
        if ((object = this.getWidget(l)) == null) {
            return 0L;
        }
        return ((Widget)object).windowProc(l, l2, l3);
    }

    long windowProc(long l, long l2, long l3, long l4) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2, l3, l4);
    }

    long windowProc(long l, long l2, long l3, long l4, long l5) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2, l3, l4, l5);
    }

    long windowProc(long l, long l2, long l3, long l4, long l5, long l6) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.windowProc(l, l2, l3, l4, l5, l6);
    }

    long windowTimerProc(long l) {
        Widget widget = this.getWidget(l);
        if (widget == null) {
            return 0L;
        }
        return widget.timerProc(l);
    }

    long getWindowPointerPosition(long l, int[] nArray, int[] nArray2, int[] nArray3) {
        long l2 = 0L;
        if (l != 0L) {
            l2 = GDK.gdk_window_get_display((long)l);
        } else {
            l = GDK.gdk_get_default_root_window();
            l2 = GDK.gdk_window_get_display((long)l);
        }
        long l3 = GDK.gdk_get_pointer((long)l2);
        return GDK.gdk_window_get_device_position((long)l, (long)l3, (int[])nArray, (int[])nArray2, (int[])nArray3);
    }

    void getPointerPosition(double[] dArray, double[] dArray2) {
        long l = GDK.gdk_display_get_default();
        long l2 = GDK.gdk_display_get_default_seat((long)l);
        long l3 = GDK.gdk_seat_get_pointer((long)l2);
        GDK.gdk_device_get_surface_at_position((long)l3, (double[])dArray, (double[])dArray2);
    }

    long gdk_device_get_window_at_position(int[] nArray, int[] nArray2) {
        long l = GDK.gdk_display_get_default();
        long l2 = GDK.gdk_get_pointer((long)l);
        return GDK.gdk_device_get_window_at_position((long)l2, (int[])nArray, (int[])nArray2);
    }

    long gdk_device_get_surface_at_position(double[] dArray, double[] dArray2) {
        long l = GDK.gdk_display_get_default();
        long l2 = GDK.gdk_get_pointer((long)l);
        return GDK.gdk_device_get_surface_at_position((long)l2, (double[])dArray, (double[])dArray2);
    }

    static int _getDeviceZoom(long l) {
        int n = 96;
        long l2 = GDK.gdk_display_get_default();
        long l3 = GDK.gdk_display_get_monitor_at_point((long)l2, (int)0, (int)0);
        int n2 = GDK.gdk_monitor_get_scale_factor((long)l3);
        return DPIUtil.mapDPIToZoom(n *= n2);
    }

    static {
        Object object;
        block14: {
            logger = new Logger("org.eclipse.swt.widgets.Display");
            classLock = new Object();
            try {
                object = System.getProperty("eclipse.swt.DisplayCreationHooks");
                String string = new Environment().getEnv("SWT_DISPLAY_CREATION_HOOKS");
                if (string != null) {
                    Object object2 = object = object == null ? string : (String)object + ":" + string;
                }
                if (object == null) break block14;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ":;, \t\r\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    try {
                        Object object3;
                        String string3;
                        block15: {
                            Class<?> clazz;
                            try {
                                clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                            }
                            catch (Throwable throwable) {
                                clazz = Display.class.getClassLoader().loadClass(string2);
                            }
                            Object obj = clazz.getConstructor(Class.class).newInstance(Display.class);
                            string3 = null;
                            try {
                                InputStream inputStream = Display.class.getResourceAsStream("/org/eclipse/swt/widgets/qfsbuild.properties");
                                object3 = new Properties();
                                ((Properties)object3).load(inputStream);
                                string3 = ((Properties)object3).getProperty("buildnumber");
                            }
                            catch (Throwable throwable) {
                                if (Display.logger.level < 3) break block15;
                                logger.log(3, "run()", throwable);
                            }
                        }
                        int n = SWT.getVersion();
                        if (n >= 4922) {
                            int n2 = (n - 4922) / 2;
                            if (n >= 4940) {
                                --n2;
                            }
                            String string4 = "4." + (10 + n2);
                            int n3 = 2018 + (n2 + 3) / 4;
                            int n4 = n2 % 4 * 3 % 12;
                            if (n4 == 0) {
                                n4 = 12;
                            }
                            String string5 = n3 + "-" + (n4 < 10 ? "0" : "") + n4;
                            object3 = string4 + "/" + string5 + " (" + n + ")";
                        } else {
                            object3 = n >= 4900 ? "4.9/2018-09 (" + n + ")" : n / 1000 + "." + n % 1000 / 100 + " (" + n + ")";
                        }
                        System.out.println("SWT " + (String)object3 + (String)(string3 == null ? " via QF-Test agent" : " instrumented from QF-Test build " + string3));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        strictChecks = System.getProperty("org.eclipse.swt.internal.gtk.enableStrictChecks") != null;
        APP_NAME = "SWT";
        APP_VERSION = "";
        object = Converter.wcsToMbcs((String)"SWT_OBJECT_INDEX", (boolean)true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string((byte[])object);
        object = Converter.wcsToMbcs((String)"SWT_OBJECT_INDEX1", (boolean)true);
        SWT_OBJECT_INDEX1 = OS.g_quark_from_string((byte[])object);
        object = Converter.wcsToMbcs((String)"SWT_OBJECT_INDEX2", (boolean)true);
        SWT_OBJECT_INDEX2 = OS.g_quark_from_string((byte[])object);
        colorPattern = Pattern.compile("[^-]color: (rgba?\\((?:\\d+(?:,\\s?)?){3,4}\\))");
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65027, 32768}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65485, 0x1000019}, {65486, 0x100001A}, {65487, 0x100001B}, {65488, 0x100001C}, {65489, 0x100001D}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[1];
        DeviceFinder = () -> {
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            Display.setDevice(display);
        };
    }

    private class SessionManagerListener
    implements SessionManagerDBus.IListener {
        Display parent;

        public SessionManagerListener(Display display2) {
            this.parent = display2;
        }

        public boolean isReadyToExit() {
            Event event = new Event();
            this.parent.sendEvent(21, event);
            return event.doit;
        }

        public void stop() {
            this.parent.dispose();
        }
    }

    private static class Environment {
        private final String[] dosNames = new String[]{"Windows 95", "Windows 98", "Windows ME"};
        private final boolean is15 = "1.5".compareTo(System.getProperty("java.version")) <= 0;
        private final int OS_OTHER = 0;
        private final int OS_POSIX = 1;
        private final int OS_NT = 2;
        private final int OS_DOS = 3;
        private final int OS_MAC = 4;
        private int os = 0;
        private Properties environment;

        public Environment() {
            this.determineOS();
            if (this.os != 0) {
                this.initEnvironment();
            }
        }

        public boolean isAvaliable() {
            return this.os != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Properties getEnvironment() {
            if (this.os == 0) {
                return null;
            }
            Environment environment = this;
            synchronized (environment) {
                if (this.environment == null) {
                    this.initEnvironment();
                }
            }
            return this.environment;
        }

        public final void setEnvironment(Properties properties) {
            if (this.os == 0) {
                return;
            }
            this.environment = properties;
        }

        public String getEnv(String string) {
            if (this.os == 0) {
                return null;
            }
            return this.getEnvironment().getProperty(this.transformName(string));
        }

        public void setEnv(String string, String string2) {
            if (this.os == 0) {
                return;
            }
            this.getEnvironment().put(this.transformName(string), string2);
        }

        public void unsetEnv(String string) {
            if (this.os == 0) {
                return;
            }
            this.getEnvironment().remove(this.transformName(string));
        }

        private void determineOS() {
            String string = System.getProperty("os.name");
            if (string == null) {
                if (this.is15) {
                    this.os = 1;
                    return;
                }
                return;
            }
            if (string.startsWith("Windows")) {
                int n;
                for (n = 0; n < this.dosNames.length; ++n) {
                    if (!this.dosNames[n].equalsIgnoreCase(string)) continue;
                    this.os = 3;
                }
                if (n == this.dosNames.length) {
                    this.os = 2;
                }
            } else {
                this.os = string.startsWith("MacOS") ? 4 : 1;
            }
        }

        private void initEnvironment() {
            this.environment = new Properties();
            if (this.is15) {
                try {
                    Map map = (Map)System.class.getMethod("getenv", new Class[0]).invoke(null, new Object[0]);
                    for (Map.Entry entry : map.entrySet()) {
                        this.environment.put(this.transformName((String)entry.getKey()), entry.getValue());
                    }
                    return;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String[] stringArray = null;
            switch (this.os) {
                case 1: {
                    stringArray = new String[]{"sh", "-c", "env"};
                    break;
                }
                case 2: {
                    stringArray = new String[]{"cmd", "/c", "set"};
                    break;
                }
                case 3: {
                    stringArray = new String[]{"command.com", "/c", "set"};
                }
            }
            if (stringArray != null) {
                try {
                    Process process = Runtime.getRuntime().exec(stringArray);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string = bufferedReader.readLine();
                    if (string.indexOf(61) <= 0) {
                        this.terminateProcess(process);
                        return;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    String string2 = "";
                    int n = 0;
                    while (string != null) {
                        ++n;
                        int n2 = string.indexOf(61);
                        if (n2 < 0) {
                            stringBuffer.append("\n");
                            stringBuffer.append(string);
                        } else {
                            this.environment.put(string2, stringBuffer.toString());
                            stringBuffer.setLength(0);
                            string2 = this.transformName(string.substring(0, n2));
                            stringBuffer.append(string.substring(n2 + 1));
                        }
                        string = bufferedReader.readLine();
                    }
                    this.environment.put(string2, stringBuffer.toString());
                    this.terminateProcess(process);
                }
                catch (Throwable throwable) {
                    this.os = 0;
                }
            }
        }

        private void terminateProcess(final Process process) {
            final byte[] byArray = new byte[32768];
            new Thread(){

                @Override
                public void run() {
                    try {
                        InputStream inputStream = process.getInputStream();
                        while (inputStream.read(byArray) >= 0) {
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    try {
                        InputStream inputStream = process.getErrorStream();
                        while (inputStream.read(byArray) >= 0) {
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }.start();
            process.destroy();
        }

        private String transformName(String string) {
            return this.os == 3 || this.os == 2 ? string.toUpperCase() : string;
        }
    }

    public static interface IdleProc {
        public long idleProc(long var1);
    }

    public static interface IGdkEventFilter {
        public boolean filterGdkEvent(long var1, int var3);
    }

    public static interface IDNDHook {
        public void dragSourceCreated(DragSource var1);

        public void dropTargetCreated(DropTarget var1);

        public void trackerDragStarted();

        public void trackerDragFinished(boolean var1);
    }

    public static interface IDialogHook {
        public void dialogCreated(Dialog var1);

        public void dialogShown(Dialog var1, Object var2);

        public Object dialogClosed(Dialog var1, Object var2);
    }

    public static interface IDisplayCreationHook {
        public void displayCreated(Display var1);
    }
}

