/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.client.android;

import de.qfs.apps.qftest.client.Client;
import de.qfs.apps.qftest.client.android.AndroidHelper;
import de.qfs.apps.qftest.client.android.toolkit.AndroidComponent;
import de.qfs.apps.qftest.extensions.ExtraFeatureResolver;
import de.qfs.apps.qftest.shared.data.ExtraFeature;
import de.qfs.apps.qftest.shared.data.ExtraFeatureSet;
import de.qfs.apps.qftest.shared.extensions.BaseHelper;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;

public class AndroidExtraFeatureResolver
implements ExtraFeatureResolver,
BaseHelper {
    private static final QFLogger a = new QFLogger("de.qfs.apps.qftest.client.android.AndroidExtraFeatureResolver");
    private static final String b = "android:package";
    private static final String c = "android:id";
    private static final String d = "android:className";
    private static final String e = "android:text";
    private static final String f = "android:password";
    private static final String g = "android:contentDesc";
    private static final String h = "android:labeledBy";
    private static final String i = "android:windowType";
    public final AndroidHelper helper;

    public AndroidExtraFeatureResolver(AndroidHelper androidHelper) {
        if (AndroidExtraFeatureResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)a.lvlBuild(7, "AndroidExtraFeatureResolver(AndroidHelper)", 67).addDetail("helper", (Object)androidHelper)).log();
        }
        this.helper = androidHelper;
    }

    public ExtraFeatureSet getExtraFeatures(Object object, ExtraFeatureSet extraFeatureSet) {
        if (AndroidExtraFeatureResolver.a.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)a.lvlBuild(7, "getExtraFeatures(Object,ExtraFeatureSet)", 92).addDetail("element", object)).addDetail("features", (Object)extraFeatureSet)).log();
        }
        if (object instanceof AndroidComponent) {
            String string;
            AndroidComponent androidComponent = (AndroidComponent)object;
            if (Client.instance().isExtraFeatureRelevant(b)) {
                if (androidComponent.isRoot()) {
                    extraFeatureSet.add(new ExtraFeature(2, b, androidComponent.getPackageName()));
                } else {
                    extraFeatureSet.add(new ExtraFeature(0, b, androidComponent.getPackageName()));
                }
            }
            if (Client.instance().isExtraFeatureRelevant(c) && !Misc.emptyOrNull((String)(string = androidComponent.getResourceId()))) {
                extraFeatureSet.add(new ExtraFeature(0, c, string));
            }
            if (Client.instance().isExtraFeatureRelevant(d)) {
                extraFeatureSet.add(new ExtraFeature(0, d, androidComponent.getClassName()));
            }
            if (!androidComponent.isEditable() && !androidComponent.isEditableByClick()) {
                if (Client.instance().isExtraFeatureRelevant(e)) {
                    string = this.helper.getWholeTextBase(androidComponent);
                    if (!Misc.emptyOrNull((String)(string = AndroidHelper.calcCleanText(string)))) {
                        extraFeatureSet.add(new ExtraFeature(1, e, string));
                    }
                }
            } else if (Client.instance().isExtraFeatureRelevant(f) && !Client.instance().isCaptureContext()) {
                extraFeatureSet.add(new ExtraFeature(0, f, "" + androidComponent.isPassword()));
            }
            if (Client.instance().isExtraFeatureRelevant(g) && !Misc.emptyOrNull((String)(string = androidComponent.getContentDesc()))) {
                extraFeatureSet.add(new ExtraFeature(1, g, string));
            }
            if (Client.instance().isExtraFeatureRelevant(h) && androidComponent.getLabeledBy() != null && !Misc.emptyOrNull((String)(string = androidComponent.getLabeledBy().getText()))) {
                extraFeatureSet.add(new ExtraFeature(1, h, string));
            }
            if (Client.instance().isExtraFeatureRelevant(i) && androidComponent.isRoot()) {
                string = null;
                if (androidComponent.getWindowType() == 1) {
                    string = "APPLICATION";
                } else if (androidComponent.getWindowType() == 2) {
                    string = "INPUT";
                } else if (androidComponent.getWindowType() == 3) {
                    string = "SYSTEM";
                }
                if (string != null) {
                    extraFeatureSet.add(new ExtraFeature(1, i, string));
                }
            }
            return extraFeatureSet;
        }
        return null;
    }
}

