/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long groupHandle;
    long labelHandle;
    long imageHandle;
    long boxHandle;
    int accelerator;
    int userId;
    String toolTipText;

    public MenuItem(Menu menu, int n) {
        super((Widget)menu, MenuItem.checkStyle(n));
        this.parent = menu;
        this.createWidget(menu.getItemCount());
    }

    public MenuItem(Menu menu, int n, int n2) {
        super((Widget)menu, MenuItem.checkStyle(n));
        this.parent = menu;
        int n3 = menu.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    void addAccelerator(long l) {
        this.updateAccelerator(l, true);
    }

    void addAccelerators(long l) {
        this.addAccelerator(l);
        if (this.menu != null) {
            this.menu.addAccelerators(l);
        }
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)armListener);
        this.addListener(30, (Listener)typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)helpListener);
        this.addListener(28, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)selectionListener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    static int checkStyle(int n) {
        return MenuItem.checkBits((int)n, (int)8, (int)32, (int)16, (int)2, (int)64, (int)0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        boolean bl;
        long l;
        this.state |= 8;
        byte[] byArray = new byte[1];
        int n2 = 122;
        switch (this.style & n2) {
            case 2: {
                this.handle = GTK.gtk_separator_menu_item_new();
                if (this.handle != 0L) break;
                this.error(2);
                break;
            }
            case 16: {
                this.groupHandle = GTK.gtk_radio_menu_item_new((long)0L);
                if (this.groupHandle == 0L) {
                    this.error(2);
                }
                OS.g_object_ref_sink(this.groupHandle);
                l = GTK.gtk_radio_menu_item_get_group((long)this.groupHandle);
                this.handle = GTK.gtk_radio_menu_item_new((long)l);
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.labelHandle = GTK.gtk_accel_label_new((byte[])byArray);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.boxHandle = this.gtk_box_new(0, false, 6);
                if (this.boxHandle == 0L) {
                    this.error(2);
                }
                if (!OS.SWT_PADDED_MENU_ITEMS) break;
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle != 0L) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = GTK.gtk_check_menu_item_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.labelHandle = GTK.gtk_accel_label_new((byte[])byArray);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.boxHandle = this.gtk_box_new(0, false, 6);
                if (this.boxHandle == 0L) {
                    this.error(2);
                }
                if (!OS.SWT_PADDED_MENU_ITEMS) break;
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle != 0L) break;
                this.error(2);
                break;
            }
            case 64: {
                this.handle = GTK.gtk_menu_item_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.labelHandle = GTK.gtk_accel_label_new((byte[])byArray);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.boxHandle = this.gtk_box_new(0, false, 6);
                if (this.boxHandle == 0L) {
                    this.error(2);
                }
                if ((this.parent.style & n2) == 2 || !OS.SWT_PADDED_MENU_ITEMS) break;
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle != 0L) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = GTK.gtk_menu_item_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.labelHandle = GTK.gtk_accel_label_new((byte[])byArray);
                if (this.labelHandle == 0L) {
                    this.error(2);
                }
                this.boxHandle = this.gtk_box_new(0, false, 6);
                if (this.boxHandle == 0L) {
                    this.error(2);
                }
                if (!OS.SWT_PADDED_MENU_ITEMS) break;
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle != 0L) break;
                this.error(2);
            }
        }
        if (this.imageHandle != 0L) {
            if (OS.SWT_PADDED_MENU_ITEMS) {
                GTK.gtk_image_set_pixel_size((long)this.imageHandle, (int)16);
            }
            GTK.gtk_container_add((long)this.boxHandle, (long)this.imageHandle);
            GTK.gtk_widget_show((long)this.imageHandle);
        }
        if (this.labelHandle != 0L) {
            GTK.gtk_label_set_xalign((long)this.labelHandle, (float)0.0f);
            GTK.gtk_widget_set_halign((long)this.labelHandle, (int)0);
            this.gtk_box_pack_end(this.boxHandle, this.labelHandle, true, true, 0);
            GTK.gtk_widget_show((long)this.labelHandle);
        }
        if (this.boxHandle != 0L) {
            GTK.gtk_container_add((long)this.handle, (long)this.boxHandle);
            GTK.gtk_widget_show((long)this.boxHandle);
        }
        if ((this.style & 2) == 0) {
            if (this.boxHandle == 0L) {
                this.labelHandle = GTK.gtk_bin_get_child((long)this.handle);
            }
            GTK.gtk_accel_label_set_accel_widget((long)this.labelHandle, (long)0L);
        }
        if (!(bl = GTK.gtk_widget_get_sensitive((long)(l = this.parent.handle)))) {
            GTK.gtk_widget_set_sensitive((long)l, (boolean)true);
        }
        GTK.gtk_menu_shell_insert((long)l, (long)this.handle, (int)n);
        if (!bl) {
            GTK.gtk_widget_set_sensitive((long)l, (boolean)false);
        }
        GTK.gtk_widget_show((long)this.handle);
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null && !this.menu.isDisposed() && !decorations.isDisposed()) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    long getAccelGroup() {
        Menu menu = this.parent;
        while (menu != null && menu.cascade != null) {
            menu = menu.cascade.parent;
        }
        if (menu == null) {
            return 0L;
        }
        Decorations decorations = menu.parent;
        if (decorations == null) {
            return 0L;
        }
        return decorations.menuBar == menu ? decorations.accelGroup : 0L;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!GTK.gtk_widget_get_mapped((long)this.handle)) {
            return new Rectangle(0, 0, 0, 0);
        }
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation((long)this.handle, (GtkAllocation)gtkAllocation);
        int n = gtkAllocation.x;
        int n2 = gtkAllocation.y;
        int n3 = gtkAllocation.width;
        int n4 = gtkAllocation.height;
        return new Rectangle(n, n2, n3, n4);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return GTK.gtk_widget_get_sensitive((long)this.handle);
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return GTK.gtk_check_menu_item_get_active((long)this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    long gtk_activate(long l) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0L;
        }
        if (!this.isEnabled()) {
            return 0L;
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13);
        return 0L;
    }

    long gtk_select(long l) {
        this.parent.selectedItem = this;
        this.sendEvent(30);
        return 0L;
    }

    long gtk_show_help(long l, long l2) {
        boolean bl = this.hooks(28);
        if (bl) {
            this.postEvent(28);
        } else {
            bl = this.parent.sendHelpEvent(l2);
        }
        if (bl) {
            GTK.gtk_menu_shell_deactivate((long)this.parent.handle);
            return 1L;
        }
        return 0L;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.select, this.display.getClosure(44), false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            if (this.menu.selectedItem == this) {
                this.menu.selectedItem = null;
            }
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        if (this.groupHandle != 0L) {
            OS.g_object_unref(this.groupHandle);
        }
        this.groupHandle = 0L;
        this.accelerator = 0;
        this.parent = null;
    }

    void removeAccelerator(long l) {
        this.updateAccelerator(l, false);
    }

    void removeAccelerators(long l) {
        this.removeAccelerator(l);
        if (this.menu != null) {
            this.menu.removeAccelerators(l);
        }
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, (SWTEventListener)armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, (SWTEventListener)helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, (SWTEventListener)selectionListener);
        this.eventTable.unhook(14, (SWTEventListener)selectionListener);
    }

    void reskinChildren(int n) {
        if (this.menu != null) {
            this.menu.reskin(n);
        }
        super.reskinChildren(n);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i = 0; i < menuItemArray.length && menuItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && menuItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < menuItemArray.length && menuItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n) {
        this.checkWidget();
        if (this.accelerator == n) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        this.accelerator = n;
        if (l != 0L) {
            this.addAccelerator(l);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (GTK.gtk_widget_get_sensitive((long)this.handle) == bl) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerator(l);
        }
        GTK.gtk_widget_set_sensitive((long)this.handle, (boolean)bl);
        if (l != 0L) {
            this.addAccelerator(l);
        }
    }

    public void setID(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        this.userId = n;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (image != null) {
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            int n = imageList.indexOf(image);
            long l = 0L;
            if (n == -1) {
                n = imageList.add(image);
                l = imageList.getPixbuf(n);
                if (DPIUtil.useCairoAutoScale()) {
                    Rectangle rectangle = image.getBounds();
                    long l2 = GDK.gdk_pixbuf_scale_simple((long)l, (int)rectangle.width, (int)rectangle.height, (int)2);
                    if (l2 != 0L) {
                        l = l2;
                    }
                    imageList.replacePixbuf(n, l);
                }
            } else {
                imageList.put(n, image);
                l = imageList.getPixbuf(n);
            }
            if (!GTK.GTK_IS_MENU_ITEM((long)this.handle)) {
                return;
            }
            if (OS.SWT_PADDED_MENU_ITEMS && this.imageHandle != 0L) {
                GTK.gtk_image_set_from_pixbuf((long)this.imageHandle, (long)l);
            } else {
                if (this.imageHandle == 0L && this.boxHandle != 0L) {
                    this.imageHandle = GTK.gtk_image_new_from_pixbuf((long)l);
                    GTK.gtk_container_add((long)this.boxHandle, (long)this.imageHandle);
                    GTK.gtk_box_reorder_child((long)this.boxHandle, (long)this.imageHandle, (int)0);
                } else {
                    GTK.gtk_image_set_from_pixbuf((long)this.imageHandle, (long)l);
                }
                if (this.boxHandle == 0L) {
                    this.error(2);
                }
            }
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            GTK.gtk_widget_show((long)this.imageHandle);
        } else if (this.imageHandle != 0L && this.boxHandle != 0L) {
            if (OS.SWT_PADDED_MENU_ITEMS) {
                GTK.gtk_container_remove((long)this.boxHandle, (long)this.imageHandle);
                this.imageHandle = GTK.gtk_image_new();
                if (this.imageHandle == 0L) {
                    this.error(2);
                }
                GTK.gtk_image_set_pixel_size((long)this.imageHandle, (int)16);
                GTK.gtk_container_add((long)this.boxHandle, (long)this.imageHandle);
                GTK.gtk_widget_show((long)this.imageHandle);
            } else {
                GTK.gtk_container_remove((long)this.boxHandle, (long)this.imageHandle);
                this.imageHandle = 0L;
            }
        }
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        long l = this.getAccelGroup();
        if (l != 0L) {
            this.removeAccelerators(l);
        }
        if (menu2 != null) {
            menu2.cascade = null;
            OS.g_object_ref(menu2.handle);
            GTK.gtk_menu_item_set_submenu((long)this.handle, (long)0L);
        }
        if ((this.menu = menu) != null) {
            menu.cascade = this;
            GTK.gtk_menu_item_set_submenu((long)this.handle, (long)menu.handle);
        }
        if (l != 0L) {
            this.addAccelerators(l);
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            GTK.gtk_widget_set_direction((long)this.handle, (int)n);
            GTK.gtk_container_forall((long)this.handle, (long)this.display.setDirectionProc, (long)n);
            if (this.menu != null) {
                this.menu._setOrientation(this.parent.style & 0x6000000);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
        GTK.gtk_check_menu_item_set_active((long)this.handle, (boolean)bl);
        if ((this.style & 0x10) != 0) {
            GTK.gtk_check_menu_item_set_active((long)this.groupHandle, (!bl ? 1 : 0) != 0);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 1L);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        int n = string.indexOf(9);
        if (n != -1) {
            string = string.substring(0, n);
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs((char[])cArray, (boolean)true);
        if (this.labelHandle != 0L && GTK.GTK_IS_LABEL((long)this.labelHandle)) {
            GTK.gtk_label_set_text_with_mnemonic((long)this.labelHandle, (byte[])byArray);
            if (GTK.GTK_IS_ACCEL_LABEL((long)this.labelHandle)) {
                MaskKeysym maskKeysym = this.getMaskKeysym();
                if (maskKeysym != null) {
                    GTK.gtk_accel_label_set_accel_widget((long)this.labelHandle, (long)this.handle);
                    GTK.gtk_accel_label_set_accel((long)this.labelHandle, (int)maskKeysym.keysym, (int)maskKeysym.mask);
                }
                OS.g_signal_emit_by_name(this.handle, OS.accel_closures_changed);
            }
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (string != null && (string.trim().length() == 0 || string.equals(this.toolTipText))) {
            return;
        }
        this.toolTipText = string;
        this.parent.getShell().setToolTipText(this.handle, this.toolTipText);
    }

    void updateAccelerator(long l, boolean bl) {
        int n;
        int n2;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return;
        }
        int n3 = 0;
        if ((this.accelerator & 0x10000) != 0) {
            n3 |= 8;
        }
        if ((this.accelerator & 0x20000) != 0) {
            n3 |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            n3 |= 4;
        }
        if ((n2 = Display.untranslateKey(n = this.accelerator & 0x100FFFF)) != 0) {
            n = n2;
        } else {
            switch (n) {
                case 13: {
                    n = 65293;
                    break;
                }
                default: {
                    n = Converter.wcsToMbcs((char)((char)n));
                }
            }
        }
        if (n != 0) {
            if (bl) {
                GTK.gtk_widget_add_accelerator((long)this.handle, (byte[])OS.activate, (long)l, (int)n, (int)n3, (int)1);
            } else {
                GTK.gtk_widget_remove_accelerator((long)this.handle, (long)l, (int)n, (int)n3);
            }
        }
    }

    private MaskKeysym getMaskKeysym() {
        if (this.text == null) {
            return null;
        }
        MaskKeysym maskKeysym = new MaskKeysym();
        int n = this.text.indexOf(9);
        if (n == -1) {
            return null;
        }
        int n2 = n + 1;
        int n3 = this.text.indexOf(43, n2);
        while (n3 != -1) {
            String string = this.text.substring(n2, n3);
            if (string.equals("Ctrl")) {
                maskKeysym.mask |= 4;
            }
            if (string.equals("Shift")) {
                maskKeysym.mask |= 1;
            }
            if (string.equals("Alt")) {
                maskKeysym.mask |= 8;
            }
            n2 = n3 + 1;
            n3 = this.text.indexOf(43, n2);
        }
        if ("Enter".equals(this.text.substring(n2))) {
            maskKeysym.keysym = 65076;
        }
        block0 : switch (this.text.length() - n2) {
            case 1: {
                maskKeysym.keysym = this.text.charAt(n2);
                maskKeysym.keysym = Converter.wcsToMbcs((char)((char)maskKeysym.keysym));
                break;
            }
            case 2: {
                if (this.text.charAt(n2) != 'F') break;
                switch (this.text.charAt(n2 + 1)) {
                    case '1': {
                        maskKeysym.keysym = 65470;
                        break;
                    }
                    case '2': {
                        maskKeysym.keysym = 65471;
                        break;
                    }
                    case '3': {
                        maskKeysym.keysym = 65472;
                        break;
                    }
                    case '4': {
                        maskKeysym.keysym = 65473;
                        break;
                    }
                    case '5': {
                        maskKeysym.keysym = 65474;
                        break;
                    }
                    case '6': {
                        maskKeysym.keysym = 65475;
                        break;
                    }
                    case '7': {
                        maskKeysym.keysym = 65476;
                        break;
                    }
                    case '8': {
                        maskKeysym.keysym = 65477;
                        break;
                    }
                    case '9': {
                        maskKeysym.keysym = 65478;
                    }
                }
                break;
            }
            case 3: {
                if (this.text.charAt(n2) != 'F' || this.text.charAt(n2 + 1) != '1') break;
                switch (this.text.charAt(n2 + 2)) {
                    case '0': {
                        maskKeysym.keysym = 65479;
                        break block0;
                    }
                    case '1': {
                        maskKeysym.keysym = 65480;
                        break block0;
                    }
                    case '2': {
                        maskKeysym.keysym = 65481;
                        break block0;
                    }
                    case '3': {
                        maskKeysym.keysym = 65482;
                        break block0;
                    }
                    case '4': {
                        maskKeysym.keysym = 65483;
                        break block0;
                    }
                    case '5': {
                        maskKeysym.keysym = 65484;
                    }
                }
            }
        }
        return maskKeysym;
    }

    boolean updateAcceleratorText(boolean bl) {
        if (this.accelerator != 0) {
            return false;
        }
        MaskKeysym maskKeysym = null;
        if (bl) {
            maskKeysym = this.getMaskKeysym();
        }
        if (maskKeysym == null) {
            return true;
        }
        if (maskKeysym.keysym != 0) {
            long l = this.getAccelGroup();
            if (bl) {
                GTK.gtk_widget_add_accelerator((long)this.handle, (byte[])OS.activate, (long)l, (int)maskKeysym.keysym, (int)maskKeysym.mask, (int)1);
            } else {
                GTK.gtk_widget_remove_accelerator((long)this.handle, (long)l, (int)maskKeysym.keysym, (int)maskKeysym.mask);
            }
        }
        return maskKeysym.keysym != 0;
    }

    private class MaskKeysym {
        int mask = 0;
        int keysym = 0;

        private MaskKeysym() {
        }
    }
}

