/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.Worker;
import org.jboss.netty.channel.socket.oio.AbstractOioChannel;

abstract class AbstractOioWorker<C extends AbstractOioChannel>
implements Worker {
    private final Queue<Runnable> eventQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final C channel;
    protected volatile Thread thread;
    private volatile boolean done;

    protected AbstractOioWorker(C channel) {
        this.channel = channel;
        ((AbstractOioChannel)channel).worker = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = ((AbstractOioChannel)this.channel).workerThread = Thread.currentThread();
        while (((AbstractChannel)this.channel).isOpen()) {
            Object object = ((AbstractOioChannel)this.channel).interestOpsLock;
            synchronized (object) {
                while (!((AbstractChannel)this.channel).isReadable()) {
                    try {
                        ((AbstractOioChannel)this.channel).interestOpsLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (((AbstractChannel)this.channel).isOpen()) continue;
                        break;
                    }
                }
            }
            boolean cont = false;
            try {
                cont = this.process();
            }
            catch (Throwable t) {
                boolean readTimeout = t instanceof SocketTimeoutException;
                if (!readTimeout && !((AbstractOioChannel)this.channel).isSocketClosed()) {
                    Channels.fireExceptionCaught(this.channel, t);
                }
                if (readTimeout) {
                    cont = true;
                }
            }
            finally {
                this.processEventQueue();
            }
            if (cont) continue;
            break;
        }
        Object object = ((AbstractOioChannel)this.channel).interestOpsLock;
        synchronized (object) {
            ((AbstractOioChannel)this.channel).workerThread = null;
        }
        AbstractOioWorker.close(this.channel, Channels.succeededFuture(this.channel), true);
        this.done = true;
        this.processEventQueue();
    }

    static boolean isIoThread(AbstractOioChannel channel) {
        return Thread.currentThread() == channel.workerThread;
    }

    @Override
    public void executeInIoThread(Runnable task) {
        if (Thread.currentThread() == this.thread || this.done) {
            task.run();
        } else {
            boolean added = this.eventQueue.offer(task);
            if (added) {
                // empty if block
            }
        }
    }

    private void processEventQueue() {
        Runnable task;
        while ((task = this.eventQueue.poll()) != null) {
            task.run();
        }
    }

    abstract boolean process() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInterestOps(AbstractOioChannel channel, ChannelFuture future, int interestOps) {
        block12: {
            boolean iothread = AbstractOioWorker.isIoThread(channel);
            interestOps &= 0xFFFFFFFB;
            interestOps |= channel.getInternalInterestOps() & 4;
            boolean changed = false;
            try {
                if (channel.getInternalInterestOps() != interestOps) {
                    if ((interestOps & 1) != 0) {
                        channel.setInternalInterestOps(1);
                    } else {
                        channel.setInternalInterestOps(0);
                    }
                    changed = true;
                }
                future.setSuccess();
                if (!changed) break block12;
                Object object = channel.interestOpsLock;
                synchronized (object) {
                    channel.setInternalInterestOps(interestOps);
                    Thread currentThread = Thread.currentThread();
                    Thread workerThread = channel.workerThread;
                    if (workerThread != null && currentThread != workerThread) {
                        workerThread.interrupt();
                    }
                }
                if (iothread) {
                    Channels.fireChannelInterestChanged(channel);
                } else {
                    Channels.fireChannelInterestChangedLater(channel);
                }
            }
            catch (Throwable t) {
                future.setFailure(t);
                if (iothread) {
                    Channels.fireExceptionCaught(channel, t);
                }
                Channels.fireExceptionCaughtLater(channel, t);
            }
        }
    }

    static void close(AbstractOioChannel channel, ChannelFuture future) {
        AbstractOioWorker.close(channel, future, AbstractOioWorker.isIoThread(channel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(AbstractOioChannel channel, ChannelFuture future, boolean iothread) {
        block16: {
            boolean connected = channel.isConnected();
            boolean bound = channel.isBound();
            try {
                channel.closeSocket();
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (connected) {
                        Thread currentThread = Thread.currentThread();
                        Object object = channel.interestOpsLock;
                        synchronized (object) {
                            Thread workerThread = channel.workerThread;
                            if (workerThread != null && currentThread != workerThread) {
                                workerThread.interrupt();
                            }
                        }
                        if (iothread) {
                            Channels.fireChannelDisconnected(channel);
                        } else {
                            Channels.fireChannelDisconnectedLater(channel);
                        }
                    }
                    if (bound) {
                        if (iothread) {
                            Channels.fireChannelUnbound(channel);
                        } else {
                            Channels.fireChannelUnboundLater(channel);
                        }
                    }
                    if (iothread) {
                        Channels.fireChannelClosed(channel);
                    } else {
                        Channels.fireChannelClosedLater(channel);
                    }
                    break block16;
                }
                future.setSuccess();
            }
            catch (Throwable t) {
                future.setFailure(t);
                if (iothread) {
                    Channels.fireExceptionCaught(channel, t);
                }
                Channels.fireExceptionCaughtLater(channel, t);
            }
        }
    }
}

