/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.http.cookie;

import java.util.Iterator;
import org.jboss.netty.handler.codec.http.cookie.Cookie;
import org.jboss.netty.handler.codec.http.cookie.CookieEncoder;
import org.jboss.netty.handler.codec.http.cookie.CookieUtil;
import org.jboss.netty.handler.codec.http.cookie.DefaultCookie;

public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);

    private ClientCookieEncoder(boolean strict) {
        super(strict);
    }

    public String encode(String name, String value) {
        return this.encode((Cookie)new DefaultCookie(name, value));
    }

    public String encode(Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie");
        }
        StringBuilder buf = new StringBuilder();
        this.encode(buf, cookie);
        return CookieUtil.stripTrailingSeparator(buf);
    }

    public String encode(Cookie ... cookies) {
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        if (cookies.length == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (Cookie c : cookies) {
            if (c == null) break;
            this.encode(buf, c);
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    public String encode(Iterable<? extends Cookie> cookies) {
        Cookie c;
        if (cookies == null) {
            throw new NullPointerException("cookies");
        }
        Iterator<? extends Cookie> cookiesIt = cookies.iterator();
        if (!cookiesIt.hasNext()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        while (cookiesIt.hasNext() && (c = cookiesIt.next()) != null) {
            this.encode(buf, c);
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    private void encode(StringBuilder buf, Cookie c) {
        String name = c.name();
        String value = c.value() != null ? c.value() : "";
        this.validateCookie(name, value);
        if (c.wrap()) {
            CookieUtil.addQuoted(buf, name, value);
        } else {
            CookieUtil.add(buf, name, value);
        }
    }
}

