/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.timeout;

import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

@ChannelHandler.Sharable
public class ReadTimeoutHandler
extends SimpleChannelUpstreamHandler
implements LifeCycleAwareChannelHandler,
ExternalResourceReleasable {
    static final ReadTimeoutException EXCEPTION = new ReadTimeoutException();
    final Timer timer;
    final long timeoutMillis;

    public ReadTimeoutHandler(Timer timer, int timeoutSeconds) {
        this(timer, timeoutSeconds, TimeUnit.SECONDS);
    }

    public ReadTimeoutHandler(Timer timer, long timeout, TimeUnit unit) {
        if (timer == null) {
            throw new NullPointerException("timer");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.timer = timer;
        this.timeoutMillis = timeout <= 0L ? 0L : Math.max(unit.toMillis(timeout), 1L);
    }

    @Override
    public void releaseExternalResources() {
        this.timer.stop();
    }

    @Override
    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        if (ctx.getPipeline().isAttached()) {
            this.initialize(ctx);
        }
    }

    @Override
    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
        ReadTimeoutHandler.destroy(ctx);
    }

    @Override
    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.initialize(ctx);
        ctx.sendUpstream(e);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ReadTimeoutHandler.destroy(ctx);
        ctx.sendUpstream(e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        State state = (State)ctx.getAttachment();
        state.lastReadTime = System.currentTimeMillis();
        ctx.sendUpstream(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(ChannelHandlerContext ctx) {
        State state;
        State state2 = state = ReadTimeoutHandler.state(ctx);
        synchronized (state2) {
            switch (state.state) {
                case 1: 
                case 2: {
                    return;
                }
            }
            state.state = 1;
        }
        if (this.timeoutMillis > 0L) {
            state.timeout = this.timer.newTimeout(new ReadTimeoutTask(ctx), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void destroy(ChannelHandlerContext ctx) {
        State state;
        State state2 = state = ReadTimeoutHandler.state(ctx);
        synchronized (state2) {
            if (state.state != 1) {
                return;
            }
            state.state = 2;
        }
        if (state.timeout != null) {
            state.timeout.cancel();
            state.timeout = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State state(ChannelHandlerContext ctx) {
        State state;
        ChannelHandlerContext channelHandlerContext = ctx;
        synchronized (channelHandlerContext) {
            state = (State)ctx.getAttachment();
            if (state != null) {
                return state;
            }
            state = new State();
            ctx.setAttachment(state);
        }
        return state;
    }

    protected void readTimedOut(ChannelHandlerContext ctx) throws Exception {
        Channels.fireExceptionCaught(ctx, (Throwable)EXCEPTION);
    }

    private static final class State {
        int state;
        volatile Timeout timeout;
        volatile long lastReadTime = System.currentTimeMillis();

        State() {
        }
    }

    private final class ReadTimeoutTask
    implements TimerTask {
        private final ChannelHandlerContext ctx;

        ReadTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            if (!this.ctx.getChannel().isOpen()) {
                return;
            }
            State state = (State)this.ctx.getAttachment();
            long currentTime = System.currentTimeMillis();
            long nextDelay = ReadTimeoutHandler.this.timeoutMillis - (currentTime - state.lastReadTime);
            if (nextDelay <= 0L) {
                state.timeout = ReadTimeoutHandler.this.timer.newTimeout(this, ReadTimeoutHandler.this.timeoutMillis, TimeUnit.MILLISECONDS);
                this.fireReadTimedOut(this.ctx);
            } else {
                state.timeout = ReadTimeoutHandler.this.timer.newTimeout(this, nextDelay, TimeUnit.MILLISECONDS);
            }
        }

        private void fireReadTimedOut(final ChannelHandlerContext ctx) throws Exception {
            ctx.getPipeline().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReadTimeoutHandler.this.readTimedOut(ctx);
                    }
                    catch (Throwable t) {
                        Channels.fireExceptionCaught(ctx, t);
                    }
                }
            });
        }
    }
}

