/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.UIManager;

public abstract class BaseDemo
implements Runnable {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.multi.BaseDemo");
    public static String[] argdef = new String[]{"-dialog", "-noop"};
    protected String[] args;
    protected ArgsParser argsParser;
    protected boolean asDialog;
    protected boolean asNonModal;
    protected boolean special1;
    protected boolean special2;
    protected boolean special3;
    protected Frame frame;
    protected Dialog dialog;
    protected boolean exitOnClose;
    private boolean justHide;

    public BaseDemo(boolean bl) {
        this.asDialog = bl;
    }

    public BaseDemo(boolean bl, boolean bl2) {
        this.asDialog = bl;
        this.justHide = bl2;
    }

    public static void setupAndRun(String[] stringArray, BaseDemo baseDemo) {
        Log.setOutputLevel((int)10);
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "main()", "");
        }
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            String string = UIManager.getSystemLookAndFeelClassName();
            if (string.endsWith("MotifLookAndFeel")) {
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            logger.log("main(String[])", (Throwable)exception);
        }
        baseDemo.argsParser = new ArgsParser(argdef);
        LogSetup.instance().addOptions(baseDemo.argsParser);
        baseDemo.addArgOptions();
        try {
            baseDemo.argsParser.parse(stringArray);
            LogSetup.instance().setupLogging("awt", baseDemo.argsParser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        baseDemo.setAsDialog(baseDemo.argsParser.getBoolean("dialog", false));
        new JDK11BugThread().start();
        baseDemo.setExitOnClose(true);
        SwingUtil.invokeAndWait((Runnable)baseDemo);
    }

    public final boolean isExitOnClose() {
        return this.exitOnClose;
    }

    public final void setExitOnClose(boolean bl) {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "setExitOnClose(boolean)", BaseDemo.logger.level < 8 ? "" : "exitOnClose: " + bl);
        }
        this.exitOnClose = bl;
    }

    public final ArgsParser getArgsParser() {
        return this.argsParser;
    }

    public final void setArgsParser(ArgsParser argsParser) {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "setArgsParser(ArgsParser)", BaseDemo.logger.level < 8 ? "" : "argsParser: " + argsParser);
        }
        this.argsParser = argsParser;
    }

    public final boolean isAsDialog() {
        return this.asDialog;
    }

    public final void setAsDialog(boolean bl) {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "setAsDialog(boolean)", BaseDemo.logger.level < 8 ? "" : "asDialog: " + bl);
        }
        this.asDialog = bl;
    }

    public final boolean isAsNonModal() {
        return this.asNonModal;
    }

    public final void setNonModal(boolean bl) {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "setNonModal(boolean)", BaseDemo.logger.level < 8 ? "" : "asnonModal: " + bl);
        }
        this.asNonModal = bl;
    }

    public final boolean isSpecial1() {
        return this.special1;
    }

    public final void setSpecial1(boolean bl) {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "setSpecial1(boolean)", BaseDemo.logger.level < 8 ? "" : "special1: " + bl);
        }
        this.special1 = bl;
    }

    public final boolean isSpecial2() {
        return this.special2;
    }

    public final void setSpecial2(boolean bl) {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "setSpecial2(boolean)", BaseDemo.logger.level < 8 ? "" : "special2: " + bl);
        }
        this.special2 = bl;
    }

    public final boolean isSpecial3() {
        return this.special3;
    }

    public final void setSpecial3(boolean bl) {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "setSpecial3(boolean)", BaseDemo.logger.level < 8 ? "" : "special3: " + bl);
        }
        this.special3 = bl;
    }

    public Window getWindow() {
        return this.frame == null ? this.dialog : this.frame;
    }

    @Override
    public void run() {
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "run()", "");
        }
        this.showFrameOrDialog();
    }

    protected abstract void showFrameOrDialog();

    protected void addArgOptions() {
    }

    protected void finishWindow(Window window) {
        this.finishWindow(window, -1, -1);
    }

    protected void finishWindow(Window window, int n, int n2) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BaseDemo.this.exit(0);
            }
        });
        window.pack();
        if (n >= 0 && n2 >= 0) {
            window.setSize(n, n2);
        }
        SwingUtil.centerWindow((Window)window);
        window.show();
        if (BaseDemo.logger.level >= 7) {
            logger.log(7, "finishWindow(Window,int,int)", "Done showing");
        }
    }

    protected void exit(int n) {
        if (this.exitOnClose) {
            if (BaseDemo.logger.level >= 7) {
                logger.log(7, "exit()", "");
            }
            LogSetup.instance().stopLogging();
            System.exit(n);
        } else {
            if (BaseDemo.logger.level >= 7) {
                logger.log(7, "dispose()", "");
            }
            if (this.dialog != null) {
                if (this.justHide) {
                    this.dialog.setVisible(false);
                } else {
                    this.dialog.dispose();
                    this.dialog = null;
                }
            }
            if (this.frame != null) {
                if (this.justHide) {
                    this.frame.setVisible(false);
                } else {
                    this.frame.dispose();
                    this.frame = null;
                }
            }
        }
    }

    private static class JDK11BugThread
    extends Thread {
        Class[] bug = new Class[]{Log.class, Logger.class};

        public JDK11BugThread() {
            this.setDaemon(true);
            this.setName("JDK1.1 Bug Workaroud Thread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        JDK11BugThread.sleep(3600000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

