/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class Combo {
    private static JComboBox combo;
    private static ActionListener exitAction;
    private static ActionListener nextAction;

    public static void main(String[] stringArray) {
        Log.setOutputLevel((int)4);
        ArgsParser argsParser = new ArgsParser();
        LogSetup.instance().addOptions(argsParser);
        try {
            argsParser.parse(stringArray);
            LogSetup.instance().setupLogging("combo", argsParser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = Combo.makeFrame();
        SwingUtil.centerWindow((Window)jFrame);
        SwingUtil.closeOnEscape((Window)jFrame);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Combo.exit(0);
            }
        });
        new JDK11BugThread().start();
        jFrame.show();
    }

    private static JFrame makeFrame() {
        JFrame jFrame = new JFrame("Combo demo");
        Grid grid = new Grid();
        jFrame.getContentPane().add((Component)grid);
        grid.addGlue();
        SwingUtil.prepareKeymaps();
        combo = new JComboBox<String>(new String[]{"one", "two", "three", "four", "five"});
        combo.setName("combo");
        combo.setPreferredSize(new Dimension(200, Combo.combo.getPreferredSize().height));
        grid.addLine(new Component[]{combo});
        grid.addGlue();
        JButton jButton = new JButton("Next");
        jButton.setName("next");
        jButton.addActionListener(nextAction);
        jFrame.getRootPane().setDefaultButton(jButton);
        jButton.setPreferredSize(new Dimension(100, jButton.getPreferredSize().height));
        JButton jButton2 = new JButton("Exit");
        jButton2.setName("exit");
        jButton2.addActionListener(exitAction);
        jButton2.setPreferredSize(new Dimension(100, jButton2.getPreferredSize().height));
        grid.addLine(new Component[]{jButton, Box.createHorizontalGlue(), jButton2});
        jFrame.pack();
        return jFrame;
    }

    private static void exit(int n) {
        LogSetup.instance().stopLogging();
        System.exit(n);
    }

    static {
        exitAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Combo.exit(0);
            }
        };
        nextAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
    }

    private static class JDK11BugThread
    extends Thread {
        Class[] bug = new Class[]{Combo.class, Log.class, Logger.class};

        public JDK11BugThread() {
            this.setDaemon(true);
            this.setName("JDK1.1 Bug Workaroud Thread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        JDK11BugThread.sleep(3600000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

