/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.apps.qftest.demo.DNDComponentInterface;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class DNDList
extends JList
implements DNDComponentInterface,
DragGestureListener,
DragSourceListener,
DropTargetListener {
    DropTarget dropTarget = new DropTarget(this, this);
    DragSource dragSource = DragSource.getDefaultDragSource();

    public DNDList() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dragEnter");
        dropTargetDragEvent.acceptDrag(2);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        System.out.println("dragExit");
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("dragOver");
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                dropTargetDropEvent.acceptDrop(2);
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.addElement(string);
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Exception" + iOException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            System.err.println("Exception" + unsupportedFlavorException.getMessage());
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Object e = this.getSelectedValue();
        if (e != null) {
            StringSelection stringSelection = new StringSelection(e.toString());
            this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, stringSelection, this);
        } else {
            System.out.println("nothing was selected");
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (dragSourceDropEvent.getDropSuccess()) {
            this.removeElement();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println(" dragEnter");
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
        System.out.println(" dragExit");
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println(" dragOver");
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        System.out.println(" dropActionChanged");
    }

    @Override
    public void addElement(Object object) {
        ((DefaultListModel)this.getModel()).addElement(object.toString());
    }

    @Override
    public void removeElement() {
        ((DefaultListModel)this.getModel()).removeElement(this.getSelectedValue());
    }
}

