/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.apps.qftest.demo.Incrementer;
import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

public class IncrementerImpl
extends UnicastRemoteObject
implements Incrementer {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.IncrementerImpl");

    public IncrementerImpl() throws RemoteException {
        if (IncrementerImpl.logger.level >= 7) {
            logger.log(7, "IncrementerImpl()", "this: " + this);
        }
    }

    @Override
    public int increment(int n) {
        if (IncrementerImpl.logger.level >= 7) {
            Logger.Builder builder = logger.build("increment(int)");
            (IncrementerImpl.logger.level < 8 ? builder : builder.add("x: ").add(n).add(", this: ").add((Object)this)).log(7);
        }
        return n + 1;
    }

    @Override
    public int call(Incrementer incrementer, int n) throws RemoteException {
        if (IncrementerImpl.logger.level >= 7) {
            Logger.Builder builder = logger.build("call(Incrementer,int)");
            (IncrementerImpl.logger.level < 8 ? builder : builder.add("incr: ").add((Object)incrementer).add(", x: ").add(n).add(", this: ").add((Object)this)).log(7);
        }
        try {
            return incrementer.increment(n);
        }
        catch (RemoteException remoteException) {
            if (IncrementerImpl.logger.level >= 1) {
                logger.log(1, "call(Incrementer,int)", (Throwable)remoteException);
            }
            throw remoteException;
        }
    }

    public static void main(String[] stringArray) {
        block8: {
            LogSetup.instance().setupInitialLogging("incr");
            ArgsParser argsParser = new ArgsParser();
            argsParser.setOptions(new String[]{"+port"});
            LogSetup.instance().addOptions(argsParser);
            try {
                argsParser.parse(stringArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            LogSetup.instance().setupLogging("incr", argsParser);
            if (IncrementerImpl.logger.level >= 7) {
                Logger.Builder builder = logger.build("main(String[])");
                (IncrementerImpl.logger.level < 8 ? builder : builder.add("args: ").add((Object)stringArray)).log(7);
            }
            int n = argsParser.getInt("port", 4567);
            if (IncrementerImpl.logger.level >= 9) {
                logger.build("main(String[])").add("port: ").add(n).log(9);
            }
            try {
                Registry registry = LocateRegistry.createRegistry(n);
                if (IncrementerImpl.logger.level >= 9) {
                    logger.build("main(String[])").add("reg: ").add((Object)registry).log(9);
                }
                IncrementerImpl incrementerImpl = new IncrementerImpl();
                if (IncrementerImpl.logger.level >= 9) {
                    logger.build("main(String[])").add("incr: ").add((Object)incrementerImpl).log(9);
                }
                registry.rebind("incr", incrementerImpl);
            }
            catch (Throwable throwable) {
                if (IncrementerImpl.logger.level < 1) break block8;
                logger.log(1, "main(String[])", throwable);
            }
        }
    }
}

