/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo;

import de.qfs.lib.config.Configurable;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.option.ChoiceOption;
import de.qfs.lib.option.EditorOption;
import de.qfs.lib.option.IntegerOption;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.NestedOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionDialog;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.OptionValidator;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.option.TableOption;
import de.qfs.lib.option.TextOption;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JButton;

public class Options {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.Options");
    private static final String CFG = "options.cfg";
    public static OptionDialog dialog;

    public static void main(String[] stringArray) {
        String string;
        Object object;
        Log.setOutputLevel((int)2);
        ArgsParser argsParser = new ArgsParser();
        LogSetup.instance().addOptions(argsParser);
        try {
            argsParser.parse(stringArray);
            LogSetup.instance().setupLogging("Options", argsParser);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = System.getProperty("user.language");
        if (string2 != null && string2.length() > 0 && !string2.equals(Locale.getDefault().getLanguage())) {
            object = System.getProperty("user.region", "");
            string = "";
            int n = ((String)object).indexOf(95);
            if (n >= 0) {
                string = ((String)object).substring(n + 1);
                object = ((String)object).substring(0, n);
            }
            Locale.setDefault(new Locale(string2, (String)object, string));
        }
        SwingUtil.prepareKeymaps();
        object = new MapResourceBundle();
        object.fetchProperties("/de/qfs/apps/qftest/demo/resources/properties/options", Options.class);
        Option.addResources((ResourceBundle)object);
        Message.addResources((ResourceBundle)object);
        string = new OptionSet("main");
        TableOption tableOption = new TableOption("table", (Object[][])new Object[][]{{"Alpha", 10, Boolean.TRUE, null, 1}, {"Bravo", 20, Boolean.FALSE, "Multi\nLine\nComment", 2}, {"Charlie", 30, Boolean.TRUE, null, 3}});
        string.add((Option)tableOption);
        String string3 = object.getString("note.text", "Missing: note.text");
        EditorOption editorOption = new EditorOption("note", string3){

            public String getConfigurableValue() {
                return "";
            }

            public void setConfigurableValue(String string) {
            }
        };
        string.add((Option)editorOption);
        string.add((Option)new BooleanOption("boolean", true));
        string.add((Option)new IntegerOption("integer", 0, true, true));
        string.add((Option)new StringOption("string", "Some string", true));
        string.add((Option)new TextOption("text", "This is some\nmulti-line text.", true));
        string.add((Option)new KeyOption("key", null));
        string.add((Option)new KeyOption("key2", null));
        OptionSet optionSet = new OptionSet("integers");
        optionSet.add((Option)new IntegerOption("integer1", 0));
        optionSet.add((Option)new IntegerOption("integer2", -1, false, true));
        optionSet.add((Option)new IntegerOption("integer3", 3, true, true));
        IntegerOption integerOption = new IntegerOption("integer4", 4, true, true);
        integerOption.addValidator(new OptionValidator(){

            public boolean checkValue(Component component, Option option, Object object) {
                if (object != null && (Integer)object % 2 != 0) {
                    Message.showMessageAndHighlight((Component)component, (String)"mustBeEven");
                    return false;
                }
                return true;
            }
        });
        optionSet.add((Option)integerOption);
        string.add((Option)new NestedOption("integers", optionSet));
        OptionSet optionSet2 = new OptionSet("choices");
        optionSet2.add((Option)new IntegerOption("radio", 1));
        optionSet2.add((Option)new ChoiceOption("combo", (Object)"Different choice"));
        optionSet2.add((Option)new ChoiceOption("combo2", (Object)"First choice"));
        string.add((Option)new NestedOption("choices", optionSet2));
        Configuration.instance().register((Configurable)string);
        try {
            Configuration.instance().restore((InputStream)new FileInputStream(CFG));
            System.err.println("Configuration restored");
        }
        catch (Exception exception) {
            System.err.println("Configuration not read");
        }
        SwingUtil.invokeAndWait((Runnable)new Runnable((OptionSet)string){
            final /* synthetic */ OptionSet val$main;
            {
                this.val$main = optionSet;
            }

            @Override
            public void run() {
                JButton jButton;
                dialog = new OptionDialog("demo", (Frame)null, this.val$main, "tree");
                JButton jButton2 = dialog.getButton("save");
                if (jButton2 == null) {
                    if (logger.level >= 1) {
                        logger.log(1, "main(String[])", "No save button");
                    }
                } else {
                    jButton2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (dialog.readValues()) {
                                try {
                                    Configuration.instance().save((OutputStream)new FileOutputStream(Options.CFG));
                                    System.err.println("Configuration saved.");
                                }
                                catch (Exception exception) {
                                    System.err.println("Configuration not saved.");
                                }
                            } else {
                                throw new RuntimeException("For debugging only");
                            }
                        }
                    });
                }
                if ((jButton = dialog.getButton("reset")) == null) {
                    if (logger.level >= 1) {
                        logger.log(1, "main(String[])", "No reset button");
                    }
                } else {
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                Configuration.instance().restore((InputStream)new FileInputStream(Options.CFG));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            dialog.update(val$main);
                        }
                    });
                }
                dialog.doModal(null, true);
            }
        });
        LogSetup.instance().stopLogging();
        System.exit(0);
    }
}

