/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ColumnConstraintsBuilder;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MainStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MessageBox;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Accessory;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Special;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;
import java.util.Collection;
import java.util.LinkedList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class AccessoriesStage
extends CarConfigFxStage {
    MainStage mainStage;
    public AccessoriesStage accessoriesStage = this;
    public LinkedList accessories;
    public LinkedList savedSelectedAccessory;
    public Accessory selectedAccessory;
    public LinkedList specials;
    public Special savedSelectedSpecial;
    TableView accessoriesTablePanelTableView;
    TextField accessoryNameTextField;
    TextField accessoryIdTextField;
    TextField accessoryPriceTextField;

    public AccessoriesStage(MainStage mainStage) {
        super(mainStage.params);
        Cloneable cloneable;
        Cloneable cloneable22;
        this.mainStage = mainStage;
        this.setTitle(LangCountrySettings.getLanguageString("dialog.accessories.name"));
        this.specials = new LinkedList();
        for (Cloneable cloneable22 : mainStage.specials) {
            cloneable = ((Special)cloneable22).clone();
            if (mainStage.selectedSpecial == cloneable22) {
                this.savedSelectedSpecial = cloneable;
            }
            this.specials.add(cloneable);
        }
        this.accessories = new LinkedList();
        this.savedSelectedAccessory = new LinkedList();
        for (Cloneable cloneable22 : mainStage.accessories) {
            cloneable = ((Accessory)cloneable22).clone();
            if (mainStage.selectedAccessories.contains(cloneable22)) {
                this.savedSelectedAccessory.add(cloneable);
            }
            for (Special special : this.specials) {
                if (!special.containingAccessories.contains(cloneable22)) continue;
                special.containingAccessories.remove(cloneable22);
                special.containingAccessories.add(cloneable);
            }
            this.accessories.add(((Accessory)cloneable22).clone());
        }
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        borderPane.setId("AccessoryDialog");
        borderPane.setPrefHeight(400.0);
        borderPane.setPrefWidth(600.0);
        cloneable22 = new Scene((Parent)borderPane);
        this.setScene((Scene)cloneable22);
        borderPane.setCenter(this.createMiddleElements());
        borderPane.setRight(this.createRightElements());
        this.updateAccessoryTablePaneTableView();
    }

    public Node createMiddleElements() {
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).hgrow(Priority.ALWAYS).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.setHgap(3.0);
        gridPane.setVgap(3.0);
        gridPane.setPrefWidth(300.0);
        gridPane.setPrefHeight(100.0);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.accessories.name"));
        label.setStyle("-fx-text-fill: blue;");
        gridPane.add((Node)label, 0, 1);
        this.accessoriesTablePanelTableView = new TableView();
        this.accessoriesTablePanelTableView.setId("AccessoriesTable");
        this.accessoriesTablePanelTableView.setMaxHeight(Double.MAX_VALUE);
        this.accessoriesTablePanelTableView.setMaxWidth(Double.MAX_VALUE);
        this.accessoriesTablePanelTableView.setEditable(false);
        this.accessoriesTablePanelTableView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.accessoriesTablePanelTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.accessoriesTablePanelTableView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new OnAccessoryTableColumnClickEventHandler());
        gridPane.add((Node)this.accessoriesTablePanelTableView, 0, 2);
        gridPane.setId("AccessoryTablePanel");
        GridPane gridPane2 = new GridPane();
        gridPane2.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        ColumnConstraints columnConstraints2 = ColumnConstraintsBuilder.create().maxWidth(Double.NEGATIVE_INFINITY).hgrow(Priority.SOMETIMES).build();
        ColumnConstraints columnConstraints3 = ColumnConstraintsBuilder.create().maxWidth(Double.MAX_VALUE).hgrow(Priority.SOMETIMES).build();
        ColumnConstraints columnConstraints4 = ColumnConstraintsBuilder.create().maxWidth(Double.NEGATIVE_INFINITY).hgrow(Priority.SOMETIMES).build();
        ColumnConstraints columnConstraints5 = ColumnConstraintsBuilder.create().maxWidth(Double.NEGATIVE_INFINITY).hgrow(Priority.SOMETIMES).build();
        gridPane2.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints2, columnConstraints3, columnConstraints4, columnConstraints5});
        gridPane2.setHgap(3.0);
        gridPane2.setId("AccessoryDialogEditPanel");
        Label label2 = new Label(LangCountrySettings.getLanguageString("dialog.accessories.edit.name"));
        label2.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label2, 0, 0);
        this.accessoryNameTextField = new TextField("");
        this.accessoryNameTextField.setMaxWidth(120.0);
        this.accessoryNameTextField.setId("AccessoryName");
        gridPane2.add((Node)this.accessoryNameTextField, 0, 1);
        Label label3 = new Label(LangCountrySettings.getLanguageString("dialog.accessories.edit.id"));
        label3.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label3, 2, 0);
        this.accessoryIdTextField = new TextField("");
        this.accessoryIdTextField.setMaxWidth(36.0);
        this.accessoryIdTextField.setId("AccessoryId");
        gridPane2.add((Node)this.accessoryIdTextField, 2, 1);
        Label label4 = new Label(LangCountrySettings.getLanguageString("dialog.accessories.edit.price"));
        label4.setStyle("-fx-text-fill: blue;");
        gridPane2.add((Node)label4, 3, 0);
        this.accessoryPriceTextField = new TextField("");
        this.accessoryPriceTextField.setMaxWidth(80.0);
        this.accessoryPriceTextField.setId("AccessoryPrice");
        gridPane2.add((Node)this.accessoryPriceTextField, 3, 1);
        borderPane.setCenter((Node)gridPane);
        borderPane.setBottom((Node)gridPane2);
        return borderPane;
    }

    public Node createRightElements() {
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderPane.setId("changeButtonPanel");
        VBox vBox = new VBox();
        vBox.setSpacing(3.0);
        Button button = new Button(LangCountrySettings.getLanguageString("button.new"));
        button.setId("NewButton");
        button.setOnAction((EventHandler)new OnNewButtonEventHandler());
        button.setMaxWidth(Double.MAX_VALUE);
        Button button2 = new Button(LangCountrySettings.getLanguageString("button.change"));
        button2.setId("ChangeButton");
        button2.setOnAction((EventHandler)new OnChangeButtonEventHandler());
        button2.setMaxWidth(Double.MAX_VALUE);
        Button button3 = new Button(LangCountrySettings.getLanguageString("button.delete"));
        button3.setId("DeleteButton");
        button3.setOnAction((EventHandler)new OnDeleteButtonEventHandler());
        button3.setMaxWidth(Double.MAX_VALUE);
        vBox.getChildren().addAll((Object[])new Node[]{button, button2, button3});
        borderPane.setTop((Node)vBox);
        VBox vBox2 = new VBox();
        vBox2.setSpacing(3.0);
        Button button4 = new Button(LangCountrySettings.getLanguageString("button.cancel"));
        button4.setId("CancelButton");
        button4.setOnAction((EventHandler)new OnCancelButtonEventHandler());
        button4.setMaxWidth(Double.MAX_VALUE);
        Button button5 = new Button(LangCountrySettings.getLanguageString("button.ok"));
        button5.setId("OkButton");
        button5.setOnAction((EventHandler)new OnOkButtonEventHandler());
        button5.setMaxWidth(Double.MAX_VALUE);
        vBox2.getChildren().addAll((Object[])new Node[]{button4, button5});
        borderPane.setBottom((Node)vBox2);
        return borderPane;
    }

    public void updateAccessoryTablePaneTableView() {
        TableColumn tableColumn = new TableColumn();
        TableColumn tableColumn2 = new TableColumn();
        TableColumn tableColumn3 = new TableColumn();
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        tableColumn2.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER;");
                return tableCell;
            }
        });
        tableColumn3.setCellFactory(new Callback(){

            public TableCell call(TableColumn tableColumn) {
                TableCell tableCell = new TableCell(){

                    public void updateItem(String string, boolean bl) {
                        super.updateItem((Object)string, bl);
                        this.setText(bl ? null : this.getString());
                        this.setGraphic(null);
                    }

                    private String getString() {
                        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
                    }
                };
                tableCell.setStyle("-fx-alignment: CENTER-RIGHT;");
                return tableCell;
            }
        });
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)this.params.getLanguage())) {
            tableColumn.setText("Beschreibung");
            tableColumn2.setText("ID");
            tableColumn3.setText("Preis");
        } else {
            tableColumn.setText("Description");
            tableColumn2.setText("ID");
            tableColumn3.setText("Price");
        }
        this.accessoriesTablePanelTableView.getColumns().setAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3});
        this.accessoriesTablePanelTableView.setItems(FXCollections.observableArrayList((Collection)this.accessories));
        if (this.selectedAccessory != null) {
            this.accessoriesTablePanelTableView.getSelectionModel().select((Object)this.selectedAccessory);
        }
    }

    public class OnOkButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            AccessoriesStage.this.mainStage.accessories = AccessoriesStage.this.accessoriesStage.accessories;
            AccessoriesStage.this.mainStage.selectedAccessories = AccessoriesStage.this.accessoriesStage.savedSelectedAccessory;
            AccessoriesStage.this.mainStage.specials = AccessoriesStage.this.accessoriesStage.specials;
            AccessoriesStage.this.mainStage.selectedSpecial = AccessoriesStage.this.accessoriesStage.savedSelectedSpecial;
            if (AccessoriesStage.this.params.getLoadTest()) {
                Utility.simulateLoadTest();
            }
            AccessoriesStage.this.accessoriesStage.close();
        }
    }

    public class OnCancelButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            AccessoriesStage.this.accessoriesStage.close();
        }
    }

    public class OnDeleteButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            if (AccessoriesStage.this.accessoriesStage.selectedAccessory == null) {
                return;
            }
            Accessory accessory = AccessoriesStage.this.accessoriesStage.selectedAccessory;
            AccessoriesStage.this.accessoriesStage.accessories.remove(accessory);
            AccessoriesStage.this.accessoriesStage.selectedAccessory = null;
            for (Special special : AccessoriesStage.this.accessoriesStage.specials) {
                special.containingAccessories.remove(accessory);
            }
            AccessoriesStage.this.accessoriesStage.savedSelectedAccessory.remove(accessory);
            AccessoriesStage.this.accessoriesStage.accessoriesTablePanelTableView.getItems().setAll((Collection)AccessoriesStage.this.accessoriesStage.accessories);
        }
    }

    public class OnChangeButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            if (AccessoriesStage.this.accessoriesStage.selectedAccessory == null) {
                return;
            }
            String string = AccessoriesStage.this.accessoriesStage.accessoryNameTextField.getText();
            String string2 = AccessoriesStage.this.accessoriesStage.accessoryIdTextField.getText();
            double d = 0.0;
            try {
                d = Utility.convertStringToPriceDouble(AccessoriesStage.this.accessoriesStage.accessoryPriceTextField.getText(), LangCountrySettings.getConcurrency(), LangCountrySettings.getComma().charAt(0), LangCountrySettings.getDelimeter().charAt(0));
            }
            catch (Exception exception) {
                MessageBox.showOkDialog(AccessoriesStage.this.accessoriesStage, null, "CarConfigurator - Error", LangCountrySettings.getLanguageString("error.price.invalid"));
                return;
            }
            AccessoriesStage.this.accessoriesStage.selectedAccessory.name = string;
            AccessoriesStage.this.accessoriesStage.selectedAccessory.id = string2;
            AccessoriesStage.this.accessoriesStage.selectedAccessory.price = d;
            ((TableColumn)AccessoriesStage.this.accessoriesStage.accessoriesTablePanelTableView.getColumns().get(0)).setVisible(false);
            ((TableColumn)AccessoriesStage.this.accessoriesStage.accessoriesTablePanelTableView.getColumns().get(0)).setVisible(true);
        }
    }

    public class OnNewButtonEventHandler
    implements EventHandler {
        public void handle(ActionEvent actionEvent) {
            String string = AccessoriesStage.this.accessoriesStage.accessoryNameTextField.getText();
            String string2 = AccessoriesStage.this.accessoriesStage.accessoryIdTextField.getText();
            double d = 0.0;
            try {
                d = Utility.convertStringToPriceDouble(AccessoriesStage.this.accessoriesStage.accessoryPriceTextField.getText(), LangCountrySettings.getConcurrency(), LangCountrySettings.getComma().charAt(0), LangCountrySettings.getDelimeter().charAt(0));
            }
            catch (Exception exception) {
                MessageBox.showOkDialog(AccessoriesStage.this.accessoriesStage, null, "CarConfigurator - Error", LangCountrySettings.getLanguageString("error.price.invalid"));
                return;
            }
            Accessory accessory = new Accessory(string, string2, d);
            AccessoriesStage.this.accessoriesStage.accessories.add(accessory);
            AccessoriesStage.this.accessoriesStage.accessoriesTablePanelTableView.getItems().add((Object)accessory);
            AccessoriesStage.this.accessoriesStage.accessoriesTablePanelTableView.getSelectionModel().select((Object)accessory);
        }
    }

    public class OnAccessoryTableColumnClickEventHandler
    implements ChangeListener {
        public void changed(ObservableValue observableValue, Accessory accessory, Accessory accessory2) {
            AccessoriesStage.this.accessoriesStage.selectedAccessory = (Accessory)AccessoriesStage.this.accessoriesStage.accessoriesTablePanelTableView.getSelectionModel().getSelectedItem();
            if (AccessoriesStage.this.accessoriesStage.selectedAccessory == null) {
                return;
            }
            AccessoriesStage.this.accessoriesStage.accessoryNameTextField.setText(AccessoriesStage.this.accessoriesStage.selectedAccessory.name);
            AccessoriesStage.this.accessoriesStage.accessoryIdTextField.setText(AccessoriesStage.this.accessoriesStage.selectedAccessory.id);
            AccessoriesStage.this.accessoriesStage.accessoryPriceTextField.setText(Utility.convertDoubleToPriceString(AccessoriesStage.this.accessoriesStage.selectedAccessory.price, "", LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter()));
        }
    }
}

