/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class LoginStage
extends CarConfigFxStage {
    private LOGINSTATE currentLoginState = LOGINSTATE.LOGIN_DENIED;
    TextField userField;
    Label userLabel;
    PasswordField pwdField;
    Label pwdLabel;
    Label msgLabel;
    Button loginButton;
    Button cancelBtn;
    String currentUser;

    public LoginStage(CarConfigFxParameters carConfigFxParameters) {
        super(carConfigFxParameters);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(3.0);
        gridPane.setVgap(3.0);
        gridPane.setStyle(this.getCSSString());
        gridPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Scene scene = new Scene((Parent)gridPane);
        this.setScene(scene);
        this.setTitle(LangCountrySettings.getLanguageString("carconfig.login.title"));
        gridPane.setId("LoginDialog");
        this.userField = new TextField();
        this.userField.setId("userField");
        this.userLabel = new Label(LangCountrySettings.getLanguageString("carconfig.login.user"));
        this.userLabel.setLabelFor((Node)this.userField);
        this.pwdField = new PasswordField();
        this.pwdField.setId("pwdField");
        this.pwdLabel = new Label(LangCountrySettings.getLanguageString("carconfig.login.password"));
        this.pwdLabel.setLabelFor((Node)this.pwdField);
        this.msgLabel = new Label(LangCountrySettings.getLanguageString("carconfig.login.loginsteps"));
        this.loginButton = new Button();
        this.loginButton.setId("loginBtn");
        this.loginButton.setText(LangCountrySettings.getLanguageString("carconfig.login.login"));
        this.loginButton.setOnAction((EventHandler)new LoginButtonEventHandler(this));
        this.cancelBtn = new Button();
        this.cancelBtn.setId("cancelBtn");
        this.cancelBtn.setText(LangCountrySettings.getLanguageString("carconfig.login.cancel"));
        this.cancelBtn.setOnAction((EventHandler)new CancelButtonEventHandler(this));
        gridPane.add((Node)this.userLabel, 0, 0);
        gridPane.add((Node)this.userField, 1, 0);
        gridPane.add((Node)this.pwdLabel, 0, 1);
        gridPane.add((Node)this.pwdField, 1, 1);
        gridPane.add((Node)this.msgLabel, 0, 2, 2, 1);
        gridPane.add((Node)this.loginButton, 0, 3);
        gridPane.add((Node)this.cancelBtn, 1, 3);
        this.resizableProperty().setValue(Boolean.FALSE);
    }

    public LOGINSTATE getCurrentLoginState() {
        return this.currentLoginState;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    class CancelButtonEventHandler
    implements EventHandler {
        LoginStage lStage;

        public CancelButtonEventHandler(LoginStage loginStage2) {
            this.lStage = loginStage2;
        }

        public void handle(ActionEvent actionEvent) {
            this.lStage.close();
        }
    }

    class LoginButtonEventHandler
    implements EventHandler {
        LoginStage lStage;

        public LoginButtonEventHandler(LoginStage loginStage2) {
            this.lStage = loginStage2;
        }

        public void handle(ActionEvent actionEvent) {
            LoginStage.this.currentUser = this.lStage.userField.getText();
            String string = this.lStage.pwdField.getText();
            if ("tester".equals(LoginStage.this.currentUser) && "tester".equals(string)) {
                this.lStage.currentLoginState = LOGINSTATE.LOGIN_ACCEPTED;
                this.lStage.close();
            } else if ("user".equals(LoginStage.this.currentUser) && "user".equals(string)) {
                this.lStage.currentLoginState = LOGINSTATE.LOGIN_ACCEPTED;
                this.lStage.close();
            } else {
                this.lStage.currentLoginState = LOGINSTATE.LOGIN_DENIED;
                this.lStage.msgLabel.setText(LangCountrySettings.getLanguageString("carconfig.login.loginfailed"));
                this.lStage.userField.setText("");
                this.lStage.pwdField.setText("");
            }
        }
    }

    public static enum LOGINSTATE {
        LOGIN_ACCEPTED,
        LOGIN_DENIED;

    }
}

