/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.BorderedTitlePane;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ColumnConstraintsBuilder;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MainStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MessageBox;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Accessory;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class PurchaseOrderStage
extends CarConfigFxStage {
    MainStage mainStage;
    private TextField surnameField;
    private TextField firstnameField;
    private TextField streetField;
    private TextField emailAddressField;
    private TextField zipCodeField;
    private TextField cityField;
    private TextField countryField;
    private TextField phonenumberField;

    public PurchaseOrderStage(MainStage mainStage) {
        super(mainStage.params);
        this.mainStage = mainStage;
        this.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.name"));
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        borderPane.setId("SendPurchaseOrderDialog");
        borderPane.setPrefWidth(400.0);
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        borderPane.setCenter(this.createMiddleElementsPane());
        borderPane.setBottom(this.createBottonSendCancelPane());
        this.setResizable(false);
    }

    public Node createMiddleElementsPane() {
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.add(this.createVehicleDetailsElements(), 0, 0);
        gridPane.add(this.createSpecialsDetailsElements(), 0, 1);
        gridPane.add(this.createAccessoriesDetailsElements(), 0, 2);
        gridPane.add(this.createPriceDetailsElements(), 0, 3);
        gridPane.add(this.createAddressElements(), 0, 4);
        gridPane.setId("SendPurchaseOrderPanel");
        return gridPane;
    }

    public Node createVehicleDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.vehicle.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.vehicle.label"));
        gridPane.add((Node)label, 0, 0);
        String string = LangCountrySettings.getLanguageString("error.purchaseorder.novehicle");
        if (this.mainStage.selectedVehicle != null) {
            string = this.mainStage.selectedVehicle.name;
        }
        TextField textField = new TextField(string);
        textField.setEditable(false);
        gridPane.add((Node)textField, 1, 0);
        return borderedTitlePane;
    }

    public Node createSpecialsDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.special.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.special.label"));
        gridPane.add((Node)label, 0, 0);
        String string = "";
        if (this.mainStage.selectedSpecial != null) {
            string = this.mainStage.selectedSpecial.name;
        }
        TextField textField = new TextField(string);
        textField.setEditable(false);
        gridPane.add((Node)textField, 1, 0);
        return borderedTitlePane;
    }

    public Node createAccessoriesDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.accessory.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        if (this.mainStage.selectedAccessories.isEmpty()) {
            Label label = new Label(LangCountrySettings.getLanguageString("error.purchaseorder.noaccessory"));
            borderedTitlePane.contentPane.setAlignment(Pos.CENTER);
            borderedTitlePane.setContent((Node)label);
            return borderedTitlePane;
        }
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        int n = 0;
        for (Accessory accessory : this.mainStage.selectedAccessories) {
            Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.accessory.label") + " " + n);
            TextField textField = new TextField(accessory.name);
            textField.setEditable(false);
            label.setId("label_" + accessory.name);
            textField.setId("name_" + accessory.name);
            gridPane.add((Node)label, 0, n);
            gridPane.add((Node)textField, 1, n);
            ++n;
        }
        return borderedTitlePane;
    }

    public Node createPriceDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.price.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.price.label"));
        gridPane.add((Node)label, 0, 0);
        double d = Utility.calculateFinalPrice(this.params.getBuggy(), this.mainStage.selectedVehicle, this.mainStage.selectedSpecial, this.params.getDiscount(), this.mainStage.selectedAccessories, this.mainStage.accessoryChkBox.isSelected());
        String string = Utility.convertDoubleToPriceString(d, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter());
        TextField textField = new TextField(string);
        textField.setEditable(false);
        gridPane.add((Node)textField, 1, 0);
        return borderedTitlePane;
    }

    public Node createAddressElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.surname"));
        Label label2 = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.firstname"));
        Label label3 = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.street"));
        Label label4 = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.zip"));
        Label label5 = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.city"));
        Label label6 = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.country"));
        Label label7 = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.phone"));
        Label label8 = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.contact.mail"));
        this.surnameField = new TextField();
        this.firstnameField = new TextField();
        this.streetField = new TextField();
        this.zipCodeField = new TextField();
        this.cityField = new TextField();
        this.countryField = new TextField();
        this.phonenumberField = new TextField();
        this.emailAddressField = new TextField();
        this.surnameField.setId("surname");
        this.firstnameField.setId("firstname");
        this.streetField.setId("address");
        this.zipCodeField.setId("zipcode");
        this.cityField.setId("city");
        this.countryField.setId("country");
        this.phonenumberField.setId("number");
        this.emailAddressField.setId("address");
        gridPane.add((Node)label, 0, 0);
        gridPane.add((Node)label2, 0, 1);
        gridPane.add((Node)label3, 0, 2);
        gridPane.add((Node)label4, 0, 3);
        gridPane.add((Node)label5, 0, 4);
        gridPane.add((Node)label6, 0, 5);
        gridPane.add((Node)label7, 0, 6);
        gridPane.add((Node)label8, 0, 7);
        gridPane.add((Node)this.surnameField, 1, 0);
        gridPane.add((Node)this.firstnameField, 1, 1);
        gridPane.add((Node)this.streetField, 1, 2);
        gridPane.add((Node)this.zipCodeField, 1, 3);
        gridPane.add((Node)this.cityField, 1, 4);
        gridPane.add((Node)this.countryField, 1, 5);
        gridPane.add((Node)this.phonenumberField, 1, 6);
        gridPane.add((Node)this.emailAddressField, 1, 7);
        return borderedTitlePane;
    }

    public Node createBottonSendCancelPane() {
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button button = new Button(LangCountrySettings.getLanguageString("button.sendorder"));
        button.setId("SendOrderButton");
        button.setOnAction((EventHandler)new SendButtonEventHandler(this));
        flowPane.getChildren().add((Object)button);
        Button button2 = new Button(LangCountrySettings.getLanguageString("button.cancel"));
        button2.setId("CancelButton");
        button2.setOnAction((EventHandler)new CancelButtonEventHandler(this));
        flowPane.getChildren().add((Object)button2);
        return flowPane;
    }

    public boolean isEmptyTextField(TextField textField) {
        return textField.getText().isEmpty();
    }

    class CancelButtonEventHandler
    implements EventHandler {
        Stage toClose;

        public CancelButtonEventHandler(Stage stage) {
            this.toClose = stage;
        }

        public void handle(ActionEvent actionEvent) {
            this.toClose.close();
        }
    }

    class SendButtonEventHandler
    implements EventHandler {
        Stage stage;

        public SendButtonEventHandler(Stage stage) {
            this.stage = stage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(ActionEvent actionEvent) {
            if (PurchaseOrderStage.this.params.getLoadTest()) {
                Utility.simulateLoadTest();
            }
            if (PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.surnameField) || PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.firstnameField) || PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.streetField) || PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.emailAddressField) || PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.zipCodeField) || PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.cityField) || PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.countryField) || PurchaseOrderStage.this.isEmptyTextField(PurchaseOrderStage.this.phonenumberField)) {
                MessageBox.showOkDialog(this.stage, null, "Error", LangCountrySettings.getLanguageString("error.purchaseorder.nodetails"));
                return;
            }
            Writer writer = null;
            File file = new File("order.xml");
            try {
                Date date = new Date(System.currentTimeMillis());
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                writer = new PrintWriter(file, "UTF8");
                writer.write("<order date=\"order_" + simpleDateFormat.format(date) + "\">\n");
                writer.write("<surname value=\"" + PurchaseOrderStage.this.surnameField.getText() + "\"/>\n");
                writer.write("<firstname value=\"" + PurchaseOrderStage.this.firstnameField.getText() + "\"/>\n");
                writer.write("<streetaddress value=\"" + PurchaseOrderStage.this.streetField.getText() + "\"/>\n");
                writer.write("<zipcode value=\"" + PurchaseOrderStage.this.zipCodeField.getText() + "\"/>\n");
                writer.write("<city value=\"" + PurchaseOrderStage.this.cityField.getText() + "\"/>\n");
                writer.write("<country value=\"" + PurchaseOrderStage.this.countryField.getText() + "\"/>\n");
                writer.write("<phone value=\"" + PurchaseOrderStage.this.phonenumberField.getText() + "\"/>\n");
                writer.write("<email value=\"" + PurchaseOrderStage.this.emailAddressField.getText() + "\"/>\n");
                writer.write("</order>");
            }
            catch (Exception exception) {
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            MessageBox.showOkDialog(this.stage, null, LangCountrySettings.getLanguageString("dialog.purchasesuccess.name"), LangCountrySettings.getLanguageString("message.purchaseorder.success") + "\n '" + file.getAbsolutePath() + "' .");
            if (PurchaseOrderStage.this.params.getLoadTest()) {
                Utility.simulateLoadTest();
            }
            this.stage.close();
        }
    }
}

