/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.stages;

import de.qfs.apps.qftest.demo.fx.carconfig.stages.BorderedTitlePane;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.CarConfigFxStage;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.ColumnConstraintsBuilder;
import de.qfs.apps.qftest.demo.fx.carconfig.stages.MainStage;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Accessory;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;
import java.util.Random;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class ViewOrderStage
extends CarConfigFxStage {
    MainStage mainStage;
    static final char[] randomChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_', '-', '.', '+', '~', '=', '&', '%', '$', '!', '&', '#'};

    public ViewOrderStage(MainStage mainStage) {
        super(mainStage.params);
        this.mainStage = mainStage;
        this.setTitle(LangCountrySettings.getLanguageString("dialog.viewpurchaseorder.name"));
        BorderPane borderPane = new BorderPane();
        borderPane.setStyle(this.getCSSString());
        borderPane.setId("ViewPurchaseOrderDialog");
        borderPane.setPrefWidth(400.0);
        Scene scene = new Scene((Parent)borderPane);
        this.setScene(scene);
        borderPane.setCenter(this.createMiddleElementsPane());
        borderPane.setBottom(this.createBottonOkPane());
        this.setResizable(false);
    }

    public Node createMiddleElementsPane() {
        GridPane gridPane = new GridPane();
        gridPane.setId("ViewPurchaseOrderPanel");
        ColumnConstraints columnConstraints = ColumnConstraintsBuilder.create().percentWidth(100.0).build();
        gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnConstraints});
        gridPane.add(this.createVehicleDetailsElements(), 0, 0);
        gridPane.add(this.createSpecialsDetailsElements(), 0, 1);
        gridPane.add(this.createAccessoriesDetailsElements(), 0, 2);
        gridPane.add(this.createPriceDetailsElements(), 0, 3);
        return gridPane;
    }

    public Node createVehicleDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.vehicle.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.vehicle.label"));
        label.setId("SelectedModelLbl" + ViewOrderStage.createRandomString());
        gridPane.add((Node)label, 0, 0);
        String string = LangCountrySettings.getLanguageString("error.purchaseorder.novehicle");
        if (this.mainStage.selectedVehicle != null) {
            string = this.mainStage.selectedVehicle.name;
        }
        TextField textField = new TextField(string);
        textField.setEditable(false);
        textField.setId("SelectedModelTxtFld" + ViewOrderStage.createRandomString());
        gridPane.add((Node)textField, 1, 0);
        return borderedTitlePane;
    }

    public Node createSpecialsDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.special.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.special.label"));
        label.setId("SelectedSpecialLbl" + ViewOrderStage.createRandomString());
        gridPane.add((Node)label, 0, 0);
        String string = "";
        if (this.mainStage.selectedSpecial != null) {
            string = this.mainStage.selectedSpecial.name;
        }
        TextField textField = new TextField(string);
        textField.setEditable(false);
        textField.setId("SelectedSpecialTxtFld" + ViewOrderStage.createRandomString());
        gridPane.add((Node)textField, 1, 0);
        return borderedTitlePane;
    }

    public Node createAccessoriesDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.accessory.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        if (this.mainStage.selectedAccessories.isEmpty()) {
            Label label = new Label(LangCountrySettings.getLanguageString("error.purchaseorder.noaccessory"));
            borderedTitlePane.contentPane.setAlignment(Pos.CENTER);
            borderedTitlePane.setContent((Node)label);
            return borderedTitlePane;
        }
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        int n = 1;
        for (Accessory accessory : this.mainStage.selectedAccessories) {
            Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.accessory.label") + " " + n);
            label.setId("label_" + accessory.name);
            gridPane.add((Node)label, 0, n);
            TextField textField = new TextField(accessory.name);
            textField.setEditable(false);
            textField.setId("name_" + accessory.name);
            gridPane.add((Node)textField, 1, n);
            ++n;
        }
        return borderedTitlePane;
    }

    public Node createPriceDetailsElements() {
        BorderedTitlePane borderedTitlePane = new BorderedTitlePane(this.params.getFont());
        borderedTitlePane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        borderedTitlePane.setTitle(LangCountrySettings.getLanguageString("dialog.purchaseorder.price.title"));
        borderedTitlePane.setMaxWidth(Double.MAX_VALUE);
        borderedTitlePane.setMaxHeight(Double.MAX_VALUE);
        GridPane gridPane = new GridPane();
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setPercentWidth(50.0);
        columnConstraints.setHalignment(HPos.LEFT);
        gridPane.getColumnConstraints().add((Object)columnConstraints);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setPercentWidth(50.0);
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        borderedTitlePane.setContent((Node)gridPane);
        Label label = new Label(LangCountrySettings.getLanguageString("dialog.purchaseorder.price.label"));
        label.setId("CalculatedPriceLbl" + ViewOrderStage.createRandomString());
        gridPane.add((Node)label, 0, 0);
        double d = Utility.calculateFinalPrice(this.params.getBuggy(), this.mainStage.selectedVehicle, this.mainStage.selectedSpecial, this.params.getDiscount(), this.mainStage.selectedAccessories, this.mainStage.accessoryChkBox.isSelected());
        String string = Utility.convertDoubleToPriceString(d, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter());
        TextField textField = new TextField(string);
        textField.setEditable(false);
        textField.setId("CalculatedPriceTxtFld" + ViewOrderStage.createRandomString());
        gridPane.add((Node)textField, 1, 0);
        return borderedTitlePane;
    }

    public Node createBottonOkPane() {
        FlowPane flowPane = new FlowPane();
        flowPane.alignmentProperty().setValue((Object)Pos.CENTER);
        flowPane.setMaxWidth(Double.MAX_VALUE);
        flowPane.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        Button button = new Button(LangCountrySettings.getLanguageString("button.ok"));
        button.setId("OKButton");
        button.setOnAction((EventHandler)new OkButtonEventHandler(this));
        flowPane.getChildren().add((Object)button);
        return flowPane;
    }

    public static String createRandomString() {
        Random random = new Random();
        return "" + random.nextInt();
    }

    class OkButtonEventHandler
    implements EventHandler {
        Stage toClose;

        public OkButtonEventHandler(Stage stage) {
            this.toClose = stage;
        }

        public void handle(ActionEvent actionEvent) {
            this.toClose.close();
        }
    }
}

