/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.structures;

import de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings;
import de.qfs.apps.qftest.demo.fx.carconfig.structures.Utility;

public class Accessory
implements Cloneable {
    public String name;
    public String id;
    public double price;

    public Accessory() {
        this.name = "myNewAccessory";
        this.id = "?";
        this.price = 0.0;
    }

    public Accessory(String string, double d) {
        this.name = string;
        this.price = d;
    }

    public Accessory(String string, String string2, String string3, String string4, String string5) {
        this.name = string;
        this.id = "?";
        this.price = Utility.convertStringToPriceDouble(string2, string3, string4.charAt(0), string5.charAt(0));
    }

    public Accessory(String string, String string2, double d) {
        this.name = string;
        this.id = string2;
        this.price = d;
    }

    public Accessory(String string, String string2, String string3, String string4, String string5, String string6) {
        this.name = string;
        this.id = string2;
        this.price = Utility.convertStringToPriceDouble(string3, string4, string5.charAt(0), string6.charAt(0));
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getPrice() {
        return Utility.convertDoubleToPriceString(this.price, LangCountrySettings.getConcurrency(), LangCountrySettings.getBeforeValue(), LangCountrySettings.getComma(), LangCountrySettings.getDelimeter());
    }

    public Accessory getThis() {
        return this;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            Accessory accessory = (Accessory)object;
            return this.name.equals(accessory.name) && this.id.equals(accessory.id) && this.price == accessory.price;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int compareAccessorysByName(Accessory accessory) {
        return this.name.compareTo(accessory.name);
    }

    public int compareAccessoriesById(Accessory accessory) {
        return this.id.compareTo(accessory.id);
    }

    public int compareAccessoriesByPrice(Accessory accessory) {
        if (this.price == accessory.price) {
            return 0;
        }
        if (this.price > accessory.price) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "[@Accessory: name: \"" + this.name + "\"; id: \"" + this.id + "\"; price: \"" + this.price + "\" ]";
    }

    public int hashCode() {
        int n = 5;
        n = 37 * n + this.name.hashCode();
        n = 37 * n + this.id.hashCode();
        n = 37 * n + (int)(Double.doubleToLongBits(this.price) ^ Double.doubleToLongBits(this.price) >>> 32);
        return n;
    }

    public Accessory clone() {
        return new Accessory(this.name, this.id, this.price);
    }
}

