/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.carconfig.structures;

import de.qfs.apps.qftest.demo.fx.carconfig.structures.CarConfigFxParameters;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.MapResourceBundle;
import java.util.Locale;
import javafx.scene.image.Image;

public class LangCountrySettings {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.fx.carconfig.structures.LangCountrySettings");
    static CarConfigFxParameters.Language lang;
    public static String concurrencyDE;
    public static String concurrencyEn;
    public static boolean beforeValueDE;
    public static boolean beforeValueEn;
    public static String commaDE;
    public static String commaEN;
    public static String delimeterDE;
    public static String delimeterEN;
    public static String statisticsWeekDe;
    public static String statisticsWeekEn;
    public static String statisticsAmountDe;
    public static String statisticsAmountEn;
    public static MapResourceBundle rb;

    public LangCountrySettings() {
        if (LangCountrySettings.logger.level >= 7) {
            logger.lvlBuild(7, "LangCountrySettings.LangCountrySettings()", 16).log();
        }
    }

    public static void setLanguageCountrySettings(CarConfigFxParameters carConfigFxParameters) {
        if (LangCountrySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setLanguageCountrySettings(CarConfigFxParameters)", 102).addDetail("p", (Object)carConfigFxParameters)).log();
        }
        lang = carConfigFxParameters.getLanguage();
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)carConfigFxParameters.getLanguage())) {
            rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.GERMANY, LangCountrySettings.class);
        } else {
            rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.US, LangCountrySettings.class);
        }
    }

    public static String getLanguageString(String string) {
        if (LangCountrySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getLanguageString(String)", 124).addDetail("s", string)).log();
        }
        return rb.getString(string);
    }

    public static String getConcurrency() {
        if (LangCountrySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getConcurrency()", 134).log();
        }
        if (CarConfigFxParameters.Language.GERMAN.equals((Object)lang)) {
            return concurrencyDE;
        }
        return concurrencyEn;
    }

    public static boolean getBeforeValue() {
        if (LangCountrySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getBeforeValue()", 149).log();
        }
        return CarConfigFxParameters.Language.GERMAN.equals((Object)lang) ? beforeValueDE : beforeValueEn;
    }

    public static String getComma() {
        if (LangCountrySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getComma()", 160).log();
        }
        return CarConfigFxParameters.Language.GERMAN.equals((Object)lang) ? commaDE : commaEN;
    }

    public static String getDelimeter() {
        if (LangCountrySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getDelimeter()", 168).log();
        }
        return CarConfigFxParameters.Language.GERMAN.equals((Object)lang) ? delimeterDE : delimeterEN;
    }

    public static Image getImage(String string) {
        if (LangCountrySettings.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getImage(String)", 180).addDetail("resourceString", string)).log();
        }
        String string2 = rb.getString(string, null);
        return new Image(LangCountrySettings.class.getResourceAsStream("/" + string2));
    }

    public static String getStatisticsWeek() {
        if (LangCountrySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getStatisticsWeek()", 202).log();
        }
        return CarConfigFxParameters.Language.GERMAN.equals((Object)lang) ? statisticsWeekDe : statisticsWeekEn;
    }

    public static String getStatisticsAmount() {
        if (LangCountrySettings.logger.level >= 7) {
            logger.lvlBuild(7, "getStatisticsAmount()", 213).log();
        }
        return CarConfigFxParameters.Language.GERMAN.equals((Object)lang) ? statisticsAmountDe : statisticsAmountEn;
    }

    static {
        concurrencyDE = "\u20ac";
        concurrencyEn = "$";
        beforeValueDE = false;
        beforeValueEn = true;
        commaDE = ",";
        commaEN = ".";
        delimeterDE = ".";
        delimeterEN = ",";
        statisticsWeekDe = "Woche";
        statisticsWeekEn = "Week";
        statisticsAmountDe = "Bestellmenge";
        statisticsAmountEn = "Ordered Amount";
        rb = new MapResourceBundle();
    }
}

