/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FXitemResolverDemo {
    public static List myDrawings = new ArrayList();
    public static MyDrawing selectedDrawing = new MyDrawing();

    private static void reset(Canvas canvas, Color color) {
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.setFill((Paint)color);
        graphicsContext.fillRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
    }

    public static Node getRootNode() {
        GridPane gridPane = new GridPane();
        gridPane.setId("FXitemResolverDemo");
        Canvas canvas = new Canvas(400.0, 400.0);
        canvas.setId("The_Canvas");
        FXitemResolverDemo.reset(canvas, Color.BLUE);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        MyDrawing myDrawing = new MyDrawing(graphicsContext, Color.RED, 10.0, 10.0, 100.0, 100.0);
        myDrawings.add(myDrawing);
        MyDrawing myDrawing2 = new MyDrawing(graphicsContext, Color.YELLOW, 150.0, 0.0, 100.0, 200.0);
        myDrawings.add(myDrawing2);
        MyDrawing myDrawing3 = new MyDrawing(graphicsContext, Color.GREEN, 10.0, 250.0, 200.0, 100.0);
        myDrawings.add(myDrawing3);
        MyDrawing myDrawing4 = new MyDrawing(graphicsContext, Color.WHITE, 300.0, 150.0, 50.0, 75.0);
        myDrawings.add(myDrawing4);
        for (MyDrawing myDrawing5 : myDrawings) {
            myDrawing5.drawShape();
        }
        gridPane.getChildren().add((Object)canvas);
        final Button button = new Button("Reset");
        button.relocate(80.0, 400.0);
        button.setOnMouseClicked(new EventHandler(){

            public void handle(MouseEvent mouseEvent) {
                button.setText("None");
                selectedDrawing = new MyDrawing();
            }
        });
        canvas.setOnMouseClicked(new EventHandler(){

            public void handle(MouseEvent mouseEvent) {
                for (MyDrawing myDrawing : myDrawings) {
                    if (myDrawing.isClickHere(mouseEvent.getX(), mouseEvent.getY()) == null) continue;
                    selectedDrawing = myDrawing;
                }
                if (selectedDrawing.getColor() != null) {
                    button.setText("Click to reset \n" + FXitemResolverDemo.getColorStringAsString(selectedDrawing.getColor().toString()));
                }
            }
        });
        gridPane.getChildren().addAll((Object[])new Node[]{button});
        return gridPane;
    }

    public static String getColorStringAsString(String string) {
        String string2 = "-1";
        TreeSet treeSet = new TreeSet(MyDrawing.colorMap.keySet());
        for (String string3 : treeSet) {
            if (!string3.equals(string)) continue;
            string2 = (String)MyDrawing.colorMap.get(string3);
        }
        return string2;
    }

    public static class MyDrawing {
        public static Map colorMap = new LinkedHashMap();
        double x;
        double y;
        double width;
        double height;
        Color color;
        GraphicsContext gc;

        public MyDrawing(GraphicsContext graphicsContext, Color color, double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
            this.color = color;
            this.gc = graphicsContext;
        }

        public void drawShape() {
            this.drawShape(this.gc, this.color, this.x, this.y, this.width, this.height);
        }

        public MyDrawing() {
        }

        public void drawShape(GraphicsContext graphicsContext, Color color, double d, double d2, double d3, double d4) {
            graphicsContext.setFill((Paint)color);
            graphicsContext.fillRect(d, d2, d3, d4);
        }

        public MyDrawing isClickHere(double d, double d2) {
            boolean bl;
            boolean bl2 = this.x <= d && d <= this.x + this.width;
            boolean bl3 = bl = this.y <= d2 && d2 <= this.y + this.height;
            if (bl2 && bl) {
                return this;
            }
            return null;
        }

        public String getColorAsText() {
            return FXitemResolverDemo.getColorStringAsString(this.color.toString());
        }

        public String toString() {
            return "MyDrawing [color=" + this.color + ", x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
        }

        public double getX() {
            return this.x;
        }

        public void setX(double d) {
            this.x = d;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double d) {
            this.y = d;
        }

        public double getWidth() {
            return this.width;
        }

        public void setWidth(double d) {
            this.width = d;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        static {
            colorMap.put("0x008000ff", "GREEN");
            colorMap.put("0xffff00ff", "YELLOW");
            colorMap.put("0xffffffff", "WHITE");
            colorMap.put("0xff0000ff", "RED");
        }
    }
}

