/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.apps.qftest.demo.fx.multi.FxMultiItem;
import de.qfs.lib.log.Logger;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.scene.control.cell.ChoiceBoxListCell;
import javafx.scene.control.cell.ComboBoxListCell;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class FxListDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.fx.multi.FxListDemo");

    public static Node getRootNode() {
        if (FxListDemo.logger.level >= 7) {
            logger.log(7, "getRootNode()", "");
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(6.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("ListDemo");
        ObservableList observableList = FXCollections.observableArrayList((Object[])new FxMultiItem[]{new FxMultiItem("Alpha"), new FxMultiItem("Bravo"), new FxMultiItem("Charlie"), new FxMultiItem("Delta"), new FxMultiItem("Echo"), new FxMultiItem("Foxtrot"), new FxMultiItem("Golf"), new FxMultiItem("Hotel")});
        if (FxListDemo.logger.level >= 9) {
            logger.build("getRootNode()").add("items: ").add((Object)observableList).log(9);
        }
        FxListDemo.createListview(Types.CHECKBOX, gridPane, observableList);
        FxListDemo.createListviewString(Types.COMBOBOX, gridPane, FXCollections.observableArrayList((Object[])new String[]{"add", "add", "add", "add", "add", "add", "add", "add", "add", "add"}), FXCollections.observableArrayList((Object[])new String[]{"add", "edit", "delete"}));
        FxListDemo.createListviewString(Types.CHOICEBOX, gridPane, FXCollections.observableArrayList((Object[])new String[]{"red", "red", "red", "red", "red", "red", "red", "red", "red", "red"}), FXCollections.observableArrayList((Object[])new String[]{"red", "green", "blue"}));
        FxListDemo.createListviewString(Types.TEXT, gridPane, FXCollections.observableArrayList((Object[])new String[]{"red", "green", "blue"}), null);
        ObservableList observableList2 = FXCollections.observableArrayList((Object[])new String[]{"A", "trivial", "List", "with", "more", "than", "enough", "entries"});
        ListView listView = new ListView(observableList2);
        listView.setId("trivialList");
        listView.setMaxSize(140.0, 140.0);
        gridPane.add((Node)listView, 1, 4);
        Label label = new Label("Trivial");
        gridPane.add((Node)label, 0, 4);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setContent((Node)gridPane);
        return scrollPane;
    }

    private static void createListview(Types types, GridPane gridPane, ObservableList observableList) {
        ListView listView = new ListView(observableList);
        FxListDemo.setFxId((Node)listView, types, "DemoListView");
        listView.setMaxSize(140.0, 140.0);
        listView.setCellFactory(new Callback(){

            public ListCell call(ListView listView) {
                return new CheckBoxListCell(new Callback(){

                    public BooleanProperty call(FxMultiItem fxMultiItem) {
                        return fxMultiItem.selectedProperty();
                    }
                }, new StringConverter(){

                    public String toString(FxMultiItem fxMultiItem) {
                        return fxMultiItem.textProperty().get();
                    }

                    public FxMultiItem fromString(String string) {
                        return new FxMultiItem(string);
                    }
                });
            }
        });
        if (FxListDemo.logger.level >= 9) {
            logger.build("getRootNode()").add("lv: ").add((Object)listView).log(9);
        }
        Label label = new Label("ListView");
        label.setLabelFor((Node)listView);
        FxListDemo.setFxId((Node)label, types, "DemoLVLabel");
        final ListView listView2 = listView;
        RadioButton radioButton = new RadioButton("Single Selection");
        FxListDemo.setFxId((Node)radioButton, types, "SingleSelectionRadio");
        radioButton.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                listView2.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            }
        });
        RadioButton radioButton2 = new RadioButton("Multiple Selection");
        FxListDemo.setFxId((Node)radioButton2, types, "MultiSelectionRadio");
        radioButton2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                listView2.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            }
        });
        listView.getSelectionModel().selectedIndexProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object object, Object object2) {
                if (logger.level >= 9) {
                    logger.build("createListview(Types,GridPane,ObservableList<FxMultiItem>)").add("val: ").add((Object)observableValue).dumpStack(9);
                }
            }
        });
        ToggleGroup toggleGroup = new ToggleGroup();
        radioButton.setToggleGroup(toggleGroup);
        radioButton2.setToggleGroup(toggleGroup);
        toggleGroup.selectToggle((Toggle)radioButton);
        VBox vBox = new VBox(10.0);
        FxListDemo.setFxId((Node)vBox, types, "SelectionTypeVBox");
        vBox.getChildren().addAll((Object[])new Node[]{radioButton, radioButton2});
        gridPane.add((Node)label, 0, types.ordinal());
        gridPane.add((Node)listView, 1, types.ordinal());
        gridPane.add((Node)vBox, 3, types.ordinal());
    }

    private static void createListviewString(Types types, GridPane gridPane, ObservableList observableList, ObservableList observableList2) {
        ListView listView = new ListView(observableList);
        FxListDemo.setFxId((Node)listView, types, "DemoListView");
        listView.setMaxSize(140.0, 300.0);
        listView.setEditable(true);
        listView.setItems(observableList);
        switch (types) {
            case COMBOBOX: {
                listView.setCellFactory(ComboBoxListCell.forListView((ObservableList)observableList2));
                break;
            }
            case CHOICEBOX: {
                listView.setCellFactory(ChoiceBoxListCell.forListView((ObservableList)observableList2));
                break;
            }
            case TEXT: {
                listView.setCellFactory(TextFieldListCell.forListView());
                break;
            }
        }
        if (FxListDemo.logger.level >= 9) {
            logger.build("getRootNode()").add("lv: ").add((Object)listView).log(9);
        }
        Label label = new Label("ListView");
        label.setLabelFor((Node)listView);
        FxListDemo.setFxId((Node)label, types, "DemoLVLabel");
        listView.getSelectionModel().selectedIndexProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object object, Object object2) {
                if (logger.level >= 9) {
                    logger.build("createListview(Types,GridPane,ObservableList<FxMultiItem>)").add("val: ").add((Object)observableValue).dumpStack(9);
                }
            }
        });
        final ListView listView2 = listView;
        RadioButton radioButton = new RadioButton("Single Selection");
        FxListDemo.setFxId((Node)radioButton, types, "SingleSelectionRadio");
        radioButton.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                listView2.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            }
        });
        RadioButton radioButton2 = new RadioButton("Multiple Selection");
        FxListDemo.setFxId((Node)radioButton2, types, "MultiSelectionRadio");
        radioButton2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                listView2.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            }
        });
        ToggleGroup toggleGroup = new ToggleGroup();
        radioButton.setToggleGroup(toggleGroup);
        radioButton2.setToggleGroup(toggleGroup);
        toggleGroup.selectToggle((Toggle)radioButton);
        VBox vBox = new VBox(10.0);
        FxListDemo.setFxId((Node)vBox, types, "SelectionTypeVBox");
        vBox.getChildren().addAll((Object[])new Node[]{radioButton, radioButton2});
        gridPane.add((Node)label, 0, types.ordinal());
        gridPane.add((Node)listView, 1, types.ordinal());
        gridPane.add((Node)vBox, 3, types.ordinal());
    }

    private static void setFxId(Node node, Types types, String string) {
        switch (types) {
            case CHECKBOX: {
                node.setId(string);
                break;
            }
            default: {
                node.setId(string + types.name());
            }
        }
    }

    private static enum Types {
        CHECKBOX,
        COMBOBOX,
        CHOICEBOX,
        TEXT;

    }
}

