/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.apps.qftest.demo.fx.multi.FxMultiItem;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.ChoiceBoxTableCell;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class FxMiscDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.fx.multi.FxMiscDemo");
    private static GridPane pane;
    private static TextField textField;
    private static TableView table;

    public FxMiscDemo() {
        if (FxMiscDemo.logger.level >= 7) {
            logger.lvlBuild(7, "FxMiscDemo.FxMiscDemo()", 53).log();
        }
    }

    public static Node getRootNode() {
        if (FxMiscDemo.logger.level >= 7) {
            logger.lvlBuild(7, "getRootNode()", 72).log();
        }
        pane = new GridPane();
        pane.setHgap(4.0);
        pane.setVgap(20.0);
        pane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        pane.setStyle("-fx-background-color: grey;");
        pane.setId("MiscDemo");
        int n = 0;
        textField = new TextField();
        textField.setId("tfDelay");
        textField.setText("3");
        pane.add((Node)textField, 0, n);
        Button button = new Button("Busy pane");
        button.setId("bBusyPane");
        button.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                block5: {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 94).addDetail("e", (Object)actionEvent)).log();
                    }
                    String string = textField.getText();
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 96).add("text", string)).log();
                    }
                    try {
                        final int n = Integer.parseInt(string);
                        final Scene scene = textField.getScene();
                        if (scene.getRoot() instanceof StackPane) {
                            final BorderPane borderPane = new BorderPane();
                            ProgressIndicator progressIndicator = new ProgressIndicator();
                            progressIndicator.setMaxWidth(progressIndicator.getPrefWidth());
                            progressIndicator.setMaxHeight(progressIndicator.getPrefHeight());
                            borderPane.setCenter((Node)progressIndicator);
                            ((StackPane)scene.getRoot()).getChildren().add((Object)borderPane);
                            new Thread(){

                                @Override
                                public void run() {
                                    if (logger.level >= 7) {
                                        logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent).Thread.run()", 109).log();
                                    }
                                    try {
                                        Thread.sleep(n * 1000);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            if (logger.level >= 7) {
                                                logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent).Thread.run().Runnable.run()", 116).log();
                                            }
                                            ((StackPane)scene.getRoot()).getChildren().remove((Object)borderPane);
                                        }
                                    });
                                }
                            }.start();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (logger.level < 5) break block5;
                        ((LevelAwareLogBuilder)logger.lvlBuild(5, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 127).add("ex", (Object)numberFormatException)).log();
                    }
                }
            }
        });
        pane.add((Node)button, 1, n);
        Button button2 = new Button("1");
        button2.setId("bOne");
        button2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 137).addDetail("e", (Object)actionEvent)).log();
                }
                textField.setText("1");
            }
        });
        pane.add((Node)button2, 2, n);
        Button button3 = new Button("2");
        button3.setId("bTwo");
        button3.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 147).addDetail("e", (Object)actionEvent)).log();
                }
                textField.setText("2");
            }
        });
        pane.add((Node)button3, 3, n);
        Button button4 = new Button("3");
        button4.setId("bThree");
        button4.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 157).addDetail("e", (Object)actionEvent)).log();
                }
                textField.setText("3");
            }
        });
        pane.add((Node)button4, 4, n);
        ++n;
        final Label label = new Label();
        label.setId("labelSelection");
        SplitMenuButton splitMenuButton = new SplitMenuButton();
        splitMenuButton.setText("Shutdown");
        splitMenuButton.getItems().addAll((Object[])new MenuItem[]{FxMiscDemo.createMenuItem("Logout", label), FxMiscDemo.createMenuItem("Sleep", label)});
        splitMenuButton.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 174).addDetail("e", (Object)actionEvent)).log();
                }
                label.setText("Shutdown button");
            }
        });
        SplitMenuButton splitMenuButton2 = new SplitMenuButton();
        splitMenuButton2.setText("");
        splitMenuButton2.getItems().addAll((Object[])new MenuItem[]{FxMiscDemo.createMenuItem("Mini", label), FxMiscDemo.createMenuItem("Maxi", label)});
        splitMenuButton2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 184).addDetail("e", (Object)actionEvent)).log();
                }
                label.setText("Mini button");
            }
        });
        HBox hBox = new HBox(10.0);
        hBox.getChildren().addAll((Object[])new Node[]{splitMenuButton, splitMenuButton2});
        pane.add((Node)hBox, 0, n);
        pane.add((Node)label, 1, n++);
        table = FxMiscDemo.createTable();
        pane.add((Node)table, 0, 2);
        return pane;
    }

    public static final TextField getTextField() {
        if (FxMiscDemo.logger.level >= 7) {
            logger.lvlBuild(7, "getTextField()", 213).log();
        }
        return textField;
    }

    public static void recreateTextField() {
        if (FxMiscDemo.logger.level >= 7) {
            logger.lvlBuild(7, "recreateTextField()", 221).log();
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "recreateTextField().Runnable.run()", 225).log();
                }
                String string = textField.getText();
                pane.getChildren().remove((Object)textField);
                FxMiscDemo.textField = new TextField();
                textField.setId("tfDelay");
                textField.setText(string);
                pane.add((Node)textField, 0, 0);
            }
        });
    }

    private static TableView createTable() {
        if (FxMiscDemo.logger.level >= 7) {
            logger.lvlBuild(7, "createTable()", 245).log();
        }
        ObservableList observableList = FXCollections.observableArrayList((Object[])new FxMultiItem[]{new FxMultiItem("Alpha"), new FxMultiItem("Bravo"), new FxMultiItem("Charlie"), new FxMultiItem("Delta")});
        ObservableList observableList2 = FXCollections.observableArrayList((Object[])new String[]{"add", "edit", "delete"});
        ObservableList observableList3 = FXCollections.observableArrayList((Object[])new String[]{"red", "green", "blue"});
        if (FxMiscDemo.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "createTable()", 259).add("items", (Object)observableList)).log();
        }
        TableView tableView = new TableView(observableList);
        tableView.setId("DemoTableView");
        tableView.setMaxSize(400.0, 100.0);
        tableView.setTableMenuButtonVisible(true);
        tableView.setItems(observableList);
        TableColumn tableColumn = new TableColumn("Check");
        tableColumn.setMinWidth(20.0);
        tableColumn.setId("CheckColumn");
        TableColumn tableColumn2 = new TableColumn("Name");
        tableColumn2.setMinWidth(50.0);
        tableColumn2.setId("NameColumn");
        TableColumn tableColumn3 = new TableColumn("Action");
        tableColumn3.setMinWidth(80.0);
        tableColumn3.setId("ActionColumn");
        TableColumn tableColumn4 = new TableColumn("Color");
        tableColumn4.setMinWidth(80.0);
        tableColumn4.setId("ColorColumn");
        tableView.getColumns().addAll((Object[])new TableColumn[]{tableColumn, tableColumn2, tableColumn3, tableColumn4});
        tableColumn.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        tableColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)tableColumn));
        tableColumn.setEditable(true);
        tableColumn2.setCellValueFactory((Callback)new PropertyValueFactory("text"));
        tableColumn2.setCellFactory(TextFieldTableCell.forTableColumn());
        tableColumn2.setEditable(true);
        tableColumn3.setCellValueFactory((Callback)new PropertyValueFactory("action"));
        tableColumn3.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)observableList2));
        tableColumn4.setCellValueFactory((Callback)new PropertyValueFactory("color"));
        tableColumn4.setCellFactory(ChoiceBoxTableCell.forTableColumn((ObservableList)observableList2));
        tableView.setEditable(true);
        if (FxMiscDemo.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "createTable()", 303).add("tv", (Object)tableView)).log();
        }
        return tableView;
    }

    public static void recreateTable() {
        if (FxMiscDemo.logger.level >= 7) {
            logger.lvlBuild(7, "recreateTable()", 310).log();
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "recreateTable().Runnable.run()", 314).log();
                }
                pane.getChildren().remove((Object)table);
                table = FxMiscDemo.createTable();
                pane.add((Node)table, 0, 2);
            }
        });
    }

    public static final TableView getTable() {
        if (FxMiscDemo.logger.level >= 7) {
            logger.lvlBuild(7, "getTable()", 330).log();
        }
        return table;
    }

    private static MenuItem createMenuItem(final String string, final Label label) {
        if (FxMiscDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createMenuItem(String,Label)", 338).addDetail("name", string)).addDetail("target", (Object)label)).log();
        }
        MenuItem menuItem = new MenuItem(string);
        menuItem.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "createMenuItem(String,Label).EventHandler<ActionEvent>.handle(ActionEvent)", 342).addDetail("e", (Object)actionEvent)).log();
                }
                label.setText(string + " item");
            }
        });
        return menuItem;
    }
}

