/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class FxNestedColumnsTableDemoController
implements Initializable {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.fx.multi.FxNestedColumnsTableDemoController");
    private static final int NUMBER_OF_ROWS = 100;
    private static final int COLUMN_COUNT = 6;
    public static final String CLASS_NestedTableColumnHeader = Misc.IS_JAVA_VERSION_AT_LEAST_9 ? "javafx.scene.control.skin.NestedTableColumnHeader" : "com.sun.javafx.scene.control.skin.NestedTableColumnHeader";
    public static final String CLASS_TableColumnHeader = Misc.IS_JAVA_VERSION_AT_LEAST_9 ? "javafx.scene.control.skin.TableColumnHeader" : "com.sun.javafx.scene.control.skin.TableColumnHeader";
    @FXML
    TableView tableView;
    int columnIndex = 0;

    public FxNestedColumnsTableDemoController() {
        if (FxNestedColumnsTableDemoController.logger.level >= 7) {
            logger.lvlBuild(7, "FxNestedColumnsTableDemoController.FxNestedColumnsTableDemoController()", 42).log();
        }
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        if (FxNestedColumnsTableDemoController.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "initialize(URL,ResourceBundle)", 70).addDetail("url", (Object)uRL)).addDetail("bundle", (Object)resourceBundle)).log();
        }
        for (TableColumn tableColumn : this.tableView.getColumns()) {
            this.initTableColumn(tableColumn);
        }
        this.tableView.setItems(this.generateListData());
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                block5: {
                    Node node = FxNestedColumnsTableDemoController.this.findById((Parent)FxNestedColumnsTableDemoController.this.tableView, "columnWithHeaderToHide");
                    if (node != null) {
                        try {
                            Class<?> clazz = Class.forName(CLASS_NestedTableColumnHeader);
                            if (clazz.isAssignableFrom(node.getClass())) {
                                node = FxNestedColumnsTableDemoController.this.findById((Parent)node, "columnWithHeaderToHide");
                            }
                            Class.forName(CLASS_TableColumnHeader);
                            if (node != null && clazz.isAssignableFrom(node.getClass())) {
                                Reflector.call((Object)node, (String)"setPrefHeight", Integer.TYPE, (Object)0);
                            }
                        }
                        catch (Throwable throwable) {
                            if (logger.level < 1) break block5;
                            ((LevelAwareLogBuilder)logger.lvlBuild(1, "initialize(URL,ResourceBundle).Runnable.run()", 96).add("ex", (Object)throwable)).log();
                        }
                    }
                }
            }
        });
    }

    private Node findById(Parent parent, String string) {
        assert (string != null);
        Node node = null;
        for (Node node2 : parent.getChildrenUnmodifiable()) {
            if (!(node2 instanceof Parent)) continue;
            if (string.equals(node2.getId())) {
                return node2;
            }
            node = this.findById((Parent)node2, string);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    void initTableColumn(TableColumn tableColumn) {
        ObservableList observableList;
        if (FxNestedColumnsTableDemoController.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "initTableColumn(TableColumn<String[], ?>)", 126).addDetail("column", (Object)tableColumn)).log();
        }
        if ((observableList = tableColumn.getColumns()).size() > 0) {
            for (TableColumn tableColumn2 : observableList) {
                this.initTableColumn(tableColumn2);
            }
        } else {
            this.setCellValueFactory(tableColumn);
        }
    }

    void setCellValueFactory(TableColumn tableColumn) {
        if (FxNestedColumnsTableDemoController.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCellValueFactory(TableColumn<String[], String>)", 141).addDetail("column", (Object)tableColumn)).log();
        }
        final int n = this.columnIndex++;
        tableColumn.setCellValueFactory(new Callback(){

            public ObservableValue call(TableColumn.CellDataFeatures cellDataFeatures) {
                String string = ((String[])cellDataFeatures.getValue())[n];
                return new SimpleStringProperty(string);
            }
        });
    }

    ObservableList generateListData() {
        if (FxNestedColumnsTableDemoController.logger.level >= 7) {
            logger.lvlBuild(7, "generateListData()", 162).log();
        }
        ObservableList observableList = FXCollections.observableArrayList();
        for (int i = 0; i < 100; ++i) {
            String[] stringArray = new String[6];
            for (int j = 0; j < 6; ++j) {
                stringArray[j] = String.format("%03d:%d", i + 1, j + 1);
            }
            observableList.add((Object)stringArray);
        }
        return observableList;
    }
}

