/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.log.Logger;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;

public class FxNestedColumnsTreeTableDemoController
implements Initializable {
    private static final int NESTING_LEVEL = 5;
    private static final int ELEMENTS_PER_LEVEL = 3;
    private static final int COLUMN_COUNT = 6;
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.fx.multi.FxNestedColumnsTableDemoController");
    @FXML
    TreeTableView tableView;
    int columnIndex = 0;

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        if (FxNestedColumnsTreeTableDemoController.logger.level >= 7) {
            Logger.Builder builder = logger.build("initialize()");
            (FxNestedColumnsTreeTableDemoController.logger.level < 8 ? builder : builder).log(7);
        }
        for (TreeTableColumn treeTableColumn : this.tableView.getColumns()) {
            this.initTableColumn(treeTableColumn);
        }
        this.tableView.setRoot(this.getTreeRoot());
    }

    void initTableColumn(TreeTableColumn treeTableColumn) {
        ObservableList observableList;
        if (FxNestedColumnsTreeTableDemoController.logger.level >= 7) {
            observableList = logger.build("initTableColumn(TreeTableColumn<String[],?>)");
            (FxNestedColumnsTreeTableDemoController.logger.level < 8 ? observableList : observableList.add("column: ").add((Object)treeTableColumn)).log(7);
        }
        if ((observableList = treeTableColumn.getColumns()).size() > 0) {
            for (TreeTableColumn treeTableColumn2 : observableList) {
                this.initTableColumn(treeTableColumn2);
            }
        } else {
            this.setCellValueFactory(treeTableColumn);
        }
    }

    void setCellValueFactory(TreeTableColumn treeTableColumn) {
        int n = this.columnIndex++;
        if (FxNestedColumnsTreeTableDemoController.logger.level >= 7) {
            Logger.Builder builder = logger.build("setCellValueFactory(TreeTableColumn<String[],String>)");
            (FxNestedColumnsTreeTableDemoController.logger.level < 8 ? builder : builder.add("column: ").add((Object)treeTableColumn).add(", index: ").add(n)).log(7);
        }
        treeTableColumn.setCellValueFactory(cellDataFeatures -> {
            String string = ((String[])cellDataFeatures.getValue().getValue())[n];
            return new SimpleStringProperty(string);
        });
    }

    TreeItem getTreeRoot() {
        if (FxNestedColumnsTreeTableDemoController.logger.level >= 7) {
            Logger.Builder builder = logger.build("getTreeRoot()");
            (FxNestedColumnsTreeTableDemoController.logger.level < 8 ? builder : builder).log(7);
        }
        return this.getTreeItem("0", 0);
    }

    TreeItem getTreeItem(String string, int n) {
        Logger.Builder builder;
        if (FxNestedColumnsTreeTableDemoController.logger.level >= 7) {
            builder = logger.build("getTreeItem(String,int)");
            (FxNestedColumnsTreeTableDemoController.logger.level < 8 ? builder : builder.add("id: ").add(string).add(", level: ").add(n)).log(7);
        }
        builder = this.getTreeItemData(string);
        TreeItem treeItem = new TreeItem((Object)builder);
        if (n < 5) {
            for (int i = 0; i < 3; ++i) {
                String string2 = String.format("%s.%d", string, i + 1);
                TreeItem treeItem2 = this.getTreeItem(string2, n + 1);
                treeItem.getChildren().add((Object)treeItem2);
            }
        }
        return treeItem;
    }

    private String[] getTreeItemData(String string) {
        Logger.Builder builder;
        if (FxNestedColumnsTreeTableDemoController.logger.level >= 7) {
            builder = logger.build("getTreeItemData(String)");
            (FxNestedColumnsTreeTableDemoController.logger.level < 8 ? builder : builder.add("rowId: ").add(string)).log(7);
        }
        builder = new String[6];
        for (int i = 0; i < 6; ++i) {
            builder[i] = String.format("%s:%d", string, i + 1);
        }
        return builder;
    }
}

