/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.apps.qftest.demo.multi.DNDDemo;
import de.qfs.apps.qftest.demo.multi.NestedPopupMenu;
import de.qfs.apps.qftest.demo.multi.TableDemo;
import de.qfs.apps.qftest.demo.multi.TwoDialogs;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.awt.Window;
import java.util.LinkedList;
import javafx.embed.swing.SwingNode;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javax.swing.JComponent;
import javax.swing.JDialog;

public abstract class FxSwingNodeDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.fx.multi.FxSwingNodeDemo");
    private static LinkedList nodes = new LinkedList();

    public FxSwingNodeDemo() {
        if (FxSwingNodeDemo.logger.level >= 7) {
            logger.lvlBuild(7, "FxSwingNodeDemo.FxSwingNodeDemo()", 50).log();
        }
    }

    public static Node getRootNode(final String string) {
        SwingNode swingNode;
        if (FxSwingNodeDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode(String)", 66).addDetail("demo", string)).log();
        }
        if (FxSwingNodeDemo.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRootNode(String)", 69).add("nodes", (Object)nodes)).log();
        }
        GridPane gridPane = nodes.iterator();
        while (gridPane.hasNext()) {
            swingNode = (SwingNode)gridPane.next();
            if (FxSwingNodeDemo.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getRootNode(String)", 72).add("node", (Object)swingNode)).add("node.getParent()", (Object)swingNode.getParent())).add("node.getScene()", (Object)swingNode.getScene())).log();
            }
            if (swingNode.getScene() != null) continue;
            swingNode.setContent(null);
            gridPane.remove();
        }
        if (FxSwingNodeDemo.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRootNode(String)", 78).add("nodes now", (Object)nodes)).log();
        }
        gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(6.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("SwingNodeDemo-" + string);
        swingNode = new ColumnConstraints();
        swingNode.setFillWidth(true);
        swingNode.setHgrow(Priority.ALWAYS);
        gridPane.getColumnConstraints().add((Object)swingNode);
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setFillHeight(true);
        rowConstraints.setVgrow(Priority.ALWAYS);
        gridPane.getRowConstraints().add((Object)rowConstraints);
        SwingNode swingNode2 = new SwingNode();
        nodes.add(swingNode2);
        final RefHelper refHelper = new RefHelper(swingNode2);
        swingNode2.setId("SwingNode-" + string);
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                if ("dnd".equals(string)) {
                    new DNDDemo(true){

                        @Override
                        protected void finishWindow(Window window, int n, int n2) {
                            window.pack();
                            refHelper.connect((JComponent)((JDialog)window).getContentPane().getComponents()[0]);
                        }

                        @Override
                        public void showFrameOrDialog() {
                            super.showFrameOrDialog();
                        }
                    }.showFrameOrDialog();
                } else if ("dialogs".equals(string)) {
                    new TwoDialogs(true){

                        @Override
                        protected void finishWindow(Window window, int n, int n2) {
                            refHelper.connect((JComponent)((JDialog)window).getContentPane().getComponents()[0]);
                        }

                        @Override
                        public void showFrameOrDialog() {
                            super.showFrameOrDialog();
                        }
                    }.showFrameOrDialog();
                } else if ("nested".equals(string)) {
                    new NestedPopupMenu(true, false){

                        @Override
                        protected void finishWindow(Window window, int n, int n2) {
                            refHelper.connect((JComponent)((JDialog)window).getContentPane().getComponents()[0]);
                        }

                        @Override
                        public void showFrameOrDialog() {
                            super.showFrameOrDialog();
                        }
                    }.showFrameOrDialog();
                } else if ("table".equals(string)) {
                    new TableDemo(true){

                        @Override
                        protected void finishWindow(Window window, int n, int n2) {
                            refHelper.connect((JComponent)((JDialog)window).getContentPane().getComponents()[0]);
                        }

                        @Override
                        public void showFrameOrDialog() {
                            super.showFrameOrDialog();
                        }
                    }.showFrameOrDialog();
                }
            }
        });
        gridPane.add((Node)swingNode2, 0, 0);
        return gridPane;
    }

    public static class RefHelper {
        private SwingNode swingNode;

        public RefHelper(SwingNode swingNode) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RefHelper.RefHelper(SwingNode)", 165).addDetail("swingNode", (Object)swingNode)).log();
            }
            this.swingNode = swingNode;
        }

        public void connect(JComponent jComponent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RefHelper.connect(JComponent)", 168).addDetail("com", (Object)jComponent)).log();
            }
            this.swingNode.setContent(jComponent);
            this.swingNode = null;
        }
    }
}

