/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.fx.multi;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class FxWindowDemo {
    private static final QFLogger logger = new QFLogger("de.qfs.apps.qftest.demo.fx.multi.FxWindowDemo");

    public FxWindowDemo() {
        if (FxWindowDemo.logger.level >= 7) {
            logger.lvlBuild(7, "FxWindowDemo.FxWindowDemo()", 53).log();
        }
    }

    public static Node getRootNode() {
        if (FxWindowDemo.logger.level >= 7) {
            logger.lvlBuild(7, "getRootNode()", 66).log();
        }
        GridPane gridPane = new GridPane();
        gridPane.setHgap(4.0);
        gridPane.setVgap(6.0);
        gridPane.setPadding(new Insets(18.0, 18.0, 18.0, 18.0));
        gridPane.setStyle("-fx-background-color: grey;");
        gridPane.setId("WindowDemo");
        int n = 0;
        final Button button = new Button("Open new window");
        button.setId("bOpenStage");
        button.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 81).addDetail("e", (Object)actionEvent)).log();
                }
                FxWindowDemo.createStage(button.getScene().getWindow(), true);
            }
        });
        gridPane.add((Node)button, 0, n++);
        final Button button2 = new Button("Open new window (nonmodal)");
        button2.setId("bOpenStageNonModal");
        button2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 91).addDetail("e", (Object)actionEvent)).log();
                }
                FxWindowDemo.createStage(button2.getScene().getWindow(), false);
            }
        });
        gridPane.add((Node)button2, 0, n++);
        Button button3 = new Button("Confirm on close");
        button3.setId("bOpenConfirm");
        button3.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 101).addDetail("e", (Object)actionEvent)).log();
                }
                final Stage stage = FxWindowDemo.createStage(button.getScene().getWindow(), true);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 103).add("stage", (Object)stage)).log();
                }
                stage.setOnCloseRequest(new EventHandler(){

                    public void handle(WindowEvent windowEvent) {
                        if (logger.level >= 7) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent).EventHandler<WindowEvent>.handle(WindowEvent)", 106).addDetail("e", (Object)windowEvent)).log();
                        }
                        FxWindowDemo.createDialog((Window)stage, 0, true, true);
                    }
                });
            }
        });
        gridPane.add((Node)button3, 0, n++);
        final Button button4 = new Button("Temporary window");
        button4.setId("bOpenTemp");
        button4.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 118).addDetail("e", (Object)actionEvent)).log();
                }
                FxWindowDemo.createTempStage(button4.getScene().getWindow());
            }
        });
        gridPane.add((Node)button4, 0, n++);
        final Button button5 = new Button("File Chooser (single)");
        button5.setId("bOpenFileChooserSingle");
        final Label label = new Label("None");
        label.setId("labelFile");
        button5.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                File file;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 130).addDetail("e", (Object)actionEvent)).log();
                }
                label.setText((file = new FileChooser().showOpenDialog(button5.getScene().getWindow())) == null ? "None" : Misc.getBestPath((File)file));
            }
        });
        gridPane.add((Node)button5, 0, n);
        gridPane.add((Node)label, 1, n++);
        final Button button6 = new Button("File Chooser (multi)");
        button6.setId("bOpenFileChooserMulti");
        final Label label2 = new Label("None");
        label2.setId("labelFiles");
        button6.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                List list;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 145).addDetail("e", (Object)actionEvent)).log();
                }
                if ((list = new FileChooser().showOpenMultipleDialog(button6.getScene().getWindow())) == null || list.size() == 0) {
                    label2.setText("None");
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            stringBuilder.append("|");
                        }
                        stringBuilder.append(Misc.getBestPath((File)((File)list.get(i))));
                    }
                    label2.setText(stringBuilder.toString());
                }
            }
        });
        gridPane.add((Node)button6, 0, n);
        gridPane.add((Node)label2, 1, n++);
        final Button button7 = new Button("File Chooser (save)");
        button7.setId("bOpenFileChooserSave");
        final Label label3 = new Label("None");
        label3.setId("labelSaveFile");
        button7.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                File file;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 171).addDetail("e", (Object)actionEvent)).log();
                }
                label3.setText((file = new FileChooser().showSaveDialog(button7.getScene().getWindow())) == null ? "None" : Misc.getBestPath((File)file));
            }
        });
        gridPane.add((Node)button7, 0, n);
        gridPane.add((Node)label3, 1, n++);
        final Button button8 = new Button("Directory Chooser");
        button8.setId("bOpenDirChooser");
        final Label label4 = new Label("None");
        label4.setId("labelDir");
        button8.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                File file;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 186).addDetail("e", (Object)actionEvent)).log();
                }
                label4.setText((file = new DirectoryChooser().showDialog(button8.getScene().getWindow())) == null ? "None" : Misc.getBestPath((File)file));
            }
        });
        gridPane.add((Node)button8, 0, n);
        gridPane.add((Node)label4, 1, n++);
        Button button9 = new Button("File Chooser (no parent)");
        button9.setId("bOpenFileChooserNoParent");
        final Label label5 = new Label("None");
        label5.setId("labelFileNoParent");
        button9.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                File file;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 201).addDetail("e", (Object)actionEvent)).log();
                }
                label5.setText((file = new FileChooser().showOpenDialog(null)) == null ? "None" : Misc.getBestPath((File)file));
            }
        });
        gridPane.add((Node)button9, 0, n);
        gridPane.add((Node)label5, 1, n++);
        Button button10 = new Button("File Chooser (save, no parent)");
        button10.setId("bOpenFileChooserSaveNoParent");
        final Label label6 = new Label("None");
        label6.setId("labelSaveFileNoParent");
        button10.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "getRootNode().EventHandler<ActionEvent>.handle(ActionEvent)", 215).addDetail("e", (Object)actionEvent)).log();
                }
                FileChooser fileChooser = new FileChooser();
                ArrayList<FileChooser.ExtensionFilter> arrayList = new ArrayList<FileChooser.ExtensionFilter>();
                FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter("CSV Files (*.csv)", new String[]{"*.csv"});
                FileChooser.ExtensionFilter extensionFilter2 = new FileChooser.ExtensionFilter("PDF Files (*.pdf)", new String[]{"*.pdf"});
                arrayList.add(extensionFilter);
                arrayList.add(extensionFilter2);
                fileChooser.getExtensionFilters().addAll(arrayList);
                Reflector.safeCall((Object)fileChooser, (String)"setSelectedExtensionFilter", FileChooser.ExtensionFilter.class, (Object)extensionFilter2);
                System.err.println("dir: " + fileChooser.getInitialDirectory());
                File file = fileChooser.showSaveDialog(null);
                label6.setText(file == null ? "None" : Misc.getBestPath((File)file));
                System.err.println("dir now: " + fileChooser.getInitialDirectory());
                Object object = Reflector.safeCall((Object)fileChooser, (String)"getSelectedExtensionFilter");
                System.err.println("filter: " + object);
                if (object instanceof FileChooser.ExtensionFilter) {
                    System.err.println("extensions: " + ((FileChooser.ExtensionFilter)object).getExtensions());
                }
            }
        });
        gridPane.add((Node)button10, 0, n);
        gridPane.add((Node)label6, 1, n++);
        return gridPane;
    }

    private static Stage createStage(Window window, final boolean bl) {
        if (FxWindowDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createStage(Window,boolean)", 254).addDetail("parent", (Object)window)).addDetail("modal", bl)).log();
        }
        final Stage stage = new Stage();
        stage.initOwner(window);
        stage.setTitle("New window");
        Button button = new Button("Open dialogs");
        button.setId("bOpenDialogs");
        button.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "createStage(Window,boolean).EventHandler<ActionEvent>.handle(ActionEvent)", 264).addDetail("e", (Object)actionEvent)).log();
                }
                FxWindowDemo.createDialog((Window)stage, 0, bl, false);
                FxWindowDemo.createDialog((Window)stage, 1, bl, bl);
            }
        });
        BorderPane borderPane = new BorderPane();
        borderPane.setId("borderPaneStage");
        borderPane.setCenter((Node)button);
        stage.setScene(new Scene((Parent)borderPane, 300.0, 100.0));
        stage.setX(window.getX() + 200.0);
        stage.setY(window.getY() + 100.0);
        stage.show();
        return stage;
    }

    private static void createTempStage(Window window) {
        if (FxWindowDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createTempStage(Window)", 288).addDetail("parent", (Object)window)).log();
        }
        final Stage stage = new Stage();
        stage.initOwner(window);
        stage.setTitle("Temporary window");
        BorderPane borderPane = new BorderPane();
        borderPane.setId("borderPaneTemp");
        stage.setScene(new Scene((Parent)borderPane, 300.0, 100.0));
        stage.setX(window.getX() + 300.0);
        stage.setY(window.getY() + 200.0);
        stage.show();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "createTempStage(Window).TimerTask.run()", 303).log();
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (logger.level >= 7) {
                            logger.lvlBuild(7, "createTempStage(Window).TimerTask.run().Runnable.run()", 306).log();
                        }
                        stage.close();
                    }
                });
            }
        }, 1400L);
    }

    private static void createDialog(Window window, int n, boolean bl, boolean bl2) {
        if (FxWindowDemo.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "createDialog(Window,int,boolean,boolean)", 325).addDetail("parent", (Object)window)).addDetail("num", n)).addDetail("modal", bl)).addDetail("wait", bl2)).log();
        }
        final Stage stage = new Stage();
        stage.initOwner(window);
        if (bl) {
            stage.initModality(Modality.WINDOW_MODAL);
        }
        stage.setTitle(n == 0 ? "First dialog" : "Second dialog");
        final Button button = new Button("Close " + (n == 0 ? "first" : "second"));
        button.setId("bClose");
        if (n == 1 && "true".equals(System.getProperty("qftest.fxmulti.window.invisiblebutton"))) {
            button.setVisible(false);
        }
        button.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "createDialog(Window,int,boolean,boolean).EventHandler<ActionEvent>.handle(ActionEvent)", 341).addDetail("e", (Object)actionEvent)).log();
                }
                stage.close();
            }
        });
        BorderPane borderPane = new BorderPane();
        borderPane.setId((n == 0 ? "First" : "Second") + "borderPaneDialog");
        borderPane.setCenter((Node)button);
        Button button2 = new Button("Dummy");
        button2.setOnAction(new EventHandler(){

            public void handle(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "createDialog(Window,int,boolean,boolean).EventHandler<ActionEvent>.handle(ActionEvent)", 351).addDetail("e", (Object)actionEvent)).log();
                }
                button.setVisible(!button.isVisible());
            }
        });
        borderPane.setBottom((Node)button2);
        stage.setScene(new Scene((Parent)borderPane, 300.0, 100.0));
        stage.setX(window.getX() + 100.0 + (double)(100 * n));
        stage.setY(window.getY() + 50.0 + (double)(50 * n));
        if (bl2) {
            stage.showAndWait();
        } else {
            stage.show();
        }
    }
}

