/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import de.qfs.apps.qftest.demo.BaseDemo;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.Logger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdvancedImageDemo
extends BaseDemo {
    private static final Logger logger = new Logger("de.qfs.apps.qftest.demo.AdvancedImageDemo");
    private Window win;
    private Grid grid;
    private Container pane;
    private ComboBoxImages comboBoxImages;
    private JPanel imagePanel;
    private JTextField textField;
    private JButton openButton;
    private ImageComponent[] imageComponents;
    private static final String[] allImages = new String[]{"Black-16x8.png", "Black_to_white-256x256.png", "Black_White_Stripes-32x32.png", "Black_White-32x32.png", "Black_with_white_mini_square-256x256.png", "Black_with_white_mini_square-300x300.png", "Black_with_white_squares-300x300.png", "Black-256x256.png", "Black-300x300.png", "Black-32x32.png", "Black-512x512.png", "Black-640x480.png", "Blue_to_white-256x256.png", "Blue-256x256.png", "CMY_Circles-256x256.png", "GoogleMaps-640x480.png", "GoogleMaps_Small-210x145.png", "GoogleMaps_Very_Small-120x60.png", "GoogleMaps_Modified-640x480.png", "GoogleMaps_Modified_Small-210x145.png", "GoogleMaps_Modified_Very_Small-120x60.png", "Green_to_white-256x256.png", "Green-256x256.png", "Grey-256x256.png", "Grey-300x300.png", "Grey-32x32.png", "Half_Colors-32x32.png", "Mixed_soft_colors-256x256.png", "Mixed_soft_colors-512x512.png", "Mixed_soft_colors-40x80.png", "Mixed_soft_colors_different-40x80.png", "Mountains_Modified-640x480.png", "Mountains-640x480.png", "Multiple_squares-300x300.png", "Red_to_white-256x256.png", "Red-256x256.png", "RGB_Circles-256x256.png", "Screenshot_GUI-512x512.png", "White-256x256.png", "White-300x300.png", "White-32x32.png", "White-640x480.png"};

    public AdvancedImageDemo(boolean bl) {
        super(bl);
    }

    public static void main(String[] stringArray) {
        AdvancedImageDemo advancedImageDemo = new AdvancedImageDemo(false);
        BaseDemo.setupAndRun(stringArray, advancedImageDemo);
    }

    @Override
    protected void showFrameOrDialog() {
        Serializable serializable;
        if (AdvancedImageDemo.logger.level >= 7) {
            logger.log(7, "showFrameOrDialog()", "");
        }
        if (this.asDialog) {
            serializable = new JDialog(new JFrame(), "AdvancedImageDemo [dialog]", !this.isAsNonModal());
            this.win = serializable;
            this.pane = serializable.getContentPane();
        } else {
            this.frame = new JFrame("AdvancedImageDemo [ Frame ]");
            this.win = this.frame;
            this.pane = ((JFrame)this.frame).getContentPane();
        }
        this.win.setName("AdvancedImageDemo");
        this.grid = new Grid();
        this.grid.setName("grid");
        serializable = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = AdvancedImageDemo.this.comboBoxImages.getSelectedIndex();
                AdvancedImageDemo.this.showImage(AdvancedImageDemo.this.comboBoxImages.getSelectedItem().toString(), n);
            }
        };
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedImageDemo.this.showImage(AdvancedImageDemo.this.textField.getText(), -1);
            }
        };
        this.comboBoxImages = new ComboBoxImages();
        this.comboBoxImages.setName("comboBoxImages");
        this.comboBoxImages.addActionListener((ActionListener)((Object)serializable));
        this.imagePanel = new JPanel();
        this.imagePanel.setPreferredSize(new Dimension(800, 500));
        this.imagePanel.setMinimumSize(new Dimension(800, 500));
        this.imagePanel.setName("imagePanel");
        this.textField = new JTextField();
        this.textField.setName("inputTextField");
        this.openButton = new JButton("Open");
        this.openButton.setName("openButton");
        this.openButton.addActionListener(abstractAction);
        this.grid.addLine(new Component[]{Box.createHorizontalGlue(), this.comboBoxImages, Box.createHorizontalGlue()});
        this.grid.addLine(new Component[]{this.imagePanel});
        this.grid.addLine(new Component[]{Box.createHorizontalStrut(2), this.textField, this.openButton, Box.createHorizontalStrut(2)});
        this.imageComponents = new ImageComponent[this.comboBoxImages.getAmountOfImages()];
        this.pane.add((Component)this.grid);
        this.finishWindow(this.win, 800, 600);
        int n = this.comboBoxImages.getSelectedIndex();
        try {
            this.showImage(this.comboBoxImages.getSelectedItem().toString(), n);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void showImage(String string, int n) {
        ImageComponent imageComponent = this.getImageComponent(string, n);
        try {
            this.imagePanel.removeAll();
            this.imagePanel.add(imageComponent);
            this.imagePanel.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.win.paintAll(this.win.getGraphics());
    }

    private void loadImage(String string) {
        System.out.println("loading");
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            ImageComponent imageComponent = new ImageComponent(bufferedImage);
            if (!this.comboBoxImages.getItemAt(this.comboBoxImages.getItemCount() - 1).toString().startsWith("FS")) {
                this.comboBoxImages.addItem("FS: " + string);
            }
            this.imagePanel.removeAll();
            this.imagePanel.add(imageComponent);
            this.imagePanel.repaint();
            this.win.paintAll(this.win.getGraphics());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Image not found: " + string);
        }
    }

    private ImageComponent getImageComponent(String string, int n) {
        if (n != -1 && !string.startsWith("FS")) {
            if (this.imageComponents[n] == null) {
                try {
                    ImageComponent imageComponent;
                    BufferedImage bufferedImage = ImageIO.read(this.getClass().getResource("AdvancedImageDemoImages/" + this.toFileFormat(string)));
                    this.imageComponents[n] = imageComponent = new ImageComponent(bufferedImage);
                    return imageComponent;
                }
                catch (IIOException iIOException) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            return this.imageComponents[n];
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string.replace("FS: ", "")));
            ImageComponent imageComponent = new ImageComponent(bufferedImage);
            if (n == -1) {
                this.comboBoxImages.addItem("FS: " + string);
                this.comboBoxImages.setSelectedIndex(this.comboBoxImages.getItemCount() - 1);
            }
            return imageComponent;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Image not found: " + string);
            return null;
        }
    }

    private String toFileFormat(String string) {
        return string.replaceAll(" ", "_") + ".png";
    }

    class ImageComponent
    extends JPanel
    implements MouseListener {
        public ImageComponent(BufferedImage bufferedImage) {
            this.addMouseListener(this);
            JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
            jLabel.setName("imageLabel");
            this.add(jLabel);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JOptionPane.showMessageDialog(this, "Image has been clicked.");
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class ComboBoxImages
    extends JComboBox {
        private final int amountOfImages = AdvancedImageDemo.access$300().length;

        public ComboBoxImages() {
            this.addDropDownElements();
        }

        private void addDropDownElements() {
            for (int i = 0; i < allImages.length; ++i) {
                this.addItem(this.toNicerFormat(allImages[i]));
            }
        }

        private String toNicerFormat(String string) {
            try {
                return string.replaceAll("_", " ").substring(0, string.length() - 4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return string;
            }
        }

        public int getAmountOfImages() {
            return this.amountOfImages;
        }
    }
}

