/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.apps.qftest.demo.multi;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import de.qfs.apps.qftest.demo.multi.carconfigurator.viewSwing.SimpleTwoDTree;
import de.qfs.lib.gui.Grid;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class CarConfigurator
implements Runnable {
    private JFrame frame;
    private static final int WIDTH = 350;
    private static final int HEIGHT = 400;
    private int x_pos = 0;
    private int y_pos = 0;
    private boolean m_exitOnClose;
    private boolean m_doRealExit = true;
    private SkyBluer m_theme = new SkyBluer();
    private ImageIcon icon16;
    private ImageIcon icon32;
    private ImageIcon iconAbout;
    private VehicleTablePanel vehicleTablePanel;
    private NewVehicleTablePanel vehicleTablePanel_new;
    private AccessoryTablePanel accessoryTablePanel;
    private SpecialsPanel specialsPanel;
    private CalculatorPanel calculatorPanel;
    private static MapResourceBundle rb;
    private int m_language;
    private static final int GERMAN = 0;
    private static final int ENGLISH = 1;
    private static final int LOADTEST_WAITTIME = 3000;
    private NumberFormat m_numberFormatter;
    private NumberFormat m_currencyFormatter;
    private int minimumFontSize = 14;
    private double m_baseprice;
    private double m_specialprice;
    private String m_special_contained_extras;
    private int m_discount;
    private String m_user;
    private JCheckBoxMenuItem buggyCheckboxMenuItem;
    private boolean buggyState;
    private JCheckBoxMenuItem newVersionCheckboxMenuItem;
    private boolean newVersionState;
    private boolean withLogin;
    private JCheckBoxMenuItem loadtestCheckboxMenuItem;
    private boolean loadtestState;
    private boolean cleanNames;
    private Action vehiclesAction;
    private Action accessoriesAction;
    private Action specialsAction;
    private Action viewStatisticsAction;
    private Action viewPurchaseOrderAction;
    private Action sendPurchaseOrderAction;
    private Action germanAction;
    private Action englishAction;
    private Action resetAction;
    private Action logoutAction;
    private Action infoAction;
    private Action buggyAction;
    private Action newVersionAction;
    private Action loadtestAction;
    private static final int VEHILCE_NAME_INDEX = 0;
    private static final int VEHILCE_PRICE_INDEX = 1;
    private Object[][] vehicleCells = new Object[][]{{"Rolo", 12300.0}, {"Minigolf", 15000.0}, {"Rassant", 17000.0}, {"Rassant Family", 18500.0}, {"I5", 29000.0}};
    private String[] vehicleColumnNames;
    private String[] vehicleColumnNames_DE = new String[]{"Modell", "Preis"};
    private String[] vehicleColumnNames_EN = new String[]{"Model", "Price"};
    private Integer[] vehicleColumnMaxWidth = new Integer[]{-1, 100};
    private static final int VEHILCE_NAME_INDEX_new = 0;
    private static final int VEHILCE_ID_INDEX_new = 1;
    private static final int VEHILCE_PRICE_INDEX_new = 2;
    private Object[][] vehicleCells_new = new Object[][]{{"Rolo", "M1", 12300.0}, {"Minigolf", "M2", 15000.0}, {"Rassant", "M3", 17000.0}, {"Rassant Family", "M4", 18500.0}, {"I5", "M5", 29000.0}};
    private String[] vehicleColumnNames_new;
    private String[] vehicleColumnNames_DE_new = new String[]{"Modell", "ID", "Preis"};
    private String[] vehicleColumnNames_EN_new = new String[]{"Model", "ID", "Price"};
    private Integer[] vehicleColumnMaxWidth_new = new Integer[]{-1, 30, 100};
    private Object[][] specialsEntries;
    private String[] specialsColumnNames;
    private Object[][] specialsEntries_DE = new Object[][]{{"- kein Sondermodell -", "-", 0.0, ""}, {"Gomera", "Lackierung in zwei Braunt\u00f6nen\r\nFelgen und Stossstangen in Wagenfarbe\r\nZentralverriegelung\r\nSportfelgen\r\nFensterheber hinten\r\n\r\nPreis: 1413,00 EUR", 1413.0, "S4 S3 S6"}, {"Jazz", "Lackierung in Himmelblau und Dunkelblau\r\nFelgen und Stossstangen in Wagenfarbe\r\nRadio mit CD\r\nSportfelgen\r\nFussmatten\r\n\r\nPreis: 1049,00 EUR", 1049.0, "S7 S8 S4"}, {"Luxus", "Lackierung in zwei gedeckten Pastellfarben\r\nFelgen und Stossstangen in Wagenfarbe\r\nABS\r\nRadio mit CD\r\nZentralverriegelung\r\nFensterheber hinten\r\n\r\nPreis: 2499,99 EUR", 2499.99, "S7 S6 S5 S3"}};
    private Object[][] specialsEntries_EN = new Object[][]{{"- no special model -", "-", 0.0, ""}, {"Gomera", "Varnishing in two shades of brown\r\nRims ans bumpers in same color as car\r\nCentralized door locking\r\nAlloy rims\r\nPower windows in back\r\n\r\nPrice: 1413.00 EUR", 1413.0, "S4 S3 S6"}, {"Jazz", "Varnishing bright and dark blue\r\nRims ans bumpers in same color as car\r\nRadio with CD\r\nAlloy rims\r\nMats\r\n\r\nPrice: 1049.00 EUR", 1049.0, "S7 S8 S4"}, {"Luxus", "Varnishing in two muted pastel colors\r\nRims ans bumpers in same color as car\r\nAnti-skid system\r\nRadio with CD\r\nCentralized door locking\r\nPower windows in back\r\n\r\nPrice: 2499.99 EUR", 2499.99, "S7 S6 S5 S3"}};
    private String[] specialsColumnNames_DE = new String[]{"Modelle", "Hide", "Hide", "Hide"};
    private String[] specialsColumnNames_EN = new String[]{"Models", "Hide", "Hide", "Hide"};
    private Integer[] specialsColumnMaxWidth = new Integer[]{-1};
    private static final int SPECIALS_TOTAL = 4;
    private static final int SPECIALS_NAME_INDEX = 0;
    private static final int SPECIALS_DESCRIPTION_INDEX = 1;
    private static final int SPECIALS_PRICE_INDEX = 2;
    private static final int SPECIALS_FEATURES_INDEX = 3;
    private String[] accessoryColumnNames;
    private Object[][] accessoryCells;
    private Object[][] accessoryCells_DE = new Object[][]{{Boolean.FALSE, "Lederlenkrad", "S1", 360.0}, {Boolean.FALSE, "Beheizbare Aussenspiegel", "S2", 210.0}, {Boolean.FALSE, "Zentralverriegelung", "S3", 1200.0}, {Boolean.FALSE, "Sportfelgen", "S4", 900.0}, {Boolean.FALSE, "ABS", "S5", 990.0}, {Boolean.FALSE, "Fensterheber hinten", "S6", 490.0}, {Boolean.FALSE, "Radio mit CD-Wechsler", "S7", 470.0}, {Boolean.FALSE, "Fussmatten", "S8", 26.0}};
    private String[] accessoryColumnNames_DE = new String[]{" ", "Beschreibung", "ID", "Preis"};
    private Object[][] accessoryCells_EN = new Object[][]{{Boolean.FALSE, "Steering wheel in leather", "S1", 360.0}, {Boolean.FALSE, "Heatable outside mirror", "S2", 210.0}, {Boolean.FALSE, "Centralized door locking", "S3", 1200.0}, {Boolean.FALSE, "Alloy rims", "S4", 900.0}, {Boolean.FALSE, "Anti-skid system", "S5", 990.0}, {Boolean.FALSE, "Power windows in back", "S6", 490.0}, {Boolean.FALSE, "Radio with CD", "S7", 470.0}, {Boolean.FALSE, "Mats", "S8", 26.0}};
    private String[] accessoryColumnNames_EN = new String[]{" ", "Description", "ID", "Price"};
    private Integer[] accessoryColumnMaxWidth = new Integer[]{30, -1, 30, 100};
    private static final int ACCESSORY_SELECT_INDEX = 0;
    private static final int ACCESSORY_NAME_INDEX = 1;
    private static final int ACCESSORY_ID_INDEX = 2;
    private static final int ACCESSORY_PRICE_INDEX = 3;
    private String[] statisticsColumnNames_DE = new String[]{"Woche", "Bestellmenge"};
    private String[] statisticsColumnNames_EN = new String[]{"Week", "Ordered Amount"};
    private Integer[] statisticsColumnMaxWidth = new Integer[]{-1, -1};

    public CarConfigurator() {
        this(true, null, -1, false, false, false, false, 0, 0, false, CarLogin.currentUser);
    }

    public CarConfigurator(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, boolean bl5, boolean bl6, String string2) {
        this(!bl5, string, n, bl, bl2, bl3, bl4, n2, n3, bl6, CarLogin.currentUser);
    }

    public CarConfigurator(boolean bl, String string, int n, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, int n3, boolean bl6, String string2) {
        if (n != -1) {
            this.minimumFontSize = n;
        }
        this.m_exitOnClose = bl;
        String string3 = string;
        if (string == null) {
            string3 = Locale.getDefault().getLanguage();
        }
        if (string3.equalsIgnoreCase("de")) {
            System.out.println("Diese Demo is veraltet und wird entfernt werden.\nNutzen Sie de.qfs.apps.qftest.demo.multi.carconfigurator.main.CarConfigurator als Einstiegsklasse.");
            this.m_language = 0;
            this.m_numberFormatter = NumberFormat.getNumberInstance(Locale.GERMANY);
            this.m_currencyFormatter = NumberFormat.getCurrencyInstance(Locale.GERMANY);
        } else {
            System.out.println("This demo is deprecated and will be removed.\nUse de.qfs.apps.qftest.demo.multi.carconfigurator.main.CarConfigurator new as entry point.");
            this.m_language = 1;
            this.m_numberFormatter = NumberFormat.getNumberInstance(Locale.US);
            this.m_currencyFormatter = NumberFormat.getCurrencyInstance(Locale.US);
        }
        this.m_numberFormatter.setGroupingUsed(false);
        this.buggyState = bl6;
        this.loadtestState = bl2;
        this.newVersionState = bl3;
        this.x_pos = n2;
        this.y_pos = n3;
        this.withLogin = bl4;
        this.cleanNames = bl5;
        this.m_special_contained_extras = new String("");
        this.m_user = string2;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2 = -1;
            boolean bl = false;
            String string = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            int n3 = 0;
            int n4 = 0;
            if (stringArray.length > 0 && !stringArray[0].startsWith("-")) {
                string = stringArray[0];
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n] == null) continue;
                if ("-fontsize".equalsIgnoreCase(stringArray[n])) {
                    try {
                        n2 = Integer.valueOf(stringArray[++n]);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ("-pos.x".equalsIgnoreCase(stringArray[n])) {
                    try {
                        n3 = Integer.valueOf(stringArray[++n]);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ("-pos.y".equalsIgnoreCase(stringArray[n])) {
                    try {
                        n4 = Integer.valueOf(stringArray[++n]);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if ("-loadtest".equalsIgnoreCase(stringArray[n])) {
                    bl = true;
                    continue;
                }
                if ("-splash".equalsIgnoreCase(stringArray[n])) {
                    bl2 = true;
                    continue;
                }
                if ("-newversion".equalsIgnoreCase(stringArray[n])) {
                    bl3 = true;
                    continue;
                }
                if ("-login".equalsIgnoreCase(stringArray[n])) {
                    bl5 = true;
                    continue;
                }
                if ("-cleannames".equalsIgnoreCase(stringArray[n])) {
                    bl6 = true;
                    continue;
                }
                if ("-buggy".equalsIgnoreCase(stringArray[n])) {
                    bl4 = true;
                    continue;
                }
                if ("-noexit".equalsIgnoreCase(stringArray[n])) {
                    bl7 = true;
                    continue;
                }
                if ("-lang".equalsIgnoreCase(stringArray[n])) {
                    try {
                        string = stringArray[++n];
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!"-help".equalsIgnoreCase(stringArray[n])) continue;
                CarConfigurator.exitUsage();
            }
            if (bl2) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            CarSplashWindow.instance().show();
                        }
                    });
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
            }
            n = 1;
            final int[] nArray = new int[]{1};
            if (bl5) {
                if (bl2) {
                    CarSplashWindow.instance().dispose();
                }
                final String string2 = string;
                final int n5 = n2;
                final int n6 = n3;
                final int n7 = n4;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        nArray[0] = CarLogin.showLogin(string2, n5, n6, n7);
                        while (nArray[0] == 0) {
                            nArray[0] = CarLogin.showLogin(string2, n5, n6, n7);
                        }
                    }
                });
            }
            if (n != 0 && nArray[0] == 1) {
                SwingUtilities.invokeAndWait(new CarConfigurator(string, n2, bl, bl3, bl5, bl6, n3, n4, bl7, bl4, CarLogin.currentUser));
            }
            if (bl2) {
                CarSplashWindow.instance().dispose();
            }
            if (nArray[0] == -1) {
                System.exit(-2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static void exitUsage() {
        String string = "Call the script as follows:\n\nrun_car.bat or run_car.sh [-lang <language>] [-loadtest] [-buggy] [-fontsize <font-size>] [-pos.x <x.position>] [-pos.y <y.position>] [-splash] [-login]\n\n[-lang <language>] ... specifies the language to start.\n[-fontsize <font-size>]  ... specifies the font-size to use.\n[-pos.x <x-position>]  ... specifies the X position of the frame for launching.\n[-pos.y <y-position>]  ... sspecifies the Y position of the frame for launching.\n[-splash] ... starts the application with splash screen (5 seconds delay till main dialog appears)\n[-login] ... starts with login dialog. Use tester/tester (all permissions) or user/user (limited permissions).\n[-cleannames] ... starts with clean component names for single sourcing.\n[-loadtest] ... starts the application in load test mode.\n[-buggy] ... starts the application in buggy mode.";
        System.out.println(string);
        System.exit(1);
    }

    @Override
    public void run() {
        block6: {
            FontPolicy fontPolicy = new FontPolicy(){

                public FontSet getFontSet(String string, UIDefaults uIDefaults) {
                    return new DerivedFontSet(FontPolicies.getDefaultPlasticPolicy().getFontSet(string, uIDefaults), CarConfigurator.this.minimumFontSize);
                }
            };
            fontPolicy = FontPolicies.customSettingsPolicy((FontPolicy)fontPolicy);
            PlasticLookAndFeel.setFontPolicy((FontPolicy)fontPolicy);
            try {
                try {
                    Options.setSelectOnFocusGainEnabled((boolean)false);
                    System.getProperty("Plastic.tabStyle");
                    PlasticLookAndFeel.setPlasticTheme((PlasticTheme)this.m_theme);
                    if (Misc.OS_IS_WINDOWS) {
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                        break block6;
                    }
                    UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                }
                catch (Exception exception) {
                    String string = UIManager.getSystemLookAndFeelClassName();
                    if (string.endsWith("MotifLookAndFeel")) {
                        string = UIManager.getCrossPlatformLookAndFeelClassName();
                    }
                    UIManager.setLookAndFeel(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setupActions();
        this.frame = this.makeFrame();
        this.frame.show();
    }

    private JFrame makeFrame() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.frame = new JFrame(this.getMainFrameTitle());
        this.frame.setName("JCarConfigurator");
        rb = new MapResourceBundle();
        if (this.m_language == 0) {
            rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.GERMANY, this.getClass());
            rb.fetchProperties("resources/properties/carconfig", Locale.GERMANY, this.getClass());
        } else {
            rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.US, this.getClass());
            rb.fetchProperties("resources/properties/carconfig", Locale.US, this.getClass());
        }
        this.icon16 = (ImageIcon)rb.getIcon("icon.CarConfig.frame", null);
        if (this.icon16 != null) {
            this.frame.setIconImage(this.icon16.getImage());
        }
        this.icon32 = (ImageIcon)rb.getIcon("icon.CarConfig.frame32", null);
        if (this.icon32 != null) {
            this.frame.setIconImage(this.icon32.getImage());
        }
        this.iconAbout = (ImageIcon)rb.getIcon("icon.CarConfig.about", null);
        if (this.newVersionState) {
            this.iconAbout = (ImageIcon)rb.getIcon("icon.newCarConfig.about", null);
        }
        this.makeMenus(this.frame);
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        this.initializeData();
        this.initContents();
        JTabbedPane jTabbedPane = this.createTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        jPanel.add((Component)this.calculatorPanel, "South");
        Container container = this.frame.getContentPane();
        container.add((Component)jPanel, "Center");
        this.frame.pack();
        this.frame.setSize(350, 400);
        this.frame.setLocation(this.x_pos, this.y_pos);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CarConfigurator.this.exit(0);
            }
        });
        return this.frame;
    }

    private void switchFrame() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.frame = this.makeFrame();
        this.frame.setVisible(true);
    }

    private void makeMenus(JFrame jFrame) {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setName("MenuBar");
        jFrame.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu(rb.getString("menu.file.name"));
        jMenu.setMnemonic(rb.getString("menu.file.mnemonic").charAt(0));
        jMenu.setName("mFile");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(rb.getString("menu.file.reset.name"));
        jMenuItem.setMnemonic(rb.getString("menu.file.reset.mnemonic").charAt(0));
        jMenuItem.setName("miReset");
        jMenuItem.addActionListener(this.resetAction);
        jMenu.add(jMenuItem);
        if (this.withLogin) {
            jMenuItem = new JMenuItem(rb.getString("menu.file.logout.name"));
            jMenuItem.setMnemonic(rb.getString("menu.file.logout.mnemonic").charAt(0));
            jMenuItem.setName("miLogout");
            jMenuItem.addActionListener(this.logoutAction);
            jMenu.add(jMenuItem);
        }
        jMenuItem = new JMenuItem(rb.getString("menu.file.exit.name"));
        jMenuItem.setMnemonic('x');
        jMenuItem.setName("miExit");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarConfigurator.this.exit(0);
            }
        });
        jMenu.add(jMenuItem);
        jMenu = new JMenu(rb.getString("menu.options.name"));
        jMenu.setMnemonic(rb.getString("menu.options.mnemonic").charAt(0));
        jMenu.setName("mOptions");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem(rb.getString("menu.options.vehicles.name"));
        jMenuItem.setMnemonic('f');
        jMenuItem.setName("miVehicles");
        jMenuItem.addActionListener(this.vehiclesAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(rb.getString("menu.options.specials.name"));
        jMenuItem.setMnemonic(rb.getString("menu.options.specials.mnemonic").charAt(0));
        jMenuItem.setName("miSpecials");
        jMenuItem.addActionListener(this.specialsAction);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(rb.getString("menu.options.accessories.name"));
        jMenuItem.setMnemonic(rb.getString("menu.options.accessories.mnemonic").charAt(0));
        jMenuItem.setName("miAccessories");
        jMenuItem.addActionListener(this.accessoriesAction);
        jMenu.add(jMenuItem);
        if (this.isStandardUser()) {
            jMenu = new JMenu(rb.getString("menu.order.name"));
            jMenu.setMnemonic(rb.getString("menu.order.mnemonic").charAt(0));
            jMenu.setName("mOrder");
            jMenuBar.add(jMenu);
            jMenuItem = new JMenuItem(rb.getString("menu.order.view.name"));
            jMenuItem.setMnemonic(rb.getString("menu.order.view.mnemonic").charAt(0));
            jMenuItem.setName("miViewOrder");
            jMenuItem.addActionListener(this.viewPurchaseOrderAction);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(rb.getString("menu.order.send.name"));
            jMenuItem.setMnemonic(rb.getString("menu.order.send.mnemonic").charAt(0));
            jMenuItem.setName("miSendOrder");
            jMenuItem.addActionListener(this.sendPurchaseOrderAction);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(rb.getString("menu.order.statistics.name"));
            jMenuItem.setMnemonic(rb.getString("menu.order.statistics.mnemonic").charAt(0));
            jMenuItem.setName("miShowStatistics");
            jMenuItem.addActionListener(this.viewStatisticsAction);
            jMenu.add(jMenuItem);
        }
        jMenu = new JMenu(rb.getString("menu.help.name"));
        jMenu.setMnemonic(rb.getString("menu.help.mnemonic").charAt(0));
        jMenu.setName("mHelp");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Info");
        jMenuItem.setMnemonic('i');
        jMenuItem.setName("miInfo");
        jMenuItem.addActionListener(this.infoAction);
        jMenu.add(jMenuItem);
        this.buggyCheckboxMenuItem = new JCheckBoxMenuItem(rb.getString("menu.help.buggy.name"), this.buggyState);
        this.buggyCheckboxMenuItem.setMnemonic(rb.getString("menu.help.buggy.mnemonic").charAt(0));
        this.buggyCheckboxMenuItem.setName("miBuggy");
        this.buggyCheckboxMenuItem.addActionListener(this.buggyAction);
        jMenu.add(this.buggyCheckboxMenuItem);
        this.newVersionCheckboxMenuItem = new JCheckBoxMenuItem(rb.getString("menu.help.newversion.name"), this.newVersionState);
        this.newVersionCheckboxMenuItem.setMnemonic(rb.getString("menu.help.newversion.mnemonic").charAt(0));
        this.newVersionCheckboxMenuItem.setName("miNewVersion");
        this.newVersionCheckboxMenuItem.addActionListener(this.newVersionAction);
        jMenu.add(this.newVersionCheckboxMenuItem);
        this.loadtestCheckboxMenuItem = new JCheckBoxMenuItem(rb.getString("menu.help.loadtest.name"), this.loadtestState);
        this.loadtestCheckboxMenuItem.setMnemonic(rb.getString("menu.help.loadtest.mnemonic").charAt(0));
        this.loadtestCheckboxMenuItem.setName("miLoadtest");
        this.loadtestCheckboxMenuItem.addActionListener(this.loadtestAction);
        jMenu.add(this.loadtestCheckboxMenuItem);
    }

    private void setupActions() {
        this.vehiclesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CarConfigurator.this.newVersionState) {
                    NewVehiclesDialog newVehiclesDialog = new NewVehiclesDialog(CarConfigurator.this.frame);
                } else {
                    VehiclesDialog vehiclesDialog = new VehiclesDialog(CarConfigurator.this.frame);
                }
            }
        };
        this.accessoriesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AccessoryDialog accessoryDialog = new AccessoryDialog(CarConfigurator.this.frame);
            }
        };
        this.specialsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpecialsDialog specialsDialog = new SpecialsDialog(CarConfigurator.this.frame);
            }
        };
        this.viewStatisticsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsDialog statisticsDialog = new StatisticsDialog(CarConfigurator.this.frame);
            }
        };
        this.viewPurchaseOrderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewPurchaseOrderDialog viewPurchaseOrderDialog = new ViewPurchaseOrderDialog(CarConfigurator.this.frame);
            }
        };
        this.sendPurchaseOrderAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendPurchaseOrderDialog sendPurchaseOrderDialog = new SendPurchaseOrderDialog(CarConfigurator.this.frame);
            }
        };
        this.resetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarConfigurator.this.reset();
            }
        };
        this.logoutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarConfigurator.this.logout();
            }
        };
        this.infoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l = System.currentTimeMillis();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                String string = simpleDateFormat.format(l);
                final JDialog jDialog = new JDialog(CarConfigurator.this.frame);
                jDialog.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
                jDialog.setModal(true);
                jDialog.setTitle("Info");
                JButton jButton = new JButton();
                jButton.setText("OK");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jDialog.dispose();
                    }
                });
                jButton.setPreferredSize(new Dimension(80, 30));
                jButton.setSize(80, 30);
                JLabel jLabel = new JLabel();
                jLabel.setIcon(CarConfigurator.this.iconAbout);
                jLabel.setSize(32, 32);
                jLabel.setPreferredSize(new Dimension(32, 32));
                JLabel jLabel2 = new JLabel();
                jLabel2.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;CarConfigurator Swing Version 2.0<br/><br/> &nbsp;&nbsp;&nbsp;&nbsp;Copyright   (C)   2004 - " + string + "<br/>&nbsp;&nbsp;&nbsp;&nbsp;Quality First Software GmbH<br/>&nbsp;&nbsp;&nbsp;&nbsp;Based on C++ implementation by imbus AG<br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;All rights reserved.<br/></html>");
                Grid grid = new Grid();
                grid.add((Component)jLabel);
                grid.add((Component)jLabel2);
                Grid grid2 = new Grid();
                Grid grid3 = new Grid();
                grid3.add((Component)jButton);
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)grid, "Center");
                jDialog.getContentPane().add((Component)grid3, "South");
                jDialog.pack();
                jDialog.setVisible(true);
            }
        };
        this.buggyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarConfigurator.this.buggyState = CarConfigurator.this.buggyCheckboxMenuItem.getState();
            }
        };
        this.newVersionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarConfigurator.this.newVersionState = CarConfigurator.this.newVersionCheckboxMenuItem.getState();
                CarConfigurator.this.switchFrame();
            }
        };
        this.loadtestAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarConfigurator.this.loadtestState = CarConfigurator.this.loadtestCheckboxMenuItem.getState();
            }
        };
    }

    public boolean isStandardUser() {
        return "tester".equals(this.m_user);
    }

    public double calculatePrice(double d, double d2, double d3, int n, int n2, double d4) {
        double d5 = n - n2 > 3 ? 10.0 : 0.0;
        if (n - n2 >= 5) {
            d5 = 15.0;
        }
        if (d4 > d5) {
            d5 = d4;
        }
        double d6 = d / 100.0 * (100.0 - d4) + d2 + d3 / 100.0 * (100.0 - d5);
        return d6;
    }

    public double calculatePriceOk(double d, double d2, double d3, int n, int n2, double d4) {
        if (this.buggyState && d >= 29000.0) {
            d = 0.0;
        }
        double d5 = n - n2 >= 3 ? 10.0 : 0.0;
        if (n - n2 >= 5) {
            d5 = 15.0;
        }
        if (d4 > d5) {
            d5 = d4;
        }
        double d6 = d / 100.0 * (100.0 - d4) + d2 + d3 / 100.0 * (100.0 - d5);
        return d6;
    }

    protected void updateCalculatedPrice() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        if (this.accessoryTablePanel.isPriceIntoAccount()) {
            for (int i = 0; i < this.accessoryTablePanel.model.getRowCount(); ++i) {
                Boolean bl = (Boolean)this.accessoryTablePanel.model.getValueAt(i, 0);
                if (!bl.booleanValue()) continue;
                ++n;
                String string = (String)this.accessoryTablePanel.model.getValueAt(i, 2);
                int n3 = this.findDoubles(string, this.m_special_contained_extras);
                if (n3 > 0) {
                    n2 += n3;
                    continue;
                }
                Double d2 = (Double)this.accessoryTablePanel.model.getValueAt(i, 3);
                d += d2.doubleValue();
            }
        }
        double d3 = this.buggyState ? this.calculatePrice(this.m_baseprice, this.m_specialprice, d, n, n2, this.m_discount) : this.calculatePriceOk(this.m_baseprice, this.m_specialprice, d, n, n2, this.m_discount);
        this.calculatorPanel.setBasePrice(this.m_baseprice);
        this.calculatorPanel.setSpecialsPrice(this.m_specialprice);
        this.calculatorPanel.setCalculatedPrice(d3);
    }

    private int findDoubles(String string, String string2) {
        if (this.buggyState) {
            return 0;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string)) continue;
                ++n;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        return n;
    }

    private void reset() {
        if (this.newVersionState) {
            this.vehicleTablePanel_new.reset();
        } else {
            this.vehicleTablePanel.reset();
        }
        this.accessoryTablePanel.reset();
        this.specialsPanel.reset();
        this.calculatorPanel.reset();
    }

    private void logout() {
        int n;
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
        if ((n = CarLogin.showLogin(this.m_language == 0 ? "de" : "en", this.minimumFontSize, this.x_pos, this.y_pos)) == 1) {
            this.run();
        } else {
            this.exit(0);
        }
    }

    protected void exit(int n) {
        if (this.m_exitOnClose) {
            System.exit(n);
        } else if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    private void sleepForLoadtesting() {
        if (this.loadtestState) {
            Random random = new Random();
            int n = random.nextInt(3000);
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private String getMainFrameTitle() {
        return "CarConfigurator Swing";
    }

    private void initializeData() {
        if (this.newVersionState) {
            if (this.m_language == 0) {
                this.vehicleColumnNames_new = (String[])this.vehicleColumnNames_DE_new.clone();
                this.accessoryCells = (Object[][])this.accessoryCells_DE.clone();
                this.accessoryColumnNames = (String[])this.accessoryColumnNames_DE.clone();
                this.specialsEntries = (Object[][])this.specialsEntries_DE.clone();
                this.specialsColumnNames = (String[])this.specialsColumnNames_DE.clone();
            } else {
                this.vehicleColumnNames_new = (String[])this.vehicleColumnNames_EN_new.clone();
                this.accessoryCells = (Object[][])this.accessoryCells_EN.clone();
                this.accessoryColumnNames = (String[])this.accessoryColumnNames_EN.clone();
                this.specialsEntries = (Object[][])this.specialsEntries_EN.clone();
                this.specialsColumnNames = (String[])this.specialsColumnNames_EN.clone();
            }
        } else if (this.m_language == 0) {
            this.vehicleColumnNames = (String[])this.vehicleColumnNames_DE.clone();
            this.accessoryCells = (Object[][])this.accessoryCells_DE.clone();
            this.accessoryColumnNames = (String[])this.accessoryColumnNames_DE.clone();
            this.specialsEntries = (Object[][])this.specialsEntries_DE.clone();
            this.specialsColumnNames = (String[])this.specialsColumnNames_DE.clone();
        } else {
            this.vehicleColumnNames = (String[])this.vehicleColumnNames_EN.clone();
            this.accessoryCells = (Object[][])this.accessoryCells_EN.clone();
            this.accessoryColumnNames = (String[])this.accessoryColumnNames_EN.clone();
            this.specialsEntries = (Object[][])this.specialsEntries_EN.clone();
            this.specialsColumnNames = (String[])this.specialsColumnNames_EN.clone();
        }
    }

    private void initContents() {
        if (this.newVersionState) {
            this.vehicleTablePanel_new = new NewVehicleTablePanel(rb.getString("panel.vehicles.name"), this.vehicleCells_new, this.vehicleColumnNames_new, this.vehicleColumnMaxWidth_new);
            this.vehicleTablePanel_new.setName("VehicleTablePanel");
        } else {
            this.vehicleTablePanel = new VehicleTablePanel(rb.getString("panel.vehicles.name"), this.vehicleCells, this.vehicleColumnNames, this.vehicleColumnMaxWidth);
            this.vehicleTablePanel.setName("VehicleTablePanel");
        }
        this.accessoryTablePanel = new AccessoryTablePanel(rb.getString("panel.accessories.name"), this.accessoryCells, this.accessoryColumnNames, this.accessoryColumnMaxWidth);
        this.accessoryTablePanel.setName("AccessoryTablePanel");
        this.specialsPanel = new SpecialsPanel(rb.getString("panel.specials.name"), this.specialsEntries);
        this.specialsPanel.setName("SpecialsPanel");
        this.calculatorPanel = new CalculatorPanel(new String(""));
        this.calculatorPanel.setName("CalculatorPanel");
    }

    private JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setName("TabbedPane");
        if (this.newVersionState) {
            jTabbedPane.add(rb.getString("panel.vehicles.name"), this.vehicleTablePanel_new);
        } else {
            jTabbedPane.add(rb.getString("panel.vehicles.name"), this.vehicleTablePanel);
        }
        jTabbedPane.add(rb.getString("panel.specials.name"), this.specialsPanel);
        jTabbedPane.add(rb.getString("panel.accessories.name"), this.accessoryTablePanel);
        return jTabbedPane;
    }

    public CarConfigurator setM_user(String string) {
        this.m_user = string;
        return this;
    }

    public CarConfigurator setBuggyState(boolean bl) {
        this.buggyState = bl;
        return this;
    }

    class Dummy {
        Dummy() {
        }

        public void run() {
        }
    }

    public static class CarLogin {
        public static final int LOGIN_KO = 0;
        public static final int LOGIN_OK = 1;
        public static final int CANCEL = 2;
        protected static int myState = -1;
        protected static JLabel msgLabel;
        protected static JPasswordField pwdField;
        protected static JTextField userField;
        protected static MapResourceBundle rb;
        protected static String currentUser;

        public static int showLogin(String string, final int n, int n2, int n3) {
            String string2;
            Object object;
            block9: {
                rb = new MapResourceBundle();
                String string3 = string;
                if (string3 == null) {
                    string3 = Locale.getDefault().getLanguage();
                }
                if ("de".equalsIgnoreCase(string3)) {
                    rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.GERMANY, CarConfigurator.class);
                } else {
                    rb.fetchProperties("/de/qfs/apps/qftest/demo/multi/resources/properties/carconfig", Locale.US, CarConfigurator.class);
                }
                FontPolicy fontPolicy = new FontPolicy(){

                    public FontSet getFontSet(String string, UIDefaults uIDefaults) {
                        return new DerivedFontSet(FontPolicies.getDefaultPlasticPolicy().getFontSet(string, uIDefaults), n);
                    }
                };
                fontPolicy = FontPolicies.customSettingsPolicy((FontPolicy)fontPolicy);
                PlasticLookAndFeel.setFontPolicy((FontPolicy)fontPolicy);
                try {
                    try {
                        object = new SkyBluer();
                        PlasticLookAndFeel.setPlasticTheme((PlasticTheme)object);
                        if (Misc.OS_IS_WINDOWS) {
                            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                            break block9;
                        }
                        UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
                    }
                    catch (Exception exception) {
                        string2 = UIManager.getSystemLookAndFeelClassName();
                        if (string2.endsWith("MotifLookAndFeel")) {
                            string2 = UIManager.getCrossPlatformLookAndFeelClassName();
                        }
                        UIManager.setLookAndFeel(string2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = new JDialog();
            ((Dialog)object).setTitle(rb.getString("carconfig.login.title"));
            ((Component)object).setName("LoginDialog");
            string2 = new Grid();
            userField = new JTextField("", 10);
            userField.setName("userField");
            JLabel jLabel = new JLabel(rb.getString("carconfig.login.user"));
            jLabel.setLabelFor(userField);
            jLabel.setPreferredSize(new Dimension(80, jLabel.getPreferredSize().height));
            jLabel.setMinimumSize(new Dimension(80, jLabel.getPreferredSize().height));
            pwdField = new JPasswordField("", 10);
            pwdField.setName("pwdField");
            JLabel jLabel2 = new JLabel(rb.getString("carconfig.login.password"));
            jLabel2.setLabelFor(pwdField);
            jLabel2.setPreferredSize(new Dimension(80, jLabel2.getPreferredSize().height));
            jLabel2.setMinimumSize(new Dimension(80, jLabel2.getPreferredSize().height));
            msgLabel = new JLabel();
            msgLabel.setText(rb.getString("carconfig.login.loginsteps"));
            JButton jButton = new JButton();
            jButton.setName("loginBtn");
            jButton.setText(rb.getString("carconfig.login.login"));
            jButton.addActionListener(new ActionListener((JDialog)object){
                final /* synthetic */ JDialog val$dlg;
                {
                    this.val$dlg = jDialog;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    currentUser = userField.getText();
                    String string = pwdField.getText();
                    if ("tester".equals(currentUser) && "tester".equals(string)) {
                        CarLogin.setState(1);
                        this.val$dlg.dispose();
                    } else if ("user".equals(currentUser) && "user".equals(string)) {
                        CarLogin.setState(1);
                        this.val$dlg.dispose();
                    } else {
                        CarLogin.setState(0);
                        CarLogin.setLoginFailedMsg();
                    }
                }
            });
            JButton jButton2 = new JButton();
            jButton2.setName("cancelBtn");
            jButton2.setText(rb.getString("carconfig.login.cancel"));
            jButton2.addActionListener(new ActionListener((JDialog)object){
                final /* synthetic */ JDialog val$dlg;
                {
                    this.val$dlg = jDialog;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CarLogin.setState(2);
                    this.val$dlg.dispose();
                }
            });
            string2.addLine(new Component[]{jLabel, userField});
            string2.addLine(new Component[]{jLabel2, pwdField});
            string2.addLine(new Component[]{msgLabel});
            string2.addLine(new Component[]{jButton, jButton2});
            string2.addGlue();
            ((JDialog)object).getContentPane().add((Component)((Object)string2));
            ((Window)object).pack();
            ((Dialog)object).setModal(true);
            ((Dialog)object).setVisible(true);
            ((Window)object).setLocation(n2, n3);
            return myState;
        }

        public static void setLoginFailedMsg() {
            msgLabel.setText(rb.getString("carconfig.login.loginfailed"));
            pwdField.setText("");
            userField.setText("");
        }

        public static void setState(int n) {
            myState = n;
        }

        static {
            currentUser = "tester";
        }
    }

    private static class CarSplash
    extends Canvas
    implements ImageObserver {
        private static final int FONT_SIZE = 13;
        private static final int VFONT_SIZE = 15;
        private static final int BORDER_DIST_X = 32;
        private static final int BORDER_DIST_Y = 54;
        private static final int VERSION_X = 300;
        private static final int VERSION_Y = 136;
        private static Color qfsBlue = new Color(20, 40, 110);
        private Image image;
        private String message;
        private Font font;
        private Font vfont;
        int x;
        int y;
        int w;
        int h;
        int vw;
        int vh;
        Image buffer;
        Image vbuffer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CarSplash(Image image) {
            this.image = image;
            if (!this.prepareImage(image, -1, -1, this)) {
                CarSplash carSplash = this;
                synchronized (carSplash) {
                    int n;
                    long l = System.currentTimeMillis() + 2000L;
                    while (((n = this.checkImage(image, null)) & 0xE0) == 0) {
                        try {
                            this.wait(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() <= l) continue;
                        break;
                    }
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.image == null) {
                return;
            }
            graphics.drawImage(this.image, 0, 0, this);
            this.paintVersion(graphics);
            this.paintMessage(graphics);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0xE0) != 0) {
                CarSplash carSplash = this;
                synchronized (carSplash) {
                    this.notifyAll();
                }
                return false;
            }
            return true;
        }

        public void setMessage(String string) {
            this.message = string;
            Graphics graphics = this.getGraphics();
            this.paintMessage(graphics);
        }

        public void setImage(Image image) {
            this.image = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintVersion(Graphics graphics) {
            CarSplash carSplash = this;
            synchronized (carSplash) {
                if (this.vfont == null) {
                    String string = "CarConfigurator Swing";
                    this.vfont = new Font("Verdana", 0, 15);
                    this.vw = graphics.getFontMetrics(this.vfont).stringWidth(string);
                    this.vh = graphics.getFontMetrics(this.vfont).getHeight();
                    this.vbuffer = this.createImage(this.vw, this.vh);
                    Graphics graphics2 = this.vbuffer.getGraphics();
                    try {
                        boolean bl = graphics2.drawImage(this.image, 0, 0, this.vw, this.vh, 300 - this.vw, 136, 300, 136 + this.vh, this);
                        if (!bl) {
                            try {
                                this.wait(2000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    graphics2.setColor(qfsBlue);
                    graphics2.setFont(this.vfont);
                    graphics2.drawString(string, 0, this.vh - graphics2.getFontMetrics().getDescent());
                }
            }
            if (this.vbuffer == null) {
                return;
            }
            try {
                graphics.drawImage(this.vbuffer, 300 - this.vw, 136, this);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintMessage(Graphics graphics) {
            Object object = this;
            synchronized (object) {
                if (this.font == null) {
                    this.font = new Font("Verdana", 0, 13);
                    this.w = 268;
                    this.h = graphics.getFontMetrics(this.font).getHeight() + 3;
                    this.x = 32;
                    this.y = 175 - this.h / 2;
                }
                if (this.buffer == null) {
                    this.buffer = this.createImage(this.w, this.h);
                }
            }
            if (this.buffer == null) {
                return;
            }
            try {
                object = this.buffer.getGraphics();
                boolean bl = ((Graphics)object).drawImage(this.image, 0, 0, this.w, this.h, this.x, this.y, this.x + this.w, this.y + this.h, this);
                if (!bl) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ((Graphics)object).setFont(this.font);
                ((Graphics)object).setColor(qfsBlue);
                if (this.message != null) {
                    int n = ((Graphics)object).getFontMetrics().stringWidth(this.message);
                    ((Graphics)object).drawString(this.message, Math.max(1, this.w - n), this.h - 2 - ((Graphics)object).getFontMetrics().getDescent());
                }
                graphics.drawImage(this.buffer, this.x, this.y, this);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class CarSplashWindow
    extends Window {
        private static final int WIDTH = 460;
        private static final int HEIGHT = 229;
        private static final String IMAGE = "/de/qfs/apps/qftest/demo/multi/resources/icons/splash";
        private CarSplash carsplash;
        private static CarSplashWindow instance;
        private static final Object lock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final CarSplashWindow instance() {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    if (EventQueue.isDispatchThread()) {
                        instance = new CarSplashWindow();
                    } else {
                        try {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    instance = new CarSplashWindow();
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.getTargetException().printStackTrace();
                        }
                    }
                }
            }
            return instance;
        }

        @Override
        public void dispose() {
            instance = null;
            super.dispose();
        }

        public CarSplashWindow() {
            super(new Frame());
            this.setSize(460, 229);
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Point point = graphicsEnvironment.getCenterPoint();
            this.setLocation(point.x - 230, point.y - 114);
            String string = System.getProperty("user.language");
            if (string == null || string.length() == 0) {
                string = Locale.getDefault().getLanguage();
            }
            Image image = this.getToolkit().getImage(this.getClass().getResource(IMAGE + ("de".equalsIgnoreCase(string) ? "_de" : "") + ".png"));
            this.carsplash = new CarSplash(image);
            this.carsplash.setSize(460, 229);
            this.add(this.carsplash);
        }

        static {
            lock = new Object();
        }
    }

    public static class DerivedFontSet
    implements FontSet {
        public int minimumSize = -1;
        private FontSet parent;
        private FontUIResource controlFont;
        private FontUIResource menuFont;
        private FontUIResource titleFont;
        private FontUIResource windowTitleFont;
        private FontUIResource smallFont;
        private FontUIResource messageFont;

        public DerivedFontSet(FontSet fontSet, int n) {
            this.parent = fontSet;
            this.minimumSize = n;
        }

        public FontUIResource getControlFont() {
            if (this.controlFont == null) {
                FontUIResource fontUIResource = this.parent.getControlFont();
                this.controlFont = fontUIResource.getSize() >= this.minimumSize ? fontUIResource : new FontUIResource(fontUIResource.getFamily(), fontUIResource.getStyle(), this.minimumSize);
            }
            return this.controlFont;
        }

        public FontUIResource getMenuFont() {
            if (this.menuFont == null) {
                FontUIResource fontUIResource = this.parent.getMenuFont();
                this.menuFont = fontUIResource.getSize() >= this.minimumSize ? fontUIResource : new FontUIResource(fontUIResource.getFamily(), fontUIResource.getStyle(), this.minimumSize);
            }
            return this.menuFont;
        }

        public FontUIResource getTitleFont() {
            if (this.titleFont == null) {
                FontUIResource fontUIResource = this.parent.getTitleFont();
                this.titleFont = fontUIResource.getSize() >= this.minimumSize ? fontUIResource : new FontUIResource(fontUIResource.getFamily(), fontUIResource.getStyle(), this.minimumSize);
            }
            return this.titleFont;
        }

        public FontUIResource getWindowTitleFont() {
            if (this.windowTitleFont == null) {
                FontUIResource fontUIResource = this.parent.getWindowTitleFont();
                this.windowTitleFont = fontUIResource.getSize() >= this.minimumSize ? fontUIResource : new FontUIResource(fontUIResource.getFamily(), fontUIResource.getStyle(), this.minimumSize);
            }
            return this.windowTitleFont;
        }

        public FontUIResource getSmallFont() {
            if (this.smallFont == null) {
                FontUIResource fontUIResource = this.parent.getSmallFont();
                this.smallFont = fontUIResource.getSize() >= this.minimumSize ? fontUIResource : new FontUIResource(fontUIResource.getFamily(), fontUIResource.getStyle(), this.minimumSize);
            }
            return this.smallFont;
        }

        public FontUIResource getMessageFont() {
            if (this.messageFont == null) {
                FontUIResource fontUIResource = this.parent.getMessageFont();
                this.messageFont = fontUIResource.getSize() >= this.minimumSize ? fontUIResource : new FontUIResource(fontUIResource.getFamily(), fontUIResource.getStyle(), this.minimumSize);
            }
            return this.messageFont;
        }
    }

    public static interface ChangeButtonActions {
        public void newActionPerformed();

        public void changeActionPerformed();

        public void deleteActionPerformed();

        public void cancelActionPerformed();

        public void confirmActionPerformed();
    }

    public static interface TablePanelReset {
        public void reset();
    }

    class ChangeButtonPanel
    extends JPanel {
        OptionDialog parentOptionDialog;
        private AbstractAction newAction;
        private AbstractAction changeAction;
        private AbstractAction deleteAction;
        private AbstractAction cancelAction;
        private AbstractAction confirmAction;
        private AbstractAction detailsAction;
        private AbstractAction overviewAction;

        public ChangeButtonPanel(OptionDialog optionDialog) {
            this.parentOptionDialog = optionDialog;
            this.setName("changeButtonPanel");
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            GridLayout gridLayout = new GridLayout(this.parentOptionDialog.detailsRequired ? 5 : 3, 1);
            gridLayout.setHgap(20);
            jPanel.setLayout(gridLayout);
            this.setupActions();
            JButton jButton = new JButton(rb.getString("button.new"));
            jButton.setName("NewButton");
            jButton.setSize(80, 30);
            jButton.addActionListener(this.newAction);
            jPanel.add(jButton);
            jButton = new JButton(rb.getString("button.change"));
            jButton.setName("ChangeButton");
            jButton.addActionListener(this.changeAction);
            jPanel.add(jButton);
            jButton = new JButton(rb.getString("button.delete"));
            jButton.setName("DeleteButton");
            jButton.addActionListener(this.deleteAction);
            jPanel.add(jButton);
            if (this.parentOptionDialog.detailsRequired) {
                jButton = new JButton(rb.getString("button.details"));
                jButton.setName("DetailsButton");
                jButton.addActionListener(this.detailsAction);
                jPanel.add(jButton);
                jButton = new JButton(rb.getString("button.overview"));
                jButton.setName("OverviewButton");
                jButton.addActionListener(this.overviewAction);
                jPanel.add(jButton);
            }
            this.add((Component)jPanel, "North");
            jPanel = new JPanel();
            this.add((Component)jPanel, "Center");
            jPanel = new JPanel();
            gridLayout = new GridLayout(2, 1);
            gridLayout.setHgap(20);
            jPanel.setLayout(gridLayout);
            jButton = new JButton(rb.getString("button.cancel"));
            jButton.setName("CancelButton");
            jButton.addActionListener(this.cancelAction);
            jPanel.add(jButton);
            jButton = new JButton(rb.getString("button.ok"));
            jButton.setName("OkButton");
            jButton.addActionListener(this.confirmAction);
            jPanel.add(jButton);
            this.add((Component)jPanel, "South");
        }

        private void setupActions() {
            this.newAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChangeButtonPanel.this.parentOptionDialog.newActionPerformed();
                }
            };
            this.changeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChangeButtonPanel.this.parentOptionDialog.changeActionPerformed();
                }
            };
            this.deleteAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChangeButtonPanel.this.parentOptionDialog.deleteActionPerformed();
                }
            };
            this.cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChangeButtonPanel.this.parentOptionDialog.cancelActionPerformed();
                }
            };
            this.confirmAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChangeButtonPanel.this.parentOptionDialog.confirmActionPerformed();
                }
            };
            this.detailsAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChangeButtonPanel.this.parentOptionDialog.detailsActionPerformed();
                }
            };
            this.overviewAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChangeButtonPanel.this.parentOptionDialog.overviewActionPerformed();
                }
            };
        }
    }

    abstract class OptionDialog
    extends JDialog
    implements ChangeButtonActions {
        public boolean detailsRequired;

        public OptionDialog(JFrame jFrame, boolean bl) {
            super(jFrame);
            this.detailsRequired = false;
            this.detailsRequired = bl;
        }

        @Override
        public abstract void newActionPerformed();

        @Override
        public abstract void changeActionPerformed();

        @Override
        public abstract void deleteActionPerformed();

        @Override
        public abstract void cancelActionPerformed();

        @Override
        public abstract void confirmActionPerformed();

        public abstract void detailsActionPerformed();

        public abstract void overviewActionPerformed();
    }

    abstract class AbstractTablePanel
    extends JPanel
    implements ListSelectionListener {
        DefaultTableModel model;
        SortFilterModel sorter;
        JTable table;

        public AbstractTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray, String string2) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
            this.setLayout(this.getPanelLayout());
            this.model = new DefaultTableModel(objectArray, stringArray);
            this.sorter = new SortFilterModel(this.model);
            this.table = new JTable(this.sorter);
            this.table.setName(string2 + "Table");
            this.table.setShowGrid(false);
            this.table.setSelectionMode(0);
            this.table.setDefaultRenderer(Double.class, new DoubleTableCellRenderer());
            JScrollPane jScrollPane = new JScrollPane(this.table);
            if (!CarConfigurator.this.cleanNames) {
                jScrollPane.setName(string2 + "ScrollPane");
            }
            jScrollPane.getViewport().setBackground(Color.WHITE);
            this.add(jScrollPane);
            this.setTableLayout(stringArray, integerArray);
            this.sorter.addMouseListener(this.table);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.model.addTableModelListener(this.table);
        }

        protected LayoutManager getPanelLayout() {
            return new BoxLayout(this, 1);
        }

        public DefaultTableModel getModel() {
            return this.model;
        }

        public TableModel getSorter() {
            return this.sorter;
        }

        void setTableLayout(String[] stringArray, Integer[] integerArray) {
            TableColumn tableColumn;
            int n;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            for (n = 0; n < integerArray.length; ++n) {
                if (integerArray[n] <= 0) continue;
                tableColumn = tableColumnModel.getColumn(n);
                tableColumn.setMaxWidth(integerArray[n]);
                if (integerArray[n] <= 0) continue;
                tableColumn.setPreferredWidth(integerArray[n]);
            }
            for (n = stringArray.length - 1; n >= 0; --n) {
                if (!stringArray[n].equals("Hide")) continue;
                tableColumn = tableColumnModel.getColumn(n);
                this.table.removeColumn(tableColumn);
            }
        }

        private void reset() {
            this.table.clearSelection();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }

        private class DoubleTableCellRenderer
        extends DefaultTableCellRenderer {
            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setText(CarConfigurator.this.m_currencyFormatter.format(Double.valueOf(jLabel.getText())));
                jLabel.setHorizontalAlignment(11);
                return jLabel;
            }
        }
    }

    public class SortFilterModel
    extends AbstractTableModel {
        private TableModel model;
        private int sortColumn;
        private Row[] rows;

        public SortFilterModel(TableModel tableModel) {
            this.model = tableModel;
            this.updateData();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.model.getValueAt(this.rows[n].index, n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.getColumnClass(n2) == Boolean.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.model.setValueAt(object, this.rows[n].index, n2);
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int n) {
            return this.model.getValueAt(0, n).getClass();
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.model.getColumnName(n);
        }

        private void updateData() {
            this.rows = new Row[this.model.getRowCount()];
            for (int i = 0; i < this.rows.length; ++i) {
                this.rows[i] = new Row();
                this.rows[i].index = i;
            }
        }

        void tableChanged() {
            this.updateData();
            this.fireTableDataChanged();
        }

        public void sort(int n) {
            this.sortColumn = n;
            Arrays.sort(this.rows);
            this.fireTableDataChanged();
        }

        public void addMouseListener(final JTable jTable) {
            jTable.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        return;
                    }
                    if (jTable.getModel().getRowCount() > 1) {
                        int n = jTable.columnAtPoint(mouseEvent.getPoint());
                        int n2 = jTable.convertColumnIndexToModel(n);
                        SortFilterModel.this.sort(n2);
                    }
                }
            });
        }

        private class Row
        implements Comparable {
            public int index;

            private Row() {
            }

            public int compareTo(Object object) {
                Row row = (Row)object;
                Object object2 = SortFilterModel.this.model.getValueAt(this.index, SortFilterModel.this.sortColumn);
                Object object3 = SortFilterModel.this.model.getValueAt(row.index, SortFilterModel.this.sortColumn);
                if (object2 instanceof Comparable) {
                    return ((Comparable)object2).compareTo(object3);
                }
                return this.index - row.index;
            }
        }
    }

    class StatisticsDialog
    extends JDialog {
        private AbstractAction okAction;

        public StatisticsDialog(JFrame jFrame) {
            Object object;
            super(jFrame);
            this.setModal(true);
            this.setSize(640, 400);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            VehicleTablePanel vehicleTablePanel = CarConfigurator.this.vehicleTablePanel;
            int n = vehicleTablePanel.table.getSelectedRow();
            String string = "--";
            if (n != -1 && (object = vehicleTablePanel.table.getValueAt(n, 0)) != null) {
                string = (String)object;
            }
            this.setTitle(rb.getString("dialog.statistics.name") + " - " + string);
            object = this.getContentPane();
            BorderLayout borderLayout = new BorderLayout();
            ((Container)object).setLayout(borderLayout);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = this.initializeVehiclesPanel();
            JPanel jPanel3 = this.initializeButtonPanel();
            JScrollPane jScrollPane = this.initializeTableData(string);
            Box box = Box.createVerticalBox();
            box.add(jPanel2);
            box.add(jScrollPane);
            jPanel.add(box);
            ((Container)object).add((Component)jPanel, "Center");
            ((Container)object).add((Component)jPanel3, "South");
            this.pack();
            CarConfigurator.this.sleepForLoadtesting();
            this.setVisible(true);
        }

        public void okActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        private JPanel initializeButtonPanel() {
            this.setupActions();
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton();
            jButton.setText(rb.getString("button.ok"));
            jButton.setName("OKButton");
            jButton.addActionListener(this.okAction);
            jButton.setSize(80, 30);
            jPanel.add(jButton);
            return jPanel;
        }

        private JScrollPane initializeTableData(String string) {
            Calendar calendar = Calendar.getInstance();
            int n = calendar.get(3);
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
            if ("Minigolf".equals(string)) {
                arrayList.add(new Object[]{n, 10});
                arrayList.add(new Object[]{n - 1, 32});
                arrayList.add(new Object[]{n - 2, 12});
                arrayList.add(new Object[]{n - 3, 2});
                arrayList.add(new Object[]{n - 4, 21});
                arrayList.add(new Object[]{n - 5, 12});
            } else if ("Rolo".equals(string)) {
                arrayList.add(new Object[]{n, 3});
                arrayList.add(new Object[]{n - 1, 8});
            } else if ("I5".equals(string)) {
                arrayList.add(new Object[]{n, 3});
                arrayList.add(new Object[]{n - 1, 12});
                arrayList.add(new Object[]{n - 2, 0});
                arrayList.add(new Object[]{n - 3, 19});
            } else if ("Rassant".equals(string)) {
                arrayList.add(new Object[]{n, 8});
                arrayList.add(new Object[]{n - 1, 2});
                arrayList.add(new Object[]{n - 2, 22});
                arrayList.add(new Object[]{n - 3, 4});
                arrayList.add(new Object[]{n - 4, 6});
                arrayList.add(new Object[]{n - 5, 15});
            } else if ("Rassant Family".equals(string)) {
                arrayList.add(new Object[]{n, 1});
                arrayList.add(new Object[]{n - 1, 13});
                arrayList.add(new Object[]{n - 2, 5});
                arrayList.add(new Object[]{n - 3, 27});
                arrayList.add(new Object[]{n - 4, 11});
            } else {
                arrayList.add(new Object[]{n, 0});
            }
            Object[][] objectArray = new Object[arrayList.size()][2];
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray[i] = (Object[])arrayList.get(i);
            }
            DefaultTableModel defaultTableModel = null;
            defaultTableModel = CarConfigurator.this.m_language == 0 ? new DefaultTableModel(objectArray, CarConfigurator.this.statisticsColumnNames_DE) : new DefaultTableModel(objectArray, CarConfigurator.this.statisticsColumnNames_EN);
            JTable jTable = new JTable(defaultTableModel);
            jTable.setShowGrid(false);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.getViewport().setBackground(Color.WHITE);
            int n2 = jTable.getRowCount();
            int n3 = jTable.getRowHeight();
            Dimension dimension = jScrollPane.getPreferredSize();
            double d = dimension.getWidth();
            int n4 = Double.valueOf(d).intValue();
            jScrollPane.setPreferredSize(new Dimension(n4, (n2 + 2) * n3));
            return jScrollPane;
        }

        private JPanel initializeVehiclesPanel() {
            Random random = new Random();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            JTextField jTextField = new JTextField(15);
            VehicleTablePanel vehicleTablePanel = CarConfigurator.this.vehicleTablePanel;
            if (CarConfigurator.this.newVersionState) {
                vehicleTablePanel = CarConfigurator.this.vehicleTablePanel_new;
            }
            int n = vehicleTablePanel.table.getSelectedRow();
            String string = "";
            if (n != -1) {
                Object object = vehicleTablePanel.table.getValueAt(n, 0);
                if (object != null) {
                    string = (String)object;
                }
            } else {
                string = rb.getString("error.purchaseorder.novehicle");
            }
            jLabel.setText(rb.getString("dialog.purchaseorder.vehicle.label"));
            jLabel.setName("SelectedModelLbl" + random.nextInt());
            jTextField.setEditable(false);
            jTextField.setText(string);
            jTextField.setName("SelectedModelTxtFld" + random.nextInt());
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            return jPanel;
        }

        private void setupActions() {
            this.okAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatisticsDialog.this.okActionPerformed();
                }
            };
        }
    }

    class ViewPurchaseOrderDialog
    extends JDialog {
        private AbstractAction okAction;

        public ViewPurchaseOrderDialog(JFrame jFrame) {
            super(jFrame);
            this.setName("ViewPurchaseOrderDialog");
            this.setTitle(rb.getString("dialog.viewpurchaseorder.name"));
            this.setModal(true);
            this.setSize(640, 400);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            Container container = this.getContentPane();
            BorderLayout borderLayout = new BorderLayout();
            container.setLayout(borderLayout);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = this.initializeAccessoryPanel();
            JPanel jPanel3 = this.initializeSpecialsPanel();
            JPanel jPanel4 = this.initializeVehiclesPanel();
            JPanel jPanel5 = this.initializePricePanel();
            JPanel jPanel6 = this.initializeButtonPanel();
            Box box = Box.createVerticalBox();
            box.add(jPanel4);
            box.add(jPanel3);
            box.add(jPanel2);
            box.add(jPanel5);
            jPanel.add(box);
            if (CarConfigurator.this.cleanNames) {
                jPanel.setName("ViewPurchaseOrderPanel");
            }
            container.add((Component)jPanel, "Center");
            container.add((Component)jPanel6, "South");
            this.pack();
            CarConfigurator.this.sleepForLoadtesting();
            this.setVisible(true);
        }

        public void okActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        private JPanel initializeButtonPanel() {
            this.setupActions();
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton();
            jButton.setText(rb.getString("button.ok"));
            jButton.setName("OKButton");
            jButton.addActionListener(this.okAction);
            jButton.setSize(80, 30);
            jPanel.add(jButton);
            return jPanel;
        }

        private JPanel initializeSpecialsPanel() {
            Random random = new Random();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(rb.getString("dialog.purchaseorder.special.label"));
            jLabel.setName("SelectedSpecialLbl" + random.nextInt());
            JTextField jTextField = new JTextField(15);
            jTextField.setName("SelectedSpecialTxtFld" + random.nextInt());
            jTextField.setText((String)CarConfigurator.this.specialsPanel.specialsCombo.getSelectedItem());
            jTextField.setEditable(false);
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.special.title"));
            jPanel.setBorder(titledBorder);
            return jPanel;
        }

        private JPanel initializePricePanel() {
            Random random = new Random();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(rb.getString("dialog.purchaseorder.price.label"));
            jLabel.setName("CalculatedPriceLbl" + random.nextInt());
            JTextField jTextField = new JTextField(15);
            jTextField.setText(((CarConfigurator)CarConfigurator.this).calculatorPanel.calculatedPrice.getText());
            jTextField.setEditable(false);
            jTextField.setName("CalculatedPriceTxtFld" + random.nextInt());
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.price.title"));
            jPanel.setBorder(titledBorder);
            return jPanel;
        }

        private JPanel initializeVehiclesPanel() {
            Object object;
            Random random = new Random();
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            JTextField jTextField = new JTextField(15);
            VehicleTablePanel vehicleTablePanel = CarConfigurator.this.vehicleTablePanel;
            if (CarConfigurator.this.newVersionState) {
                vehicleTablePanel = CarConfigurator.this.vehicleTablePanel_new;
            }
            int n = vehicleTablePanel.table.getSelectedRow();
            String string = "";
            if (n != -1) {
                object = vehicleTablePanel.table.getValueAt(n, 0);
                if (object != null) {
                    string = (String)object;
                }
            } else {
                string = rb.getString("error.purchaseorder.novehicle");
            }
            jLabel.setText(rb.getString("dialog.purchaseorder.vehicle.label"));
            jLabel.setName("SelectedModelLbl" + random.nextInt());
            jTextField.setEditable(false);
            jTextField.setText(string);
            jTextField.setName("SelectedModelTxtFld" + random.nextInt());
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            object = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.vehicle.title"));
            jPanel.setBorder((Border)object);
            return jPanel;
        }

        private JPanel initializeAccessoryPanel() {
            JPanel jPanel = new JPanel();
            Box box = Box.createVerticalBox();
            int n = 0;
            for (int i = 0; i < ((CarConfigurator)CarConfigurator.this).accessoryTablePanel.model.getRowCount(); ++i) {
                Boolean bl = (Boolean)((CarConfigurator)CarConfigurator.this).accessoryTablePanel.model.getValueAt(i, 0);
                if (!bl.booleanValue()) continue;
                ++n;
                String string = (String)((CarConfigurator)CarConfigurator.this).accessoryTablePanel.model.getValueAt(i, 1);
                int n2 = CarConfigurator.this.findDoubles(string, CarConfigurator.this.m_special_contained_extras);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(1, 2));
                JTextField jTextField = new JTextField();
                JLabel jLabel = new JLabel();
                jLabel.setText(rb.getString("dialog.purchaseorder.accessory.label") + " " + n);
                jLabel.setName("label_" + string);
                jTextField.setName("name_" + string);
                jTextField.setEditable(false);
                jTextField.setText(string);
                jPanel2.add(jLabel);
                jPanel2.add(jTextField);
                box.add(jPanel2);
            }
            if (n == 0) {
                box.add(new JLabel(rb.getString("error.purchaseorder.noaccessory")));
            }
            TitledBorder titledBorder = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.accessory.title"));
            jPanel.setBorder(titledBorder);
            jPanel.add(box);
            return jPanel;
        }

        private void setupActions() {
            this.okAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ViewPurchaseOrderDialog.this.okActionPerformed();
                }
            };
        }
    }

    class SendPurchaseOrderDialog
    extends JDialog {
        private AbstractAction cancelAction;
        private AbstractAction sendOrderAction;
        private JTextField surnameField;
        private JTextField firstnameField;
        private JTextField streetField;
        private JTextField emailAddressField;
        private JTextField zipCodeField;
        private JTextField cityField;
        private JTextField countryField;
        private JTextField phonenumberField;

        public SendPurchaseOrderDialog(JFrame jFrame) {
            super(jFrame);
            this.surnameField = new JTextField();
            this.firstnameField = new JTextField();
            this.streetField = new JTextField();
            this.emailAddressField = new JTextField();
            this.zipCodeField = new JTextField();
            this.cityField = new JTextField();
            this.countryField = new JTextField();
            this.phonenumberField = new JTextField();
            this.setName("SendPurchaseOrderDialog");
            this.setTitle(rb.getString("dialog.purchaseorder.name"));
            this.setModal(true);
            this.setSize(640, 400);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            Container container = this.getContentPane();
            BorderLayout borderLayout = new BorderLayout();
            container.setLayout(borderLayout);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = this.initializeAccessoryPanel();
            JPanel jPanel3 = this.initializeSpecialsPanel();
            JPanel jPanel4 = this.initializeVehiclesPanel();
            JPanel jPanel5 = this.initializePricePanel();
            JPanel jPanel6 = this.initializeAddressPanel();
            JPanel jPanel7 = this.initializeButtonPanel();
            Box box = Box.createVerticalBox();
            box.add(jPanel4);
            box.add(jPanel3);
            box.add(jPanel2);
            box.add(jPanel5);
            box.add(jPanel6);
            jPanel.add(box);
            if (CarConfigurator.this.cleanNames) {
                jPanel.setName("SendPurchaseOrderPanel");
            }
            container.add((Component)jPanel, "Center");
            container.add((Component)jPanel7, "South");
            this.pack();
            CarConfigurator.this.sleepForLoadtesting();
            this.show();
        }

        public void cancelActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendOrderActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            if (Misc.emptyOrNull((String)this.surnameField.getText()) || Misc.emptyOrNull((String)this.firstnameField.getText()) || Misc.emptyOrNull((String)this.streetField.getText()) || Misc.emptyOrNull((String)this.emailAddressField.getText()) || Misc.emptyOrNull((String)this.zipCodeField.getText()) || Misc.emptyOrNull((String)this.cityField.getText()) || Misc.emptyOrNull((String)this.countryField.getText()) || Misc.emptyOrNull((String)this.phonenumberField.getText())) {
                JOptionPane.showMessageDialog(this, rb.getString("error.purchaseorder.nodetails"), "Error", 0);
            } else {
                Writer writer = null;
                File file = new File("order.xml");
                try {
                    Date date = new Date(System.currentTimeMillis());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                    writer = new PrintWriter(file, "UTF8");
                    writer.write("<order date=\"order_" + simpleDateFormat.format(date) + "\">\n");
                    writer.write("<surname value=\"" + this.surnameField.getText() + "\"/>\n");
                    writer.write("<firstname value=\"" + this.firstnameField.getText() + "\"/>\n");
                    writer.write("<streetaddress value=\"" + this.streetField.getText() + "\"/>\n");
                    writer.write("<zipcode value=\"" + this.zipCodeField.getText() + "\"/>\n");
                    writer.write("<city value=\"" + this.cityField.getText() + "\"/>\n");
                    writer.write("<country value=\"" + this.countryField.getText() + "\"/>\n");
                    writer.write("<phone value=\"" + this.phonenumberField.getText() + "\"/>\n");
                    writer.write("<email value=\"" + this.emailAddressField.getText() + "\"/>\n");
                    writer.write("</order>");
                }
                catch (Exception exception) {
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                JOptionPane.showMessageDialog(this, rb.getString("message.purchaseorder.success") + "\n '" + file.getAbsolutePath() + "' .", rb.getString("dialog.purchasesuccess.name"), -1);
                CarConfigurator.this.sleepForLoadtesting();
                this.dispose();
            }
        }

        private JPanel initializeButtonPanel() {
            this.setupActions();
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton();
            JButton jButton2 = new JButton();
            jButton.setText(rb.getString("button.sendorder"));
            jButton2.setText(rb.getString("button.cancel"));
            jButton.setName("SendOrderButton");
            jButton2.setName("CancelButton");
            jButton.addActionListener(this.sendOrderAction);
            jButton2.addActionListener(this.cancelAction);
            jButton.setSize(80, 30);
            jButton2.setSize(80, 30);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            return jPanel;
        }

        private JPanel initializeAddressPanel() {
            JPanel jPanel = new JPanel();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.contact.title"));
            jPanel.setBorder(titledBorder);
            jPanel.setLayout(new GridLayout(8, 2));
            JLabel jLabel = new JLabel(rb.getString("dialog.purchaseorder.contact.surname"));
            JLabel jLabel2 = new JLabel(rb.getString("dialog.purchaseorder.contact.firstname"));
            JLabel jLabel3 = new JLabel(rb.getString("dialog.purchaseorder.contact.street"));
            JLabel jLabel4 = new JLabel(rb.getString("dialog.purchaseorder.contact.zip"));
            JLabel jLabel5 = new JLabel(rb.getString("dialog.purchaseorder.contact.city"));
            JLabel jLabel6 = new JLabel(rb.getString("dialog.purchaseorder.contact.country"));
            JLabel jLabel7 = new JLabel(rb.getString("dialog.purchaseorder.contact.phone"));
            JLabel jLabel8 = new JLabel(rb.getString("dialog.purchaseorder.contact.mail"));
            this.surnameField = new JTextField();
            this.firstnameField = new JTextField();
            this.streetField = new JTextField();
            this.zipCodeField = new JTextField();
            this.cityField = new JTextField();
            this.countryField = new JTextField();
            this.phonenumberField = new JTextField();
            this.emailAddressField = new JTextField();
            this.surnameField.setName("surname");
            this.firstnameField.setName("firstname");
            this.streetField.setName("address");
            this.zipCodeField.setName("zipcode");
            this.cityField.setName("city");
            this.countryField.setName("country");
            this.phonenumberField.setName("number");
            this.emailAddressField.setName("address");
            jPanel.add(jLabel);
            jPanel.add(this.surnameField);
            jPanel.add(jLabel2);
            jPanel.add(this.firstnameField);
            jPanel.add(jLabel3);
            jPanel.add(this.streetField);
            jPanel.add(jLabel4);
            jPanel.add(this.zipCodeField);
            jPanel.add(jLabel5);
            jPanel.add(this.cityField);
            jPanel.add(jLabel6);
            jPanel.add(this.countryField);
            jPanel.add(jLabel7);
            jPanel.add(this.phonenumberField);
            jPanel.add(jLabel8);
            jPanel.add(this.emailAddressField);
            return jPanel;
        }

        private JPanel initializeSpecialsPanel() {
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(rb.getString("dialog.purchaseorder.special.label"));
            JTextField jTextField = new JTextField(15);
            jTextField.setText((String)CarConfigurator.this.specialsPanel.specialsCombo.getSelectedItem());
            jTextField.setEditable(false);
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.special.title"));
            jPanel.setBorder(titledBorder);
            return jPanel;
        }

        private JPanel initializePricePanel() {
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(rb.getString("dialog.purchaseorder.price.label"));
            JTextField jTextField = new JTextField(15);
            jTextField.setText(((CarConfigurator)CarConfigurator.this).calculatorPanel.calculatedPrice.getText());
            jTextField.setEditable(false);
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.price.title"));
            jPanel.setBorder(titledBorder);
            return jPanel;
        }

        private JPanel initializeVehiclesPanel() {
            Object object;
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            JTextField jTextField = new JTextField(15);
            VehicleTablePanel vehicleTablePanel = CarConfigurator.this.vehicleTablePanel;
            if (CarConfigurator.this.newVersionState) {
                vehicleTablePanel = CarConfigurator.this.vehicleTablePanel_new;
            }
            int n = vehicleTablePanel.table.getSelectedRow();
            String string = "";
            if (n != -1) {
                object = vehicleTablePanel.table.getValueAt(n, 0);
                if (object != null) {
                    string = (String)object;
                }
            } else {
                string = rb.getString("error.purchaseorder.novehicle");
            }
            jLabel.setText(rb.getString("dialog.purchaseorder.vehicle.label"));
            jTextField.setEditable(false);
            jTextField.setText(string);
            jPanel.add(jLabel);
            jPanel.add(jTextField);
            object = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.vehicle.title"));
            jPanel.setBorder((Border)object);
            return jPanel;
        }

        private JPanel initializeAccessoryPanel() {
            JPanel jPanel = new JPanel();
            Box box = Box.createVerticalBox();
            int n = 0;
            for (int i = 0; i < ((CarConfigurator)CarConfigurator.this).accessoryTablePanel.model.getRowCount(); ++i) {
                Boolean bl = (Boolean)((CarConfigurator)CarConfigurator.this).accessoryTablePanel.model.getValueAt(i, 0);
                if (!bl.booleanValue()) continue;
                ++n;
                String string = (String)((CarConfigurator)CarConfigurator.this).accessoryTablePanel.model.getValueAt(i, 1);
                int n2 = CarConfigurator.this.findDoubles(string, CarConfigurator.this.m_special_contained_extras);
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(new GridLayout(1, 2));
                JTextField jTextField = new JTextField();
                JLabel jLabel = new JLabel();
                jLabel.setText(rb.getString("dialog.purchaseorder.accessory.label") + " " + n);
                jTextField.setText(string);
                jLabel.setName("label_" + string);
                jTextField.setName("name_" + string);
                jTextField.setEditable(false);
                jPanel2.add(jLabel);
                jPanel2.add(jTextField);
                box.add(jPanel2);
            }
            if (n == 0) {
                box.add(new JLabel(rb.getString("error.purchaseorder.noaccessory")));
            }
            TitledBorder titledBorder = BorderFactory.createTitledBorder(rb.getString("dialog.purchaseorder.accessory.title"));
            jPanel.setBorder(titledBorder);
            jPanel.add(box);
            return jPanel;
        }

        private void setupActions() {
            this.cancelAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SendPurchaseOrderDialog.this.cancelActionPerformed();
                }
            };
            this.sendOrderAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SendPurchaseOrderDialog.this.sendOrderActionPerformed();
                }
            };
        }
    }

    private class SpecialsDialogAccessoryTablePanel
    extends AccessoryTablePanel {
        private SpecialsDialogEditPanel assignedEditPanel;

        public SpecialsDialogAccessoryTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray, SpecialsDialogEditPanel specialsDialogEditPanel) {
            super(string, objectArray, stringArray, integerArray);
            this.assignedEditPanel = specialsDialogEditPanel;
            SpecialsDialogAccessoryTableModelListener specialsDialogAccessoryTableModelListener = new SpecialsDialogAccessoryTableModelListener();
            this.getSorter().addTableModelListener(specialsDialogAccessoryTableModelListener);
        }

        @Override
        protected void addCustomComponents() {
        }

        @Override
        protected LayoutManager getPanelLayout() {
            return new BoxLayout(this, 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.assignedEditPanel.setSpecialsSeparatePrices(this.getSelectedAccessoriesPrice());
        }

        private class SpecialsDialogAccessoryTableModelListener
        implements TableModelListener {
            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                SpecialsDialogAccessoryTablePanel.this.assignedEditPanel.setSpecialsSeparatePrices(SpecialsDialogAccessoryTablePanel.this.getSelectedAccessoriesPrice());
            }
        }
    }

    private class SpecialsDialogEditPanel
    extends JPanel {
        private JTextField specialsName;
        private JTextField specialsPrice;
        private JTextField specialsSeparatePrices;

        public SpecialsDialogEditPanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.specials.edit.name")));
            this.specialsName = new JTextField("", 18);
            this.specialsName.setName("SpecialsName");
            jPanel.add(this.specialsName);
            this.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.specials.edit.price")));
            this.specialsPrice = new JTextField("", 6);
            this.specialsPrice.setName("SpecialsPrice");
            jPanel3.add(this.specialsPrice);
            JPanel jPanel4 = new JPanel(new FlowLayout(2));
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.specials.edit.seperateprice")));
            this.specialsSeparatePrices = new JTextField("", 6);
            this.specialsSeparatePrices.setName("SpecialsSeparatePrices");
            this.specialsSeparatePrices.setEditable(false);
            jPanel4.add(this.specialsSeparatePrices);
            jPanel2.add(jPanel3);
            jPanel2.add(jPanel4);
            if (CarConfigurator.this.newVersionState) {
                JPanel jPanel5 = new JPanel(new BorderLayout());
                jPanel5.setName("NewGroupingPanel");
                jPanel5.add((Component)jPanel2, "Center");
                this.add((Component)jPanel5, "East");
            } else {
                this.add((Component)jPanel2, "East");
            }
        }

        public String getSpecialsName() {
            return this.specialsName.getText();
        }

        public void setSpecialsName(String string) {
            this.specialsName.setText(string);
        }

        public Double getSpecialsPrice() {
            Double d;
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMinimumFractionDigits(2);
                String string = this.specialsPrice.getText().trim();
                d = numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                d = 0.0;
            }
            return d;
        }

        public void setSpecialsPrice(Double d) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            this.specialsPrice.setText(numberFormat.format(d));
        }

        public void setSpecialsSeparatePrices(Double d) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            this.specialsSeparatePrices.setText(numberFormat.format(d));
        }

        public void reset() {
            this.specialsName.setText("");
            this.specialsPrice.setText("");
        }
    }

    private class SpecialsDialogTablePanel
    extends AbstractTablePanel {
        private SpecialsDialogEditPanel assignedEditPanel;
        private JTextArea assignedTextArea;
        private AccessoryTablePanel assignedAccessoryTable;

        public SpecialsDialogTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray, SpecialsDialogEditPanel specialsDialogEditPanel, JTextArea jTextArea, AccessoryTablePanel accessoryTablePanel) {
            super(string, objectArray, stringArray, integerArray, "Specials");
            this.setName("SpecialsDialogTablePanel");
            this.assignedEditPanel = specialsDialogEditPanel;
            this.assignedTextArea = jTextArea;
            this.assignedAccessoryTable = accessoryTablePanel;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n < 0) {
                this.assignedEditPanel.setSpecialsName("");
                this.assignedEditPanel.setSpecialsPrice(0.0);
                this.assignedTextArea.setText("");
            } else if (CarConfigurator.this.buggyState && n == this.sorter.getRowCount() - 1) {
                this.assignedEditPanel.setSpecialsName("");
                this.assignedEditPanel.setSpecialsPrice(0.0);
                this.assignedTextArea.setText("");
            } else {
                this.assignedEditPanel.setSpecialsName((String)this.sorter.getValueAt(n, 0));
                this.assignedEditPanel.setSpecialsPrice((Double)this.sorter.getValueAt(n, 2));
                this.assignedTextArea.setText((String)this.sorter.getValueAt(n, 1));
                String string = (String)this.sorter.getValueAt(n, 3);
                this.assignedAccessoryTable.showContainedAccessories(string);
                this.assignedEditPanel.setSpecialsSeparatePrices(this.assignedAccessoryTable.getSelectedAccessoriesPrice());
            }
        }

        public String getSelectedSpecial() {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n > -1) {
                return (String)this.table.getValueAt(n, 0);
            }
            return null;
        }
    }

    public class SpecialsOverviewDialog
    extends JDialog {
        private AbstractAction closeAction;

        public SpecialsOverviewDialog(Dialog dialog, String string, TableModel tableModel) {
            super(dialog);
            String string2 = rb.getString("dialog.specialoverview.title");
            if (string != null) {
                string2 = string2 + " " + string;
            }
            this.setTitle(string2);
            this.setModal(true);
            this.setSize(600, 400);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            this.setupActions();
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton();
            jButton.setText(rb.getString("button.ok"));
            jButton.setName("CloseButton");
            jButton.addActionListener(this.closeAction);
            jButton.setSize(80, 30);
            jPanel.add(jButton);
            Component component = this.buildGraph(string, tableModel);
            JScrollPane jScrollPane = new JScrollPane(component);
            jScrollPane.setName("graphScrollPane");
            jScrollPane.setPreferredSize(new Dimension(600, 400));
            this.getContentPane().add((Component)jScrollPane, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            this.setVisible(true);
        }

        public void closeActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        private void setupActions() {
            this.closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SpecialsOverviewDialog.this.closeActionPerformed();
                }
            };
        }

        private Component buildGraph(String string, TableModel tableModel) {
            SimpleTwoDTree simpleTwoDTree = new SimpleTwoDTree();
            if (string != null) {
                simpleTwoDTree.setRoot(string);
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    Boolean bl = (Boolean)tableModel.getValueAt(i, 0);
                    if (!bl.booleanValue()) continue;
                    Object object = tableModel.getValueAt(i, 0);
                    simpleTwoDTree.addLeaf(object.toString());
                }
            } else {
                simpleTwoDTree.setRoot("-XXX-");
            }
            return simpleTwoDTree;
        }
    }

    public class SpecialsDetailsDialog
    extends JDialog {
        private AbstractAction closeAction;

        public SpecialsDetailsDialog(Dialog dialog, Object object, String string, TableModel tableModel) {
            super(dialog);
            String string2 = rb.getString("dialog.specialdetails.title");
            if (object != null) {
                string2 = string2 + " " + (String)object;
            }
            this.setTitle(string2);
            this.setModal(true);
            this.setSize(450, 300);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            this.setupActions();
            JPanel jPanel = new JPanel(new FlowLayout());
            JButton jButton = new JButton();
            jButton.setText(rb.getString("button.ok"));
            jButton.setName("CloseButton");
            jButton.addActionListener(this.closeAction);
            jButton.setSize(80, 30);
            jPanel.add(jButton);
            JTree jTree = this.buildTree(string, tableModel);
            JScrollPane jScrollPane = new JScrollPane(jTree);
            jScrollPane.setName("treeScrollPane");
            jScrollPane.setPreferredSize(new Dimension(450, 200));
            this.getContentPane().add((Component)jScrollPane, "Center");
            this.getContentPane().add((Component)jPanel, "South");
            this.pack();
            this.setVisible(true);
        }

        public void closeActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        private void setupActions() {
            this.closeAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SpecialsDetailsDialog.this.closeActionPerformed();
                }
            };
        }

        private JTree buildTree(String string, TableModel tableModel) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            defaultMutableTreeNode.setUserObject(rb.getString("dialog.specialdetails.tree.information"));
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            defaultMutableTreeNode2.setUserObject(rb.getString("dialog.specialdetails.tree.accessories"));
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode();
            defaultMutableTreeNode3.setUserObject(rb.getString("dialog.specialdetails.tree.description"));
            if (!Misc.emptyOrNull((String)string)) {
                DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode();
                defaultMutableTreeNode4.setUserObject(string.replaceAll("\n", " "));
                defaultMutableTreeNode3.add(defaultMutableTreeNode4);
            }
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                Boolean bl = (Boolean)tableModel.getValueAt(i, 0);
                if (!bl.booleanValue()) continue;
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode();
                defaultMutableTreeNode5.setUserObject(tableModel.getValueAt(i, 1));
                defaultMutableTreeNode2.add(defaultMutableTreeNode5);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            JTree jTree = new JTree(defaultMutableTreeNode);
            jTree.setName("DetailsTree");
            return jTree;
        }
    }

    class SpecialsDialog
    extends OptionDialog {
        private SpecialsDialogTablePanel specialsDialogTablePanel;
        private SpecialsDialogEditPanel specialsDialogEditPanel;
        private JTextArea specialsDialogArea;
        private AccessoryTablePanel specialsDialogAccessoryTablePanel;
        private Object[][] accessoryCells;
        private Object[][] specialsCells;

        public SpecialsDialog(JFrame jFrame) {
            super(jFrame, true);
            this.setName("SpecialsDialog");
            this.setTitle(rb.getString("dialog.specials.name"));
            this.setModal(true);
            this.setSize(420, 500);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            Container container = this.getContentPane();
            BorderLayout borderLayout = new BorderLayout();
            container.setLayout(borderLayout);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            JPanel jPanel2 = new JPanel();
            borderLayout = new BorderLayout();
            borderLayout.setHgap(20);
            jPanel2.setLayout(borderLayout);
            this.specialsDialogEditPanel = new SpecialsDialogEditPanel();
            this.specialsDialogEditPanel.setName("SpecialsDialogEditPanel");
            jPanel2.add((Component)this.specialsDialogEditPanel, "South");
            JPanel jPanel3 = new JPanel();
            borderLayout = new BorderLayout();
            borderLayout.setHgap(20);
            jPanel3.setLayout(borderLayout);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.specials.edit.desc")));
            this.specialsDialogArea = new JTextArea();
            this.specialsDialogArea.setName("SpecialsDialogArea");
            this.specialsDialogArea.setRows(5);
            this.specialsDialogArea.setEditable(true);
            this.specialsDialogArea.setBorder(BorderFactory.createEtchedBorder());
            JScrollPane jScrollPane = new JScrollPane(this.specialsDialogArea);
            if (!CarConfigurator.this.cleanNames) {
                jScrollPane.setName("SpecialsDialogAreaScrollPane");
            }
            jPanel4.add((Component)jScrollPane, "Center");
            jPanel3.add((Component)jPanel4, "North");
            DefaultTableModel defaultTableModel = CarConfigurator.this.accessoryTablePanel.getModel();
            this.accessoryCells = new Object[defaultTableModel.getRowCount()][defaultTableModel.getColumnCount()];
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < defaultTableModel.getColumnCount(); ++j) {
                    this.accessoryCells[i][j] = defaultTableModel.getValueAt(i, j);
                }
            }
            this.specialsDialogAccessoryTablePanel = new SpecialsDialogAccessoryTablePanel(rb.getString("dialog.specials.contained"), this.accessoryCells, CarConfigurator.this.accessoryColumnNames, CarConfigurator.this.accessoryColumnMaxWidth, this.specialsDialogEditPanel);
            this.specialsDialogAccessoryTablePanel.setName("AccessorySpecialsTablePanel");
            jPanel3.add((Component)this.specialsDialogAccessoryTablePanel, "Center");
            this.specialsCells = (Object[][])CarConfigurator.this.specialsPanel.specials.clone();
            this.specialsDialogTablePanel = new SpecialsDialogTablePanel(rb.getString("dialog.specials.label"), this.specialsCells, CarConfigurator.this.specialsColumnNames, CarConfigurator.this.specialsColumnMaxWidth, this.specialsDialogEditPanel, this.specialsDialogArea, this.specialsDialogAccessoryTablePanel);
            this.specialsDialogTablePanel.setName("SpecialsTablePanel");
            jPanel2.add((Component)this.specialsDialogTablePanel, "Center");
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            container.add((Component)jPanel, "Center");
            container.add((Component)new ChangeButtonPanel(this), "East");
            this.show();
        }

        @Override
        public void newActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            if (CarConfigurator.this.buggyState) {
                try {
                    Thread.sleep(122000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            SortFilterModel sortFilterModel = (SortFilterModel)this.specialsDialogTablePanel.getSorter();
            DefaultTableModel defaultTableModel = this.specialsDialogTablePanel.getModel();
            Double d = this.specialsDialogEditPanel.getSpecialsPrice();
            int n = defaultTableModel.getRowCount();
            if (d <= 0.0) {
                this.showInvalidPriceDialog();
                return;
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = new String(this.specialsDialogEditPanel.getSpecialsName());
            objectArray[2] = d;
            objectArray[3] = this.specialsDialogAccessoryTablePanel.getSelectedAccessories();
            objectArray[1] = new String(this.specialsDialogArea.getText());
            defaultTableModel.addRow(objectArray);
            sortFilterModel.tableChanged();
            this.reset();
        }

        @Override
        public void changeActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SortFilterModel sortFilterModel = (SortFilterModel)this.specialsDialogTablePanel.table.getModel();
            int n = this.specialsDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                Double d = this.specialsDialogEditPanel.getSpecialsPrice();
                if (d > 0.0) {
                    String string = this.specialsDialogEditPanel.getSpecialsName();
                    String string2 = this.specialsDialogTablePanel.assignedTextArea.getText();
                    String string3 = this.specialsDialogAccessoryTablePanel.getSelectedAccessories();
                    sortFilterModel.setValueAt(string, n, 0);
                    sortFilterModel.setValueAt(d, n, 2);
                    sortFilterModel.setValueAt(string2, n, 1);
                    sortFilterModel.setValueAt(string3, n, 3);
                    sortFilterModel.fireTableDataChanged();
                    this.reset();
                } else {
                    this.showInvalidPriceDialog();
                }
            }
        }

        @Override
        public void deleteActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            DefaultTableModel defaultTableModel = this.specialsDialogTablePanel.getModel();
            SortFilterModel sortFilterModel = (SortFilterModel)this.specialsDialogTablePanel.table.getModel();
            int n = this.specialsDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                defaultTableModel.removeRow(n);
                sortFilterModel.tableChanged();
                this.reset();
            }
        }

        @Override
        public void cancelActionPerformed() {
            this.dispose();
        }

        @Override
        public void confirmActionPerformed() {
            int n;
            DefaultTableModel defaultTableModel = this.specialsDialogTablePanel.getModel();
            CarConfigurator.this.specialsPanel.specialsCombo.removeAllItems();
            for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
                CarConfigurator.this.specialsPanel.specialsCombo.addItem(defaultTableModel.getValueAt(n, 0));
            }
            SpecialsPanel.access$2602(CarConfigurator.this.specialsPanel, new Object[defaultTableModel.getRowCount()][4]);
            for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
                for (int i = 0; i < defaultTableModel.getColumnCount(); ++i) {
                    ((SpecialsPanel)((CarConfigurator)CarConfigurator.this).specialsPanel).specials[n][i] = defaultTableModel.getValueAt(n, i);
                }
            }
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        @Override
        public void detailsActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SpecialsDetailsDialog specialsDetailsDialog = new SpecialsDetailsDialog(this, CarConfigurator.this.specialsPanel.specialsCombo.getSelectedItem(), this.specialsDialogArea.getText(), this.specialsDialogAccessoryTablePanel.getModel());
        }

        @Override
        public void overviewActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SpecialsOverviewDialog specialsOverviewDialog = new SpecialsOverviewDialog(this, this.specialsDialogTablePanel.getSelectedSpecial(), this.specialsDialogAccessoryTablePanel.getModel());
        }

        public String getBusinessId() {
            return "SPECIALSDIALOG";
        }

        private void showInvalidPriceDialog() {
            JOptionPane.showMessageDialog(CarConfigurator.this.frame, rb.getString("error.price.invalid"), "CarConfigurator - Error", 0);
        }

        private void reset() {
            this.specialsDialogEditPanel.reset();
            this.specialsDialogArea.setText("");
            this.specialsDialogAccessoryTablePanel.reset();
        }

        private void setupActions() {
        }
    }

    private class AccessoryDialogEditPanel
    extends JPanel {
        private JTextField accessoryName;
        private JTextField accessoryId;
        private JTextField accessoryPrice;

        public AccessoryDialogEditPanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.accessories.edit.name")));
            this.accessoryName = new JTextField("", 15);
            this.accessoryName.setName("AccessoryName");
            jPanel.add(this.accessoryName);
            this.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.accessories.edit.id")));
            this.accessoryId = new JTextField("", 2);
            this.accessoryId.setName("AccessoryId");
            jPanel3.add(this.accessoryId);
            jPanel2.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel(new FlowLayout(2));
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.accessories.edit.price")));
            this.accessoryPrice = new JTextField("", 6);
            this.accessoryPrice.setName("AccessoryPrice");
            jPanel4.add(this.accessoryPrice);
            jPanel2.add((Component)jPanel4, "East");
            this.add((Component)jPanel2, "East");
        }

        public String getAccessoryName() {
            return this.accessoryName.getText();
        }

        public void setAccessoryName(String string) {
            this.accessoryName.setText(string);
        }

        public String getAccessoryId() {
            return this.accessoryId.getText();
        }

        public void setAccessoryId(String string) {
            this.accessoryId.setText(string);
        }

        public Double getAccessoryPrice() {
            Double d;
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMinimumFractionDigits(2);
                String string = this.accessoryPrice.getText().trim();
                d = numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                d = 0.0;
            }
            return d;
        }

        public void setAccessoryPrice(Double d) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            this.accessoryPrice.setText(numberFormat.format(d));
        }

        public void reset() {
            this.accessoryName.setText("");
            this.accessoryId.setText("");
            this.accessoryPrice.setText("");
        }
    }

    private class AccessoryDialogTablePanel
    extends AbstractTablePanel {
        AccessoryDialogEditPanel assignedEditPanel;
        Object[][] accessoryDialogCells;

        public AccessoryDialogTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray, AccessoryDialogEditPanel accessoryDialogEditPanel) {
            super(string, objectArray, stringArray, integerArray, "Accessories");
            this.setName("AccessoryDialogTablePanel");
            this.assignedEditPanel = accessoryDialogEditPanel;
            this.accessoryDialogCells = objectArray;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(0);
            this.table.removeColumn(tableColumn);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n < 0) {
                this.assignedEditPanel.setAccessoryName("");
                this.assignedEditPanel.setAccessoryId("");
                this.assignedEditPanel.setAccessoryPrice(0.0);
            } else if (CarConfigurator.this.buggyState && n == this.sorter.getRowCount() - 1) {
                this.assignedEditPanel.setAccessoryName("");
                this.assignedEditPanel.setAccessoryId("");
                this.assignedEditPanel.setAccessoryPrice(0.0);
            } else {
                this.assignedEditPanel.setAccessoryName((String)this.sorter.getValueAt(n, 1));
                this.assignedEditPanel.setAccessoryId((String)this.sorter.getValueAt(n, 2));
                this.assignedEditPanel.setAccessoryPrice((Double)this.sorter.getValueAt(n, 3));
            }
        }
    }

    class AccessoryDialog
    extends OptionDialog {
        private AccessoryDialogTablePanel accessoryDialogTablePanel;
        private AccessoryDialogEditPanel accessoryDialogEditPanel;

        public AccessoryDialog(JFrame jFrame) {
            super(jFrame, false);
            this.setName("AccessoryDialog");
            this.setTitle(rb.getString("dialog.accessories.name"));
            this.setModal(true);
            this.setSize(420, 300);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            Container container = this.getContentPane();
            BorderLayout borderLayout = new BorderLayout();
            container.setLayout(borderLayout);
            JPanel jPanel = new JPanel();
            borderLayout = new BorderLayout();
            borderLayout.setHgap(20);
            jPanel.setLayout(borderLayout);
            this.accessoryDialogEditPanel = new AccessoryDialogEditPanel();
            this.accessoryDialogEditPanel.setName("AccessoryDialogEditPanel");
            jPanel.add((Component)this.accessoryDialogEditPanel, "South");
            DefaultTableModel defaultTableModel = CarConfigurator.this.accessoryTablePanel.getModel();
            Object[][] objectArray = new Object[defaultTableModel.getRowCount()][defaultTableModel.getColumnCount()];
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < defaultTableModel.getColumnCount(); ++j) {
                    objectArray[i][j] = defaultTableModel.getValueAt(i, j);
                }
            }
            this.accessoryDialogTablePanel = new AccessoryDialogTablePanel(rb.getString("dialog.accessories.label"), objectArray, CarConfigurator.this.accessoryColumnNames, CarConfigurator.this.accessoryColumnMaxWidth, this.accessoryDialogEditPanel);
            if (!CarConfigurator.this.cleanNames) {
                this.accessoryDialogTablePanel.setName("AccessoryTablePanel");
            }
            jPanel.add((Component)this.accessoryDialogTablePanel, "Center");
            container.add((Component)jPanel, "Center");
            container.add((Component)new ChangeButtonPanel(this), "East");
            this.show();
        }

        @Override
        public void newActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SortFilterModel sortFilterModel = (SortFilterModel)this.accessoryDialogTablePanel.table.getModel();
            DefaultTableModel defaultTableModel = this.accessoryDialogTablePanel.getModel();
            Double d = this.accessoryDialogEditPanel.getAccessoryPrice();
            int n = defaultTableModel.getRowCount();
            if (d <= 0.0) {
                this.showInvalidPriceDialog();
                return;
            }
            Object[] objectArray = new Object[]{false, new String(this.accessoryDialogEditPanel.getAccessoryName()), new String(this.accessoryDialogEditPanel.getAccessoryId()), d};
            defaultTableModel.addRow(objectArray);
            sortFilterModel.tableChanged();
            this.accessoryDialogEditPanel.reset();
        }

        @Override
        public void changeActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SortFilterModel sortFilterModel = (SortFilterModel)this.accessoryDialogTablePanel.table.getModel();
            int n = this.accessoryDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                Double d = this.accessoryDialogEditPanel.getAccessoryPrice();
                if (d > 0.0) {
                    sortFilterModel.setValueAt(this.accessoryDialogEditPanel.getAccessoryName(), n, 1);
                    sortFilterModel.setValueAt(this.accessoryDialogEditPanel.getAccessoryId(), n, 2);
                    sortFilterModel.setValueAt(d, n, 3);
                    sortFilterModel.fireTableDataChanged();
                    this.accessoryDialogEditPanel.reset();
                } else {
                    this.showInvalidPriceDialog();
                }
            }
        }

        @Override
        public void deleteActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            DefaultTableModel defaultTableModel = this.accessoryDialogTablePanel.getModel();
            SortFilterModel sortFilterModel = (SortFilterModel)this.accessoryDialogTablePanel.table.getModel();
            int n = this.accessoryDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                defaultTableModel.removeRow(n);
            }
            sortFilterModel.tableChanged();
        }

        @Override
        public void cancelActionPerformed() {
            this.dispose();
        }

        @Override
        public void confirmActionPerformed() {
            DefaultTableModel defaultTableModel = this.accessoryDialogTablePanel.getModel();
            DefaultTableModel defaultTableModel2 = CarConfigurator.this.accessoryTablePanel.getModel();
            defaultTableModel2.setNumRows(defaultTableModel.getRowCount());
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < defaultTableModel.getColumnCount(); ++j) {
                    defaultTableModel2.setValueAt(defaultTableModel.getValueAt(i, j), i, j);
                }
            }
            SortFilterModel sortFilterModel = (SortFilterModel)((CarConfigurator)CarConfigurator.this).accessoryTablePanel.table.getModel();
            sortFilterModel.tableChanged();
            defaultTableModel2.fireTableDataChanged();
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        @Override
        public void detailsActionPerformed() {
        }

        @Override
        public void overviewActionPerformed() {
        }

        public String getBusinessId() {
            return "ACCESSORIESDIALOG";
        }

        private void showInvalidPriceDialog() {
            JOptionPane.showMessageDialog(CarConfigurator.this.frame, rb.getString("error.price.invalid"), "CarConfigurator - Error", 0);
        }
    }

    private class NewVehicleDialogEditPanel
    extends JPanel {
        private JTextField vehicleName;
        private JTextField vehiclePrice;
        private JTextField vehicleId;

        public NewVehicleDialogEditPanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.vehicles.edit.name")));
            this.vehicleName = new JTextField("", 15);
            this.vehicleName.setName("VehicleName");
            jPanel.add(this.vehicleName);
            this.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.vehicles.edit.id")));
            this.vehicleId = new JTextField("", 2);
            this.vehicleId.setName("VehicleId");
            jPanel3.add(this.vehicleId);
            jPanel2.add((Component)jPanel3, "Center");
            JPanel jPanel4 = new JPanel(new FlowLayout(2));
            jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.vehicles.edit.price")));
            this.vehiclePrice = new JTextField("", 6);
            this.vehiclePrice.setName("VehiclePrice");
            jPanel4.add(this.vehiclePrice);
            jPanel2.add((Component)jPanel4, "East");
            this.add((Component)jPanel2, "East");
        }

        public String getVehicleName() {
            return this.vehicleName.getText();
        }

        public void setVehicleName(String string) {
            this.vehicleName.setText(string);
        }

        public Double getVehiclePrice() {
            Double d;
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMinimumFractionDigits(2);
                String string = this.vehiclePrice.getText().trim();
                d = numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                d = 0.0;
            }
            return d;
        }

        public void setVehiclePrice(Double d) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            this.vehiclePrice.setText(numberFormat.format(d));
        }

        public String getVehicleId() {
            return this.vehicleId.getText();
        }

        public void setVehicleId(String string) {
            this.vehicleId.setText(string);
        }

        public void reset() {
            this.vehicleId.setText("");
            this.vehicleName.setText("");
            this.vehiclePrice.setText("");
        }
    }

    private class VehicleDialogEditPanel
    extends JPanel {
        private JTextField vehicleName;
        private JTextField vehiclePrice;

        public VehicleDialogEditPanel() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.vehicles.edit.name")));
            this.vehicleName = new JTextField("", 18);
            this.vehicleName.setName("VehicleName");
            jPanel.add(this.vehicleName);
            this.add((Component)jPanel, "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout(2));
            jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), rb.getString("dialog.vehicles.edit.price")));
            this.vehiclePrice = new JTextField("", 6);
            this.vehiclePrice.setName("VehiclePrice");
            jPanel2.add(this.vehiclePrice);
            this.add((Component)jPanel2, "East");
        }

        public String getVehicleName() {
            return this.vehicleName.getText();
        }

        public void setVehicleName(String string) {
            this.vehicleName.setText(string);
        }

        public Double getVehiclePrice() {
            Double d;
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMinimumFractionDigits(2);
                String string = this.vehiclePrice.getText().trim();
                d = numberFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                d = 0.0;
            }
            return d;
        }

        public void setVehiclePrice(Double d) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            this.vehiclePrice.setText(numberFormat.format(d));
        }

        public void reset() {
            this.vehicleName.setText("");
            this.vehiclePrice.setText("");
        }
    }

    private class NewVehicleDialogTablePanel
    extends AbstractTablePanel {
        protected NewVehicleDialogEditPanel assignedEditPanel;
        protected Object[][] vehicleDialogCells;

        public NewVehicleDialogTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray, NewVehicleDialogEditPanel newVehicleDialogEditPanel) {
            super(string, objectArray, stringArray, integerArray, "Vehicles");
            this.setName("VehiclesDialogTablePanel");
            this.assignedEditPanel = newVehicleDialogEditPanel;
            this.vehicleDialogCells = objectArray;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n < 0) {
                this.assignedEditPanel.setVehicleName("");
                this.assignedEditPanel.setVehicleId("");
                this.assignedEditPanel.setVehiclePrice(0.0);
            } else if (CarConfigurator.this.buggyState && n == this.sorter.getRowCount() - 1) {
                this.assignedEditPanel.setVehicleName("");
                this.assignedEditPanel.setVehicleId("");
                this.assignedEditPanel.setVehiclePrice(0.0);
            } else {
                this.assignedEditPanel.setVehicleName((String)this.sorter.getValueAt(n, 0));
                this.assignedEditPanel.setVehicleId((String)this.sorter.getValueAt(n, 1));
                this.assignedEditPanel.setVehiclePrice((Double)this.sorter.getValueAt(n, 2));
            }
        }
    }

    private class VehicleDialogTablePanel
    extends AbstractTablePanel {
        protected VehicleDialogEditPanel assignedEditPanel;
        protected Object[][] vehicleDialogCells;

        public VehicleDialogTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray, VehicleDialogEditPanel vehicleDialogEditPanel) {
            super(string, objectArray, stringArray, integerArray, "Vehicles");
            this.setName("VehiclesDialogTablePanel");
            this.assignedEditPanel = vehicleDialogEditPanel;
            this.vehicleDialogCells = objectArray;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n < 0) {
                this.assignedEditPanel.setVehicleName("");
                this.assignedEditPanel.setVehiclePrice(0.0);
            } else if (CarConfigurator.this.buggyState && n == this.sorter.getRowCount() - 1) {
                this.assignedEditPanel.setVehicleName("");
                this.assignedEditPanel.setVehiclePrice(0.0);
            } else {
                this.assignedEditPanel.setVehicleName((String)this.sorter.getValueAt(n, 0));
                this.assignedEditPanel.setVehiclePrice((Double)this.sorter.getValueAt(n, 1));
            }
        }
    }

    class NewVehiclesDialog
    extends OptionDialog {
        protected NewVehicleDialogTablePanel vehicleDialogTablePanel;
        protected NewVehicleDialogEditPanel vehicleDialogEditPanel;

        public NewVehiclesDialog(JFrame jFrame) {
            super(jFrame, false);
            this.setContent();
            this.show();
        }

        public void setContent() {
            this.setName("VehiclesDialog");
            this.setTitle(rb.getString("dialog.vehicles.name"));
            this.setModal(true);
            this.setSize(420, 300);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            Container container = this.getContentPane();
            BorderLayout borderLayout = new BorderLayout();
            container.setLayout(borderLayout);
            JPanel jPanel = new JPanel();
            borderLayout = new BorderLayout();
            borderLayout.setHgap(20);
            jPanel.setLayout(borderLayout);
            this.vehicleDialogEditPanel = new NewVehicleDialogEditPanel();
            this.vehicleDialogEditPanel.setName("VehicleDialogEditPanel");
            jPanel.add((Component)this.vehicleDialogEditPanel, "North");
            DefaultTableModel defaultTableModel = CarConfigurator.this.vehicleTablePanel_new.getModel();
            Object[][] objectArray = new Object[defaultTableModel.getRowCount()][defaultTableModel.getColumnCount()];
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < defaultTableModel.getColumnCount(); ++j) {
                    objectArray[i][j] = defaultTableModel.getValueAt(i, j);
                }
            }
            this.vehicleDialogTablePanel = new NewVehicleDialogTablePanel(rb.getString("dialog.vehicles.label"), objectArray, CarConfigurator.this.vehicleColumnNames_new, CarConfigurator.this.vehicleColumnMaxWidth_new, this.vehicleDialogEditPanel);
            if (!CarConfigurator.this.cleanNames) {
                this.vehicleDialogTablePanel.setName("VehicleTablePanel");
            }
            jPanel.add((Component)this.vehicleDialogTablePanel, "Center");
            container.add((Component)jPanel, "Center");
            container.add((Component)new ChangeButtonPanel(this), "East");
        }

        @Override
        public void newActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SortFilterModel sortFilterModel = (SortFilterModel)this.vehicleDialogTablePanel.table.getModel();
            DefaultTableModel defaultTableModel = this.vehicleDialogTablePanel.getModel();
            Double d = this.vehicleDialogEditPanel.getVehiclePrice();
            int n = defaultTableModel.getRowCount();
            if (d <= 0.0) {
                this.showInvalidPriceDialog();
                return;
            }
            Object[] objectArray = new Object[]{new String(this.vehicleDialogEditPanel.getVehicleName()), new String(this.vehicleDialogEditPanel.getVehicleId()), d};
            defaultTableModel.addRow(objectArray);
            sortFilterModel.tableChanged();
            this.vehicleDialogEditPanel.reset();
        }

        @Override
        public void changeActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SortFilterModel sortFilterModel = (SortFilterModel)this.vehicleDialogTablePanel.table.getModel();
            int n = this.vehicleDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                Double d = this.vehicleDialogEditPanel.getVehiclePrice();
                if (d > 0.0) {
                    sortFilterModel.setValueAt(this.vehicleDialogEditPanel.getVehicleName(), n, 0);
                    sortFilterModel.setValueAt(this.vehicleDialogEditPanel.getVehicleId(), n, 1);
                    sortFilterModel.setValueAt(d, n, 2);
                    sortFilterModel.fireTableDataChanged();
                    this.vehicleDialogEditPanel.reset();
                } else {
                    this.showInvalidPriceDialog();
                }
            }
        }

        @Override
        public void deleteActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            DefaultTableModel defaultTableModel = this.vehicleDialogTablePanel.getModel();
            SortFilterModel sortFilterModel = (SortFilterModel)this.vehicleDialogTablePanel.table.getModel();
            int n = this.vehicleDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                defaultTableModel.removeRow(n);
            }
            sortFilterModel.tableChanged();
        }

        @Override
        public void cancelActionPerformed() {
            this.dispose();
        }

        @Override
        public void confirmActionPerformed() {
            DefaultTableModel defaultTableModel = this.vehicleDialogTablePanel.getModel();
            DefaultTableModel defaultTableModel2 = CarConfigurator.this.vehicleTablePanel_new.getModel();
            defaultTableModel2.setNumRows(defaultTableModel.getRowCount());
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < defaultTableModel.getColumnCount(); ++j) {
                    defaultTableModel2.setValueAt(defaultTableModel.getValueAt(i, j), i, j);
                }
            }
            SortFilterModel sortFilterModel = (SortFilterModel)((CarConfigurator)CarConfigurator.this).vehicleTablePanel_new.table.getModel();
            sortFilterModel.tableChanged();
            defaultTableModel2.fireTableDataChanged();
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        @Override
        public void detailsActionPerformed() {
        }

        @Override
        public void overviewActionPerformed() {
        }

        public String getBusinessId() {
            return "VEHICLESDIALOG";
        }

        protected void showInvalidPriceDialog() {
            JOptionPane.showMessageDialog(CarConfigurator.this.frame, rb.getString("error.price.invalid"), "CarConfigurator - Error", 0);
        }
    }

    class VehiclesDialog
    extends OptionDialog {
        protected VehicleDialogTablePanel vehicleDialogTablePanel;
        protected VehicleDialogEditPanel vehicleDialogEditPanel;

        public VehiclesDialog(JFrame jFrame) {
            super(jFrame, false);
            this.setContent();
            this.show();
        }

        public void setContent() {
            this.setName("VehiclesDialog");
            this.setTitle(rb.getString("dialog.vehicles.name"));
            this.setModal(true);
            this.setSize(420, 300);
            this.setLocation(CarConfigurator.this.x_pos, CarConfigurator.this.y_pos);
            Container container = this.getContentPane();
            BorderLayout borderLayout = new BorderLayout();
            container.setLayout(borderLayout);
            JPanel jPanel = new JPanel();
            borderLayout = new BorderLayout();
            borderLayout.setHgap(20);
            jPanel.setLayout(borderLayout);
            this.vehicleDialogEditPanel = new VehicleDialogEditPanel();
            this.vehicleDialogEditPanel.setName("VehicleDialogEditPanel");
            jPanel.add((Component)this.vehicleDialogEditPanel, "South");
            DefaultTableModel defaultTableModel = CarConfigurator.this.vehicleTablePanel.getModel();
            Object[][] objectArray = new Object[defaultTableModel.getRowCount()][defaultTableModel.getColumnCount()];
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < defaultTableModel.getColumnCount(); ++j) {
                    objectArray[i][j] = defaultTableModel.getValueAt(i, j);
                }
            }
            this.vehicleDialogTablePanel = new VehicleDialogTablePanel(rb.getString("dialog.vehicles.label"), objectArray, CarConfigurator.this.vehicleColumnNames, CarConfigurator.this.vehicleColumnMaxWidth, this.vehicleDialogEditPanel);
            if (!CarConfigurator.this.cleanNames) {
                this.vehicleDialogTablePanel.setName("VehicleTablePanel");
            }
            jPanel.add((Component)this.vehicleDialogTablePanel, "Center");
            container.add((Component)jPanel, "Center");
            container.add((Component)new ChangeButtonPanel(this), "East");
        }

        @Override
        public void newActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SortFilterModel sortFilterModel = (SortFilterModel)this.vehicleDialogTablePanel.table.getModel();
            DefaultTableModel defaultTableModel = this.vehicleDialogTablePanel.getModel();
            Double d = this.vehicleDialogEditPanel.getVehiclePrice();
            int n = defaultTableModel.getRowCount();
            if (d <= 0.0) {
                this.showInvalidPriceDialog();
                return;
            }
            Object[] objectArray = new Object[]{new String(this.vehicleDialogEditPanel.getVehicleName()), d};
            defaultTableModel.addRow(objectArray);
            sortFilterModel.tableChanged();
            this.vehicleDialogEditPanel.reset();
        }

        @Override
        public void changeActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            SortFilterModel sortFilterModel = (SortFilterModel)this.vehicleDialogTablePanel.table.getModel();
            int n = this.vehicleDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                Double d = this.vehicleDialogEditPanel.getVehiclePrice();
                if (d > 0.0) {
                    sortFilterModel.setValueAt(this.vehicleDialogEditPanel.getVehicleName(), n, 0);
                    sortFilterModel.setValueAt(d, n, 1);
                    sortFilterModel.fireTableDataChanged();
                    this.vehicleDialogEditPanel.reset();
                } else {
                    this.showInvalidPriceDialog();
                }
            }
        }

        @Override
        public void deleteActionPerformed() {
            CarConfigurator.this.sleepForLoadtesting();
            DefaultTableModel defaultTableModel = this.vehicleDialogTablePanel.getModel();
            SortFilterModel sortFilterModel = (SortFilterModel)this.vehicleDialogTablePanel.table.getModel();
            int n = this.vehicleDialogTablePanel.table.getSelectionModel().getMinSelectionIndex();
            if (n >= 0) {
                defaultTableModel.removeRow(n);
            }
            sortFilterModel.tableChanged();
        }

        @Override
        public void cancelActionPerformed() {
            this.dispose();
        }

        @Override
        public void confirmActionPerformed() {
            DefaultTableModel defaultTableModel = this.vehicleDialogTablePanel.getModel();
            DefaultTableModel defaultTableModel2 = CarConfigurator.this.vehicleTablePanel.getModel();
            defaultTableModel2.setNumRows(defaultTableModel.getRowCount());
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                for (int j = 0; j < defaultTableModel.getColumnCount(); ++j) {
                    defaultTableModel2.setValueAt(defaultTableModel.getValueAt(i, j), i, j);
                }
            }
            SortFilterModel sortFilterModel = (SortFilterModel)((CarConfigurator)CarConfigurator.this).vehicleTablePanel.table.getModel();
            sortFilterModel.tableChanged();
            defaultTableModel2.fireTableDataChanged();
            CarConfigurator.this.sleepForLoadtesting();
            this.dispose();
        }

        @Override
        public void detailsActionPerformed() {
        }

        @Override
        public void overviewActionPerformed() {
        }

        public String getBusinessId() {
            return "VEHICLESDIALOG";
        }

        protected void showInvalidPriceDialog() {
            JOptionPane.showMessageDialog(CarConfigurator.this.frame, rb.getString("error.price.invalid"), "CarConfigurator - Error", 0);
        }
    }

    class CalculatorPanel
    extends JPanel
    implements ActionListener,
    FocusListener,
    MouseListener,
    DocumentListener {
        JTextField basePrice;
        JTextField specialsPrice;
        JTextField calculatedPrice;
        JTextField discountValue;
        Action discountAction;
        NumberFormat pformatter = NumberFormat.getPercentInstance();
        boolean errorShown = false;

        public CalculatorPanel(String string) {
            this.setName("CalculatorPanel");
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            GridLayout gridLayout = new GridLayout(4, 1);
            jPanel.setLayout(gridLayout);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            this.basePrice = new JTextField("", 10);
            this.basePrice.setText(CarConfigurator.this.m_currencyFormatter.format(CarConfigurator.this.m_baseprice));
            this.basePrice.setName("BasePrice");
            this.basePrice.setHorizontalAlignment(4);
            this.basePrice.setEditable(false);
            this.basePrice.setBorder(null);
            JLabel jLabel = new JLabel(rb.getString("panel.vehicles.label"));
            jLabel.setLabelFor(this.basePrice);
            jPanel2.add((Component)jLabel, "West");
            jPanel2.add((Component)this.basePrice, "East");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BorderLayout());
            jPanel3.setSize(50, 10);
            this.specialsPrice = new JTextField("", 10);
            this.specialsPrice.setText(CarConfigurator.this.m_currencyFormatter.format(0L));
            this.specialsPrice.setName("SpecialsPrice");
            this.specialsPrice.setHorizontalAlignment(4);
            this.specialsPrice.setEditable(false);
            this.specialsPrice.setBorder(null);
            JLabel jLabel2 = new JLabel(rb.getString("panel.specials.label"));
            jLabel2.setLabelFor(this.specialsPrice);
            jPanel3.add((Component)jLabel2, "West");
            jPanel3.add((Component)this.specialsPrice, "East");
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.setSize(50, 10);
            this.discountValue = new JTextField(this.formatPercent(0.0), 4);
            this.discountValue.setName("DiscountValue");
            this.discountValue.setHorizontalAlignment(4);
            this.discountValue.setEditable(true);
            this.discountValue.setBorder(null);
            this.discountValue.addActionListener(this);
            this.discountValue.addFocusListener(this);
            this.discountValue.getDocument().addDocumentListener(this);
            this.discountValue.addMouseListener(this);
            JLabel jLabel3 = new JLabel(rb.getString("panel.price.discount"));
            jLabel3.setLabelFor(this.discountValue);
            jPanel4.add((Component)jLabel3, "West");
            jPanel4.add((Component)this.discountValue, "East");
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BorderLayout());
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.calculatedPrice = new JTextField("", 10);
            this.setCalculatedPrice(0.0);
            this.calculatedPrice.setName("CalculatedPrice");
            this.calculatedPrice.setHorizontalAlignment(4);
            this.calculatedPrice.setEditable(false);
            this.calculatedPrice.setBorder(null);
            this.calculatedPrice.setFont(this.calculatedPrice.getFont().deriveFont(1));
            this.calculatedPrice.setForeground(CarConfigurator.this.m_theme.getTitleTextColor());
            JLabel jLabel4 = new JLabel(rb.getString("panel.price.calculated"));
            jLabel4.setFont(jLabel4.getFont().deriveFont(1));
            jLabel4.setForeground(CarConfigurator.this.m_theme.getTitleTextColor());
            jLabel4.setLabelFor(this.calculatedPrice);
            jPanel5.add((Component)jLabel4, "West");
            jPanel5.add((Component)this.calculatedPrice, "East");
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.add(jPanel5);
            JPanel jPanel6 = new JPanel();
            this.add((Component)jPanel6, "West");
            JPanel jPanel7 = new JPanel();
            GridLayout gridLayout2 = new GridLayout(4, 1);
            jPanel7.setLayout(gridLayout2);
            JButton jButton = new JButton("-5%");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CalculatorPanel.this.increaseDiscount();
                }
            });
            jPanel7.add(Box.createVerticalBox());
            jPanel7.add(Box.createVerticalBox());
            jPanel7.add(Box.createVerticalBox());
            jPanel7.add(jButton);
            this.add((Component)jPanel7, "East");
            this.add((Component)jPanel, "Center");
        }

        private boolean checkDiscount() {
            String string = this.discountValue.getText();
            try {
                Number number = CarConfigurator.this.m_numberFormatter.parse(this.discountValue.getText().trim());
                CarConfigurator.this.m_discount = number.intValue();
            }
            catch (ParseException parseException) {
                return false;
            }
            if (CarConfigurator.this.m_discount < 0) {
                CarConfigurator.this.m_discount = 0;
                return false;
            }
            if (!CarConfigurator.this.buggyState && CarConfigurator.this.m_discount > 100) {
                CarConfigurator.this.m_discount = 100;
            }
            return true;
        }

        private void checkDiscountShowError() {
            if (!this.checkDiscount()) {
                JOptionPane.showMessageDialog(CarConfigurator.this.frame, rb.getString("error.discount.invalid"), "CarConfigurator - Error", 0);
                this.discountValue.setText(this.formatPercent(0.0));
            }
            if (CarConfigurator.this.m_discount == 100) {
                JOptionPane.showMessageDialog(CarConfigurator.this.frame, rb.getString("error.discount.hundred"), "CarConfigurator - Error", 0);
                this.discountValue.setText(this.formatPercent(0.0));
            }
        }

        public void setBasePrice(double d) {
            this.basePrice.setText(CarConfigurator.this.m_currencyFormatter.format(d));
        }

        public void setSpecialsPrice(double d) {
            this.specialsPrice.setText(CarConfigurator.this.m_currencyFormatter.format(d));
        }

        public void setCalculatedPrice(double d) {
            this.calculatedPrice.setText(CarConfigurator.this.m_currencyFormatter.format(d));
        }

        private void reset() {
            CarConfigurator.this.m_discount = 0;
            this.discountValue.setText(this.formatPercent(0.0));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.errorShown) {
                this.errorShown = true;
                this.checkDiscountShowError();
                CarConfigurator.this.updateCalculatedPrice();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.errorShown = false;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!this.errorShown) {
                this.errorShown = true;
                this.checkDiscountShowError();
                try {
                    Number number = CarConfigurator.this.m_numberFormatter.parse(this.discountValue.getText().trim());
                    this.discountValue.setText(this.formatPercent(number.floatValue() / 100.0f));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                CarConfigurator.this.updateCalculatedPrice();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.errorShown = false;
            if (this.checkDiscount()) {
                CarConfigurator.this.updateCalculatedPrice();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.errorShown = false;
            if (this.checkDiscount()) {
                CarConfigurator.this.updateCalculatedPrice();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.errorShown = false;
            if (this.checkDiscount()) {
                CarConfigurator.this.updateCalculatedPrice();
            }
        }

        public void increaseDiscount() {
            int n = 5;
            if (CarConfigurator.this.buggyState) {
                n = 3;
            }
            try {
                Number number = CarConfigurator.this.m_numberFormatter.parse(this.discountValue.getText().trim());
                CarConfigurator.this.m_discount = number.intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (CarConfigurator.this.m_discount < 0) {
                CarConfigurator.this.m_discount = 0;
            }
            CarConfigurator.this.m_discount = CarConfigurator.this.m_discount + n;
            if (CarConfigurator.this.m_discount > 99) {
                CarConfigurator.this.m_discount = 99;
            }
            this.discountValue.setText(Integer.toString(CarConfigurator.this.m_discount) + "%");
            CarConfigurator.this.updateCalculatedPrice();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.discountValue.selectAll();
        }

        private String formatPercent(double d) {
            return this.pformatter.format(d).replace("\u00a0", "");
        }
    }

    private class AccessoryTablePanel
    extends AbstractTablePanel
    implements ItemListener {
        private AccessoryTablePanelModelListener accessoryTablePanelModelListener;
        private JCheckBox takeAccessoryPriceIntoAccount;

        public AccessoryTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray) {
            super(string, objectArray, stringArray, integerArray, "Accessory");
            this.setName("AccessoryTablePanel");
            this.accessoryTablePanelModelListener = new AccessoryTablePanelModelListener();
            this.getSorter().addTableModelListener(this.accessoryTablePanelModelListener);
            this.addCustomComponents();
        }

        protected void addCustomComponents() {
            this.takeAccessoryPriceIntoAccount = new JCheckBox(rb.getString("panel.accessories.withprice"));
            this.takeAccessoryPriceIntoAccount.setName("AddAccessoryPriceChkbox");
            this.takeAccessoryPriceIntoAccount.setSelected(true);
            this.takeAccessoryPriceIntoAccount.addItemListener(this);
            this.add((Component)this.takeAccessoryPriceIntoAccount, "South");
        }

        @Override
        protected LayoutManager getPanelLayout() {
            return new BorderLayout();
        }

        public boolean isPriceIntoAccount() {
            if (this.takeAccessoryPriceIntoAccount != null) {
                return this.takeAccessoryPriceIntoAccount.isSelected();
            }
            return false;
        }

        public void showContainedAccessories(String string) {
            for (int i = 0; i < this.sorter.getRowCount(); ++i) {
                String string2 = (String)this.sorter.getValueAt(i, 2);
                if (CarConfigurator.this.findDoubles(string2, string) > 0) {
                    this.sorter.setValueAt(true, i, 0);
                    continue;
                }
                this.sorter.setValueAt(false, i, 0);
            }
        }

        public String getSelectedAccessories() {
            String string = new String();
            for (int i = 0; i < this.sorter.getRowCount(); ++i) {
                Boolean bl = (Boolean)this.sorter.getValueAt(i, 0);
                if (!bl.booleanValue()) continue;
                string = string.length() > 0 ? string + " " + (String)this.sorter.getValueAt(i, 2) : (String)this.sorter.getValueAt(i, 2);
            }
            return string;
        }

        public Double getSelectedAccessoriesPrice() {
            double d = 0.0;
            for (int i = 0; i < this.sorter.getRowCount(); ++i) {
                Boolean bl = (Boolean)this.sorter.getValueAt(i, 0);
                if (!bl.booleanValue()) continue;
                d += ((Double)this.sorter.getValueAt(i, 3)).doubleValue();
            }
            return d;
        }

        private void reset() {
            ((AbstractTablePanel)this).reset();
            this.model.setDataVector((Object[][])CarConfigurator.this.accessoryCells.clone(), CarConfigurator.this.accessoryColumnNames);
            this.setTableLayout(CarConfigurator.this.accessoryColumnNames, CarConfigurator.this.accessoryColumnMaxWidth);
            this.sorter.updateData();
            if (this.takeAccessoryPriceIntoAccount != null) {
                this.takeAccessoryPriceIntoAccount.setSelected(true);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            CarConfigurator.this.updateCalculatedPrice();
        }

        private class AccessoryTablePanelModelListener
        implements TableModelListener {
            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                CarConfigurator.this.updateCalculatedPrice();
            }
        }
    }

    class SpecialsPanel
    extends JPanel {
        private Object[][] specials;
        private JTextArea specialsArea;
        private JComboBox specialsCombo;
        private Action specialsComboAction;

        public SpecialsPanel(String string, Object[][] objectArray) {
            this.specials = objectArray;
            this.setName("SpecialsPanel");
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), string));
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(5);
            this.setLayout(borderLayout);
            this.specialsCombo = new JComboBox();
            this.specialsCombo.setName("SpecialsCombo");
            for (int i = 0; i < 4; ++i) {
                this.specialsCombo.addItem(this.specials[i][0]);
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setSize(50, 10);
            JLabel jLabel = new JLabel(rb.getString("panel.specials.label"));
            this.specialsArea = new JTextArea();
            this.specialsArea.setName("SpecialsArea");
            this.specialsArea.setEditable(false);
            this.specialsArea.setBackground(Color.WHITE);
            JScrollPane jScrollPane = new JScrollPane(this.specialsArea);
            if (!CarConfigurator.this.cleanNames) {
                jScrollPane.setName("SpecialsAreaScrollPane");
            }
            this.add((Component)this.specialsCombo, "North");
            this.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel, "South");
            this.setupComboAction();
            this.specialsCombo.addActionListener(this.specialsComboAction);
        }

        private void setupComboAction() {
            this.specialsComboAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SpecialsPanel.this.specialsCombo.getSelectedIndex();
                    if (!(CarConfigurator.this.buggyState || n >= 0 && n < SpecialsPanel.this.specialsCombo.getItemCount())) {
                        n = 0;
                    }
                    Double d = (Double)SpecialsPanel.this.specials[n][2];
                    SpecialsPanel.this.specialsArea.setText(SpecialsPanel.this.specials[n][1].toString());
                    CarConfigurator.this.m_specialprice = d;
                    CarConfigurator.this.m_special_contained_extras = (String)SpecialsPanel.this.specials[n][3];
                    CarConfigurator.this.updateCalculatedPrice();
                }
            };
        }

        private void reset() {
            int n;
            this.specials = (Object[][])CarConfigurator.this.specialsEntries.clone();
            int n2 = this.specialsCombo.getItemCount();
            for (n = 0; n < 4; ++n) {
                this.specialsCombo.addItem(this.specials[n][0]);
            }
            for (n = 0; n < n2; ++n) {
                this.specialsCombo.removeItemAt(0);
            }
            this.specialsCombo.setSelectedIndex(0);
        }

        static /* synthetic */ Object[][] access$2602(SpecialsPanel specialsPanel, Object[][] objectArray) {
            specialsPanel.specials = objectArray;
            return objectArray;
        }
    }

    private class NewVehicleTablePanel
    extends VehicleTablePanel {
        public NewVehicleTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray) {
            super(string, objectArray, stringArray, integerArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n < 0) {
                CarConfigurator.this.m_baseprice = 0.0;
            } else if (CarConfigurator.this.buggyState && n == this.sorter.getRowCount() - 1) {
                CarConfigurator.this.m_baseprice = 0.0;
            } else {
                Double d = (Double)this.sorter.getValueAt(n, 2);
                CarConfigurator.this.m_baseprice = d;
            }
            CarConfigurator.this.updateCalculatedPrice();
        }

        private void reset() {
            this.table.clearSelection();
            this.model.setDataVector((Object[][])CarConfigurator.this.vehicleCells_new.clone(), CarConfigurator.this.vehicleColumnNames_new);
            this.setTableLayout(CarConfigurator.this.vehicleColumnNames_new, CarConfigurator.this.vehicleColumnMaxWidth_new);
            this.sorter.updateData();
        }
    }

    private class VehicleTablePanel
    extends AbstractTablePanel {
        public VehicleTablePanel(String string, Object[][] objectArray, String[] stringArray, Integer[] integerArray) {
            super(string, objectArray, stringArray, integerArray, "Vehicle");
            this.setName("VehicleTablePanel");
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = this.table.getSelectionModel().getMinSelectionIndex();
            if (n < 0) {
                CarConfigurator.this.m_baseprice = 0.0;
            } else if (CarConfigurator.this.buggyState && n == this.sorter.getRowCount() - 1) {
                CarConfigurator.this.m_baseprice = 0.0;
            } else {
                Double d = (Double)this.sorter.getValueAt(n, 1);
                CarConfigurator.this.m_baseprice = d;
            }
            CarConfigurator.this.updateCalculatedPrice();
        }

        private void reset() {
            ((AbstractTablePanel)this).reset();
            this.model.setDataVector((Object[][])CarConfigurator.this.vehicleCells.clone(), CarConfigurator.this.vehicleColumnNames);
            this.setTableLayout(CarConfigurator.this.vehicleColumnNames, CarConfigurator.this.vehicleColumnMaxWidth);
            this.sorter.updateData();
        }
    }
}

